/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.threetier;

import oracle.toplink.exceptions.ConcurrencyException;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.sessions.Login;
import oracle.toplink.threetier.ConnectionPool;
import oracle.toplink.threetier.ServerSession;

public class ExternalConnectionPool
extends ConnectionPool {
    protected Accessor cachedConnection;

    public ExternalConnectionPool() {
    }

    public ExternalConnectionPool(String string, Login login, ServerSession serverSession) {
        super(string, login, 0, 0, serverSession);
    }

    public Accessor acquireConnection() throws ConcurrencyException {
        return (Accessor)this.getCachedConnection().clone();
    }

    protected Accessor getCachedConnection() {
        return this.cachedConnection;
    }

    public boolean hasConnectionAvailable() {
        return true;
    }

    public boolean isThereConflictBetweenLoginAndType() {
        return !this.getLogin().shouldUseExternalConnectionPooling();
    }

    public void releaseConnection(Accessor accessor) throws DatabaseException {
        accessor.closeConnection();
    }

    protected void setCachedConnection(Accessor accessor) {
        this.cachedConnection = accessor;
    }

    public synchronized void shutDown() {
        this.setIsConnected(false);
    }

    public synchronized void startUp() {
        this.setCachedConnection(this.buildConnection());
        this.setIsConnected(true);
    }
}

