/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.threetier;

import java.io.StringWriter;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.sequencing.Sequencing;
import oracle.toplink.internal.sequencing.SequencingFactory;
import oracle.toplink.internal.sessions.AbstractSession;
import oracle.toplink.internal.sessions.ClientSessionIdentityMapAccessor;
import oracle.toplink.platform.server.ServerPlatform;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.remote.CacheSynchronizationManager;
import oracle.toplink.remotecommand.CommandManager;
import oracle.toplink.sessions.Project;
import oracle.toplink.threetier.ConnectionPolicy;
import oracle.toplink.threetier.ServerSession;

public class ClientSession
extends AbstractSession {
    protected ServerSession parent;
    protected ConnectionPolicy connectionPolicy;
    protected Accessor writeConnection;
    protected boolean isActive;
    protected Sequencing sequencing;

    public ClientSession(ServerSession serverSession, ConnectionPolicy connectionPolicy) {
        super(serverSession.getProject());
        if (connectionPolicy.isUserDefinedConnection()) {
            this.setProject((Project)this.getProject().clone());
            this.setLogin(connectionPolicy.getLogin());
        }
        this.isActive = true;
        this.externalTransactionController = serverSession.getExternalTransactionController();
        this.parent = serverSession;
        this.connectionPolicy = connectionPolicy;
        this.writeConnection = this.accessor;
        this.accessor = serverSession.getAccessor();
        this.name = serverSession.getName();
        this.profiler = serverSession.getProfiler();
        this.isInProfile = serverSession.isInProfile();
        this.commitManager = serverSession.getCommitManager();
        this.sessionLog = serverSession.getSessionLog();
        this.eventManager = serverSession.getEventManager().clone(this);
        this.exceptionHandler = serverSession.getExceptionHandler();
        this.getEventManager().postAcquireClientSession();
        this.incrementProfile("ClientSession");
    }

    protected ClientSession(Project project) {
        super(project);
    }

    public void afterTransaction(boolean bl, boolean bl2) {
        if (this.hasWriteConnection()) {
            this.getParent().afterTransaction(bl, bl2, this.getWriteConnection());
            if (bl2) {
                this.getWriteConnection().afterJTSTransaction();
                this.releaseWriteConnection();
            }
        }
    }

    public void basicBeginTransaction() {
        if (!this.hasWriteConnection() && this.getConnectionPolicy().isLazy()) {
            this.getParent().acquireClientConnection(this);
        }
        super.basicBeginTransaction();
    }

    public void basicCommitTransaction() {
        super.basicCommitTransaction();
        if (!this.getParent().getDatasourceLogin().shouldUseExternalTransactionController()) {
            this.releaseWriteConnection();
        } else if (this.getExternalTransactionController() == null) {
            this.releaseWriteConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicRollbackTransaction() {
        block7: {
            try {
                if (this.hasWriteConnection()) {
                    super.basicRollbackTransaction();
                }
                Object var2_1 = null;
                if (this.getParent().getDatasourceLogin().shouldUseExternalTransactionController()) break block7;
                this.releaseWriteConnection();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (!this.getParent().getDatasourceLogin().shouldUseExternalTransactionController()) {
                    this.releaseWriteConnection();
                } else if (this.getExternalTransactionController() == null) {
                    this.releaseWriteConnection();
                }
                throw throwable;
            }
        }
        if (this.getExternalTransactionController() == null) {
            this.releaseWriteConnection();
        }
    }

    public void connect() throws DatabaseException {
        this.getWriteConnection().connect(this.getDatasourceLogin(), this);
    }

    public boolean containsQuery(String string) {
        boolean bl = this.getQueries().containsKey(string);
        if (!bl) {
            bl = this.getParent().containsQuery(string);
        }
        return bl;
    }

    public void disconnect() throws DatabaseException {
        this.getWriteConnection().disconnect(this);
    }

    public Accessor getAccessor() {
        if (this.isInTransaction()) {
            return this.getWriteConnection();
        }
        return super.getAccessor();
    }

    public CacheSynchronizationManager getCacheSynchronizationManager() {
        return this.getParent().getCacheSynchronizationManager();
    }

    public ConnectionPolicy getConnectionPolicy() {
        return this.connectionPolicy;
    }

    public Session getParentIdentityMapSession(DatabaseQuery databaseQuery, boolean bl, boolean bl2) {
        return this.getParent().getParentIdentityMapSession(databaseQuery, bl, bl2);
    }

    public Session getExecutionSession(DatabaseQuery databaseQuery) {
        if (this.isInTransaction()) {
            return this;
        }
        return this.getParent().getExecutionSession(databaseQuery);
    }

    public ServerSession getParent() {
        return this.parent;
    }

    public DatabaseQuery getQuery(String string) {
        DatabaseQuery databaseQuery = super.getQuery(string);
        if (databaseQuery == null) {
            databaseQuery = this.getParent().getQuery(string);
        }
        return databaseQuery;
    }

    public DatabaseQuery getQuery(String string, Vector vector) {
        DatabaseQuery databaseQuery = super.getQuery(string, vector);
        if (databaseQuery == null) {
            databaseQuery = this.getParent().getQuery(string, vector);
        }
        return databaseQuery;
    }

    public void initializeSequencing() {
        this.sequencing = SequencingFactory.createSequencing(this);
    }

    public Sequencing getSequencing() {
        if (this.sequencing == null) {
            this.initializeSequencing();
        }
        return this.sequencing;
    }

    public ServerPlatform getServerPlatform() {
        return this.getParent().getServerPlatform();
    }

    public String getSessionTypeString() {
        return "ClientSession";
    }

    public Accessor getWriteConnection() {
        return this.writeConnection;
    }

    public boolean hasCacheSynchronizationManager() {
        return this.getParent().hasCacheSynchronizationManager();
    }

    protected boolean hasWriteConnection() {
        if (this.getWriteConnection() == null) {
            return false;
        }
        return this.getWriteConnection().isConnected();
    }

    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new ClientSessionIdentityMapAccessor(this);
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isClientSession() {
        return true;
    }

    public boolean isConnected() {
        return this.getParent().isConnected();
    }

    public void release() throws DatabaseException {
        if (!this.isActive()) {
            return;
        }
        this.getEventManager().preReleaseClientSession();
        if (this.hasWriteConnection()) {
            this.getParent().releaseClientSession(this);
        }
        this.setIsActive(false);
        this.log(2, "connection", "client_released");
        this.getEventManager().postReleaseClientSession();
    }

    protected void releaseWriteConnection() {
        if (this.getConnectionPolicy().isLazy() && this.hasWriteConnection()) {
            this.getParent().releaseClientSession(this);
            this.setWriteConnection(null);
        }
    }

    public void setConnectionPolicy(ConnectionPolicy connectionPolicy) {
        this.connectionPolicy = connectionPolicy;
    }

    protected void setIsActive(boolean bl) {
        this.isActive = bl;
    }

    protected void setParent(ServerSession serverSession) {
        this.parent = serverSession;
    }

    public void setWriteConnection(Accessor accessor) {
        this.writeConnection = accessor;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(this.getSessionTypeString());
        stringWriter.write("(");
        stringWriter.write(String.valueOf(this.getWriteConnection()));
        stringWriter.write(")");
        return stringWriter.toString();
    }

    public CommandManager getCommandManager() {
        return this.getParent().getCommandManager();
    }

    public boolean shouldPropagateChanges() {
        return this.getParent().shouldPropagateChanges();
    }

    public void releaseReadConnection(Accessor accessor) {
        this.getParent().releaseReadConnection(accessor);
    }
}

