/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.sessions;

import java.io.Serializable;
import java.util.Date;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.publicinterface.Session;

public class SessionLogEntry
implements Serializable {
    protected Date date = new Date();
    protected transient Session session;
    protected transient Thread thread = Thread.currentThread();
    protected transient Accessor connection;
    protected String message;
    protected Throwable throwable;
    protected int level;
    protected String nameSpace;
    protected Object[] parameters;
    protected boolean shouldTranslate;

    public SessionLogEntry(Session session) {
        this.session = session;
        this.message = "";
        this.level = 5;
    }

    public SessionLogEntry(Session session, Throwable throwable) {
        this(session);
        this.throwable = throwable;
        this.level = 7;
    }

    public SessionLogEntry(Session session, String string) {
        this(session);
        this.message = string;
    }

    public SessionLogEntry(Session session, String string, Accessor accessor) {
        this(session, string);
        this.connection = accessor;
    }

    public SessionLogEntry(Session session, String string, boolean bl, Accessor accessor) {
        this(session, string, accessor);
        if (bl) {
            this.level = 1;
        }
    }

    public SessionLogEntry(Session session, String string, boolean bl) {
        this(session, string);
        if (bl) {
            this.level = 1;
        }
    }

    public SessionLogEntry(int n, Session session, String string, Object[] objectArray, Accessor accessor, boolean bl) {
        this(session, string, accessor);
        this.level = n;
        this.parameters = objectArray;
        this.shouldTranslate = bl;
    }

    public SessionLogEntry(int n, String string, Session session, String string2, Object[] objectArray, Accessor accessor, boolean bl) {
        this(n, session, string2, objectArray, accessor, bl);
        this.nameSpace = string;
    }

    public SessionLogEntry(Session session, int n, String string, Throwable throwable) {
        this(session, throwable);
        this.level = n;
        this.nameSpace = string;
    }

    public Accessor getConnection() {
        return this.connection;
    }

    public Date getDate() {
        return this.date;
    }

    public Throwable getException() {
        return this.throwable;
    }

    public String getMessage() {
        return this.message;
    }

    public Session getSession() {
        return this.session;
    }

    public Thread getThread() {
        return this.thread;
    }

    public int getLevel() {
        return this.level;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public boolean shouldTranslate() {
        return this.shouldTranslate;
    }

    public boolean hasException() {
        return this.getException() != null;
    }

    public boolean isDebug() {
        return this.level == 1;
    }

    public void setConnection(Accessor accessor) {
        this.connection = accessor;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setException(Throwable throwable) {
        this.throwable = throwable;
    }

    public void setIsDebug(boolean bl) {
        if (bl) {
            this.level = 1;
        }
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public void setNameSpace(String string) {
        this.nameSpace = string;
    }

    public void setParameters(Object[] objectArray) {
        this.parameters = objectArray;
    }

    public void setShouldTranslate(boolean bl) {
        this.shouldTranslate = bl;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getMessage() + ")";
    }
}

