/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.sessions;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.internal.helper.ConversionManager;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.localization.ToStringLocalization;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.sessions.Connector;

public class DefaultConnector
implements Connector {
    protected String driverClassName;
    protected String driverURLHeader;
    protected String databaseURL;

    public DefaultConnector() {
        this("sun.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:", "");
    }

    public DefaultConnector(String string, String string2, String string3) {
        this.initialize(string, string2, string3);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            throw new InternalError("Clone failed");
        }
    }

    public Connection connect(Properties properties) throws DatabaseException {
        this.loadDriver();
        try {
            return DriverManager.getConnection(this.getConnectionString(), properties);
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException);
        }
    }

    public String getConnectionString() {
        return this.getDriverURLHeader() + this.getDatabaseURL();
    }

    public String getConnectionDetails() {
        return this.getConnectionString();
    }

    public String getDatabaseURL() {
        return this.databaseURL;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getDriverURLHeader() {
        return this.driverURLHeader;
    }

    protected void initialize(String string, String string2, String string3) {
        this.setDriverClassName(string);
        this.setDriverURLHeader(string2);
        this.setDatabaseURL(string3);
    }

    protected Class loadDriver() throws DatabaseException {
        try {
            return PrivilegedAccessController.getClassForName(this.getDriverClassName(), true, ConversionManager.getDefaultManager().getLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw DatabaseException.configurationErrorClassNotFound(this.getDriverClassName());
        }
    }

    public void setDatabaseURL(String string) {
        this.databaseURL = string;
    }

    public void setDriverClassName(String string) {
        this.driverClassName = string;
    }

    public void setDriverURLHeader(String string) {
        this.driverURLHeader = string;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getConnectionString() + ")";
    }

    public void toString(PrintWriter printWriter) {
        printWriter.println(ToStringLocalization.buildMessage("datasource_URL", null) + "=> \"" + this.getConnectionString() + "\"");
    }
}

