/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.sdk;

import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.internal.queryframework.ContainerPolicy;
import oracle.toplink.internal.sessions.ChangeRecord;
import oracle.toplink.internal.sessions.MergeManager;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.sdk.SDKCollectionChangeRecord;
import oracle.toplink.sdk.SDKCollectionMapping;
import oracle.toplink.sdk.SDKOrderedCollectionChangeRecord;

public class SDKCollectionMappingHelper {
    private SDKCollectionMapping mapping;
    private static Object XXX = new Object();

    public SDKCollectionMappingHelper(SDKCollectionMapping sDKCollectionMapping) {
        this.mapping = sDKCollectionMapping;
    }

    private Object buildAddedElementFromChangeSet(Object object, MergeManager mergeManager) {
        return this.getMapping().buildAddedElementFromChangeSet(object, mergeManager);
    }

    private Object buildChangeSet(Object object, ObjectChangeSet objectChangeSet, Session session) {
        return this.getMapping().buildChangeSet(object, objectChangeSet, session);
    }

    private Object buildElementFromElement(Object object, MergeManager mergeManager) {
        return this.getMapping().buildElementFromElement(object, mergeManager);
    }

    private Object buildRemovedElementFromChangeSet(Object object, MergeManager mergeManager) {
        return this.getMapping().buildRemovedElementFromChangeSet(object, mergeManager);
    }

    private boolean compareAttributeValues(Object object, Object object2, Session session) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (containerPolicy.sizeFor(object) != containerPolicy.sizeFor(object2)) {
            return false;
        }
        if (containerPolicy.sizeFor(object) == 0) {
            return true;
        }
        if (containerPolicy.hasOrder()) {
            return this.compareAttributeValuesWithOrder(object, object2, session);
        }
        return this.compareAttributeValuesWithoutOrder(object, object2, session);
    }

    private ChangeRecord compareAttributeValuesForChangeWithOrder(Object object, Object object2, ObjectChangeSet objectChangeSet, Session session) {
        Object e;
        int n;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Vector vector = containerPolicy.vectorFor(object, session);
        Vector vector2 = containerPolicy.vectorFor(object2, session);
        SDKOrderedCollectionChangeRecord sDKOrderedCollectionChangeRecord = new SDKOrderedCollectionChangeRecord(objectChangeSet, this.getAttributeName(), this.getDatabaseMapping());
        for (n = 0; n < vector.size(); ++n) {
            e = vector.elementAt(n);
            boolean bl = false;
            for (int i = 0; i < vector2.size(); ++i) {
                if (!this.compareElementsForChange(e, vector2.elementAt(i), session)) continue;
                bl = true;
                vector2.setElementAt(XXX, i);
                sDKOrderedCollectionChangeRecord.addMovedChangeSet(this.buildChangeSet(e, objectChangeSet, session), i, n);
                break;
            }
            if (bl) continue;
            sDKOrderedCollectionChangeRecord.addAddedChangeSet(this.buildChangeSet(e, objectChangeSet, session), n);
        }
        for (n = 0; n < vector2.size(); ++n) {
            e = vector2.elementAt(n);
            if (e == XXX) continue;
            sDKOrderedCollectionChangeRecord.addRemovedChangeSet(this.buildChangeSet(e, objectChangeSet, session), n);
        }
        if (sDKOrderedCollectionChangeRecord.hasChanges()) {
            return sDKOrderedCollectionChangeRecord;
        }
        return null;
    }

    private ChangeRecord compareAttributeValuesForChangeWithoutOrder(Object object, Object object2, ObjectChangeSet objectChangeSet, Session session) {
        Object object3;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Vector vector = containerPolicy.vectorFor(object2, session);
        SDKCollectionChangeRecord sDKCollectionChangeRecord = new SDKCollectionChangeRecord(objectChangeSet, this.getAttributeName(), this.getDatabaseMapping());
        Object object4 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object4)) {
            object3 = containerPolicy.next(object4, session);
            boolean bl = false;
            for (int i = 0; i < vector.size(); ++i) {
                if (!this.compareElementsForChange(object3, vector.elementAt(i), session)) continue;
                bl = true;
                vector.setElementAt(XXX, i);
                if (!this.mapKeyHasChanged(object3, session)) break;
                sDKCollectionChangeRecord.addChangedMapKeyChangeSet(this.buildChangeSet(object3, objectChangeSet, session));
                break;
            }
            if (bl) continue;
            sDKCollectionChangeRecord.addAddedChangeSet(this.buildChangeSet(object3, objectChangeSet, session));
        }
        for (int i = 0; i < vector.size(); ++i) {
            object3 = vector.elementAt(i);
            if (object3 == XXX) continue;
            sDKCollectionChangeRecord.addRemovedChangeSet(this.buildChangeSet(object3, objectChangeSet, session));
        }
        if (sDKCollectionChangeRecord.hasChanges()) {
            return sDKCollectionChangeRecord;
        }
        return null;
    }

    private boolean compareAttributeValuesWithOrder(Object object, Object object2, Session session) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object3 = containerPolicy.iteratorFor(object);
        Object object4 = containerPolicy.iteratorFor(object2);
        while (containerPolicy.hasNext(object3)) {
            if (this.compareElements(containerPolicy.next(object3, session), containerPolicy.next(object4, session), session)) continue;
            return false;
        }
        return true;
    }

    private boolean compareAttributeValuesWithoutOrder(Object object, Object object2, Session session) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Vector vector = containerPolicy.vectorFor(object2, session);
        Enumeration enumeration = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(enumeration)) {
            Object object3 = containerPolicy.next(enumeration, session);
            boolean bl = false;
            for (int i = 0; i < vector.size(); ++i) {
                if (!this.compareElements(object3, vector.elementAt(i), session)) continue;
                bl = true;
                vector.setElementAt(XXX, i);
                break;
            }
            if (bl) continue;
            return false;
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            if (enumeration.nextElement() == XXX) continue;
            return false;
        }
        return true;
    }

    private boolean compareElements(Object object, Object object2, Session session) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object2 == XXX) {
            return false;
        }
        return this.getMapping().compareElements(object, object2, session);
    }

    private boolean compareElementsForChange(Object object, Object object2, Session session) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object2 == XXX) {
            return false;
        }
        return this.getMapping().compareElementsForChange(object, object2, session);
    }

    public ChangeRecord compareForChange(Object object, Object object2, ObjectChangeSet objectChangeSet, Session session) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object3 = this.getRealCollectionAttributeValueFromObject(object, session);
        Object object4 = null;
        object4 = objectChangeSet.isNew() ? containerPolicy.containerInstance(1) : this.getRealCollectionAttributeValueFromObject(object2, session);
        if (containerPolicy.hasOrder()) {
            return this.compareAttributeValuesForChangeWithOrder(object3, object4, objectChangeSet, session);
        }
        return this.compareAttributeValuesForChangeWithoutOrder(object3, object4, objectChangeSet, session);
    }

    public boolean compareObjects(Object object, Object object2, Session session) {
        return this.compareAttributeValues(this.getRealCollectionAttributeValueFromObject(object, session), this.getRealCollectionAttributeValueFromObject(object2, session), session);
    }

    private String getAttributeName() {
        return this.getMapping().getAttributeName();
    }

    private ContainerPolicy getContainerPolicy() {
        return this.getMapping().getContainerPolicy();
    }

    public DatabaseMapping getDatabaseMapping() {
        return (DatabaseMapping)((Object)this.getMapping());
    }

    public SDKCollectionMapping getMapping() {
        return this.mapping;
    }

    private Object getRealCollectionAttributeValueFromObject(Object object, Session session) {
        return this.getMapping().getRealCollectionAttributeValueFromObject(object, session);
    }

    private boolean mapKeyHasChanged(Object object, Session session) {
        return this.getMapping().mapKeyHasChanged(object, session);
    }

    public void mergeChangesIntoObject(Object object, ChangeRecord changeRecord, Object object2, MergeManager mergeManager) {
        if (this.getContainerPolicy().hasOrder()) {
            this.mergeChangesIntoObjectWithOrder(object, changeRecord, object2, mergeManager);
        } else {
            this.mergeChangesIntoObjectWithoutOrder(object, changeRecord, object2, mergeManager);
        }
    }

    private void mergeChangesIntoObjectWithOrder(Object object, ChangeRecord changeRecord, Object object2, MergeManager mergeManager) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Session session = mergeManager.getSession();
        Vector vector = ((SDKOrderedCollectionChangeRecord)changeRecord).getNewCollection();
        Object object3 = containerPolicy.containerInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object object4 = this.buildAddedElementFromChangeSet(enumeration.nextElement(), mergeManager);
            containerPolicy.addInto(object4, object3, session);
        }
        this.setRealAttributeValueInObject(object, object3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeChangesIntoObjectWithoutOrder(Object object, ChangeRecord changeRecord, Object object2, MergeManager mergeManager) {
        SDKCollectionChangeRecord sDKCollectionChangeRecord = (SDKCollectionChangeRecord)changeRecord;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Session session = mergeManager.getSession();
        Object object3 = null;
        object3 = sDKCollectionChangeRecord.getOwner().isNew() ? containerPolicy.containerInstance(sDKCollectionChangeRecord.getAdds().size()) : this.getRealCollectionAttributeValueFromObject(object, session);
        Vector vector = sDKCollectionChangeRecord.getRemoves();
        Vector vector2 = sDKCollectionChangeRecord.getAdds();
        Vector vector3 = sDKCollectionChangeRecord.getChangedMapKeys();
        Object object4 = object3;
        synchronized (object4) {
            Object object5;
            Object object6;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object6 = this.buildRemovedElementFromChangeSet(enumeration.nextElement(), mergeManager);
                object5 = null;
                Object object7 = containerPolicy.iteratorFor(object3);
                while (containerPolicy.hasNext(object7) && !this.compareElements(object5 = containerPolicy.next(object7, session), object6, session)) {
                }
                if (object5 == null) continue;
                containerPolicy.removeFrom(object5, object3, session);
            }
            enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                object6 = this.buildAddedElementFromChangeSet(enumeration.nextElement(), mergeManager);
                containerPolicy.addInto(object6, object3, session);
            }
            enumeration = vector3.elements();
            while (enumeration.hasMoreElements()) {
                object6 = this.buildAddedElementFromChangeSet(enumeration.nextElement(), mergeManager);
                object5 = ((UnitOfWork)session).getOriginalVersionOfObject(object6);
                containerPolicy.removeFrom(object5, object3, session);
                containerPolicy.addInto(object6, object3, session);
            }
        }
        this.setRealAttributeValueInObject(object, object3);
    }

    public void mergeIntoObject(Object object, boolean bl, Object object2, MergeManager mergeManager) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Session session = mergeManager.getSession();
        Object object3 = this.getRealCollectionAttributeValueFromObject(object2, session);
        Object object4 = containerPolicy.containerInstance(containerPolicy.sizeFor(object3));
        Object object5 = containerPolicy.iteratorFor(object3);
        while (containerPolicy.hasNext(object5)) {
            Object object6 = this.buildElementFromElement(containerPolicy.next(object5, session), mergeManager);
            containerPolicy.addInto(object6, object4, session);
        }
        this.setRealAttributeValueInObject(object, object4);
    }

    private void setRealAttributeValueInObject(Object object, Object object2) {
        this.getMapping().setRealAttributeValueInObject(object, object2);
    }

    public void simpleAddToCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, Session session) {
        if (this.getContainerPolicy().hasOrder()) {
            this.simpleAddToCollectionChangeRecordWithOrder(object, object2, objectChangeSet, session);
        } else {
            this.simpleAddToCollectionChangeRecordWithoutOrder(object, object2, objectChangeSet, session);
        }
    }

    private void simpleAddToCollectionChangeRecordWithOrder(Object object, Object object2, ObjectChangeSet objectChangeSet, Session session) {
        SDKOrderedCollectionChangeRecord sDKOrderedCollectionChangeRecord = (SDKOrderedCollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (sDKOrderedCollectionChangeRecord == null) {
            sDKOrderedCollectionChangeRecord = new SDKOrderedCollectionChangeRecord(objectChangeSet, this.getAttributeName(), this.getDatabaseMapping());
            objectChangeSet.addChange(sDKOrderedCollectionChangeRecord);
        }
        sDKOrderedCollectionChangeRecord.simpleAddChangeSet(object2);
    }

    private void simpleAddToCollectionChangeRecordWithoutOrder(Object object, Object object2, ObjectChangeSet objectChangeSet, Session session) {
        SDKCollectionChangeRecord sDKCollectionChangeRecord = (SDKCollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (sDKCollectionChangeRecord == null) {
            sDKCollectionChangeRecord = new SDKCollectionChangeRecord(objectChangeSet, this.getAttributeName(), this.getDatabaseMapping());
            objectChangeSet.addChange(sDKCollectionChangeRecord);
        }
        sDKCollectionChangeRecord.simpleAddChangeSet(object2);
    }

    public void simpleRemoveFromCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, Session session) {
        if (this.getContainerPolicy().hasOrder()) {
            this.simpleRemoveFromCollectionChangeRecordWithOrder(object, object2, objectChangeSet, session);
        } else {
            this.simpleRemoveFromCollectionChangeRecordWithoutOrder(object, object2, objectChangeSet, session);
        }
    }

    private void simpleRemoveFromCollectionChangeRecordWithOrder(Object object, Object object2, ObjectChangeSet objectChangeSet, Session session) {
        SDKOrderedCollectionChangeRecord sDKOrderedCollectionChangeRecord = (SDKOrderedCollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (sDKOrderedCollectionChangeRecord == null) {
            sDKOrderedCollectionChangeRecord = new SDKOrderedCollectionChangeRecord(objectChangeSet, this.getAttributeName(), this.getDatabaseMapping());
            objectChangeSet.addChange(sDKOrderedCollectionChangeRecord);
        }
        sDKOrderedCollectionChangeRecord.simpleRemoveChangeSet(object2);
    }

    private void simpleRemoveFromCollectionChangeRecordWithoutOrder(Object object, Object object2, ObjectChangeSet objectChangeSet, Session session) {
        SDKCollectionChangeRecord sDKCollectionChangeRecord = (SDKCollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (sDKCollectionChangeRecord == null) {
            sDKCollectionChangeRecord = new SDKCollectionChangeRecord(objectChangeSet, this.getAttributeName(), this.getDatabaseMapping());
            objectChangeSet.addChange(sDKCollectionChangeRecord);
        }
        sDKCollectionChangeRecord.simpleRemoveChangeSet(object2);
    }
}

