/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.queryframework;

import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.databaseaccess.DatabaseCall;
import oracle.toplink.internal.databaseaccess.QueryStringCall;
import oracle.toplink.internal.expressions.ParameterExpression;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.publicinterface.Session;

public class SQLCall
extends DatabaseCall
implements QueryStringCall {
    protected boolean hasCustomSQLArguments = false;

    public SQLCall() {
    }

    public SQLCall(String string) {
        this();
        this.setSQLString(string);
    }

    protected void afterTranslateCustomQuery(Vector vector, Vector vector2) {
        for (int i = 0; i < this.getParameters().size(); ++i) {
            DatabaseField databaseField;
            Integer n = (Integer)this.getParameterTypes().elementAt(i);
            Object e = this.getParameters().elementAt(i);
            if (n == MODIFY || n == OUT || n == OUT_CURSOR || n == IN && e instanceof DatabaseField) {
                databaseField = (DatabaseField)e;
                this.afterTranslateCustomQueryUpdateParameter(databaseField, i, n, vector, vector2);
                continue;
            }
            if (n != INOUT) continue;
            databaseField = (DatabaseField)((Object[])e)[1];
            this.afterTranslateCustomQueryUpdateParameter(databaseField, i, n, vector, vector2);
            if (!(((Object[])e)[0] instanceof DatabaseField) || ((Object[])e)[0] == ((Object[])e)[1]) continue;
            DatabaseField databaseField2 = (DatabaseField)((Object[])e)[0];
            this.afterTranslateCustomQueryUpdateParameter(databaseField2, i, n, vector, vector2);
        }
    }

    protected void afterTranslateCustomQueryUpdateParameter(DatabaseField databaseField, int n, Integer n2, Vector vector, Vector vector2) {
        for (int i = 0; i < vector.size(); ++i) {
            DatabaseField databaseField2 = (DatabaseField)vector.elementAt(i);
            if (!databaseField.equals(databaseField2)) continue;
            Integer n3 = (Integer)vector2.elementAt(i);
            if (n3 == null) {
                databaseField.setType(databaseField2.getType());
                break;
            }
            if (n3 != OUT_CURSOR) break;
            if (n2 == OUT) {
                this.getParameterTypes().setElementAt(OUT_CURSOR, n);
                break;
            }
            throw ValidationException.cannotSetCursorForParameterTypeOtherThanOut(databaseField.getName(), this.toString());
        }
    }

    public boolean hasCustomSQLArguments() {
        return this.hasCustomSQLArguments;
    }

    public boolean isSQLCall() {
        return true;
    }

    public boolean isQueryStringCall() {
        return true;
    }

    protected void prepareInternal(Session session) {
        if (this.hasCustomSQLArguments()) {
            Vector vector = null;
            Vector vector2 = null;
            if (this.getParameters().size() > 0) {
                vector = this.getParameters();
                this.setParameters(NonSynchronizedVector.newInstance());
                vector2 = this.getParameterTypes();
                this.setParameterTypes(NonSynchronizedVector.newInstance());
            }
            this.translateCustomQuery();
            if (vector != null) {
                this.afterTranslateCustomQuery(vector, vector2);
            }
        }
        super.prepareInternal(session);
    }

    public void setHasCustomSQLArguments(boolean bl) {
        this.hasCustomSQLArguments = bl;
    }

    public void setCustomSQLArgumentType(String string, Class clazz) {
        DatabaseField databaseField = new DatabaseField(string);
        databaseField.setType(clazz);
        this.getParameters().add(databaseField);
        this.getParameterTypes().add(null);
    }

    public void setSQLString(String string) {
        this.setSQLStringInternal(string);
    }

    public void appendTranslationParameter(Writer writer, ParameterExpression parameterExpression) throws IOException {
        try {
            writer.write("?");
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        this.getParameters().addElement(parameterExpression);
        this.getParameterTypes().addElement(TRANSLATION);
    }

    public void useCustomSQLCursorOutputAsResultSet(String string) {
        DatabaseField databaseField = new DatabaseField(string);
        this.getParameters().add(databaseField);
        this.getParameterTypes().add(OUT_CURSOR);
        this.setIsCursorOutputProcedure(true);
    }
}

