/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.queryframework;

import oracle.toplink.descriptors.DescriptorEvent;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.internal.indirection.ProxyIndirectionPolicy;
import oracle.toplink.internal.sessions.CommitManager;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.DescriptorEventManager;
import oracle.toplink.publicinterface.DescriptorQueryManager;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelModifyQuery;
import oracle.toplink.tools.profiler.QueryMonitor;

public class DeleteObjectQuery
extends ObjectLevelModifyQuery {
    protected boolean isFullRowRequired = false;

    public DeleteObjectQuery() {
    }

    public DeleteObjectQuery(Object object) {
        this();
        this.setObject(object);
    }

    public DeleteObjectQuery(Call call) {
        this();
        this.setCall(call);
    }

    public boolean isFullRowRequired() {
        return this.isFullRowRequired;
    }

    public void setIsFullRowRequired(boolean bl) {
        this.isFullRowRequired = bl;
    }

    protected DatabaseQuery checkForCustomQuery(Session session, DatabaseRow databaseRow) {
        this.checkDescriptor(session);
        DescriptorQueryManager descriptorQueryManager = this.getDescriptor().getQueryManager();
        if (!this.isCallQuery() && !this.isUserDefined() && descriptorQueryManager.hasDeleteQuery()) {
            return descriptorQueryManager.getDeleteQuery();
        }
        return null;
    }

    protected Object executeInUnitOfWorkObjectLevelModifyQuery(UnitOfWork unitOfWork, DatabaseRow databaseRow) throws DatabaseException, OptimisticLockException {
        Object object = unitOfWork.processDeleteObjectQuery(this);
        if (object != null) {
            return object;
        }
        return super.executeInUnitOfWorkObjectLevelModifyQuery(unitOfWork, databaseRow);
    }

    public Object executeDatabaseQuery() throws DatabaseException, OptimisticLockException {
        Session session = this.getSession();
        CommitManager commitManager = session.getCommitManager();
        Object object = this.getObject();
        boolean bl = session.isUnitOfWork();
        try {
            int n;
            Descriptor descriptor;
            DescriptorEventManager descriptorEventManager;
            if (commitManager.isCommitCompleted(object) || commitManager.isCommitInPostModify(object) || commitManager.isCommitInPreModify(object)) {
                return object;
            }
            commitManager.markPreModifyCommitInProgress(this.getObject());
            if (!bl) {
                session.beginTransaction();
            }
            if ((descriptorEventManager = (descriptor = this.getDescriptor()).getEventManager()).hasAnyEventListeners()) {
                descriptorEventManager.executeEvent(new DescriptorEvent(2, this));
            }
            if (this.shouldCascadeParts()) {
                descriptor.getQueryManager().preDelete(this);
            }
            if (descriptorEventManager.hasAnyEventListeners()) {
                DescriptorEvent descriptorEvent = new DescriptorEvent(14, this);
                descriptorEvent.setRow(this.getModifyRow());
                descriptorEventManager.executeEvent(descriptorEvent);
            }
            if (QueryMonitor.shouldMonitor()) {
                QueryMonitor.incrementDelete(this);
            }
            if ((n = this.getQueryMechanism().deleteObject().intValue()) < 1) {
                session.getEventManager().noRowsModified(this, object);
            }
            if (descriptor.usesOptimisticLocking()) {
                descriptor.getOptimisticLockingPolicy().validateDelete(n, object, this);
            }
            commitManager.markPostModifyCommitInProgress(this.getObject());
            if (this.shouldCascadeParts()) {
                descriptor.getQueryManager().postDelete(this);
            }
            if (descriptor.getHistoryPolicy() != null && descriptor.getHistoryPolicy().shouldHandleWrites()) {
                descriptor.getHistoryPolicy().postDelete(this);
            }
            if (descriptorEventManager.hasAnyEventListeners()) {
                descriptorEventManager.executeEvent(new DescriptorEvent(3, this));
            }
            if (!bl) {
                session.commitTransaction();
            }
            commitManager.markCommitCompleted(object);
            if (this.shouldMaintainCache()) {
                if (bl) {
                    ((UnitOfWork)session).addObjectDeletedDuringCommit(object);
                } else {
                    session.getIdentityMapAccessorInstance().removeFromIdentityMap(this.getPrimaryKey(), descriptor.getJavaClass(), descriptor);
                }
            }
            return object;
        }
        catch (RuntimeException runtimeException) {
            if (!bl) {
                session.rollbackTransaction();
            }
            commitManager.markCommitCompleted(object);
            throw runtimeException;
        }
    }

    public boolean isDeleteObjectQuery() {
        return true;
    }

    protected void prepare() {
        super.prepare();
        this.getQueryMechanism().prepareDeleteObject();
    }

    protected void prepareCustomQuery(DatabaseQuery databaseQuery) {
        DeleteObjectQuery deleteObjectQuery = (DeleteObjectQuery)databaseQuery;
        if (databaseQuery.getSession().getProject().hasProxyIndirection()) {
            this.setObject(ProxyIndirectionPolicy.getValueFromProxy(this.getObject()));
        }
        deleteObjectQuery.setObject(this.getObject());
        deleteObjectQuery.setObjectChangeSet(this.getObjectChangeSet());
        deleteObjectQuery.setCascadePolicy(this.getCascadePolicy());
        deleteObjectQuery.setShouldMaintainCache(this.shouldMaintainCache());
        if (this.isFullRowRequired()) {
            deleteObjectQuery.setTranslationRow(deleteObjectQuery.getDescriptor().getObjectBuilder().buildRow(this.getObject(), deleteObjectQuery.getSession()));
        }
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        if (this.getTranslationRow() == null || this.getTranslationRow().isEmpty()) {
            this.setTranslationRow(this.getDescriptor().getObjectBuilder().buildRowForTranslation(this.getObject(), this.getSession()));
        }
        if (this.getDescriptor().usesOptimisticLocking()) {
            this.getDescriptor().getOptimisticLockingPolicy().addLockValuesToTranslationRow(this);
        }
    }
}

