/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.queryframework;

import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.descriptors.DescriptorEvent;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ModifyQuery;

public class DeleteAllQuery
extends ModifyQuery {
    protected Class referenceClass;
    protected String referenceClassName;
    protected Vector objects;

    public Object executeInUnitOfWork(UnitOfWork unitOfWork, DatabaseRow databaseRow) throws DatabaseException, OptimisticLockException {
        if (unitOfWork.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.illegalOperationForUnitOfWorkLifecycle(unitOfWork.getLifecycle(), "executeQuery(DeleteAllQuery)");
        }
        if (!unitOfWork.getCommitManager().isActive()) {
            return unitOfWork.getParent().executeQuery((DatabaseQuery)this, databaseRow);
        }
        return super.executeInUnitOfWork(unitOfWork, databaseRow);
    }

    public Object executeDatabaseQuery() throws DatabaseException {
        if (this.getObjects() == null || this.getObjects().size() == 0) {
            return this.getObjects();
        }
        try {
            Object object;
            Enumeration enumeration;
            this.getSession().beginTransaction();
            if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
                enumeration = this.getObjects().elements();
                while (enumeration.hasMoreElements()) {
                    object = new DescriptorEvent(enumeration.nextElement());
                    ((oracle.toplink.publicinterface.DescriptorEvent)object).setEventCode(2);
                    ((oracle.toplink.publicinterface.DescriptorEvent)object).setSession(this.getSession());
                    ((oracle.toplink.publicinterface.DescriptorEvent)object).setQuery(this);
                    this.getDescriptor().getEventManager().executeEvent((DescriptorEvent)object);
                }
            }
            this.getQueryMechanism().deleteAll();
            if (this.getDescriptor().getHistoryPolicy() != null && this.getDescriptor().getHistoryPolicy().shouldHandleWrites()) {
                this.getDescriptor().getHistoryPolicy().postDelete(this);
            }
            if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
                enumeration = this.getObjects().elements();
                while (enumeration.hasMoreElements()) {
                    object = new DescriptorEvent(enumeration.nextElement());
                    ((oracle.toplink.publicinterface.DescriptorEvent)object).setEventCode(3);
                    ((oracle.toplink.publicinterface.DescriptorEvent)object).setSession(this.getSession());
                    ((oracle.toplink.publicinterface.DescriptorEvent)object).setQuery(this);
                    this.getDescriptor().getEventManager().executeEvent((DescriptorEvent)object);
                }
            }
            if (this.shouldMaintainCache()) {
                enumeration = this.getObjects().elements();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    if (this.getSession().isUnitOfWork()) {
                        object = this.getDescriptor().getObjectBuilder().unwrapObject(object, this.getSession());
                        ((UnitOfWork)this.getSession()).addObjectDeletedDuringCommit(object);
                        continue;
                    }
                    this.getSession().getIdentityMapAccessor().removeFromIdentityMap(object);
                }
            }
            this.getSession().commitTransaction();
            return this.getObjects();
        }
        catch (RuntimeException runtimeException) {
            this.getSession().rollbackTransaction();
            throw runtimeException;
        }
    }

    public void executeDeleteAll(Session session, DatabaseRow databaseRow, Vector vector) throws DatabaseException {
        this.checkPrepare(session, databaseRow);
        DeleteAllQuery deleteAllQuery = (DeleteAllQuery)this.clone();
        deleteAllQuery.setTranslationRow(databaseRow);
        deleteAllQuery.setSession(session);
        deleteAllQuery.setObjects(vector);
        deleteAllQuery.prepareForExecution();
        deleteAllQuery.executeDatabaseQuery();
    }

    public Vector getObjects() {
        return this.objects;
    }

    public String getReferenceClassName() {
        if (this.referenceClassName == null && this.referenceClass != null) {
            this.referenceClassName = this.referenceClass.getName();
        }
        return this.referenceClassName;
    }

    public Class getReferenceClass() {
        return this.referenceClass;
    }

    protected void prepare() throws QueryException {
        super.prepare();
        if (this.getReferenceClass() == null) {
            throw QueryException.referenceClassMissing(this);
        }
        if (this.getDescriptor() == null) {
            Descriptor descriptor = this.getSession().getDescriptor(this.getReferenceClass());
            if (descriptor == null) {
                throw QueryException.descriptorIsMissing(this.getReferenceClass(), this);
            }
            this.setDescriptor(descriptor);
        }
        if (this.getDescriptor().isAggregateDescriptor()) {
            throw QueryException.aggregateObjectCannotBeDeletedOrWritten(this.getDescriptor(), this);
        }
        this.getQueryMechanism().prepareDeleteAll();
    }

    public void setObjects(Vector vector) {
        this.objects = vector;
    }

    public void setReferenceClass(Class clazz) {
        this.referenceClass = clazz;
    }

    public void setReferenceClassName(String string) {
        this.referenceClassName = string;
    }
}

