/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.queryframework;

import oracle.toplink.exceptions.QueryException;
import oracle.toplink.internal.databaseaccess.DatabaseCall;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.CursorPolicy;
import oracle.toplink.queryframework.CursoredStream;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ReadQuery;
import oracle.toplink.queryframework.ValueReadQuery;
import oracle.toplink.remote.DistributedSession;

public class CursoredStreamPolicy
extends CursorPolicy {
    protected int initialReadSize;
    protected ValueReadQuery sizeQuery;

    public CursoredStreamPolicy() {
    }

    public CursoredStreamPolicy(ReadQuery readQuery, int n) {
        super(readQuery, n);
        this.setInitialReadSize(n);
    }

    public CursoredStreamPolicy(ReadQuery readQuery, int n, int n2) {
        this(readQuery, n2);
        this.setInitialReadSize(n);
    }

    public CursoredStreamPolicy(ReadQuery readQuery, int n, int n2, ValueReadQuery valueReadQuery) {
        this(readQuery, n, n2);
        this.setSizeQuery(valueReadQuery);
    }

    public Object execute() {
        DatabaseCall databaseCall = this.getQuery().getQueryMechanism().cursorSelectAllRows();
        CursoredStream cursoredStream = new CursoredStream(databaseCall, this);
        return cursoredStream;
    }

    public int getInitialReadSize() {
        return this.initialReadSize;
    }

    public ValueReadQuery getSizeQuery() {
        return this.sizeQuery;
    }

    public boolean hasSizeQuery() {
        return this.sizeQuery != null;
    }

    public boolean isCursoredStreamPolicy() {
        return true;
    }

    public void prepare(DatabaseQuery databaseQuery, Session session) throws QueryException {
        super.prepare(databaseQuery, session);
        if (this.getQuery().isCallQuery() && !this.hasSizeQuery()) {
            throw QueryException.additionalSizeQueryNotSpecified(this.getQuery());
        }
    }

    public Object remoteExecute() {
        return ((DistributedSession)this.getQuery().getSession()).cursorSelectObjects(this);
    }

    public void setInitialReadSize(int n) {
        this.initialReadSize = n;
    }

    public void setSizeQuery(ValueReadQuery valueReadQuery) {
        this.sizeQuery = valueReadQuery;
    }
}

