/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.platform.xml;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import oracle.toplink.internal.ox.StrBuffer;
import oracle.toplink.platform.xml.XMLPlatform;
import oracle.toplink.platform.xml.XMLPlatformFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SAXDocumentBuilder
implements ContentHandler {
    private Document document;
    private Stack nodes = new Stack();
    private XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
    private Map rootNamespaceDeclarations;
    private StrBuffer stringBuffer = new StrBuffer();

    public Document getDocument() {
        return this.document;
    }

    public Document getInitializedDocument() throws SAXException {
        if (this.document == null) {
            try {
                this.document = this.xmlPlatform.createDocument();
                this.nodes.push(this.document);
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
        }
        return this.document;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        try {
            this.document = this.xmlPlatform.createDocument();
            this.nodes.push(this.document);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    public void endDocument() throws SAXException {
        this.nodes.pop();
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        Node node = null;
        if (!this.nodes.isEmpty()) {
            node = (Node)this.nodes.peek();
        }
        if (node == null || node.getNodeType() == 9) {
            if (null == this.rootNamespaceDeclarations) {
                this.rootNamespaceDeclarations = new HashMap();
            }
            this.rootNamespaceDeclarations.put(string, string2);
        } else if (node.getNodeType() == 1) {
            this.addNamespaceDeclaration((Element)node, string, string2);
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4;
        Object object;
        if (null != string && "".equals(string)) {
            string = null;
        }
        Element element = this.getInitializedDocument().createElementNS(string, string3);
        Node node = (Node)this.nodes.peek();
        if (this.stringBuffer.length() > 0 && !this.nodes.isEmpty()) {
            object = this.getInitializedDocument().createTextNode(this.stringBuffer.toString());
            node.appendChild((Node)object);
            this.stringBuffer.reset();
        }
        node.appendChild(element);
        this.nodes.push(element);
        if (null != this.rootNamespaceDeclarations) {
            object = this.rootNamespaceDeclarations.keySet().iterator();
            while (object.hasNext()) {
                string4 = (String)object.next();
                String string5 = (String)this.rootNamespaceDeclarations.get(string4);
                this.addNamespaceDeclaration(element, string4, string5);
            }
            this.rootNamespaceDeclarations = null;
        }
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            string4 = attributes.getURI(i);
            if (null != string4 && "".equals(string4)) {
                string4 = null;
            }
            element.setAttributeNS(string4, attributes.getQName(i), attributes.getValue(i));
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        Element element = (Element)this.nodes.pop();
        if (this.stringBuffer.length() > 0) {
            Text text = this.getInitializedDocument().createTextNode(this.stringBuffer.toString());
            element.appendChild(text);
            this.stringBuffer.reset();
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.stringBuffer.append(cArray, n, n2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        ProcessingInstruction processingInstruction = this.getInitializedDocument().createProcessingInstruction(string, string2);
        Node node = (Node)this.nodes.peek();
        node.appendChild(processingInstruction);
    }

    public void skippedEntity(String string) throws SAXException {
    }

    private void addNamespaceDeclaration(Element element, String string, String string2) {
        if (string.equals("")) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", string2);
        } else {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string, string2);
        }
    }
}

