/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.ox.mappings;

import java.util.Vector;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.internal.queryframework.ContainerPolicy;
import oracle.toplink.mappings.converters.TypeConversionConverter;
import oracle.toplink.mappings.foundation.AbstractCompositeDirectCollectionMapping;
import oracle.toplink.ox.XMLDescriptor;
import oracle.toplink.ox.XMLField;
import oracle.toplink.ox.mappings.XMLMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;

public class XMLCompositeDirectCollectionMapping
extends AbstractCompositeDirectCollectionMapping
implements XMLMapping {
    public boolean isXMLMapping() {
        return true;
    }

    public void initialize(Session session) throws DescriptorException {
        super.initialize(session);
        if (this.getField() instanceof XMLField && this.getValueConverter() instanceof TypeConversionConverter) {
            TypeConversionConverter typeConversionConverter = (TypeConversionConverter)this.getValueConverter();
            this.getField().setType(typeConversionConverter.getObjectClass());
        }
    }

    public void setXPath(String string) {
        if (string.indexOf("@") == -1 && !string.endsWith("text()")) {
            string = string + "/text()";
        }
        this.setField(new XMLField(string));
    }

    public String getXPath() {
        return this.getFieldName();
    }

    public void writeFromObjectIntoRow(Object object, DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly()) {
            return;
        }
        Object object2 = this.getAttributeValueFromObject(object);
        if (object2 == null) {
            databaseRow.put(this.getField(), (Object)null);
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Vector<Object> vector = new Vector<Object>(containerPolicy.sizeFor(object2));
        Object object3 = containerPolicy.iteratorFor(object2);
        while (containerPolicy.hasNext(object3)) {
            Object object4 = containerPolicy.next(object3, session);
            if (this.getValueConverter() != null) {
                object4 = this.getValueConverter().convertObjectValueToDataValue(object4, session);
            }
            if (object4 == null) continue;
            vector.addElement(object4);
        }
        object3 = null;
        if (!vector.isEmpty()) {
            object3 = this.getDescriptor().buildFieldValueFromDirectValues(vector, this.elementDataTypeName, session);
        }
        if (((XMLDescriptor)this.getDescriptor()).shouldPreserveDocument()) {
            databaseRow.put(this.getField(), object3);
        } else {
            databaseRow.add(this.getField(), object3);
        }
    }
}

