/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.ox.jaxb;

import java.io.OutputStream;
import java.io.Writer;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.transform.Result;
import oracle.toplink.ox.XMLMarshaller;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class JAXBMarshaller
implements Marshaller {
    private ValidationEventHandler validationEventHandler = new DefaultValidationEventHandler();
    private XMLMarshaller xmlMarshaller;

    public JAXBMarshaller(XMLMarshaller xMLMarshaller) {
        this.xmlMarshaller = xMLMarshaller;
        this.xmlMarshaller.setEncoding("UTF-8");
        this.xmlMarshaller.setFormattedOutput(false);
    }

    public void marshal(Object object, Result result) throws JAXBException {
        if (object == null || result == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.xmlMarshaller.marshal(object, result);
        }
        catch (Exception exception) {
            throw new MarshalException((Throwable)exception);
        }
    }

    public void marshal(Object object, OutputStream outputStream) throws JAXBException {
        if (object == null || outputStream == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.xmlMarshaller.marshal(object, outputStream);
        }
        catch (Exception exception) {
            throw new MarshalException((Throwable)exception);
        }
    }

    public void marshal(Object object, Writer writer) throws JAXBException {
        if (object == null || writer == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.xmlMarshaller.marshal(object, writer);
        }
        catch (Exception exception) {
            throw new MarshalException((Throwable)exception);
        }
    }

    public void marshal(Object object, ContentHandler contentHandler) throws JAXBException {
        if (object == null || contentHandler == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.xmlMarshaller.marshal(object, contentHandler);
        }
        catch (Exception exception) {
            throw new MarshalException((Throwable)exception);
        }
    }

    public void marshal(Object object, Node node) throws JAXBException {
        if (object == null || node == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.xmlMarshaller.marshal(object, node);
        }
        catch (Exception exception) {
            throw new MarshalException((Throwable)exception);
        }
    }

    public Node getNode(Object object) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    public void setProperty(String string, Object object) throws PropertyException {
        block8: {
            try {
                if (string == null) {
                    throw new IllegalArgumentException();
                }
                if ("jaxb.formatted.output".equals(string)) {
                    Boolean bl = (Boolean)object;
                    this.xmlMarshaller.setFormattedOutput(bl);
                    break block8;
                }
                if ("jaxb.encoding".equals(string)) {
                    this.xmlMarshaller.setEncoding((String)object);
                    break block8;
                }
                if ("jaxb.schemaLocation".equals(string)) {
                    this.xmlMarshaller.setSchemaLocation((String)object);
                    break block8;
                }
                if ("jaxb.noNamespaceSchemaLocation".equals(string)) {
                    this.xmlMarshaller.setNoNamespaceSchemaLocation((String)object);
                    break block8;
                }
                if ("jaxb.fragment".equals(string)) {
                    Boolean bl = (Boolean)object;
                    this.xmlMarshaller.setFragment(bl);
                    break block8;
                }
                throw new PropertyException(string, object);
            }
            catch (ClassCastException classCastException) {
                throw new PropertyException(string, (Throwable)classCastException);
            }
        }
    }

    public Object getProperty(String string) throws PropertyException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if ("jaxb.formatted.output".equals(string)) {
            return new Boolean(this.xmlMarshaller.isFormattedOutput());
        }
        if ("jaxb.encoding".equals(string)) {
            return this.xmlMarshaller.getEncoding();
        }
        if ("jaxb.schemaLocation".equals(string)) {
            return this.xmlMarshaller.getSchemaLocation();
        }
        if ("jaxb.noNamespaceSchemaLocation".equals(string)) {
            return this.xmlMarshaller.getNoNamespaceSchemaLocation();
        }
        if ("jaxb.fragment".equals(string)) {
            return new Boolean(this.xmlMarshaller.isFragment());
        }
        throw new PropertyException("Unsupported Property");
    }

    public void setEventHandler(ValidationEventHandler validationEventHandler) throws JAXBException {
        this.validationEventHandler = null == validationEventHandler ? new DefaultValidationEventHandler() : validationEventHandler;
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.validationEventHandler;
    }
}

