/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.objectrelational;

import java.sql.Array;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.descriptors.RelationalDescriptor;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.internal.expressions.SQLSelectStatement;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.DatabaseTable;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.ValueReadQuery;
import oracle.toplink.sessions.DatabaseRecord;

public class ObjectRelationalDescriptor
extends RelationalDescriptor {
    protected String structureName;
    protected Vector orderedFields = NonSynchronizedVector.newInstance();

    public void addFieldOrdering(String string) {
        this.getOrderedFields().addElement(new DatabaseField(string));
    }

    public Vector buildDirectValuesFromFieldValue(Object object) throws DatabaseException {
        Object[] objectArray = null;
        try {
            objectArray = (Object[])((Array)object).getArray();
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException);
        }
        if (objectArray == null) {
            return null;
        }
        return Helper.vectorFromArray(objectArray);
    }

    public Object buildFieldValueFromDirectValues(Vector vector, String string, Session session) throws DatabaseException {
        Object[] objectArray = Helper.arrayFromVector(vector);
        try {
            return session.getPlatform().createArray(string, objectArray, session);
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException);
        }
    }

    public Object buildFieldValueFromNestedRow(DatabaseRow databaseRow, Session session) throws DatabaseException {
        return this.buildStructureFromRow(databaseRow, session);
    }

    public Object buildFieldValueFromNestedRows(Vector vector, String string, Session session) throws DatabaseException {
        Object[] objectArray = new Object[vector.size()];
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseRow databaseRow = (DatabaseRow)enumeration.nextElement();
            objectArray[n++] = this.buildStructureFromRow(databaseRow, session);
        }
        try {
            return session.getPlatform().createArray(string, objectArray, session);
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException);
        }
    }

    public DatabaseRow buildNestedRowFromFieldValue(Object object) throws DatabaseException {
        return this.buildRowFromStructure((Struct)object);
    }

    public Vector buildNestedRowsFromFieldValue(Object object, Session session) throws DatabaseException {
        Object[] objectArray = null;
        try {
            objectArray = (Object[])((Array)object).getArray();
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException);
        }
        if (objectArray == null) {
            return null;
        }
        Vector<DatabaseRow> vector = new Vector<DatabaseRow>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            Struct struct = (Struct)objectArray[i];
            if (struct == null) {
                return null;
            }
            vector.addElement(this.buildRowFromStructure(struct));
        }
        return vector;
    }

    public DatabaseRow buildRowFromStructure(Struct struct) throws DatabaseException {
        Object[] objectArray;
        DatabaseRecord databaseRecord = new DatabaseRecord();
        try {
            objectArray = struct.getAttributes();
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException);
        }
        for (int i = 0; i < this.getOrderedFields().size(); ++i) {
            DatabaseField databaseField = (DatabaseField)this.getOrderedFields().elementAt(i);
            databaseRecord.put(databaseField, objectArray[i]);
        }
        return databaseRecord;
    }

    public Struct buildStructureFromRow(DatabaseRow databaseRow, Session session) throws DatabaseException {
        Struct struct;
        Object[] objectArray = new Object[this.getOrderedFields().size()];
        for (int i = 0; i < this.getOrderedFields().size(); ++i) {
            DatabaseField databaseField = (DatabaseField)this.getOrderedFields().elementAt(i);
            objectArray[i] = databaseRow.get(databaseField);
        }
        try {
            struct = session.getPlatform().createStruct(this.getStructureName(), objectArray, session);
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException);
        }
        return struct;
    }

    protected DatabaseTable extractDefaultTable() {
        if (this.isAggregateDescriptor()) {
            return new DatabaseTable();
        }
        return super.extractDefaultTable();
    }

    public Vector getOrderedFields() {
        return this.orderedFields;
    }

    public Ref getRef(Object object, Session session) {
        SQLSelectStatement sQLSelectStatement = new SQLSelectStatement();
        sQLSelectStatement.addTable((DatabaseTable)this.getTables().firstElement());
        sQLSelectStatement.getFields().addElement(new ExpressionBuilder().ref());
        sQLSelectStatement.setWhereClause(this.getObjectBuilder().buildPrimaryKeyExpressionFromObject(object, session));
        sQLSelectStatement.setRequiresAliases(true);
        sQLSelectStatement.normalize(session, this);
        ValueReadQuery valueReadQuery = new ValueReadQuery();
        valueReadQuery.setSQLStatement(sQLSelectStatement);
        Ref ref = (Ref)session.executeQuery(valueReadQuery);
        return ref;
    }

    public String getStructureName() {
        return this.structureName;
    }

    public boolean requiresInitialization() {
        return true;
    }

    protected void validateMappingType(DatabaseMapping databaseMapping) {
    }

    public void setOrderedFields(Vector vector) {
        this.orderedFields = vector;
    }

    public void setStructureName(String string) {
        this.structureName = string;
    }
}

