/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.objectrelational;

import java.io.Serializable;
import java.sql.Array;
import java.sql.SQLException;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.internal.databaseaccess.DatabaseAccessor;
import oracle.toplink.internal.expressions.QueryKeyExpression;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.queryframework.ContainerPolicy;
import oracle.toplink.internal.sessions.ChangeRecord;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.mappings.CollectionMapping;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.objectrelational.ObjectRelationalDatabaseField;
import oracle.toplink.objectrelational.ObjectRelationalDescriptor;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.DeleteObjectQuery;
import oracle.toplink.queryframework.InsertObjectQuery;
import oracle.toplink.queryframework.WriteObjectQuery;

public class NestedTableMapping
extends CollectionMapping {
    protected DatabaseMapping nestedMapping;
    protected DatabaseField field;
    protected String structureName;

    public Object clone() {
        NestedTableMapping nestedTableMapping = (NestedTableMapping)super.clone();
        return nestedTableMapping;
    }

    protected Vector collectFields() {
        Vector<DatabaseField> vector = new Vector<DatabaseField>(1);
        vector.addElement(this.getField());
        return vector;
    }

    public DatabaseField getField() {
        return this.field;
    }

    public String getFieldName() {
        return this.getField().getName();
    }

    public Expression getJoinCriteria(QueryKeyExpression queryKeyExpression) {
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        Expression expression = expressionBuilder.ref().equal(expressionBuilder.value());
        return queryKeyExpression.getBaseExpression().twist(expression, queryKeyExpression);
    }

    public String getStructureName() {
        return this.structureName;
    }

    public boolean hasConstraintDependency() {
        return true;
    }

    public void initialize(Session session) throws DescriptorException {
        super.initialize(session);
        if (this.getField() == null) {
            throw DescriptorException.fieldNameNotSetInMapping(this);
        }
        ObjectRelationalDatabaseField objectRelationalDatabaseField = (ObjectRelationalDatabaseField)this.getField();
        objectRelationalDatabaseField.setSqlType(2003);
        objectRelationalDatabaseField.setSqlTypeName(this.getStructureName());
        this.getDescriptor().buildField(this.getField());
    }

    protected void initializeSelectionCriteria(Session session) {
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        Expression expression = expressionBuilder.getManualQueryKey(this.getAttributeName(), this.getDescriptor());
        Expression expression2 = expressionBuilder.ref().equal(expression.get(this.getAttributeName()).value());
        Expression expression3 = this.getDescriptor().getObjectBuilder().getPrimaryKeyExpression().rebuildOn(expression);
        this.setSelectionCriteria(expression2.and(expression3));
    }

    public boolean isNestedTableMapping() {
        return true;
    }

    public void postInitialize(Session session) throws DescriptorException {
        this.initializeSelectionCriteria(session);
    }

    public void preDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(deleteObjectQuery)) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(deleteObjectQuery.getObject(), deleteObjectQuery.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            DeleteObjectQuery deleteObjectQuery2 = new DeleteObjectQuery();
            deleteObjectQuery2.setIsExecutionClone(true);
            deleteObjectQuery2.setObject(containerPolicy.next(object2, deleteObjectQuery.getSession()));
            deleteObjectQuery2.setCascadePolicy(deleteObjectQuery.getCascadePolicy());
            deleteObjectQuery.getSession().executeQuery(deleteObjectQuery2);
        }
        if (!deleteObjectQuery.getSession().isUnitOfWork()) {
            this.verifyDeleteForUpdate(deleteObjectQuery);
        }
    }

    public void preInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            Serializable serializable;
            Object object3 = containerPolicy.next(object2, writeObjectQuery.getSession());
            if (this.isPrivateOwned()) {
                serializable = new InsertObjectQuery();
                serializable.setIsExecutionClone(true);
                serializable.setObject(object3);
                serializable.setCascadePolicy(writeObjectQuery.getCascadePolicy());
                writeObjectQuery.getSession().executeQuery((DatabaseQuery)serializable);
                continue;
            }
            if (writeObjectQuery.getSession().getCommitManager().isCommitInPreModify(object3)) continue;
            serializable = null;
            UnitOfWorkChangeSet unitOfWorkChangeSet = null;
            if (writeObjectQuery.getSession().isUnitOfWork() && ((UnitOfWork)writeObjectQuery.getSession()).getUnitOfWorkChangeSet() != null) {
                unitOfWorkChangeSet = (UnitOfWorkChangeSet)((UnitOfWork)writeObjectQuery.getSession()).getUnitOfWorkChangeSet();
                serializable = (ObjectChangeSet)unitOfWorkChangeSet.getObjectChangeSetForClone(object3);
            }
            WriteObjectQuery writeObjectQuery2 = new WriteObjectQuery();
            writeObjectQuery2.setIsExecutionClone(true);
            writeObjectQuery2.setObject(object3);
            writeObjectQuery2.setObjectChangeSet((ObjectChangeSet)serializable);
            writeObjectQuery2.setCascadePolicy(writeObjectQuery.getCascadePolicy());
            writeObjectQuery.getSession().executeQuery(writeObjectQuery2);
        }
    }

    public void preUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(writeObjectQuery.getObject())) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        Object object2 = this.readPrivateOwnedForObject(writeObjectQuery);
        if (object2 == null) {
            object2 = this.getContainerPolicy().containerInstance(1);
        }
        this.compareObjectsAndWrite(object2, object, writeObjectQuery);
    }

    protected void setField(DatabaseField databaseField) {
        this.field = databaseField;
    }

    public void setFieldName(String string) {
        this.setField(new ObjectRelationalDatabaseField(string));
    }

    public void setStructureName(String string) {
        this.structureName = string;
    }

    protected void verifyDeleteForUpdate(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        Object object = this.readPrivateOwnedForObject(deleteObjectQuery);
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            deleteObjectQuery.getSession().deleteObject(containerPolicy.next(object2, deleteObjectQuery.getSession()));
        }
    }

    public void writeFromObjectIntoRow(Object object, DatabaseRow databaseRow, Session session) {
        Array array;
        Object object2;
        if (this.isReadOnly()) {
            return;
        }
        Object object3 = this.getRealCollectionAttributeValueFromObject(object, session);
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object[] objectArray = new Object[containerPolicy.sizeFor(object3)];
        Object object4 = containerPolicy.iteratorFor(object3);
        for (int i = 0; i < containerPolicy.sizeFor(object3); ++i) {
            object2 = containerPolicy.next(object4, session);
            objectArray[i] = ((ObjectRelationalDescriptor)this.getReferenceDescriptor()).getRef(object2, session);
        }
        try {
            object2 = ((DatabaseAccessor)session.getAccessor()).getConnection();
            array = session.getPlatform().createArray(this.getStructureName(), objectArray, session);
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException);
        }
        databaseRow.put(this.getField(), (Object)array);
    }

    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, DatabaseRow databaseRow, Session session) {
        Array array;
        Object object;
        if (this.isReadOnly()) {
            return;
        }
        Object object2 = ((ObjectChangeSet)changeRecord.getOwner()).getUnitOfWorkClone();
        Object object3 = this.getRealAttributeValueFromObject(object2, session);
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (object3 == null) {
            object3 = containerPolicy.containerInstance(1);
        }
        Object[] objectArray = new Object[containerPolicy.sizeFor(object3)];
        Object object4 = containerPolicy.iteratorFor(object3);
        for (int i = 0; i < containerPolicy.sizeFor(object3); ++i) {
            object = containerPolicy.next(object4, session);
            objectArray[i] = ((ObjectRelationalDescriptor)this.getReferenceDescriptor()).getRef(object, session);
        }
        try {
            object = ((DatabaseAccessor)session.getAccessor()).getConnection();
            array = session.getPlatform().createArray(this.getStructureName(), objectArray, session);
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException);
        }
        databaseRow.put(this.getField(), (Object)array);
    }

    public void writeFromObjectIntoRowForShallowInsert(Object object, DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly()) {
            return;
        }
        databaseRow.put(this.getField(), (Object)null);
    }

    public void writeFromObjectIntoRowForShallowInsertWithChangeRecord(ChangeRecord changeRecord, DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly()) {
            return;
        }
        databaseRow.put(this.getField(), (Object)null);
    }

    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery writeObjectQuery, DatabaseRow databaseRow) throws DescriptorException {
        if (!this.isAttributeValueInstantiatedOrChanged(writeObjectQuery.getObject())) {
            return;
        }
        if (writeObjectQuery.getSession().isUnitOfWork() && this.compareObjects(writeObjectQuery.getObject(), writeObjectQuery.getBackupClone(), writeObjectQuery.getSession())) {
            return;
        }
        this.writeFromObjectIntoRow(writeObjectQuery.getObject(), databaseRow, writeObjectQuery.getSession());
    }

    public void writeInsertFieldsIntoRow(DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly()) {
            return;
        }
        databaseRow.put(this.getField(), (Object)null);
    }
}

