/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.mappings.transformers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.mappings.foundation.AbstractTransformationMapping;
import oracle.toplink.mappings.transformers.FieldTransformer;
import oracle.toplink.sessions.Session;

public class MethodBasedFieldTransformer
implements FieldTransformer {
    protected transient Method fieldTransformationMethod;
    protected String methodName;
    protected AbstractTransformationMapping mapping;

    public MethodBasedFieldTransformer(String string) {
        this.methodName = string;
    }

    public void initialize(AbstractTransformationMapping abstractTransformationMapping) {
        this.mapping = abstractTransformationMapping;
        try {
            this.fieldTransformationMethod = Helper.getDeclaredMethod(abstractTransformationMapping.getDescriptor().getJavaClass(), this.methodName, new Class[0]);
        }
        catch (Exception exception) {
            try {
                Class[] classArray = new Class[]{ClassConstants.PublicInterfaceSession_Class};
                this.fieldTransformationMethod = Helper.getDeclaredMethod(abstractTransformationMapping.getDescriptor().getJavaClass(), this.methodName, classArray);
            }
            catch (Exception exception2) {
                try {
                    Class[] classArray = new Class[]{ClassConstants.SessionsSession_Class};
                    this.fieldTransformationMethod = Helper.getDeclaredMethod(abstractTransformationMapping.getDescriptor().getJavaClass(), this.methodName, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw DescriptorException.noSuchMethodWhileConvertingToMethod(this.methodName, abstractTransformationMapping, noSuchMethodException);
                }
                catch (SecurityException securityException) {
                    throw DescriptorException.securityWhileConvertingToMethod(this.methodName, abstractTransformationMapping, securityException);
                }
            }
        }
    }

    public Object buildFieldValue(Object object, String string, Session session) {
        Class[] classArray = PrivilegedAccessController.getMethodParameterTypes(this.fieldTransformationMethod);
        Object[] objectArray = new Object[classArray.length];
        if (objectArray.length == 1) {
            objectArray[0] = session;
        }
        try {
            return PrivilegedAccessController.invokeMethod(this.fieldTransformationMethod, object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DescriptorException.illegalAccessWhileInvokingFieldToMethod(this.fieldTransformationMethod.getName(), this.mapping, illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DescriptorException.illegalArgumentWhileInvokingFieldToMethod(this.fieldTransformationMethod.getName(), this.mapping, illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DescriptorException.targetInvocationWhileInvokingFieldToMethod(this.fieldTransformationMethod.getName(), this.mapping, invocationTargetException);
        }
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String string) {
        this.methodName = string;
    }
}

