/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.mappings.foundation;

import java.math.BigDecimal;
import java.util.Vector;
import oracle.toplink.exceptions.ConversionException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.descriptors.DescriptorIterator;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.sessions.ChangeRecord;
import oracle.toplink.internal.sessions.DirectToFieldChangeRecord;
import oracle.toplink.internal.sessions.MergeManager;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.converters.Converter;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.QueryByExamplePolicy;
import oracle.toplink.queryframework.WriteObjectQuery;
import oracle.toplink.remote.RemoteSession;
import oracle.toplink.sessions.ObjectCopyingPolicy;

public abstract class AbstractDirectMapping
extends DatabaseMapping {
    protected DatabaseField field;
    protected transient Class attributeClassification;
    protected transient String attributeClassificationName;
    protected transient Class attributeObjectClassification;
    protected Converter converter;
    protected transient Object nullValue;
    protected Boolean isMutable;

    public AbstractDirectMapping() {
        this.setWeight(WEIGHT_1);
    }

    public Converter getConverter() {
        return this.converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public boolean isMutable() {
        if (this.isMutable == null) {
            return false;
        }
        return this.isMutable;
    }

    public void setIsMutable(boolean bl) {
        this.isMutable = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public void buildBackupClone(Object object, Object object2, UnitOfWork unitOfWork) {
        this.buildClone(object, object2, unitOfWork);
    }

    public void buildClone(Object object, Object object2, UnitOfWork unitOfWork) {
        this.buildCloneValue(object, object2, unitOfWork);
    }

    public void buildCloneValue(Object object, Object object2, Session session) {
        if (this.isCloningRequired()) {
            Object object3 = this.getAttributeValueFromObject(object);
            if (this.isMutable()) {
                object3 = this.getAttributeValue(this.getFieldValue(object3, session), session);
            }
            this.setAttributeValueInObject(object2, object3);
        }
    }

    public void buildCopy(Object object, Object object2, ObjectCopyingPolicy objectCopyingPolicy) {
        this.buildCloneValue(object2, object, objectCopyingPolicy.getSession());
    }

    public Expression buildExpression(Object object, QueryByExamplePolicy queryByExamplePolicy, Expression expression, IdentityHashtable identityHashtable, Session session) {
        String string = this.getAttributeName();
        Object object2 = this.getAttributeValueFromObject(object);
        if (!queryByExamplePolicy.shouldIncludeInQuery(object.getClass(), string, object2)) {
            return null;
        }
        Expression expression2 = expression.get(string);
        expression2 = object2 == null ? queryByExamplePolicy.completeExpressionForNull(expression2) : queryByExamplePolicy.completeExpression(expression2, object2, object2.getClass());
        return expression2;
    }

    public void cascadePerformRemoveIfRequired(Object object, UnitOfWork unitOfWork, IdentityHashtable identityHashtable) {
    }

    public void cascadeRegisterNewIfRequired(Object object, UnitOfWork unitOfWork, IdentityHashtable identityHashtable) {
    }

    public Object clone() {
        AbstractDirectMapping abstractDirectMapping = (AbstractDirectMapping)super.clone();
        abstractDirectMapping.setField((DatabaseField)this.getField().clone());
        return abstractDirectMapping;
    }

    protected Vector collectFields() {
        Vector<DatabaseField> vector = new Vector<DatabaseField>(1);
        vector.addElement(this.getField());
        return vector;
    }

    public ChangeRecord compareForChange(Object object, Object object2, ObjectChangeSet objectChangeSet, Session session) {
        if (objectChangeSet.isNew() || !this.compareObjects(object2, object, session)) {
            return this.buildChangeRecord(object, objectChangeSet, session);
        }
        return null;
    }

    public ChangeRecord buildChangeRecord(Object object, ObjectChangeSet objectChangeSet, Session session) {
        return this.internalBuildChangeRecord(this.getAttributeValueFromObject(object), objectChangeSet);
    }

    public ChangeRecord internalBuildChangeRecord(Object object, ObjectChangeSet objectChangeSet) {
        DirectToFieldChangeRecord directToFieldChangeRecord = new DirectToFieldChangeRecord(objectChangeSet);
        directToFieldChangeRecord.setAttribute(this.getAttributeName());
        directToFieldChangeRecord.setMapping(this);
        directToFieldChangeRecord.setNewValue(object);
        return directToFieldChangeRecord;
    }

    public boolean compareObjects(Object object, Object object2, Session session) {
        Object object3;
        Object object4 = this.getAttributeValueFromObject(object);
        if (object4 == (object3 = this.getAttributeValueFromObject(object2))) {
            return true;
        }
        if ((object4 = this.getFieldValue(object4, session)) == (object3 = this.getFieldValue(object3, session))) {
            return true;
        }
        if (object4 == null || object3 == null) {
            return false;
        }
        if (object4.getClass() == ClassConstants.APBYTE && object3.getClass() == ClassConstants.APBYTE) {
            return Helper.compareByteArrays((byte[])object4, (byte[])object3);
        }
        if (object4.getClass() == ClassConstants.APCHAR && object3.getClass() == ClassConstants.APCHAR) {
            return Helper.compareCharArrays((char[])object4, (char[])object3);
        }
        if (object4.getClass().isArray() && object3.getClass().isArray()) {
            return Helper.compareArrays((Object[])object4, (Object[])object3);
        }
        if (object4 instanceof BigDecimal && object3 instanceof BigDecimal) {
            return Helper.compareBigDecimals((BigDecimal)object4, (BigDecimal)object3);
        }
        return object4.equals(object3);
    }

    public void fixObjectReferences(Object object, IdentityHashtable identityHashtable, IdentityHashtable identityHashtable2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
    }

    public Class getAttributeClassification() {
        return this.attributeClassification;
    }

    public String getAttributeClassificationName() {
        return this.attributeClassificationName;
    }

    public Object getAttributeValue(Object object, Session session) {
        Object object2 = object;
        if (object == null && this.nullValue != null) {
            return this.nullValue;
        }
        if (this.converter != null) {
            object2 = this.converter.convertDataValueToObjectValue(object2, session);
        } else if (object2 == null || object2.getClass() != this.attributeObjectClassification) {
            try {
                object2 = session.getDatasourcePlatform().convertObject(object2, this.attributeClassification);
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
        }
        if (object2 == null) {
            object2 = this.nullValue;
        }
        return object2;
    }

    public DatabaseField getField() {
        return this.field;
    }

    public boolean isAbstractDirectMapping() {
        return true;
    }

    public Class getFieldClassification(DatabaseField databaseField) {
        if (databaseField.type != null) {
            return databaseField.type;
        }
        if (this.converter != null) {
            return null;
        }
        return this.attributeClassification;
    }

    public Class getFieldClassification() {
        if (this.getField() == null) {
            return null;
        }
        return this.getField().getType();
    }

    public void setFieldClassification(Class clazz) {
        this.getField().setType(clazz);
    }

    public void setFieldType(int n) {
        this.getField().setSqlType(n);
    }

    public String getFieldName() {
        return this.getField().getQualifiedName();
    }

    public Object getFieldValue(Object object, Session session) {
        Object object2 = object;
        if (this.nullValue != null && this.nullValue.equals(object2)) {
            return null;
        }
        if (this.converter != null) {
            object2 = this.converter.convertObjectValueToDataValue(object2, session);
        }
        Class clazz = this.getFieldClassification(this.getField());
        if (object2 != null && clazz != object2.getClass()) {
            try {
                object2 = session.getPlatform(this.descriptor.getJavaClass()).convertObject(object2, clazz);
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.descriptor, conversionException);
            }
        }
        return object2;
    }

    public Object getNullValue() {
        return this.nullValue;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public void preInitialize(Session session) throws DescriptorException {
        super.preInitialize(session);
        this.attributeClassification = this.getAttributeAccessor().getAttributeClass();
        this.attributeObjectClassification = Helper.getObjectClass(this.attributeClassification);
    }

    public void initialize(Session session) throws DescriptorException {
        super.initialize(session);
        if (this.isMutable == null) {
            if (this.getConverter() != null) {
                this.setIsMutable(this.getConverter().isMutable());
            } else {
                this.setIsMutable(false);
            }
        }
        if (this.getField() == null) {
            session.getIntegrityChecker().handleError(DescriptorException.fieldNameNotSetInMapping(this));
        }
        this.getDescriptor().buildField(this.getField());
        this.setFields(this.collectFields());
        if (this.getConverter() != null) {
            this.getConverter().initialize(this, session);
        }
    }

    public boolean isDirectToFieldMapping() {
        return true;
    }

    public void iterate(DescriptorIterator descriptorIterator) {
        if (descriptorIterator.shouldIterateOnPrimitives()) {
            descriptorIterator.iteratePrimitiveForMapping(this.getAttributeValueFromObject(descriptorIterator.getVisitedParent()), this);
        }
    }

    public void mergeChangesIntoObject(Object object, ChangeRecord changeRecord, Object object2, MergeManager mergeManager) {
        this.setAttributeValueInObject(object, ((DirectToFieldChangeRecord)changeRecord).getNewValue());
    }

    public void mergeIntoObject(Object object, boolean bl, Object object2, MergeManager mergeManager) {
        Object object3 = this.getAttributeValueFromObject(object2);
        if (this.getDescriptor().getObjectChangePolicy().isObjectChangeTrackingPolicy() && !this.compareObjects(object, object2, mergeManager.getSession())) {
            Object object4 = this.getAttributeValueFromObject(object);
            this.setAttributeValueInObject(object, object3);
            this.getDescriptor().getObjectChangePolicy().raiseInternalPropertyChangeEvent(object, this.getAttributeName(), object4, object3);
        } else {
            this.setAttributeValueInObject(object, object3);
        }
    }

    public void setAttributeClassification(Class clazz) {
        this.attributeClassification = clazz;
    }

    public void setAttributeClassificationName(String string) {
        this.attributeClassificationName = string;
    }

    public void setField(DatabaseField databaseField) {
        this.field = databaseField;
    }

    public void setNullValue(Object object) {
        this.nullValue = object;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getAttributeName() + "-->" + this.getField() + "]";
    }

    public void updateChangeRecord(Object object, Object object2, Object object3, ObjectChangeSet objectChangeSet, UnitOfWork unitOfWork) {
        DirectToFieldChangeRecord directToFieldChangeRecord = (DirectToFieldChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (directToFieldChangeRecord == null) {
            objectChangeSet.addChange(this.internalBuildChangeRecord(object2, objectChangeSet));
        } else {
            directToFieldChangeRecord.setNewValue(object2);
        }
    }

    public boolean isChangeTrackingSupported() {
        return !this.isMutable();
    }

    public boolean isCloningRequired() {
        return this.isMutable() || this.getDescriptor().getCopyPolicy().buildsNewInstance();
    }

    public void validateBeforeInitialization(Session session) throws DescriptorException {
        if (this.getFieldName() == null || this.getFieldName().length() == 0) {
            session.getIntegrityChecker().handleError(DescriptorException.noFieldNameForMapping(this));
        }
    }

    public Object valueFromObject(Object object, DatabaseField databaseField, Session session) throws DescriptorException {
        return this.getFieldValue(this.getAttributeValueFromObject(object), session);
    }

    public void buildCloneFromRow(DatabaseRow databaseRow, Object object, ObjectLevelReadQuery objectLevelReadQuery, UnitOfWork unitOfWork, Session session) {
        Object object2 = this.valueFromRow(databaseRow, objectLevelReadQuery, session);
        this.setAttributeValueInObject(object, object2);
    }

    public void buildShallowOriginalFromRow(DatabaseRow databaseRow, Object object, ObjectLevelReadQuery objectLevelReadQuery, Session session) {
        this.readFromRowIntoObject(databaseRow, object, objectLevelReadQuery, session);
    }

    public Object valueFromRow(DatabaseRow databaseRow, ObjectLevelReadQuery objectLevelReadQuery, Session session) {
        Object object = databaseRow.get(this.field);
        Object object2 = this.getAttributeValue(object, session);
        return object2;
    }

    public void writeFromObjectIntoRow(Object object, DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly()) {
            return;
        }
        Object object2 = this.getAttributeValueFromObject(object);
        Object object3 = this.getFieldValue(object2, session);
        this.writeValueIntoRow(databaseRow, this.getField(), object3);
    }

    protected abstract void writeValueIntoRow(DatabaseRow var1, DatabaseField var2, Object var3);

    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly()) {
            return;
        }
        Object object = ((DirectToFieldChangeRecord)changeRecord).getNewValue();
        Object object2 = this.getFieldValue(object, session);
        databaseRow.add(this.getField(), object2);
    }

    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery writeObjectQuery, DatabaseRow databaseRow) {
        if (writeObjectQuery.getSession().isUnitOfWork() && this.compareObjects(writeObjectQuery.getBackupClone(), writeObjectQuery.getObject(), writeObjectQuery.getSession())) {
            return;
        }
        super.writeFromObjectIntoRowForUpdate(writeObjectQuery, databaseRow);
    }

    public void writeInsertFieldsIntoRow(DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly()) {
            return;
        }
        databaseRow.add(this.getField(), null);
    }
}

