/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.mappings.foundation;

import java.io.Serializable;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.internal.descriptors.ObjectBuilder;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.sessions.ChangeRecord;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.mappings.AggregateMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.WriteObjectQuery;

public abstract class AbstractCompositeObjectMapping
extends AggregateMapping {
    protected DatabaseField field;

    public void cascadePerformRemoveIfRequired(Object object, UnitOfWork unitOfWork, IdentityHashtable identityHashtable) {
        Object object2 = this.getRealAttributeValueFromObject(object, unitOfWork);
        if (object2 == null) {
            return;
        }
        if (!identityHashtable.contains(object2)) {
            identityHashtable.put(object2, object2);
            ObjectBuilder objectBuilder = this.getReferenceDescriptor(object2.getClass(), (Session)unitOfWork).getObjectBuilder();
            objectBuilder.cascadePerformRemove(object2, unitOfWork, identityHashtable);
        }
    }

    public void cascadeRegisterNewIfRequired(Object object, UnitOfWork unitOfWork, IdentityHashtable identityHashtable) {
        Object object2 = this.getRealAttributeValueFromObject(object, unitOfWork);
        if (object2 == null) {
            return;
        }
        if (!identityHashtable.contains(object2)) {
            identityHashtable.put(object2, object2);
            ObjectBuilder objectBuilder = this.getReferenceDescriptor(object2.getClass(), (Session)unitOfWork).getObjectBuilder();
            objectBuilder.cascadeRegisterNewForCreate(object2, unitOfWork, identityHashtable);
        }
    }

    protected Vector collectFields() {
        Vector<DatabaseField> vector = new Vector<DatabaseField>(1);
        vector.addElement(this.getField());
        return vector;
    }

    public DatabaseField getField() {
        return this.field;
    }

    public boolean isAbstractCompositeObjectMapping() {
        return true;
    }

    public void initialize(Session session) throws DescriptorException {
        super.initialize(session);
        if (this.getField() == null) {
            throw DescriptorException.fieldNameNotSetInMapping(this);
        }
        this.getDescriptor().buildField(this.getField());
        this.setFields(this.collectFields());
    }

    protected void setField(DatabaseField databaseField) {
        this.field = databaseField;
    }

    public Object valueFromObject(Object object, DatabaseField databaseField, Session session) throws DescriptorException {
        Object object2 = this.getAttributeValueFromObject(object);
        if (object2 == null) {
            return null;
        }
        return this.getObjectBuilder(object2, session).extractValueFromObjectForField(object2, databaseField, session);
    }

    public Object valueFromRow(DatabaseRow databaseRow, ObjectLevelReadQuery objectLevelReadQuery, Session session) throws DatabaseException {
        Serializable serializable;
        Object object = databaseRow.get(this.getField());
        if (object == null || object instanceof String) {
            return null;
        }
        DatabaseRow databaseRow2 = this.getReferenceDescriptor().buildNestedRowFromFieldValue(object);
        Descriptor descriptor = this.getReferenceDescriptor();
        if (descriptor.hasInheritance()) {
            serializable = descriptor.getInheritancePolicy().classFromRow(databaseRow2, session);
            descriptor = this.getReferenceDescriptor((Class)serializable, session);
        }
        serializable = descriptor.getObjectBuilder();
        Object object2 = this.buildCompositeObject((ObjectBuilder)serializable, databaseRow2, objectLevelReadQuery);
        return object2;
    }

    public void buildShallowOriginalFromRow(DatabaseRow databaseRow, Object object, ObjectLevelReadQuery objectLevelReadQuery, Session session) {
        Serializable serializable;
        Object object2 = databaseRow.get(this.getField());
        if (object2 == null || object2 instanceof String) {
            return;
        }
        DatabaseRow databaseRow2 = this.getReferenceDescriptor().buildNestedRowFromFieldValue(object2);
        Descriptor descriptor = this.getReferenceDescriptor();
        if (descriptor.hasInheritance()) {
            serializable = descriptor.getInheritancePolicy().classFromRow(databaseRow2, session);
            descriptor = this.getReferenceDescriptor((Class)serializable, session);
        }
        serializable = descriptor.getObjectBuilder();
        Object object3 = ((ObjectBuilder)serializable).buildNewInstance();
        ((ObjectBuilder)serializable).buildAttributesIntoShallowObject(object3, databaseRow2, objectLevelReadQuery);
        this.setAttributeValueInObject(object, object3);
    }

    protected abstract Object buildCompositeObject(ObjectBuilder var1, DatabaseRow var2, ObjectLevelReadQuery var3);

    public void writeFromObjectIntoRow(Object object, DatabaseRow databaseRow, Session session) throws DescriptorException {
        if (this.isReadOnly()) {
            return;
        }
        Object object2 = this.getAttributeValueFromObject(object);
        if (object2 == null) {
            databaseRow.put(this.getField(), (Object)null);
        } else {
            Object object3 = this.buildCompositeRow(object2, session, databaseRow);
            databaseRow.put(this.getField(), object3);
        }
    }

    protected abstract Object buildCompositeRow(Object var1, Session var2, DatabaseRow var3);

    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery writeObjectQuery, DatabaseRow databaseRow) throws DescriptorException {
        if (writeObjectQuery.getSession().isUnitOfWork() && this.compareObjects(writeObjectQuery.getObject(), writeObjectQuery.getBackupClone(), writeObjectQuery.getSession())) {
            return;
        }
        this.writeFromObjectIntoRow(writeObjectQuery.getObject(), databaseRow, writeObjectQuery.getSession());
    }

    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, DatabaseRow databaseRow, Session session) throws DescriptorException {
        Object object = ((ObjectChangeSet)changeRecord.getOwner()).getUnitOfWorkClone();
        this.writeFromObjectIntoRow(object, databaseRow, session);
    }

    public void writeInsertFieldsIntoRow(DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly()) {
            return;
        }
        databaseRow.put(this.getField(), (Object)null);
    }
}

