/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.mappings;

import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.history.AsOfClause;
import oracle.toplink.indirection.ValueHolderInterface;
import oracle.toplink.internal.descriptors.DescriptorIterator;
import oracle.toplink.internal.descriptors.InstanceVariableAttributeAccessor;
import oracle.toplink.internal.descriptors.MethodAttributeAccessor;
import oracle.toplink.internal.expressions.ForUpdateOfClause;
import oracle.toplink.internal.expressions.ObjectExpression;
import oracle.toplink.internal.expressions.QueryKeyExpression;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.indirection.BasicIndirectionPolicy;
import oracle.toplink.internal.indirection.ContainerIndirectionPolicy;
import oracle.toplink.internal.indirection.IndirectionPolicy;
import oracle.toplink.internal.indirection.NoIndirectionPolicy;
import oracle.toplink.internal.indirection.UnitOfWorkQueryValueHolder;
import oracle.toplink.internal.indirection.UnitOfWorkValueHolder;
import oracle.toplink.internal.remote.RemoteSessionController;
import oracle.toplink.internal.remote.RemoteValueHolder;
import oracle.toplink.internal.sessions.MergeManager;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelModifyQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadAllQuery;
import oracle.toplink.queryframework.ReadQuery;
import oracle.toplink.remote.DistributedSession;
import oracle.toplink.remote.RemoteSession;

public abstract class ForeignReferenceMapping
extends DatabaseMapping {
    protected Class referenceClass;
    protected String referenceClassName;
    protected transient Session tempInitSession;
    protected transient Descriptor referenceDescriptor;
    protected transient ReadQuery selectionQuery;
    protected boolean isPrivateOwned = false;
    protected boolean usesBatchReading = false;
    protected IndirectionPolicy indirectionPolicy;
    protected transient boolean hasCustomSelectionQuery = false;
    protected DatabaseMapping relationshipPartner;
    protected String relationshipPartnerAttributeName;
    protected boolean cascadePersist;
    protected boolean cascadeMerge;
    protected boolean cascadeRefresh;
    protected boolean cascadeRemove;

    protected ForeignReferenceMapping() {
        this.useBasicIndirection();
        this.cascadePersist = false;
        this.cascadeMerge = false;
        this.cascadeRefresh = false;
        this.cascadeRemove = false;
    }

    protected Object batchedValueFromRow(DatabaseRow databaseRow, ReadAllQuery readAllQuery) {
        ReadQuery readQuery = (ReadQuery)readAllQuery.getProperty(this);
        if (readQuery == null) {
            if (readAllQuery.getBatchReadMappingQueries() != null) {
                readQuery = (ReadQuery)readAllQuery.getBatchReadMappingQueries().get(this);
            }
            if (readQuery == null) {
                readQuery = this.prepareNestedBatchQuery(readAllQuery);
                readQuery.setIsExecutionClone(true);
            } else {
                readQuery = (ReadQuery)readQuery.clone();
                readQuery.setIsExecutionClone(true);
            }
            readAllQuery.setProperty(this, readQuery);
        }
        return this.getIndirectionPolicy().valueFromBatchQuery(readQuery, databaseRow, readAllQuery);
    }

    public void buildBackupClone(Object object, Object object2, UnitOfWork unitOfWork) {
        Object object3 = this.getAttributeValueFromObject(object);
        Object object4 = this.getIndirectionPolicy().backupCloneAttribute(object3, object, object2, unitOfWork);
        this.setAttributeValueInObject(object2, object4);
    }

    public abstract Object buildBackupCloneForPartObject(Object var1, Object var2, Object var3, UnitOfWork var4);

    public void buildClone(Object object, Object object2, UnitOfWork unitOfWork) {
        Object object3 = this.getAttributeValueFromObject(object);
        Object object4 = this.getIndirectionPolicy().cloneAttribute(object3, object, object2, unitOfWork, false);
        this.setAttributeValueInObject(object2, object4);
    }

    public void buildCloneFromRow(DatabaseRow databaseRow, Object object, ObjectLevelReadQuery objectLevelReadQuery, UnitOfWork unitOfWork, Session session) {
        Object object2 = this.valueFromRow(databaseRow, objectLevelReadQuery, session);
        Object object3 = this.getIndirectionPolicy().cloneAttribute(object2, null, object, unitOfWork, true);
        this.setAttributeValueInObject(object, object3);
    }

    public abstract Object buildCloneForPartObject(Object var1, Object var2, Object var3, UnitOfWork var4, boolean var5);

    public Object clone() {
        ForeignReferenceMapping foreignReferenceMapping = (ForeignReferenceMapping)super.clone();
        foreignReferenceMapping.setIndirectionPolicy((IndirectionPolicy)this.indirectionPolicy.clone());
        foreignReferenceMapping.setSelectionQuery((ReadQuery)this.getSelectionQuery().clone());
        return foreignReferenceMapping;
    }

    public boolean compareObjects(Object object, Object object2, Session session) {
        if (this.isPrivateOwned()) {
            return this.compareObjectsWithPrivateOwned(object, object2, session);
        }
        return this.compareObjectsWithoutPrivateOwned(object, object2, session);
    }

    protected abstract boolean compareObjectsWithoutPrivateOwned(Object var1, Object var2, Session var3);

    protected abstract boolean compareObjectsWithPrivateOwned(Object var1, Object var2, Session var3);

    public UnitOfWorkValueHolder createUnitOfWorkValueHolder(ValueHolderInterface valueHolderInterface, Object object, Object object2, DatabaseRow databaseRow, UnitOfWork unitOfWork, boolean bl) {
        return new UnitOfWorkQueryValueHolder(valueHolderInterface, object2, this, databaseRow, unitOfWork);
    }

    protected boolean dontDoMerge(Object object, Object object2, MergeManager mergeManager) {
        if (!this.shouldMergeCascadeReference(mergeManager)) {
            return true;
        }
        if (mergeManager.shouldMergeOriginalIntoWorkingCopy()) {
            if (!this.isAttributeValueInstantiated(object)) {
                return true;
            }
        } else {
            if (mergeManager.shouldRefreshRemoteObject() && this.shouldMergeCascadeParts(mergeManager) && this.usesIndirection()) {
                return true;
            }
            if (!this.isAttributeValueInstantiated(object2)) {
                return true;
            }
        }
        return false;
    }

    public void dontUseBatchReading() {
        this.setUsesBatchReading(false);
    }

    public void dontUseIndirection() {
        this.setIndirectionPolicy(new NoIndirectionPolicy());
    }

    public Object extractResultFromBatchQuery(DatabaseQuery databaseQuery, DatabaseRow databaseRow, Session session, DatabaseRow databaseRow2) throws QueryException {
        throw QueryException.batchReadingNotSupported(this, databaseQuery);
    }

    public ObjectLevelReadQuery prepareNestedJoinQuery(ObjectLevelReadQuery objectLevelReadQuery) {
        ObjectLevelReadQuery objectLevelReadQuery2 = (ObjectLevelReadQuery)((ObjectLevelReadQuery)this.getSelectionQuery()).deepClone();
        objectLevelReadQuery2.setSession(objectLevelReadQuery.getSession());
        if (objectLevelReadQuery.hasPartialAttributeExpressions()) {
            objectLevelReadQuery2.setPartialAttributeExpressions(this.extractNestedExpressions(objectLevelReadQuery.getPartialAttributeExpressions(), objectLevelReadQuery2.getExpressionBuilder(), false));
        } else {
            objectLevelReadQuery2.setJoinedMappingIndexes(null);
            objectLevelReadQuery2.setJoinedMappingExpressions(NonSynchronizedVector.newInstance(1));
            objectLevelReadQuery2.setJoinedAttributeExpressions(this.extractNestedExpressions(objectLevelReadQuery.getJoinedAttributeExpressions(), objectLevelReadQuery2.getExpressionBuilder(), false));
            objectLevelReadQuery2.computeJoiningMappingIndexes(false);
            if (objectLevelReadQuery.isLockQuery()) {
                if (objectLevelReadQuery.getLockingClause().isForUpdateOfClause()) {
                    ForUpdateOfClause forUpdateOfClause = (ForUpdateOfClause)objectLevelReadQuery.getLockingClause().clone();
                    forUpdateOfClause.setLockedExpressions(this.extractNestedExpressions(forUpdateOfClause.getLockedExpressions(), objectLevelReadQuery2.getExpressionBuilder(), true));
                    objectLevelReadQuery2.setLockingClause(forUpdateOfClause);
                } else {
                    objectLevelReadQuery2.setLockingClause(objectLevelReadQuery.getLockingClause());
                }
            }
        }
        objectLevelReadQuery2.setShouldMaintainCache(objectLevelReadQuery.shouldMaintainCache());
        objectLevelReadQuery2.setShouldRefreshIdentityMapResult(objectLevelReadQuery.shouldRefreshIdentityMapResult());
        if (objectLevelReadQuery.hasAsOfClause()) {
            objectLevelReadQuery2.setAsOfClause(objectLevelReadQuery.getAsOfClause());
        }
        objectLevelReadQuery2.setCascadePolicy(objectLevelReadQuery.getCascadePolicy());
        objectLevelReadQuery2.computeJoiningMappingQueries();
        objectLevelReadQuery2.setSession(null);
        return objectLevelReadQuery2;
    }

    protected void postPrepareNestedBatchQuery(ReadQuery readQuery, ReadAllQuery readAllQuery) {
    }

    public ReadQuery prepareNestedBatchQuery(ReadAllQuery readAllQuery) {
        Object object;
        ReadQuery readQuery;
        Descriptor descriptor;
        ReadAllQuery readAllQuery2 = new ReadAllQuery();
        readAllQuery2.setReferenceClass(this.getReferenceClass());
        readAllQuery2.setSession(readAllQuery.getSession());
        readAllQuery2.setShouldUseWrapperPolicy(false);
        if (readAllQuery.shouldCascadeAllParts() || readAllQuery.shouldCascadePrivateParts() && this.isPrivateOwned() || readAllQuery.shouldCascadeByMapping() && this.cascadeRefresh) {
            readAllQuery2.setShouldRefreshIdentityMapResult(readAllQuery.shouldRefreshIdentityMapResult());
            readAllQuery2.setCascadePolicy(readAllQuery.getCascadePolicy());
            readAllQuery2.setShouldMaintainCache(readAllQuery.shouldMaintainCache());
            readAllQuery2.setQueryId(readAllQuery.getQueryId());
            if (readAllQuery.hasAsOfClause()) {
                readAllQuery2.setAsOfClause(readAllQuery.getAsOfClause());
            }
            readAllQuery2.setShouldBindAllParameters(readAllQuery.getShouldBindAllParameters());
            readAllQuery2.setShouldPrepare(readAllQuery.shouldPrepare());
        }
        if ((descriptor = readAllQuery.getDescriptor()) != this.getDescriptor() && !descriptor.getMappings().contains(this)) {
            descriptor = this.getDescriptor();
        }
        ExpressionBuilder expressionBuilder = readAllQuery2.getExpressionBuilder();
        Expression expression = expressionBuilder.getManualQueryKey(this.getAttributeName() + "-back-ref", descriptor);
        Expression expression2 = expression.twist(this.getSelectionCriteria(), expressionBuilder);
        if (readAllQuery.getSelectionCriteria() != null) {
            expression2 = expression2.and(readAllQuery.getSelectionCriteria().cloneUsing(expression));
        }
        if (descriptor.getQueryManager().getAdditionalJoinExpression() != null) {
            expression2 = expression2.and(descriptor.getQueryManager().getAdditionalJoinExpression().rebuildOn(expression));
        }
        if (descriptor.getHistoryPolicy() != null) {
            if (readAllQuery.getSession().getAsOfClause() != null) {
                expression.asOf(readAllQuery.getSession().getAsOfClause());
            } else if (readAllQuery2.getAsOfClause() == null) {
                expression.asOf(AsOfClause.NO_CLAUSE);
            } else {
                expression.asOf(readAllQuery2.getAsOfClause());
            }
            expression2 = expression2.and(descriptor.getHistoryPolicy().additionalHistoryExpression((ObjectExpression)expression));
        }
        readAllQuery2.setSelectionCriteria(expression2);
        if (readAllQuery.isDistinctComputed()) {
            readAllQuery2.setDistinctState(readAllQuery.getDistinctState());
        }
        if ((readQuery = this.getSelectionQuery()).isReadAllQuery()) {
            readAllQuery2.setOrderByExpressions((Vector)((ReadAllQuery)readQuery).getOrderByExpressions().clone());
            object = ((ReadAllQuery)readQuery).getBatchReadAttributeExpressions().elements();
            while (object.hasMoreElements()) {
                Expression expression3 = ((Expression)object.nextElement()).rebuildOn(readAllQuery2.getExpressionBuilder());
                readAllQuery2.addBatchReadAttribute(expression3);
            }
        }
        object = this.extractNestedExpressions(readAllQuery.getBatchReadAttributeExpressions(), readAllQuery2.getExpressionBuilder(), false);
        Helper.addAllToVector(readAllQuery2.getBatchReadAttributeExpressions(), (Vector)object);
        this.postPrepareNestedBatchQuery(readAllQuery2, readAllQuery);
        if (readAllQuery2.shouldPrepare()) {
            readAllQuery2.checkPrepare(readAllQuery.getSession(), readAllQuery.getTranslationRow());
        }
        readAllQuery2.setSession(null);
        return readAllQuery2;
    }

    protected Hashtable getBatchReadObjects(DatabaseQuery databaseQuery, Session session) {
        if (session.isUnitOfWork()) {
            UnitOfWork unitOfWork = (UnitOfWork)session;
            return (Hashtable)unitOfWork.getBatchReadObjects().get(databaseQuery);
        }
        return (Hashtable)databaseQuery.getProperty("batched objects");
    }

    protected void setBatchReadObjects(Hashtable hashtable, DatabaseQuery databaseQuery, Session session) {
        if (session.isUnitOfWork()) {
            UnitOfWork unitOfWork = (UnitOfWork)session;
            unitOfWork.getBatchReadObjects().put(databaseQuery, hashtable);
        } else {
            databaseQuery.setProperty("batched objects", hashtable);
        }
    }

    public void fixObjectReferences(Object object, IdentityHashtable identityHashtable, IdentityHashtable identityHashtable2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
        this.getIndirectionPolicy().fixObjectReferences(object, identityHashtable, identityHashtable2, objectLevelReadQuery, remoteSession);
    }

    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
        Object object2 = super.getAttributeValueFromObject(object);
        Object object3 = this.getIndirectionPolicy().validateAttributeOfInstantiatedObject(object2);
        if (object3 != object2) {
            this.setAttributeValueInObject(object, object3);
            object2 = object3;
        }
        return object2;
    }

    public IndirectionPolicy getIndirectionPolicy() {
        return this.indirectionPolicy;
    }

    public Expression getJoinCriteria(QueryKeyExpression queryKeyExpression) {
        Expression expression = this.getSelectionCriteria();
        return queryKeyExpression.getBaseExpression().twist(expression, queryKeyExpression);
    }

    public Object getObjectCorrespondingTo(Object object, RemoteSession remoteSession, IdentityHashtable identityHashtable, IdentityHashtable identityHashtable2, ObjectLevelReadQuery objectLevelReadQuery) {
        return remoteSession.getObjectCorrespondingTo(object, identityHashtable, identityHashtable2, objectLevelReadQuery);
    }

    public Object getRealAttributeValueFromObject(Object object, Session session) {
        return this.getIndirectionPolicy().getRealAttributeValueFromObject(this.getAttributeValueFromObject(object));
    }

    public Class getReferenceClass() {
        return this.referenceClass;
    }

    public String getReferenceClassName() {
        if (this.referenceClassName == null && this.referenceClass != null) {
            this.referenceClassName = this.referenceClass.getName();
        }
        return this.referenceClassName;
    }

    public Descriptor getReferenceDescriptor() {
        if (this.referenceDescriptor == null) {
            if (this.getTempSession() == null) {
                return null;
            }
            this.referenceDescriptor = this.getTempSession().getDescriptor(this.getReferenceClass());
        }
        return this.referenceDescriptor;
    }

    public DatabaseMapping getRelationshipPartner() {
        if (this.relationshipPartner == null && this.relationshipPartnerAttributeName != null) {
            this.setRelationshipPartner(this.getReferenceDescriptor().getMappingForAttributeName(this.getRelationshipPartnerAttributeName()));
        }
        return this.relationshipPartner;
    }

    public String getRelationshipPartnerAttributeName() {
        return this.relationshipPartnerAttributeName;
    }

    public Expression getSelectionCriteria() {
        return this.getSelectionQuery().getSelectionCriteria();
    }

    public ReadQuery getSelectionQuery() {
        return this.selectionQuery;
    }

    protected Session getTempSession() {
        return this.tempInitSession;
    }

    public Object getValueFromRemoteValueHolder(RemoteValueHolder remoteValueHolder) {
        return this.getIndirectionPolicy().getValueFromRemoteValueHolder(remoteValueHolder);
    }

    public boolean hasCustomSelectionQuery() {
        return this.hasCustomSelectionQuery;
    }

    public void initialize(Session session) throws DescriptorException {
        super.initialize(session);
        this.initializeReferenceDescriptor(session);
        this.initializeSelectionQuery(session);
        this.getIndirectionPolicy().initialize();
    }

    protected void initializeReferenceDescriptor(Session session) throws DescriptorException {
        if (this.getReferenceClass() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        Descriptor descriptor = session.getDescriptor(this.getReferenceClass());
        if (descriptor == null) {
            throw DescriptorException.descriptorIsMissing(this.getReferenceClass().getName(), this);
        }
        if (descriptor.isAggregateDescriptor() && !this.isAggregateCollectionMapping()) {
            throw DescriptorException.referenceDescriptorCannotBeAggregate(this);
        }
        if ((this.getDescriptor() == null || !this.getDescriptor().isIsolated()) && descriptor.isIsolated()) {
            throw DescriptorException.isolateDescriptorReferencedBySharedDescriptor(descriptor.getJavaClassName(), this.getDescriptor().getJavaClassName(), this);
        }
        this.setReferenceDescriptor(descriptor);
    }

    protected void initializeSelectionQuery(Session session) throws DescriptorException {
        if (((ObjectLevelReadQuery)this.getSelectionQuery()).getReferenceClass() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        this.getSelectionQuery().setDescriptor(this.getReferenceDescriptor());
    }

    public boolean isAttributeValueInstantiated(Object object) {
        return this.getIndirectionPolicy().objectIsInstantiated(this.getAttributeValueFromObject(object));
    }

    public boolean isCascadePersist() {
        return this.cascadePersist;
    }

    public boolean isCascadeMerge() {
        return this.cascadeMerge;
    }

    public boolean isCascadeRefresh() {
        return this.cascadeRefresh;
    }

    public boolean isCascadeRemove() {
        return this.cascadeRemove;
    }

    public boolean isForeignReferenceMapping() {
        return true;
    }

    public boolean isPrivateOwned() {
        return this.isPrivateOwned;
    }

    public void iterate(DescriptorIterator descriptorIterator) {
        Object object = this.getAttributeValueFromObject(descriptorIterator.getVisitedParent());
        this.getIndirectionPolicy().iterateOnAttributeValue(descriptorIterator, object);
    }

    public abstract void iterateOnRealAttributeValue(DescriptorIterator var1, Object var2);

    public void mergeRemoteValueHolder(Object object, Object object2, MergeManager mergeManager) {
        this.getIndirectionPolicy().mergeRemoteValueHolder(object, object2, mergeManager);
    }

    public void privateOwnedRelationship() {
        this.setIsPrivateOwned(true);
    }

    public void remoteInitialization(DistributedSession distributedSession) {
        super.remoteInitialization(distributedSession);
        this.setTempSession(distributedSession);
    }

    public IdentityHashtable replaceValueHoldersIn(Object object, RemoteSessionController remoteSessionController) {
        return remoteSessionController.replaceValueHoldersIn(object);
    }

    public void setCascadeAll(boolean bl) {
        this.setCascadePersist(bl);
        this.setCascadeMerge(bl);
        this.setCascadeRefresh(bl);
        this.setCascadeRemove(bl);
    }

    public void setCascadePersist(boolean bl) {
        this.cascadePersist = bl;
    }

    public void setCascadeMerge(boolean bl) {
        this.cascadeMerge = bl;
    }

    public void setCascadeRefresh(boolean bl) {
        this.cascadeRefresh = bl;
    }

    public void setCascadeRemove(boolean bl) {
        this.cascadeRemove = bl;
    }

    public void setCustomSelectionQuery(ReadQuery readQuery) {
        this.setSelectionQuery(readQuery);
        this.setHasCustomSelectionQuery(true);
    }

    protected void setHasCustomSelectionQuery(boolean bl) {
        this.hasCustomSelectionQuery = bl;
    }

    public void setIndirectionPolicy(IndirectionPolicy indirectionPolicy) {
        this.indirectionPolicy = indirectionPolicy;
        indirectionPolicy.setMapping(this);
    }

    public void setIsPrivateOwned(boolean bl) {
        this.isPrivateOwned = bl;
    }

    public void setRealAttributeValueInObject(Object object, Object object2) throws DescriptorException {
        this.getIndirectionPolicy().setRealAttributeValueInObject(object, object2);
    }

    public void setReferenceClass(Class clazz) {
        this.referenceClass = clazz;
        if (clazz != null) {
            this.setReferenceClassName(clazz.getName());
            this.setSelectionQuery(this.getSelectionQuery());
        }
    }

    public void setReferenceClassName(String string) {
        this.referenceClassName = string;
    }

    protected void setReferenceDescriptor(Descriptor descriptor) {
        this.referenceDescriptor = descriptor;
    }

    public void setRelationshipPartner(DatabaseMapping databaseMapping) {
        this.relationshipPartner = databaseMapping;
    }

    public void setRelationshipPartnerAttributeName(String string) {
        this.relationshipPartnerAttributeName = string;
    }

    public void setSelectionCriteria(Expression expression) {
        this.getSelectionQuery().setSelectionCriteria(expression);
    }

    protected void setSelectionQuery(ReadQuery readQuery) {
        this.selectionQuery = readQuery;
        if (this.selectionQuery != null && this.selectionQuery.isObjectLevelReadQuery() && this.selectionQuery.getReferenceClassName() == null) {
            ((ObjectLevelReadQuery)this.selectionQuery).setReferenceClass(this.getReferenceClass());
        }
    }

    public void setSelectionSQLString(String string) {
        this.getSelectionQuery().setSQLString(string);
        this.setCustomSelectionQuery(this.getSelectionQuery());
    }

    public void setSelectionCall(Call call) {
        this.getSelectionQuery().setCall(call);
        this.setCustomSelectionQuery(this.getSelectionQuery());
    }

    protected void setTempSession(Session session) {
        this.tempInitSession = session;
    }

    public void setUsesBatchReading(boolean bl) {
        this.usesBatchReading = bl;
    }

    public void setUsesIndirection(boolean bl) {
        if (bl) {
            this.useBasicIndirection();
        } else {
            this.dontUseIndirection();
        }
    }

    protected boolean shouldInitializeSelectionCriteria() {
        if (this.hasCustomSelectionQuery()) {
            return false;
        }
        return this.getSelectionCriteria() == null;
    }

    public boolean shouldMergeCascadeParts(MergeManager mergeManager) {
        return mergeManager.shouldCascadeByMapping() && this.isCascadeMerge() || mergeManager.shouldCascadeAllParts() || mergeManager.shouldCascadePrivateParts() && this.isPrivateOwned();
    }

    protected boolean shouldMergeCascadeReference(MergeManager mergeManager) {
        if (mergeManager.shouldCascadeReferences()) {
            return true;
        }
        return this.shouldMergeCascadeParts(mergeManager);
    }

    protected boolean shouldObjectModifyCascadeToParts(ObjectLevelModifyQuery objectLevelModifyQuery) {
        if (this.isReadOnly()) {
            return false;
        }
        if (objectLevelModifyQuery.shouldCascadeOnlyDependentParts()) {
            return this.hasConstraintDependency();
        }
        if (this.isPrivateOwned()) {
            return true;
        }
        return objectLevelModifyQuery.shouldCascadeAllParts();
    }

    public boolean shouldUseBatchReading() {
        return this.usesBatchReading;
    }

    public void useBasicIndirection() {
        this.setIndirectionPolicy(new BasicIndirectionPolicy());
    }

    public void useBatchReading() {
        this.setUsesBatchReading(true);
    }

    public void useContainerIndirection(Class clazz) {
        ContainerIndirectionPolicy containerIndirectionPolicy = new ContainerIndirectionPolicy();
        containerIndirectionPolicy.setContainerClass(clazz);
        this.setIndirectionPolicy(containerIndirectionPolicy);
    }

    public boolean usesIndirection() {
        return this.getIndirectionPolicy().usesIndirection();
    }

    public void validateBeforeInitialization(Session session) throws DescriptorException {
        super.validateBeforeInitialization(session);
        if (this.getAttributeAccessor() instanceof InstanceVariableAttributeAccessor) {
            Class clazz = ((InstanceVariableAttributeAccessor)this.getAttributeAccessor()).getAttributeType();
            this.getIndirectionPolicy().validateDeclaredAttributeType(clazz, session.getIntegrityChecker());
        } else if (this.getAttributeAccessor() instanceof MethodAttributeAccessor) {
            Class clazz = ((MethodAttributeAccessor)this.getAttributeAccessor()).getGetMethodReturnType();
            this.getIndirectionPolicy().validateGetMethodReturnType(clazz, session.getIntegrityChecker());
            Class clazz2 = ((MethodAttributeAccessor)this.getAttributeAccessor()).getSetMethodParameterType();
            this.getIndirectionPolicy().validateSetMethodParameterType(clazz2, session.getIntegrityChecker());
        }
    }

    public Object valueFromRow(DatabaseRow databaseRow, ObjectLevelReadQuery objectLevelReadQuery, Session session) throws DatabaseException {
        if (objectLevelReadQuery.isReadAllQuery() && (((ReadAllQuery)objectLevelReadQuery).isAttributeBatchRead(this.descriptor, this.getAttributeName()) || this.usesBatchReading)) {
            return this.batchedValueFromRow(databaseRow, (ReadAllQuery)objectLevelReadQuery);
        }
        ReadQuery readQuery = this.selectionQuery;
        if (!this.indirectionPolicy.usesIndirection()) {
            if (readQuery.shouldPrepare()) {
                readQuery.checkPrepare(session, databaseRow);
            }
            readQuery = (ReadQuery)readQuery.clone();
            readQuery.setIsExecutionClone(true);
            readQuery.setQueryId(objectLevelReadQuery.getQueryId());
        }
        if (readQuery.isObjectLevelReadQuery() && (objectLevelReadQuery.shouldCascadeAllParts() || this.isPrivateOwned && objectLevelReadQuery.shouldCascadePrivateParts() || this.cascadeRefresh && objectLevelReadQuery.shouldCascadeByMapping())) {
            if (readQuery == this.selectionQuery) {
                if (readQuery.shouldPrepare()) {
                    readQuery.checkPrepare(session, databaseRow);
                }
                readQuery = (ObjectLevelReadQuery)readQuery.clone();
                readQuery.setIsExecutionClone(true);
            }
            ((ObjectLevelReadQuery)readQuery).setShouldRefreshIdentityMapResult(objectLevelReadQuery.shouldRefreshIdentityMapResult());
            readQuery.setCascadePolicy(objectLevelReadQuery.getCascadePolicy());
            if (readQuery.shouldMaintainCache()) {
                readQuery.setShouldMaintainCache(objectLevelReadQuery.shouldMaintainCache());
            }
            if (objectLevelReadQuery.hasAsOfClause()) {
                readQuery.setSelectionCriteria((Expression)readQuery.getSelectionCriteria().clone());
                ((ObjectLevelReadQuery)readQuery).setAsOfClause(objectLevelReadQuery.getAsOfClause());
            }
        }
        readQuery = this.prepareHistoricalQuery(readQuery, objectLevelReadQuery, session);
        return this.indirectionPolicy.valueFromQuery(readQuery, databaseRow, objectLevelReadQuery.getSession());
    }

    protected ReadQuery prepareHistoricalQuery(ReadQuery readQuery, ObjectLevelReadQuery objectLevelReadQuery, Session session) {
        return readQuery;
    }
}

