/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.mappings;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.toplink.descriptors.changetracking.ChangeTracker;
import oracle.toplink.descriptors.changetracking.CollectionChangeEvent;
import oracle.toplink.exceptions.ConversionException;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.history.AsOfClause;
import oracle.toplink.history.HistoryPolicy;
import oracle.toplink.internal.databaseaccess.Platform;
import oracle.toplink.internal.descriptors.DescriptorIterator;
import oracle.toplink.internal.descriptors.changetracking.AttributeChangeListener;
import oracle.toplink.internal.descriptors.changetracking.ObjectChangeListener;
import oracle.toplink.internal.expressions.QueryKeyExpression;
import oracle.toplink.internal.expressions.SQLDeleteStatement;
import oracle.toplink.internal.expressions.SQLInsertStatement;
import oracle.toplink.internal.expressions.SQLSelectStatement;
import oracle.toplink.internal.expressions.TableExpression;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.DatabaseTable;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.identitymaps.CacheKey;
import oracle.toplink.internal.queryframework.ContainerPolicy;
import oracle.toplink.internal.remote.RemoteSessionController;
import oracle.toplink.internal.sessions.ChangeRecord;
import oracle.toplink.internal.sessions.DirectCollectionChangeRecord;
import oracle.toplink.internal.sessions.MergeManager;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.mappings.CollectionMapping;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.DirectMapMapping;
import oracle.toplink.mappings.RelationalMapping;
import oracle.toplink.mappings.converters.Converter;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DataModifyQuery;
import oracle.toplink.queryframework.DataReadQuery;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.DeleteObjectQuery;
import oracle.toplink.queryframework.DirectReadQuery;
import oracle.toplink.queryframework.ModifyQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadAllQuery;
import oracle.toplink.queryframework.ReadQuery;
import oracle.toplink.queryframework.WriteObjectQuery;
import oracle.toplink.remote.DistributedSession;
import oracle.toplink.remote.RemoteSession;
import oracle.toplink.sessions.DatabaseRecord;
import oracle.toplink.sessions.ObjectCopyingPolicy;

public class DirectCollectionMapping
extends CollectionMapping
implements RelationalMapping {
    protected static final String Delete = "delete";
    protected static final String Insert = "insert";
    protected static final String DeleteAll = "deleteAll";
    protected Converter valueConverter;
    protected transient DatabaseTable referenceTable;
    protected transient DatabaseField directField;
    protected transient Vector sourceKeyFields;
    protected transient Vector referenceKeyFields;
    protected transient DataModifyQuery insertQuery = new DataModifyQuery();
    protected transient ModifyQuery changeSetDeleteQuery;
    protected transient boolean hasCustomDeleteQuery;
    protected transient boolean hasCustomInsertQuery;
    protected HistoryPolicy historyPolicy;

    public DirectCollectionMapping() {
        this.sourceKeyFields = NonSynchronizedVector.newInstance(1);
        this.referenceKeyFields = NonSynchronizedVector.newInstance(1);
        this.selectionQuery = new DirectReadQuery();
        this.hasCustomInsertQuery = false;
        this.isPrivateOwned = true;
    }

    public boolean isRelationalMapping() {
        return true;
    }

    public Converter getValueConverter() {
        return this.valueConverter;
    }

    public void setValueConverter(Converter converter) {
        this.valueConverter = converter;
    }

    public void addReferenceKeyFieldName(String string, String string2) {
        this.getSourceKeyFields().addElement(new DatabaseField(string2));
        this.getReferenceKeyFields().addElement(new DatabaseField(string));
    }

    public ReadQuery prepareNestedBatchQuery(ReadAllQuery readAllQuery) {
        ExpressionBuilder expressionBuilder;
        DataReadQuery dataReadQuery = new DataReadQuery();
        Expression expression = null;
        IdentityHashtable identityHashtable = new IdentityHashtable();
        if (readAllQuery.getSelectionCriteria() == null) {
            expressionBuilder = new ExpressionBuilder();
            if (readAllQuery.hasAsOfClause()) {
                expressionBuilder.asOf(readAllQuery.getAsOfClause());
            }
        } else {
            expression = readAllQuery.getSelectionCriteria().copiedVersionFrom(identityHashtable);
            expressionBuilder = expression.getBuilder();
        }
        Expression expression2 = expressionBuilder.twist(this.getSelectionQuery().getSQLStatement().getWhereClause(), expressionBuilder);
        if (expression != null) {
            expression2 = expression2.and(expression);
        }
        if (readAllQuery.getDescriptor().getQueryManager().getAdditionalJoinExpression() != null) {
            expression2 = expression2.and(readAllQuery.getDescriptor().getQueryManager().getAdditionalJoinExpression().rebuildOn(expressionBuilder));
        }
        if (this.getHistoryPolicy() != null) {
            if (readAllQuery.getSession().getAsOfClause() != null) {
                expressionBuilder.asOf(readAllQuery.getSession().getAsOfClause());
            } else if (expressionBuilder.getAsOfClause() == null) {
                expressionBuilder.asOf(AsOfClause.NO_CLAUSE);
            }
            expression2 = expression2.and(this.getHistoryPolicy().additionalHistoryExpression(expressionBuilder));
        }
        SQLSelectStatement sQLSelectStatement = new SQLSelectStatement();
        Enumeration enumeration = this.getReferenceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            sQLSelectStatement.addField(expressionBuilder.getTable(this.getReferenceTable()).getField((DatabaseField)enumeration.nextElement()));
        }
        if (this instanceof DirectMapMapping) {
            sQLSelectStatement.addField(expressionBuilder.getTable(this.getReferenceTable()).getField(((DirectMapMapping)this).getDirectKeyField()));
        }
        sQLSelectStatement.addField(expressionBuilder.getTable(this.getReferenceTable()).getField(this.getDirectField()));
        sQLSelectStatement.setWhereClause(expression2);
        sQLSelectStatement.normalize(readAllQuery.getSession(), this.getDescriptor(), identityHashtable);
        dataReadQuery.setSQLStatement(sQLSelectStatement);
        return dataReadQuery;
    }

    public void buildCopy(Object object, Object object2, ObjectCopyingPolicy objectCopyingPolicy) {
        Object object3 = this.getRealCollectionAttributeValueFromObject(object2, objectCopyingPolicy.getSession());
        object3 = this.getContainerPolicy().cloneFor(object3);
        this.setRealAttributeValueInObject(object, object3);
    }

    protected Object buildElementClone(Object object, UnitOfWork unitOfWork, boolean bl) {
        Object object2 = object;
        if (this.getValueConverter() != null && this.getValueConverter().isMutable()) {
            object2 = this.getValueConverter().convertDataValueToObjectValue(this.getValueConverter().convertObjectValueToDataValue(object2, unitOfWork), unitOfWork);
        }
        return object2;
    }

    public void cascadePerformRemoveIfRequired(Object object, UnitOfWork unitOfWork, IdentityHashtable identityHashtable) {
    }

    public void cascadeRegisterNewIfRequired(Object object, UnitOfWork unitOfWork, IdentityHashtable identityHashtable) {
    }

    public Object clone() {
        DirectCollectionMapping directCollectionMapping = (DirectCollectionMapping)super.clone();
        directCollectionMapping.setSourceKeyFields(this.cloneFields(this.getSourceKeyFields()));
        directCollectionMapping.setReferenceKeyFields(this.cloneFields(this.getReferenceKeyFields()));
        return directCollectionMapping;
    }

    public void compareCollectionsForChange(Object object, Object object2, ChangeRecord changeRecord, Session session) {
        Object object3;
        Object object4;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        int n = 0;
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>(10);
        HashMap<Object, Integer> hashMap2 = new HashMap<Object, Integer>(10);
        if (object != null) {
            object4 = containerPolicy.iteratorFor(object);
            while (containerPolicy.hasNext(object4)) {
                Object object5 = containerPolicy.next(object4, session);
                if (object5 == null) {
                    --n;
                    continue;
                }
                object3 = (Integer)hashMap.get(object5);
                if (object3 == null) {
                    hashMap.put(object5, new Integer(1));
                    continue;
                }
                hashMap.put(object5, new Integer((Integer)object3 + 1));
            }
        }
        object4 = (HashMap)hashMap.clone();
        int n2 = Math.abs(n);
        if (object2 != null) {
            object3 = containerPolicy.iteratorFor(object2);
            while (containerPolicy.hasNext(object3)) {
                Object object6 = containerPolicy.next(object3, session);
                if (object6 == null) {
                    ++n;
                    continue;
                }
                Integer n3 = (Integer)hashMap.get(object6);
                if (n3 == null) {
                    Integer n4 = (Integer)hashMap2.get(object6);
                    if (n4 == null) {
                        hashMap2.put(object6, new Integer(1));
                        continue;
                    }
                    hashMap2.put(object6, new Integer(n4 + 1));
                    continue;
                }
                if (n3 == 1) {
                    hashMap.remove(object6);
                    continue;
                }
                hashMap.put(object6, new Integer(n3 - 1));
            }
        }
        if (hashMap2.isEmpty() && hashMap.isEmpty() && n == 0 && !changeRecord.getOwner().isNew()) {
            return;
        }
        ((DirectCollectionChangeRecord)changeRecord).addAdditionChange(hashMap2, (HashMap)object4);
        ((DirectCollectionChangeRecord)changeRecord).addRemoveChange(hashMap, (HashMap)object4);
        if (n != 0) {
            object3 = null;
            ((DirectCollectionChangeRecord)changeRecord).getCommitAddMap().put(DirectCollectionChangeRecord.Null, new Integer(n2));
            if (n > 0) {
                ((DirectCollectionChangeRecord)changeRecord).addAdditionChange(DirectCollectionChangeRecord.Null, new Integer(n));
            } else {
                ((DirectCollectionChangeRecord)changeRecord).addRemoveChange(DirectCollectionChangeRecord.Null, new Integer(n *= -1));
            }
        }
    }

    public ChangeRecord compareForChange(Object object, Object object2, ObjectChangeSet objectChangeSet, Session session) {
        Object object3 = null;
        Object object4 = null;
        boolean bl = false;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        object3 = this.getAttributeValueFromObject(object);
        if (object3 != null && !this.getIndirectionPolicy().objectIsInstantiated(object3)) {
            return null;
        }
        Object object5 = this.getRealCollectionAttributeValueFromObject(object, session);
        Object object6 = null;
        if (!objectChangeSet.isNew()) {
            object4 = this.getAttributeValueFromObject(object2);
            if (object4 == null && object3 == null) {
                return null;
            }
            object6 = this.getRealCollectionAttributeValueFromObject(object2, session);
        }
        DirectCollectionChangeRecord directCollectionChangeRecord = new DirectCollectionChangeRecord(objectChangeSet);
        directCollectionChangeRecord.setAttribute(this.getAttributeName());
        directCollectionChangeRecord.setMapping(this);
        this.compareCollectionsForChange(object6, object5, directCollectionChangeRecord, session);
        if (directCollectionChangeRecord.hasChanges()) {
            return directCollectionChangeRecord;
        }
        return null;
    }

    public boolean compareObjects(Object object, Object object2, Session session) {
        int n;
        Object object3;
        Object object4 = this.getRealCollectionAttributeValueFromObject(object, session);
        Object object5 = this.getRealCollectionAttributeValueFromObject(object2, session);
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (containerPolicy.sizeFor(object4) != containerPolicy.sizeFor(object5)) {
            return false;
        }
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        HashMap<Object, Integer> hashMap2 = new HashMap<Object, Integer>();
        Iterator iterator = containerPolicy.iteratorFor(object4);
        while (containerPolicy.hasNext(iterator)) {
            object3 = containerPolicy.next(iterator, session);
            if (hashMap.containsKey(object3)) {
                n = (Integer)hashMap.get(object3);
                hashMap.put(object3, new Integer(++n));
                continue;
            }
            hashMap.put(object3, new Integer(1));
        }
        iterator = containerPolicy.iteratorFor(object5);
        while (containerPolicy.hasNext(iterator)) {
            object3 = containerPolicy.next(iterator, session);
            if (hashMap2.containsKey(object3)) {
                n = (Integer)hashMap2.get(object3);
                hashMap2.put(object3, new Integer(++n));
                continue;
            }
            hashMap2.put(object3, new Integer(1));
        }
        iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            if (!hashMap2.containsKey(object3) || ((Integer)hashMap2.get(object3)).intValue() != ((Integer)hashMap.get(object3)).intValue()) {
                return false;
            }
            iterator.remove();
            hashMap2.remove(object3);
        }
        return hashMap.isEmpty() && hashMap2.isEmpty();
    }

    protected Vector extractKeyFromReferenceRow(DatabaseRow databaseRow, Session session) {
        Vector<Object> vector = new Vector<Object>(this.getReferenceKeyFields().size());
        for (int i = 0; i < this.getReferenceKeyFields().size(); ++i) {
            DatabaseField databaseField = (DatabaseField)this.getReferenceKeyFields().elementAt(i);
            DatabaseField databaseField2 = (DatabaseField)this.getSourceKeyFields().elementAt(i);
            Object object = databaseRow.get(databaseField);
            try {
                object = session.getDatasourcePlatform().getConversionManager().convertObject(object, this.getDescriptor().getObjectBuilder().getFieldClassification(databaseField2));
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
            vector.addElement(object);
        }
        return vector;
    }

    protected Vector extractPrimaryKeyFromRow(DatabaseRow databaseRow, Session session) {
        Vector<Object> vector = new Vector<Object>(this.getSourceKeyFields().size());
        Enumeration enumeration = this.getSourceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            Object object = databaseRow.get(databaseField);
            try {
                object = session.getDatasourcePlatform().getConversionManager().convertObject(object, this.getDescriptor().getObjectBuilder().getFieldClassification(databaseField));
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
            vector.addElement(object);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object extractResultFromBatchQuery(DatabaseQuery databaseQuery, DatabaseRow databaseRow, Session session, DatabaseRow databaseRow2) {
        Hashtable hashtable = null;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        DatabaseQuery databaseQuery2 = databaseQuery;
        synchronized (databaseQuery2) {
            hashtable = this.getBatchReadObjects(databaseQuery, session);
            containerPolicy = this.getContainerPolicy();
            if (hashtable == null) {
                Vector vector = (Vector)session.executeQuery(databaseQuery, databaseRow2);
                hashtable = new Hashtable();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    DatabaseRow databaseRow3 = (DatabaseRow)enumeration.nextElement();
                    Object object = databaseRow3.get(this.getDirectField());
                    CacheKey cacheKey = new CacheKey(this.extractKeyFromReferenceRow(databaseRow3, session));
                    Object object2 = hashtable.get(cacheKey);
                    if (object2 == null) {
                        object2 = containerPolicy.containerInstance();
                        hashtable.put(cacheKey, object2);
                    }
                    if (this.getValueConverter() != null) {
                        object = this.getValueConverter().convertDataValueToObjectValue(object, databaseQuery.getSession());
                    }
                    containerPolicy.addInto(object, object2, databaseQuery.getSession());
                }
                this.setBatchReadObjects(hashtable, databaseQuery, session);
            }
        }
        databaseQuery2 = hashtable.get(new CacheKey(this.extractPrimaryKeyFromRow(databaseRow, session)));
        if (databaseQuery2 == null) {
            return containerPolicy.containerInstance();
        }
        return databaseQuery2;
    }

    public void fixRealObjectReferences(Object object, IdentityHashtable identityHashtable, IdentityHashtable identityHashtable2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
    }

    protected ModifyQuery getDeleteQuery() {
        if (this.changeSetDeleteQuery == null) {
            this.changeSetDeleteQuery = new DataModifyQuery();
        }
        return this.changeSetDeleteQuery;
    }

    public DatabaseField getDirectField() {
        return this.directField;
    }

    public String getDirectFieldName() {
        if (this.getDirectField() == null) {
            return null;
        }
        return this.getDirectField().getQualifiedName();
    }

    protected DataModifyQuery getInsertQuery() {
        return this.insertQuery;
    }

    public Expression getJoinCriteria(QueryKeyExpression queryKeyExpression) {
        if (this.getHistoryPolicy() != null) {
            Expression expression = super.getJoinCriteria(queryKeyExpression);
            Expression expression2 = this.getHistoryPolicy().additionalHistoryExpression(queryKeyExpression);
            if (expression != null) {
                return expression.and(expression2);
            }
            if (expression2 != null) {
                return expression2;
            }
            return null;
        }
        return super.getJoinCriteria(queryKeyExpression);
    }

    public Object getObjectCorrespondingTo(Object object, RemoteSession remoteSession, IdentityHashtable identityHashtable, IdentityHashtable identityHashtable2, ObjectLevelReadQuery objectLevelReadQuery) {
        return object;
    }

    public HistoryPolicy getHistoryPolicy() {
        return this.historyPolicy;
    }

    public Class getReferenceClass() {
        return null;
    }

    public String getReferenceClassName() {
        return null;
    }

    public Descriptor getReferenceDescriptor() {
        return null;
    }

    public Vector getReferenceKeyFieldNames() {
        Vector<String> vector = new Vector<String>(this.getReferenceKeyFields().size());
        Enumeration enumeration = this.getReferenceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(((DatabaseField)enumeration.nextElement()).getQualifiedName());
        }
        return vector;
    }

    public Vector getReferenceKeyFields() {
        return this.referenceKeyFields;
    }

    public DatabaseTable getReferenceTable() {
        return this.referenceTable;
    }

    public String getReferenceTableName() {
        if (this.getReferenceTable() == null) {
            return null;
        }
        return this.getReferenceTable().getName();
    }

    public String getReferenceTableQualifiedName() {
        if (this.getReferenceTable() == null) {
            return null;
        }
        return this.getReferenceTable().getQualifiedName();
    }

    public DatabaseMapping getRelationshipPartner() {
        return null;
    }

    public Vector getSourceKeyFieldNames() {
        Vector<String> vector = new Vector<String>(this.getSourceKeyFields().size());
        Enumeration enumeration = this.getSourceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(((DatabaseField)enumeration.nextElement()).getQualifiedName());
        }
        return vector;
    }

    public Vector getSourceKeyFields() {
        return this.sourceKeyFields;
    }

    protected boolean hasCustomDeleteQuery() {
        return this.hasCustomDeleteQuery;
    }

    protected boolean hasCustomInsertQuery() {
        return this.hasCustomInsertQuery;
    }

    public void initialize(Session session) throws DescriptorException {
        if (this.isKeyForSourceSpecified()) {
            this.initializeSourceKeys(session);
        } else {
            this.initializeSourceKeysWithDefaults(session);
        }
        this.initializeReferenceTable(session);
        this.initializeReferenceKeys(session);
        this.initializeDirectField(session);
        if (this.shouldInitializeSelectionCriteria()) {
            this.initializeSelectionCriteria(session);
            this.initializeSelectionStatement(session);
        }
        if (!this.getSelectionQuery().hasSessionName()) {
            this.getSelectionQuery().setSessionName(session.getName());
        }
        if (this.getValueConverter() != null && this.getSelectionQuery() instanceof DirectReadQuery) {
            ((DirectReadQuery)this.getSelectionQuery()).setValueConverter(this.getValueConverter());
        }
        this.initializeDeleteAllQuery(session);
        this.initializeDeleteQuery(session);
        this.initializeInsertQuery(session);
        if (this.getHistoryPolicy() != null) {
            this.getHistoryPolicy().initialize(session);
        }
        if (this.getValueConverter() != null) {
            this.getValueConverter().initialize(this, session);
        }
        super.initialize(session);
    }

    protected void initializeDeleteAllQuery(Session session) {
        if (!this.getDeleteAllQuery().hasSessionName()) {
            this.getDeleteAllQuery().setSessionName(session.getName());
        }
        if (this.hasCustomDeleteAllQuery()) {
            return;
        }
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        SQLDeleteStatement sQLDeleteStatement = new SQLDeleteStatement();
        for (int i = 0; i < this.getReferenceKeyFields().size(); ++i) {
            DatabaseField databaseField = (DatabaseField)this.getReferenceKeyFields().elementAt(i);
            DatabaseField databaseField2 = (DatabaseField)this.getSourceKeyFields().elementAt(i);
            Expression expression2 = ((Expression)expressionBuilder).getField(databaseField);
            Expression expression3 = expressionBuilder.getParameter(databaseField2);
            Expression expression4 = expression2.equal(expression3);
            expression = expression == null ? expression4 : expression.and(expression4);
        }
        sQLDeleteStatement.setWhereClause(expression);
        sQLDeleteStatement.setTable(this.getReferenceTable());
        this.getDeleteAllQuery().setSQLStatement(sQLDeleteStatement);
    }

    protected void initializeDeleteQuery(Session session) {
        if (!this.getDeleteQuery().hasSessionName()) {
            this.getDeleteQuery().setSessionName(session.getName());
        }
        if (this.hasCustomDeleteQuery()) {
            return;
        }
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        Expression expression = ((Expression)expressionBuilder).getField(this.getDirectField()).equal(expressionBuilder.getParameter(this.getDirectField()));
        Expression expression2 = null;
        SQLDeleteStatement sQLDeleteStatement = new SQLDeleteStatement();
        for (int i = 0; i < this.getReferenceKeyFields().size(); ++i) {
            DatabaseField databaseField = (DatabaseField)this.getReferenceKeyFields().elementAt(i);
            DatabaseField databaseField2 = (DatabaseField)this.getSourceKeyFields().elementAt(i);
            Expression expression3 = ((Expression)expressionBuilder).getField(databaseField);
            Expression expression4 = expressionBuilder.getParameter(databaseField2);
            Expression expression5 = expression3.equal(expression4);
            expression2 = expression5.and(expression2);
        }
        expression2 = expression2.and(expression);
        sQLDeleteStatement.setWhereClause(expression2);
        sQLDeleteStatement.setTable(this.getReferenceTable());
        this.getDeleteQuery().setSQLStatement(sQLDeleteStatement);
    }

    protected void initializeDirectField(Session session) throws DescriptorException {
        if (this.getDirectField() == null) {
            throw DescriptorException.directFieldNameNotSet(this);
        }
        this.getDirectField().setTable(this.getReferenceTable());
        this.getDirectField().setIndex(0);
    }

    protected void initializeInsertQuery(Session session) {
        if (!this.getInsertQuery().hasSessionName()) {
            this.getInsertQuery().setSessionName(session.getName());
        }
        if (this.hasCustomInsertQuery()) {
            return;
        }
        SQLInsertStatement sQLInsertStatement = new SQLInsertStatement();
        sQLInsertStatement.setTable(this.getReferenceTable());
        DatabaseRecord databaseRecord = new DatabaseRecord();
        Enumeration enumeration = this.getReferenceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            databaseRecord.put((DatabaseField)enumeration.nextElement(), (Object)null);
        }
        databaseRecord.put(this.getDirectField(), (Object)null);
        sQLInsertStatement.setModifyRow(databaseRecord);
        this.getInsertQuery().setSQLStatement(sQLInsertStatement);
        this.getInsertQuery().setModifyRow(databaseRecord);
    }

    protected void initializeReferenceDescriptor(Session session) {
    }

    protected void initializeReferenceKeys(Session session) throws DescriptorException {
        if (this.getReferenceKeyFields().size() == 0) {
            throw DescriptorException.noReferenceKeyIsSpecified(this);
        }
        Enumeration enumeration = this.getReferenceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            if (databaseField.hasTableName() && !databaseField.getTableName().equals(this.getReferenceTable().getName())) {
                throw DescriptorException.referenceKeyFieldNotProperlySpecified(databaseField, this);
            }
            databaseField.setTable(this.getReferenceTable());
        }
    }

    protected void initializeReferenceTable(Session session) throws DescriptorException {
        Platform platform = session.getDatasourcePlatform();
        if (this.getReferenceTable() == null) {
            throw DescriptorException.referenceTableNotSpecified(this);
        }
        if (platform.getTableQualifier().length() == 0) {
            return;
        }
        if (this.getReferenceTable().getTableQualifier().length() == 0) {
            this.getReferenceTable().setTableQualifier(platform.getTableQualifier());
        }
    }

    protected void initializeSelectionCriteria(Session session) {
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        TableExpression tableExpression = (TableExpression)expressionBuilder.getTable(this.getReferenceTable());
        Enumeration enumeration = this.getReferenceKeyFields().elements();
        Enumeration enumeration2 = this.getSourceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            DatabaseField databaseField2 = (DatabaseField)enumeration2.nextElement();
            Expression expression2 = tableExpression.getField(databaseField);
            Expression expression3 = expressionBuilder.getParameter(databaseField2);
            Expression expression4 = expression2.equal(expression3);
            if (expression == null) {
                expression = expression4;
                continue;
            }
            expression = expression4.and(expression);
        }
        this.setSelectionCriteria(expression);
    }

    protected void initializeSelectionQuery(Session session) {
    }

    protected void initializeSelectionStatement(Session session) {
        SQLSelectStatement sQLSelectStatement = new SQLSelectStatement();
        sQLSelectStatement.addTable(this.getReferenceTable());
        sQLSelectStatement.addField((DatabaseField)this.getDirectField().clone());
        sQLSelectStatement.setWhereClause(this.getSelectionCriteria());
        sQLSelectStatement.normalize(session, null);
        this.getSelectionQuery().setSQLStatement(sQLSelectStatement);
    }

    protected void initializeSourceKeys(Session session) {
        Enumeration enumeration = this.getSourceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            this.getDescriptor().buildField((DatabaseField)enumeration.nextElement());
        }
    }

    protected void initializeSourceKeysWithDefaults(Session session) {
        List list = this.getDescriptor().getPrimaryKeyFields();
        for (int i = 0; i < list.size(); ++i) {
            this.getSourceKeyFields().addElement(list.get(i));
        }
    }

    public boolean isDirectCollectionMapping() {
        return true;
    }

    protected boolean isKeyForSourceSpecified() {
        return !this.getSourceKeyFields().isEmpty();
    }

    public boolean isPrivateOwned() {
        return true;
    }

    public void iterateOnRealAttributeValue(DescriptorIterator descriptorIterator, Object object) {
        if (descriptorIterator.shouldIterateOnPrimitives()) {
            super.iterateOnRealAttributeValue(descriptorIterator, object);
        }
    }

    public void iterateOnElement(DescriptorIterator descriptorIterator, Object object) {
        descriptorIterator.iteratePrimitiveForMapping(object, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeChangesIntoObject(Object object, ChangeRecord changeRecord, Object object2, MergeManager mergeManager) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object3 = null;
        Session session = mergeManager.getSession();
        HashMap hashMap = ((DirectCollectionChangeRecord)changeRecord).getAddObjectMap();
        HashMap hashMap2 = ((DirectCollectionChangeRecord)changeRecord).getRemoveObjectMap();
        object3 = this.isAttributeValueInstantiated(object) && !changeRecord.getOwner().isNew() ? this.getRealCollectionAttributeValueFromObject(object, session) : containerPolicy.containerInstance(hashMap.size());
        if (!this.isAttributeValueInstantiated(object)) {
            if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                return;
            }
            Object object4 = containerPolicy.iteratorFor(this.getRealCollectionAttributeValueFromObject(object2, session));
            while (containerPolicy.hasNext(object4)) {
                containerPolicy.addInto(containerPolicy.next(object4, session), object3, session);
            }
        } else {
            Object object5 = object3;
            synchronized (object5) {
                int n;
                int n2;
                Object k;
                Iterator iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    k = iterator.next();
                    n2 = (Integer)hashMap.get(k);
                    for (n = 0; n < n2; ++n) {
                        if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                            if (containerPolicy.contains(k, object3, session)) continue;
                            containerPolicy.addInto(k, object3, session);
                            continue;
                        }
                        containerPolicy.addInto(k, object3, session);
                    }
                }
                iterator = hashMap2.keySet().iterator();
                while (iterator.hasNext()) {
                    k = iterator.next();
                    n2 = (Integer)hashMap2.get(k);
                    for (n = 0; n < n2; ++n) {
                        containerPolicy.removeFrom(k, object3, session);
                    }
                }
            }
        }
        this.setRealAttributeValueInObject(object, object3);
    }

    public void mergeIntoObject(Object object, boolean bl, Object object2, MergeManager mergeManager) {
        Object object3;
        Object object4;
        if (bl && mergeManager.shouldMergeWorkingCopyIntoOriginal() && !this.isAttributeValueInstantiated(object2)) {
            this.setAttributeValueInObject(object, this.getIndirectionPolicy().getOriginalIndirectionObject(this.getAttributeValueFromObject(object2), mergeManager.getSession()));
            return;
        }
        if (!this.shouldMergeCascadeReference(mergeManager)) {
            return;
        }
        if (mergeManager.shouldRefreshRemoteObject() && this.usesIndirection()) {
            this.mergeRemoteValueHolder(object, object2, mergeManager);
            return;
        }
        if (mergeManager.shouldMergeOriginalIntoWorkingCopy() ? !this.isAttributeValueInstantiated(object) : !this.isAttributeValueInstantiatedOrChanged(object2)) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object5 = this.getRealCollectionAttributeValueFromObject(object2, mergeManager.getSession());
        Object object6 = this.getRealCollectionAttributeValueFromObject(object, mergeManager.getSession());
        Object object7 = containerPolicy.containerInstance(containerPolicy.sizeFor(object5));
        boolean bl2 = false;
        if (this.getDescriptor().getObjectChangePolicy().isObjectChangeTrackingPolicy() && object instanceof ChangeTracker && ((ChangeTracker)object).getTopLinkPropertyChangeListener() != null) {
            bl2 = true;
            object4 = containerPolicy.iteratorFor(object6);
            while (containerPolicy.hasNext(object4)) {
                ((ObjectChangeListener)((ChangeTracker)object).getTopLinkPropertyChangeListener()).internalPropertyChange(new CollectionChangeEvent(object, this.getAttributeName(), object6, containerPolicy.next(object4, mergeManager.getSession()), CollectionChangeEvent.REMOVE));
            }
            if (object7 instanceof ChangeTracker) {
                ((ChangeTracker)object7).setTopLinkPropertyChangeListener(((ChangeTracker)object).getTopLinkPropertyChangeListener());
            }
            if (object6 instanceof ChangeTracker) {
                ((ChangeTracker)object6).setTopLinkPropertyChangeListener(null);
            }
        }
        object6 = object7;
        object4 = containerPolicy.iteratorFor(object5);
        while (containerPolicy.hasNext(object4)) {
            object3 = containerPolicy.next(object4, mergeManager.getSession());
            if (bl2) {
                ((ObjectChangeListener)((ChangeTracker)object).getTopLinkPropertyChangeListener()).internalPropertyChange(new CollectionChangeEvent(object, this.getAttributeName(), object6, object3, CollectionChangeEvent.ADD));
            }
            containerPolicy.addInto(object3, object6, mergeManager.getSession());
        }
        if (bl2 && this.getDescriptor().getObjectChangePolicy().isAttributeChangeTrackingPolicy() && (object3 = (DirectCollectionChangeRecord)((ObjectChangeSet)(object4 = ((AttributeChangeListener)((ChangeTracker)object).getTopLinkPropertyChangeListener()).getObjectChangeSet())).getChangesForAttributeNamed(this.getAttributeName())) != null && !((DirectCollectionChangeRecord)object3).hasChanges()) {
            ((ObjectChangeSet)object4).removeChange(this.getAttributeName());
        }
        this.setRealAttributeValueInObject(object, object6);
    }

    public void performDataModificationEvent(Object[] objectArray, Session session) throws DatabaseException, DescriptorException {
        if (objectArray[0] == Delete) {
            session.executeQuery((DatabaseQuery)((DataModifyQuery)objectArray[1]), (DatabaseRow)objectArray[2]);
            if (this.getHistoryPolicy() != null && this.getHistoryPolicy().shouldHandleWrites()) {
                this.getHistoryPolicy().mappingLogicalDelete((DataModifyQuery)objectArray[1], (DatabaseRow)objectArray[2], session);
            }
        } else if (objectArray[0] == Insert) {
            session.executeQuery((DatabaseQuery)((DataModifyQuery)objectArray[1]), (DatabaseRow)objectArray[2]);
            if (this.getHistoryPolicy() != null && this.getHistoryPolicy().shouldHandleWrites()) {
                this.getHistoryPolicy().mappingLogicalInsert((DataModifyQuery)objectArray[1], (DatabaseRow)objectArray[2], session);
            }
        } else if (objectArray[0] == DeleteAll) {
            this.preDelete((DeleteObjectQuery)objectArray[1]);
        } else {
            throw DescriptorException.invalidDataModificationEventCode(objectArray[0], this);
        }
    }

    public void postInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException {
        Object[] objectArray;
        Object object;
        DatabaseRecord databaseRecord = new DatabaseRecord();
        if (this.isReadOnly()) {
            return;
        }
        Object object2 = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (containerPolicy.isEmpty(object2)) {
            return;
        }
        this.prepareTranslationRow(writeObjectQuery.getTranslationRow(), writeObjectQuery.getObject(), writeObjectQuery.getSession());
        for (int i = 0; i < this.getReferenceKeyFields().size(); ++i) {
            object = (DatabaseField)this.getReferenceKeyFields().elementAt(i);
            objectArray = (Object[])this.getSourceKeyFields().elementAt(i);
            Object object3 = writeObjectQuery.getTranslationRow().get((DatabaseField)objectArray);
            databaseRecord.put((DatabaseField)object, object3);
        }
        Object object4 = containerPolicy.iteratorFor(object2);
        while (containerPolicy.hasNext(object4)) {
            object = containerPolicy.next(object4, writeObjectQuery.getSession());
            if (this.getValueConverter() != null) {
                object = this.getValueConverter().convertObjectValueToDataValue(object, writeObjectQuery.getSession());
            }
            databaseRecord.put(this.getDirectField(), object);
            if (writeObjectQuery.shouldCascadeOnlyDependentParts()) {
                objectArray = new Object[]{Insert, this.getInsertQuery(), databaseRecord.clone()};
                writeObjectQuery.getSession().getCommitManager().addDataModificationEvent(this, objectArray);
                continue;
            }
            writeObjectQuery.getSession().executeQuery((DatabaseQuery)this.getInsertQuery(), databaseRecord);
            if (this.getHistoryPolicy() == null || !this.getHistoryPolicy().shouldHandleWrites()) continue;
            this.getHistoryPolicy().mappingLogicalInsert(this.getInsertQuery(), databaseRecord, writeObjectQuery.getSession());
        }
    }

    public void postUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException {
        if (this.isReadOnly()) {
            return;
        }
        if (writeObjectQuery.getObjectChangeSet() != null) {
            this.postUpdateWithChangeSet(writeObjectQuery);
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(writeObjectQuery.getObject())) {
            return;
        }
        if (writeObjectQuery.getSession().isUnitOfWork() && this.compareObjects(writeObjectQuery.getObject(), writeObjectQuery.getBackupClone(), writeObjectQuery.getSession())) {
            return;
        }
        DeleteObjectQuery deleteObjectQuery = new DeleteObjectQuery();
        deleteObjectQuery.setObject(writeObjectQuery.getObject());
        deleteObjectQuery.setSession(writeObjectQuery.getSession());
        deleteObjectQuery.setTranslationRow(writeObjectQuery.getTranslationRow());
        if (writeObjectQuery.shouldCascadeOnlyDependentParts()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = DeleteAll;
            objectArray[1] = deleteObjectQuery;
            writeObjectQuery.getSession().getCommitManager().addDataModificationEvent(this, objectArray);
        } else {
            this.preDelete(deleteObjectQuery);
        }
        this.postInsert(writeObjectQuery);
    }

    protected void postUpdateWithChangeSet(WriteObjectQuery writeObjectQuery) throws DatabaseException {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        DatabaseField databaseField;
        ObjectChangeSet objectChangeSet = writeObjectQuery.getObjectChangeSet();
        DirectCollectionChangeRecord directCollectionChangeRecord = (DirectCollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (directCollectionChangeRecord == null) {
            return;
        }
        for (int i = 0; i < this.getReferenceKeyFields().size(); ++i) {
            databaseField = (DatabaseField)this.getReferenceKeyFields().elementAt(i);
            serializable = (DatabaseField)this.getSourceKeyFields().elementAt(i);
            object3 = writeObjectQuery.getTranslationRow().get((DatabaseField)serializable);
            writeObjectQuery.getTranslationRow().put(databaseField, object3);
        }
        Iterator iterator = directCollectionChangeRecord.getRemoveObjectMap().keySet().iterator();
        while (iterator.hasNext()) {
            databaseField = iterator.next();
            serializable = (DatabaseRow)writeObjectQuery.getTranslationRow().clone();
            object3 = databaseField;
            if (this.getValueConverter() != null) {
                object3 = this.getValueConverter().convertObjectValueToDataValue(object3, writeObjectQuery.getSession());
            }
            if (object3 == DirectCollectionChangeRecord.Null) {
                ((DatabaseRow)serializable).add(this.getDirectField(), null);
            } else {
                ((DatabaseRow)serializable).add(this.getDirectField(), object3);
            }
            object2 = new Object[]{Delete, this.getDeleteQuery(), serializable};
            writeObjectQuery.getSession().getCommitManager().addDataModificationEvent(this, (Object[])object2);
            object = (Integer)directCollectionChangeRecord.getCommitAddMap().get(databaseField);
            if (object == null) continue;
            for (int i = ((Integer)object).intValue(); i > 0; --i) {
                serializable = (DatabaseRow)writeObjectQuery.getTranslationRow().clone();
                ((DatabaseRow)serializable).add(this.getDirectField(), object3);
                object2 = new Object[]{Insert, this.getInsertQuery(), serializable};
                writeObjectQuery.getSession().getCommitManager().addDataModificationEvent(this, (Object[])object2);
            }
        }
        iterator = directCollectionChangeRecord.getAddObjectMap().keySet().iterator();
        while (iterator.hasNext()) {
            databaseField = iterator.next();
            serializable = (Integer)directCollectionChangeRecord.getAddObjectMap().get(databaseField);
            for (int i = ((Integer)serializable).intValue(); i > 0; --i) {
                object2 = (DatabaseRow)writeObjectQuery.getTranslationRow().clone();
                object = databaseField;
                if (this.getValueConverter() != null) {
                    object = this.getValueConverter().convertObjectValueToDataValue(object, writeObjectQuery.getSession());
                }
                if (object == DirectCollectionChangeRecord.Null) {
                    ((DatabaseRow)object2).add(this.getDirectField(), null);
                } else {
                    ((DatabaseRow)object2).add(this.getDirectField(), object);
                }
                Object[] objectArray = new Object[]{Insert, this.getInsertQuery(), object2};
                writeObjectQuery.getSession().getCommitManager().addDataModificationEvent(this, objectArray);
            }
        }
    }

    public void preDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException {
        if (this.isReadOnly()) {
            return;
        }
        this.prepareTranslationRow(deleteObjectQuery.getTranslationRow(), deleteObjectQuery.getObject(), deleteObjectQuery.getSession());
        deleteObjectQuery.getSession().executeQuery((DatabaseQuery)this.getDeleteAllQuery(), deleteObjectQuery.getTranslationRow());
        if (this.getHistoryPolicy() != null && this.getHistoryPolicy().shouldHandleWrites()) {
            this.getHistoryPolicy().mappingLogicalDelete(this.getDeleteAllQuery(), deleteObjectQuery.getTranslationRow(), deleteObjectQuery.getSession());
        }
    }

    protected void prepareTranslationRow(DatabaseRow databaseRow, Object object, Session session) {
        Enumeration enumeration = this.getSourceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            if (databaseRow.containsKey(databaseField)) continue;
            Object object2 = this.getDescriptor().getObjectBuilder().extractValueFromObjectForField(object, databaseField, session);
            databaseRow.put(databaseField, object2);
        }
    }

    public void remoteInitialization(DistributedSession distributedSession) {
        if (!this.isRemotelyInitialized()) {
            this.getAttributeAccessor().initializeAttributes(this.getDescriptor().getJavaClass());
            this.remotelyInitialized();
        }
    }

    public IdentityHashtable replaceValueHoldersIn(Object object, RemoteSessionController remoteSessionController) {
        return null;
    }

    protected void setDeleteQuery(ModifyQuery modifyQuery) {
        this.changeSetDeleteQuery = modifyQuery;
    }

    public void setDeleteSQLString(String string) {
        DataModifyQuery dataModifyQuery = new DataModifyQuery();
        dataModifyQuery.setSQLString(string);
        this.setCustomDeleteQuery(dataModifyQuery);
    }

    public void setContainerPolicy(ContainerPolicy containerPolicy) {
        this.containerPolicy = containerPolicy;
        ((DataReadQuery)this.getSelectionQuery()).setContainerPolicy(containerPolicy);
    }

    public void setCustomDeleteQuery(ModifyQuery modifyQuery) {
        this.setDeleteQuery(modifyQuery);
        this.setHasCustomDeleteQuery(true);
    }

    public void setCustomInsertQuery(DataModifyQuery dataModifyQuery) {
        this.setInsertQuery(dataModifyQuery);
        this.setHasCustomInsertQuery(true);
    }

    protected void setDirectField(DatabaseField databaseField) {
        this.directField = databaseField;
    }

    public void setDirectFieldName(String string) {
        this.setDirectField(new DatabaseField(string));
    }

    protected void setHasCustomDeleteQuery(boolean bl) {
        this.hasCustomDeleteQuery = bl;
    }

    protected void setHasCustomInsertQuery(boolean bl) {
        this.hasCustomInsertQuery = bl;
    }

    protected void setInsertQuery(DataModifyQuery dataModifyQuery) {
        this.insertQuery = dataModifyQuery;
    }

    public void setInsertSQLString(String string) {
        DataModifyQuery dataModifyQuery = new DataModifyQuery();
        dataModifyQuery.setSQLString(string);
        this.setCustomInsertQuery(dataModifyQuery);
    }

    public void setReferenceClass(Class clazz) {
    }

    public void setReferenceClassName(String string) {
    }

    public void setReferenceKeyFieldName(String string) {
        this.getReferenceKeyFields().addElement(new DatabaseField(string));
    }

    public void setReferenceKeyFieldNames(Vector vector) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(new DatabaseField((String)enumeration.nextElement()));
        }
        this.setReferenceKeyFields(nonSynchronizedVector);
    }

    public void setReferenceKeyFields(Vector vector) {
        this.referenceKeyFields = vector;
    }

    protected void setReferenceTable(DatabaseTable databaseTable) {
        this.referenceTable = databaseTable;
    }

    public void setReferenceTableName(String string) {
        if (string == null) {
            this.setReferenceTable(null);
        } else {
            this.setReferenceTable(new DatabaseTable(string));
        }
    }

    public void setHistoryPolicy(HistoryPolicy historyPolicy) {
        this.historyPolicy = historyPolicy;
        if (historyPolicy != null) {
            historyPolicy.setMapping(this);
        }
    }

    public void setSessionName(String string) {
        super.setSessionName(string);
        this.getInsertQuery().setSessionName(string);
    }

    public void setSourceKeyFieldNames(Vector vector) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(new DatabaseField((String)enumeration.nextElement()));
        }
        this.setSourceKeyFields(nonSynchronizedVector);
    }

    public void setSourceKeyFields(Vector vector) {
        this.sourceKeyFields = vector;
    }

    public void calculateDeferredChanges(ChangeRecord changeRecord, Session session) {
        DirectCollectionChangeRecord directCollectionChangeRecord = (DirectCollectionChangeRecord)changeRecord;
        this.compareCollectionsForChange(directCollectionChangeRecord.getOriginalCollection(), directCollectionChangeRecord.getLatestCollection(), directCollectionChangeRecord, session);
    }

    public void simpleAddToCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, Session session) {
        DirectCollectionChangeRecord directCollectionChangeRecord = (DirectCollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (directCollectionChangeRecord == null) {
            directCollectionChangeRecord = new DirectCollectionChangeRecord(objectChangeSet);
            directCollectionChangeRecord.setAttribute(this.getAttributeName());
            directCollectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(directCollectionChangeRecord);
            Object object3 = this.getRealAttributeValueFromObject(objectChangeSet.getUnitOfWorkClone(), session);
            directCollectionChangeRecord.storeDatabaseCounts(object3, this.getContainerPolicy(), session);
        }
        directCollectionChangeRecord.addAdditionChange(object2, new Integer(1));
    }

    public void simpleRemoveFromCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, Session session) {
        DirectCollectionChangeRecord directCollectionChangeRecord = (DirectCollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (directCollectionChangeRecord == null) {
            directCollectionChangeRecord = new DirectCollectionChangeRecord(objectChangeSet);
            directCollectionChangeRecord.setAttribute(this.getAttributeName());
            directCollectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(directCollectionChangeRecord);
            Object object3 = this.getRealAttributeValueFromObject(objectChangeSet.getUnitOfWorkClone(), session);
            directCollectionChangeRecord.storeDatabaseCounts(object3, this.getContainerPolicy(), session);
        }
        directCollectionChangeRecord.addRemoveChange(object2, new Integer(1));
    }

    public void updateChangeRecord(Object object, Object object2, Object object3, ObjectChangeSet objectChangeSet, UnitOfWork unitOfWork) {
        DirectCollectionChangeRecord directCollectionChangeRecord = (DirectCollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (directCollectionChangeRecord == null) {
            directCollectionChangeRecord = new DirectCollectionChangeRecord(objectChangeSet);
            directCollectionChangeRecord.setAttribute(this.getAttributeName());
            directCollectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(directCollectionChangeRecord);
        }
        if (directCollectionChangeRecord.getOriginalCollection() == null) {
            directCollectionChangeRecord.setOriginalCollection(object3);
        }
        directCollectionChangeRecord.setLatestCollection(object2);
        objectChangeSet.deferredDetectionRequiredOn(this.getAttributeName());
    }

    public void useCollectionClass(Class clazz) {
        ContainerPolicy containerPolicy = ContainerPolicy.buildPolicyFor(clazz);
        this.setContainerPolicy(containerPolicy);
    }

    public void useMapClass(Class clazz, String string) {
        throw ValidationException.illegalUseOfMapInDirectCollection(this, clazz, string);
    }

    public Object valueFromRow(DatabaseRow databaseRow, ObjectLevelReadQuery objectLevelReadQuery, Session session) throws DatabaseException {
        if (objectLevelReadQuery.isReadAllQuery() && (((ReadAllQuery)objectLevelReadQuery).isAttributeBatchRead(this.getDescriptor(), this.getAttributeName()) || this.shouldUseBatchReading())) {
            return this.batchedValueFromRow(databaseRow, (ReadAllQuery)objectLevelReadQuery);
        }
        ReadQuery readQuery = this.getSelectionQuery();
        if (this.getHistoryPolicy() != null || objectLevelReadQuery.getSession().getAsOfClause() != null || objectLevelReadQuery.hasAsOfClause() && (objectLevelReadQuery.shouldCascadeAllParts() || objectLevelReadQuery.shouldCascadePrivateParts() && this.isPrivateOwned() || objectLevelReadQuery.shouldCascadeByMapping() && this.cascadeRefresh)) {
            readQuery = (ReadQuery)readQuery.clone();
            SQLSelectStatement sQLSelectStatement = new SQLSelectStatement();
            sQLSelectStatement.addTable(this.getReferenceTable());
            sQLSelectStatement.addField((DatabaseField)this.getDirectField().clone());
            if (this instanceof DirectMapMapping) {
                sQLSelectStatement.addField((DatabaseField)((DirectMapMapping)this).getDirectKeyField().clone());
            }
            sQLSelectStatement.setWhereClause((Expression)this.getSelectionCriteria().clone());
            sQLSelectStatement.getBuilder().asOf(objectLevelReadQuery.getAsOfClause());
            if (this.getHistoryPolicy() != null) {
                ExpressionBuilder expressionBuilder = sQLSelectStatement.getBuilder();
                if (objectLevelReadQuery.getSession().getAsOfClause() != null) {
                    expressionBuilder.asOf(objectLevelReadQuery.getSession().getAsOfClause());
                } else if (expressionBuilder.getAsOfClause() == null) {
                    expressionBuilder.asOf(AsOfClause.NO_CLAUSE);
                }
                Expression expression = this.getHistoryPolicy().additionalHistoryExpression(expressionBuilder);
                sQLSelectStatement.setWhereClause(sQLSelectStatement.getWhereClause().and(expression));
                if (expressionBuilder.hasAsOfClause()) {
                    sQLSelectStatement.getTables().set(0, this.getHistoryPolicy().getHistoricalTables().elementAt(0));
                }
            }
            sQLSelectStatement.normalize(objectLevelReadQuery.getSession(), null);
            readQuery.setSQLStatement(sQLSelectStatement);
        }
        return this.getIndirectionPolicy().valueFromQuery(readQuery, databaseRow, objectLevelReadQuery.getSession());
    }

    public boolean verifyDelete(Object object, Session session) throws DatabaseException {
        if (this.isReadOnly()) {
            return true;
        }
        DatabaseRow databaseRow = this.getDescriptor().getObjectBuilder().buildRowForTranslation(object, session);
        Object object2 = session.executeQuery((DatabaseQuery)this.getSelectionQuery(), databaseRow);
        return this.getContainerPolicy().isEmpty(object2);
    }

    public void addToCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, UnitOfWork unitOfWork) {
        DirectCollectionChangeRecord directCollectionChangeRecord;
        if (object2 == null) {
            object2 = DirectCollectionChangeRecord.Null;
        }
        if ((directCollectionChangeRecord = (DirectCollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName())) == null) {
            directCollectionChangeRecord = new DirectCollectionChangeRecord(objectChangeSet);
            directCollectionChangeRecord.setAttribute(this.getAttributeName());
            directCollectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(directCollectionChangeRecord);
            Object object3 = this.getRealAttributeValueFromObject(objectChangeSet.getUnitOfWorkClone(), unitOfWork);
            directCollectionChangeRecord.storeDatabaseCounts(object3, this.getContainerPolicy(), unitOfWork);
        }
        directCollectionChangeRecord.addAdditionChange(object2, new Integer(1));
    }

    public boolean isCascadedLockingSupported() {
        return true;
    }

    public boolean isChangeTrackingSupported() {
        return true;
    }

    public void removeFromCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, UnitOfWork unitOfWork) {
        DirectCollectionChangeRecord directCollectionChangeRecord;
        if (object2 == null) {
            object2 = DirectCollectionChangeRecord.Null;
        }
        if ((directCollectionChangeRecord = (DirectCollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName())) == null) {
            directCollectionChangeRecord = new DirectCollectionChangeRecord(objectChangeSet);
            directCollectionChangeRecord.setAttribute(this.getAttributeName());
            directCollectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(directCollectionChangeRecord);
            Object object3 = this.getRealAttributeValueFromObject(objectChangeSet.getUnitOfWorkClone(), unitOfWork);
            directCollectionChangeRecord.storeDatabaseCounts(object3, this.getContainerPolicy(), unitOfWork);
        }
        directCollectionChangeRecord.addRemoveChange(object2, new Integer(1));
    }
}

