/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.weaving;

import java.io.FileOutputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Map;
import oracle.toplink.internal.weaving.ClassDetails;
import oracle.toplink.internal.weaving.TopLinkClassWeaver;
import oracle.toplink.sessions.Session;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.attrs.Attributes;

public class TopLinkWeaver
implements ClassFileTransformer {
    protected Session session;
    protected Map classDetailsMap;

    public TopLinkWeaver(Session session, Map map) {
        this.session = session;
        this.classDetailsMap = map;
    }

    public Map getClassDetailsMap() {
        return this.classDetailsMap;
    }

    public byte[] transform(ClassLoader classLoader, String string, Class clazz, ProtectionDomain protectionDomain, byte[] byArray) throws IllegalClassFormatException {
        ClassDetails classDetails = (ClassDetails)this.classDetailsMap.get(string);
        if (classDetails != null) {
            ClassReader classReader = new ClassReader(byArray);
            ClassWriter classWriter = new ClassWriter(true, true);
            TopLinkClassWeaver topLinkClassWeaver = new TopLinkClassWeaver(classWriter, classDetails);
            classReader.accept((ClassVisitor)topLinkClassWeaver, Attributes.getDefaultAttributes(), false);
            if (topLinkClassWeaver.alreadyWeaved) {
                return null;
            }
            byte[] byArray2 = classWriter.toByteArray();
            if ("true".equalsIgnoreCase(System.getProperties().getProperty("toplink.weaver.clz", "false"))) {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(TopLinkWeaver.getShortName(string) + ".clz");
                    fileOutputStream.write(byArray2);
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (classDetails.weavedChangeTracking()) {
                return byArray2;
            }
            if (topLinkClassWeaver.weavedVH) {
                return byArray2;
            }
        }
        return null;
    }

    protected static String getShortName(String string) {
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            if ((string = string.substring(n + 1)).endsWith(";")) {
                string = string.substring(0, string.length() - 1);
            }
            return string;
        }
        return "";
    }
}

