/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.sessions;

import java.util.Vector;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.helper.WriteLockManager;
import oracle.toplink.internal.identitymaps.CacheKey;
import oracle.toplink.internal.identitymaps.IdentityMap;
import oracle.toplink.internal.identitymaps.IdentityMapManager;
import oracle.toplink.internal.sessions.IdentityMapAccessor;
import oracle.toplink.internal.sessions.IsolatedClientSession;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.InMemoryQueryIndirectionPolicy;
import oracle.toplink.queryframework.ReadQuery;
import oracle.toplink.sessions.Record;

public class IsolatedClientSessionIdentityMapAccessor
extends IdentityMapAccessor {
    public IsolatedClientSessionIdentityMapAccessor(Session session, IdentityMapManager identityMapManager) {
        super(session, identityMapManager);
    }

    public CacheKey acquireDeferredLock(Vector vector, Class clazz, Descriptor descriptor) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().acquireDeferredLock(vector, clazz, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().acquireDeferredLock(vector, clazz, descriptor);
    }

    public CacheKey acquireLock(Vector vector, Class clazz, boolean bl, Descriptor descriptor) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().acquireLock(vector, clazz, bl, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().acquireLock(vector, clazz, bl, descriptor);
    }

    public CacheKey acquireLockNoWait(Vector vector, Class clazz, boolean bl, Descriptor descriptor) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().acquireLockNoWait(vector, clazz, bl, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().acquireLockNoWait(vector, clazz, bl, descriptor);
    }

    public CacheKey acquireReadLockOnCacheKey(Vector vector, Class clazz, Descriptor descriptor) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().acquireReadLockOnCacheKey(vector, clazz, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().acquireReadLockOnCacheKey(vector, clazz, descriptor);
    }

    public CacheKey acquireReadLockOnCacheKeyNoWait(Vector vector, Class clazz, Descriptor descriptor) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().acquireReadLockOnCacheKeyNoWait(vector, clazz, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().acquireReadLockOnCacheKeyNoWait(vector, clazz, descriptor);
    }

    public boolean acquireWriteLock() {
        this.getIdentityMapManager().acquireWriteLock();
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().acquireWriteLock();
    }

    public boolean containsObjectInIdentityMap(Vector vector, Class clazz, Descriptor descriptor) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().containsKey(vector, clazz, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().containsObjectInIdentityMap(vector, clazz, descriptor);
    }

    public Vector getClassesRegistered() {
        Vector vector = this.getIdentityMapManager().getClassesRegistered();
        vector.addAll(((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getClassesRegistered());
        return vector;
    }

    public Vector getAllFromIdentityMap(Expression expression, Class clazz, Record record, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy, boolean bl) throws QueryException {
        if (this.session.getDescriptor(clazz).isIsolated()) {
            return this.getIdentityMapManager().getAllFromIdentityMap(expression, clazz, record, inMemoryQueryIndirectionPolicy, bl);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getAllFromIdentityMap(expression, clazz, record, inMemoryQueryIndirectionPolicy, bl);
    }

    public CacheKey getCacheKeyForObject(Vector vector, Class clazz, Descriptor descriptor) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().getCacheKeyForObject(vector, clazz, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getCacheKeyForObject(vector, clazz, descriptor);
    }

    public Object getFromIdentityMap(Vector vector, Class clazz, boolean bl, Descriptor descriptor) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().getFromIdentityMap(vector, clazz, bl, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getFromIdentityMap(vector, clazz, bl, descriptor);
    }

    public Object getFromIdentityMap(Expression expression, Class clazz, Record record, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy, boolean bl, boolean bl2, Descriptor descriptor) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().getFromIdentityMap(expression, clazz, record, inMemoryQueryIndirectionPolicy, bl, bl2, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getFromIdentityMap(expression, clazz, record, inMemoryQueryIndirectionPolicy, bl, bl2, descriptor);
    }

    public Object getFromIdentityMapWithDeferredLock(Vector vector, Class clazz, boolean bl, Descriptor descriptor) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().getFromIdentityMapWithDeferredLock(vector, clazz, bl, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getFromIdentityMapWithDeferredLock(vector, clazz, bl, descriptor);
    }

    public IdentityMapManager getIdentityMapManager() {
        return this.identityMapManager;
    }

    public IdentityMap getIdentityMap(Class clazz) {
        Descriptor descriptor = this.getSession().getDescriptor(clazz);
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().getIdentityMap(descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getIdentityMap(clazz);
    }

    public Object getQueryResult(ReadQuery readQuery, Vector vector, boolean bl) {
        if (((IsolatedClientSession)this.session).isIsolatedQuery(readQuery)) {
            return this.getIdentityMapManager().getQueryResult(readQuery, vector, bl);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getQueryResult(readQuery, vector, bl);
    }

    public Session getSession() {
        return this.session;
    }

    public Object getWrapper(Vector vector, Class clazz) {
        if (this.session.getDescriptor(clazz).isIsolated()) {
            return this.getIdentityMapManager().getWrapper(vector, clazz);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getWrapper(vector, clazz);
    }

    public WriteLockManager getWriteLockManager() {
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getWriteLockManager();
    }

    public Object getWriteLockValue(Vector vector, Class clazz, Descriptor descriptor) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().getWriteLockValue(vector, clazz, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getWriteLockValue(vector, clazz, descriptor);
    }

    public void initializeAllIdentityMaps() {
        super.initializeAllIdentityMaps();
        ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().initializeAllIdentityMaps();
    }

    public void initializeIdentityMap(Class clazz) {
        this.getSession().log(2, "cache", "initialize_identitymap", clazz);
        if (this.session.getDescriptor(clazz).isIsolated()) {
            this.getIdentityMapManager().initializeIdentityMap(clazz);
        } else {
            ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().initializeIdentityMap(clazz);
        }
    }

    public void initializeIdentityMaps() {
        this.getSession().log(2, "cache", "initialize_identitymaps");
        this.getIdentityMapManager().initializeIdentityMaps();
        this.getSession().getCommitManager().reinitialize();
    }

    public void putQueryResult(ReadQuery readQuery, Vector vector, Object object) {
        if (((IsolatedClientSession)this.session).isIsolatedQuery(readQuery)) {
            this.getIdentityMapManager().putQueryResult(readQuery, vector, object);
        } else {
            ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().putQueryResult(readQuery, vector, object);
        }
    }

    public void printIdentityMap(Class clazz) {
        if (this.getSession().shouldLog(7, "cache")) {
            if (this.session.getDescriptor(clazz).isIsolated()) {
                this.getIdentityMapManager().printIdentityMap(clazz);
            } else {
                ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().printIdentityMap(clazz);
            }
        }
    }

    public void printIdentityMaps() {
        if (this.getSession().shouldLog(7, "cache")) {
            this.getIdentityMapManager().printIdentityMaps();
            ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().printIdentityMaps();
        }
    }

    public void printIdentityMapLocks() {
        if (this.getSession().shouldLog(1, "cache")) {
            this.getIdentityMapManager().printLocks();
            ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().printIdentityMapLocks();
        }
    }

    public CacheKey internalPutInIdentityMap(Object object, Vector vector, Object object2, long l, Descriptor descriptor) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().putInIdentityMap(object, vector, object2, l, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().internalPutInIdentityMap(object, vector, object2, l, descriptor);
    }

    public void releaseWriteLock() {
        ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().releaseWriteLock();
        this.getIdentityMapManager().releaseWriteLock();
    }

    public Object removeFromIdentityMap(Vector vector, Class clazz, Descriptor descriptor) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().removeFromIdentityMap(vector, clazz, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().removeFromIdentityMap(vector, clazz, descriptor);
    }

    public void setIdentityMapManager(IdentityMapManager identityMapManager) {
        this.identityMapManager = identityMapManager;
    }

    public void setWrapper(Vector vector, Class clazz, Object object) {
        if (this.getSession().getDescriptor(clazz).isIsolated()) {
            this.getIdentityMapManager().setWrapper(vector, clazz, object);
        } else {
            ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().setWrapper(vector, clazz, object);
        }
    }

    public void updateWriteLockValue(Vector vector, Class clazz, Object object) {
        if (this.getSession().getDescriptor(clazz).isIsolated()) {
            this.getIdentityMapManager().setWriteLockValue(vector, clazz, object);
        } else {
            ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().updateWriteLockValue(vector, clazz, object);
        }
    }
}

