/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.sessions;

import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.localization.ToStringLocalization;
import oracle.toplink.internal.sessions.CommitOrderCalculator;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.ForeignReferenceMapping;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.InheritancePolicy;
import oracle.toplink.publicinterface.Session;

public class CommitOrderDependencyNode {
    protected CommitOrderCalculator owner;
    protected Descriptor descriptor;
    protected Session session;
    protected Vector relatedNodes;
    protected CommitOrderDependencyNode predecessor;
    protected int traversalState;
    public static int NotVisited = 1;
    public static int InProgress = 2;
    public static int Visited = 3;
    protected int discoveryTime;
    protected int finishingTime;

    public CommitOrderDependencyNode(CommitOrderCalculator commitOrderCalculator, Descriptor descriptor, Session session) {
        this.owner = commitOrderCalculator;
        this.descriptor = descriptor;
        this.relatedNodes = new Vector();
        this.session = session;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public int getFinishingTime() {
        return this.finishingTime;
    }

    public CommitOrderCalculator getOwner() {
        return this.owner;
    }

    public CommitOrderDependencyNode getPredecessor() {
        return this.predecessor;
    }

    public Vector getRelatedNodes() {
        return this.relatedNodes;
    }

    public boolean hasBeenVisited() {
        return this.traversalState == Visited;
    }

    public boolean hasNotBeenVisited() {
        return this.traversalState == NotVisited;
    }

    public void markInProgress() {
        this.traversalState = InProgress;
    }

    public void markNotVisited() {
        this.traversalState = NotVisited;
    }

    public void markVisited() {
        this.traversalState = Visited;
    }

    public void recordMappingDependencies() {
        Enumeration enumeration = this.getDescriptor().getMappings().elements();
        while (enumeration.hasMoreElements()) {
            Vector vector;
            CommitOrderDependencyNode commitOrderDependencyNode;
            Class clazz;
            Descriptor descriptor;
            DatabaseMapping databaseMapping = (DatabaseMapping)enumeration.nextElement();
            if (!databaseMapping.isForeignReferenceMapping()) continue;
            if (((ForeignReferenceMapping)databaseMapping).hasConstraintDependency()) {
                descriptor = ((ForeignReferenceMapping)databaseMapping).getReferenceDescriptor();
                if (descriptor == null) {
                    descriptor = this.session.getDescriptor(((ForeignReferenceMapping)databaseMapping).getReferenceClass());
                }
                if ((clazz = descriptor.getJavaClass()) == null) {
                    throw DescriptorException.referenceClassNotSpecified(databaseMapping);
                }
                commitOrderDependencyNode = this.getOwner().nodeFor(clazz);
                vector = this.withAllSubclasses(commitOrderDependencyNode);
                Helper.addAllToVector(this.relatedNodes, vector);
                continue;
            }
            if (!((ForeignReferenceMapping)databaseMapping).hasInverseConstraintDependency()) continue;
            descriptor = ((ForeignReferenceMapping)databaseMapping).getReferenceDescriptor();
            if (descriptor == null) {
                descriptor = this.session.getDescriptor(((ForeignReferenceMapping)databaseMapping).getReferenceClass());
            }
            if ((clazz = descriptor.getJavaClass()) == null) {
                throw DescriptorException.referenceClassNotSpecified(databaseMapping);
            }
            commitOrderDependencyNode = this.getOwner().nodeFor(clazz);
            vector = this.withAllSubclasses(this);
            Helper.addAllToVector(commitOrderDependencyNode.getRelatedNodes(), vector);
        }
    }

    public void recordSpecifiedDependencies() {
        Enumeration enumeration = this.getDescriptor().getConstraintDependencies().elements();
        while (enumeration.hasMoreElements()) {
            Class clazz = (Class)enumeration.nextElement();
            CommitOrderDependencyNode commitOrderDependencyNode = this.getOwner().nodeFor(clazz);
            Vector vector = this.withAllSubclasses(commitOrderDependencyNode);
            Helper.addAllToVector(this.relatedNodes, vector);
        }
    }

    public void setDiscoveryTime(int n) {
        this.discoveryTime = n;
    }

    public void setFinishingTime(int n) {
        this.finishingTime = n;
    }

    public void setPredecessor(CommitOrderDependencyNode commitOrderDependencyNode) {
        this.predecessor = commitOrderDependencyNode;
    }

    public String toString() {
        if (this.descriptor == null) {
            return ToStringLocalization.buildMessage("empty_commit_order_dependency_node", null);
        }
        Object[] objectArray = new Object[]{this.descriptor};
        return ToStringLocalization.buildMessage("node", objectArray);
    }

    public void visit() {
        this.markInProgress();
        int n = this.getOwner().getNextTime();
        this.setDiscoveryTime(n);
        Enumeration enumeration = this.getRelatedNodes().elements();
        while (enumeration.hasMoreElements()) {
            CommitOrderDependencyNode commitOrderDependencyNode = (CommitOrderDependencyNode)enumeration.nextElement();
            if (commitOrderDependencyNode.hasNotBeenVisited()) {
                commitOrderDependencyNode.setPredecessor(this);
                commitOrderDependencyNode.visit();
            }
            if (commitOrderDependencyNode.getPredecessor() != null) continue;
            commitOrderDependencyNode.setPredecessor(this);
        }
        this.markVisited();
        this.setFinishingTime(this.getOwner().getNextTime());
    }

    public Vector withAllSubclasses(CommitOrderDependencyNode commitOrderDependencyNode) {
        Vector<CommitOrderDependencyNode> vector = new Vector<CommitOrderDependencyNode>();
        vector.addElement(commitOrderDependencyNode);
        if (commitOrderDependencyNode.getDescriptor().hasInheritance()) {
            InheritancePolicy inheritancePolicy = commitOrderDependencyNode.getDescriptor().getInheritancePolicy();
            Enumeration enumeration = inheritancePolicy.getAllChildDescriptors().elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(this.getOwner().nodeFor((Descriptor)enumeration.nextElement()));
            }
        }
        return vector;
    }
}

