/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.sequencing;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import oracle.toplink.exceptions.ConcurrencyException;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.internal.helper.ConcurrencyManager;
import oracle.toplink.internal.sequencing.DatabaseSessionConnectionHandler;
import oracle.toplink.internal.sequencing.PreallocationHandler;
import oracle.toplink.internal.sequencing.Sequencing;
import oracle.toplink.internal.sequencing.SequencingCallback;
import oracle.toplink.internal.sequencing.SequencingConnectionHandler;
import oracle.toplink.internal.sequencing.SequencingHome;
import oracle.toplink.internal.sequencing.SequencingServer;
import oracle.toplink.internal.sequencing.ServerSessionConnectionHandler;
import oracle.toplink.publicinterface.DatabaseSession;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.sequencing.DefaultSequence;
import oracle.toplink.sequencing.NativeSequence;
import oracle.toplink.sequencing.Sequence;
import oracle.toplink.sequencing.SequencingControl;
import oracle.toplink.sequencing.TableSequence;
import oracle.toplink.sequencing.UnaryTableSequence;
import oracle.toplink.sessions.Login;
import oracle.toplink.threetier.ConnectionPool;
import oracle.toplink.threetier.ExternalConnectionPool;
import oracle.toplink.threetier.ServerSession;

class SequencingManager
implements SequencingHome,
SequencingServer,
SequencingControl {
    private DatabaseSession ownerSession;
    private SequencingConnectionHandler connectionHandler;
    private PreallocationHandler preallocationHandler;
    private int whenShouldAcquireValueForAll;
    private Vector connectedSequences;
    boolean atLeastOneSequenceShouldUseTransaction;
    boolean atLeastOneSequenceShouldUsePreallocation;
    private static final int NOPREALLOCATION = 0;
    private static final int PREALLOCATION_NOTRANSACTION = 1;
    private static final int PREALLOCATION_TRANSACTION_NOACCESSOR = 2;
    private static final int PREALLOCATION_TRANSACTION_ACCESSOR = 3;
    private static final int NUMBER_OF_STATES = 4;
    private State[] states;
    private Hashtable locks;
    private SequencingCallback callback;
    private SequencingServer server;
    private Sequencing seq;
    private boolean shouldUseSeparateConnection;
    private Login login;
    private int minPoolSize;
    private int maxPoolSize;

    public SequencingManager(DatabaseSession databaseSession) {
        this.ownerSession = databaseSession;
    }

    protected DatabaseSession getOwnerSession() {
        return this.ownerSession;
    }

    protected void createConnectionHandler() {
        Object object;
        boolean bl = this.getOwnerSession().isServerSession();
        if (this.getLogin() == null) {
            object = bl ? ((ServerSession)this.getOwnerSession()).getReadConnectionPool().getLogin() : this.getOwnerSession().getDatasourceLogin();
            this.setLogin((Login)object.clone());
        }
        if (this.getLogin() != null && this.getLogin().shouldUseExternalTransactionController()) {
            throw ValidationException.invalidSequencingLogin();
        }
        if (bl) {
            object = null;
            if (this.getLogin().shouldUseExternalConnectionPooling()) {
                object = new ExternalConnectionPool("sequencing", this.getLogin(), (ServerSession)this.getOwnerSession());
            } else {
                if (this.getMinPoolSize() == 0 && this.getMaxPoolSize() == 0) {
                    this.setMinPoolSize(2);
                    this.setMaxPoolSize(2);
                }
                object = new ConnectionPool("sequencing", this.getLogin(), this.getMinPoolSize(), this.getMaxPoolSize(), (ServerSession)this.getOwnerSession());
            }
            this.setConnectionHandler(new ServerSessionConnectionHandler((ConnectionPool)object));
        } else {
            this.setConnectionHandler(new DatabaseSessionConnectionHandler(this.getOwnerSession(), this.getLogin()));
        }
    }

    public SequencingControl getSequencingControl() {
        return this;
    }

    protected void setSequencing(Sequencing sequencing) {
        this.seq = sequencing;
    }

    public Sequencing getSequencing() {
        return this.seq;
    }

    protected void setSequencingServer(SequencingServer sequencingServer) {
        this.server = sequencingServer;
    }

    public SequencingServer getSequencingServer() {
        return this.server;
    }

    protected void setSequencingCallback(SequencingCallback sequencingCallback) {
        this.callback = sequencingCallback;
    }

    public SequencingCallback getSequencingCallback() {
        return this.callback;
    }

    public boolean shouldUseSeparateConnection() {
        return this.shouldUseSeparateConnection;
    }

    public void setShouldUseSeparateConnection(boolean bl) {
        this.shouldUseSeparateConnection = bl;
    }

    public boolean isConnectedUsingSeparateConnection() {
        return this.isConnected() && this.getConnectionHandler() != null;
    }

    public Login getLogin() {
        return this.login;
    }

    public void setLogin(Login login) {
        this.login = login;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int n) {
        this.minPoolSize = n;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int n) {
        this.maxPoolSize = n;
    }

    public boolean isConnected() {
        return this.states != null;
    }

    protected SequencingConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    protected void setConnectionHandler(SequencingConnectionHandler sequencingConnectionHandler) {
        this.connectionHandler = sequencingConnectionHandler;
    }

    public Object getNextValue(Class clazz) {
        return this.getNextValue(this.getOwnerSession(), clazz);
    }

    public void initializePreallocated() {
        if (this.getPreallocationHandler() != null) {
            this.getPreallocationHandler().initializePreallocated();
        }
    }

    public void initializePreallocated(String string) {
        if (this.getPreallocationHandler() != null) {
            this.getPreallocationHandler().initializePreallocated(string);
        }
    }

    protected void setLocks(Hashtable hashtable) {
        this.locks = hashtable;
    }

    protected Hashtable getLocks() {
        return this.locks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acquireLock(String string) {
        ConcurrencyManager concurrencyManager;
        Hashtable hashtable = this.getLocks();
        synchronized (hashtable) {
            concurrencyManager = (ConcurrencyManager)this.getLocks().get(string);
            if (concurrencyManager == null) {
                concurrencyManager = new ConcurrencyManager();
                this.getLocks().put(string, concurrencyManager);
            }
        }
        concurrencyManager.acquire();
    }

    protected void releaseLock(String string) {
        ConcurrencyManager concurrencyManager = (ConcurrencyManager)this.locks.get(string);
        concurrencyManager.release();
    }

    protected Sequence getSequence(Class clazz) {
        String string = this.getOwnerSession().getDescriptor(clazz).getSequenceNumberName();
        return this.getSequence(string);
    }

    protected void logDebugPreallocation(String string, Vector vector) {
        if (this.getOwnerSession().shouldLog(1, "sequencing")) {
            Object[] objectArray = new Object[]{string, new Integer(vector.size()), vector.firstElement(), vector.lastElement()};
            this.getOwnerSession().log(1, "sequencing", "sequencing_preallocation", objectArray);
        }
    }

    protected void logDebugLocalPreallocation(Session session, String string, Vector vector, Accessor accessor) {
        if (session.shouldLog(1, "sequencing")) {
            Object[] objectArray = new Object[]{string, new Integer(vector.size()), vector.firstElement(), vector.lastElement()};
            session.log(1, "sequencing", "sequencing_localPreallocation", objectArray, accessor);
        }
    }

    public void shouldUseNativeSequencing() {
        if (this.getOwnerSession().getDatasourcePlatform() instanceof DatabasePlatform) {
            this.getOwnerSession().getPlatform().setDefaultSequence(new NativeSequence(this.getDefaultSequence().getName(), this.getDefaultSequence().getPreallocationSize()));
        }
    }

    public void shouldUseTableSequencing() {
        if (this.getOwnerSession().getDatasourcePlatform() instanceof DatabasePlatform) {
            this.getOwnerSession().getPlatform().setDefaultSequence(new TableSequence(this.getDefaultSequence().getName(), this.getDefaultSequence().getPreallocationSize()));
        }
    }

    public void resetSequencing() {
        if (this.isConnected()) {
            this.onDisconnect();
            this.onConnect();
        }
    }

    public boolean usesCustomSequencing() {
        Sequence sequence = this.getDefaultSequence();
        if (this.getOwnerSession().getProject().usesSequencing()) {
            if (this.getOwnerSession().getDatasourcePlatform() instanceof DatabasePlatform) {
                return !(sequence instanceof TableSequence) && !(sequence instanceof UnaryTableSequence) && !(sequence instanceof NativeSequence);
            }
            return true;
        }
        return false;
    }

    public boolean usesNativeSequencing() {
        if (this.getOwnerSession().getProject().usesSequencing()) {
            return this.getDefaultSequence() instanceof NativeSequence;
        }
        return false;
    }

    public boolean usesTableSequencing() {
        if (this.getOwnerSession().getProject().usesSequencing()) {
            return this.getDefaultSequence() instanceof TableSequence;
        }
        return false;
    }

    public void onConnect() {
        if (this.isConnected()) {
            return;
        }
        if (!this.getOwnerSession().getProject().usesSequencing()) {
            return;
        }
        this.onConnectAllSequences();
        boolean bl = false;
        boolean bl2 = false;
        try {
            if (!this.shouldUseSeparateConnection()) {
                this.setConnectionHandler(null);
            } else if (this.atLeastOneSequenceShouldUseTransaction) {
                if (this.getConnectionHandler() == null) {
                    this.createConnectionHandler();
                }
                if (this.getConnectionHandler() != null) {
                    this.getConnectionHandler().onConnect();
                    bl2 = true;
                }
            }
            if (this.atLeastOneSequenceShouldUsePreallocation) {
                if (this.getPreallocationHandler() == null) {
                    this.createPreallocationHandler();
                }
                this.getPreallocationHandler().onConnect();
                bl = true;
            }
            this.initializeStates();
        }
        catch (RuntimeException runtimeException) {
            this.onDisconnectAllSequences();
            if (this.getConnectionHandler() != null) {
                if (bl2) {
                    this.getConnectionHandler().onDisconnect();
                }
                this.setConnectionHandler(null);
            }
            if (this.getPreallocationHandler() != null) {
                if (bl) {
                    this.getPreallocationHandler().onDisconnect();
                }
                this.clearPreallocationHandler();
            }
            throw runtimeException;
        }
        if (this.atLeastOneSequenceShouldUsePreallocation) {
            this.setLocks(new Hashtable(20));
        }
        this.createSequencingCallback();
        if (this.getOwnerSession().isServerSession()) {
            this.setSequencingServer(this);
        }
        this.setSequencing(this);
        this.logDebugSequencingConnected();
    }

    public void onDisconnect() {
        if (!this.isConnected()) {
            return;
        }
        this.setSequencing(null);
        this.setSequencingServer(null);
        this.setSequencingCallback(null);
        this.setLocks(null);
        this.clearStates();
        if (this.getConnectionHandler() != null) {
            this.getConnectionHandler().onDisconnect();
            this.setConnectionHandler(null);
        }
        if (this.getPreallocationHandler() != null) {
            this.getPreallocationHandler().onDisconnect();
            this.clearPreallocationHandler();
        }
        this.onDisconnectAllSequences();
        this.getOwnerSession().log(1, "sequencing", "sequencing_disconnected");
    }

    protected PreallocationHandler getPreallocationHandler() {
        return this.preallocationHandler;
    }

    protected void createPreallocationHandler() {
        this.preallocationHandler = new PreallocationHandler();
    }

    protected void clearPreallocationHandler() {
        this.preallocationHandler = null;
    }

    protected void onConnectAllSequences() {
        this.connectedSequences = new Vector();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Iterator iterator = this.getOwnerSession().getDescriptors().values().iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            if (!descriptor.usesSequenceNumbers()) continue;
            String string = descriptor.getSequenceNumberName();
            Sequence sequence = this.getSequence(string);
            if (sequence == null) {
                sequence = new DefaultSequence(string);
                this.getOwnerSession().getDatasourcePlatform().addSequence(sequence);
            }
            if (this.connectedSequences.contains(sequence)) continue;
            try {
                if (sequence instanceof DefaultSequence && !this.connectedSequences.contains(this.getDefaultSequence())) {
                    this.getDefaultSequence().onConnect(this.getOwnerSession().getDatasourcePlatform());
                    this.connectedSequences.add(0, this.getDefaultSequence());
                    bl |= this.getDefaultSequence().shouldUseTransaction();
                    bl2 |= this.getDefaultSequence().shouldUsePreallocation();
                    bl3 |= this.getDefaultSequence().shouldAcquireValueAfterInsert();
                }
                sequence.onConnect(this.getOwnerSession().getDatasourcePlatform());
                this.connectedSequences.addElement(sequence);
                bl |= sequence.shouldUseTransaction();
                bl2 |= sequence.shouldUsePreallocation();
                bl3 |= sequence.shouldAcquireValueAfterInsert();
            }
            catch (RuntimeException runtimeException) {
                for (int i = this.connectedSequences.size() - 1; i >= 0; --i) {
                    try {
                        Sequence sequence2 = (Sequence)this.connectedSequences.elementAt(i);
                        sequence2.onDisconnect(this.getOwnerSession().getDatasourcePlatform());
                        continue;
                    }
                    catch (RuntimeException runtimeException2) {
                        // empty catch block
                    }
                }
                this.connectedSequences = null;
                throw runtimeException;
            }
        }
        if (bl3 && !bl2) {
            this.whenShouldAcquireValueForAll = 1;
        } else if (!bl3 && bl2) {
            this.whenShouldAcquireValueForAll = -1;
        }
        this.atLeastOneSequenceShouldUseTransaction = bl;
        this.atLeastOneSequenceShouldUsePreallocation = bl2;
    }

    protected void onDisconnectAllSequences() {
        RuntimeException runtimeException = null;
        for (int i = this.connectedSequences.size() - 1; i >= 0; --i) {
            try {
                Sequence sequence = (Sequence)this.connectedSequences.elementAt(i);
                sequence.onDisconnect(this.getOwnerSession().getDatasourcePlatform());
                continue;
            }
            catch (RuntimeException runtimeException2) {
                if (runtimeException != null) continue;
                runtimeException = runtimeException2;
            }
        }
        this.connectedSequences = null;
        this.whenShouldAcquireValueForAll = 0;
        this.atLeastOneSequenceShouldUseTransaction = false;
        this.atLeastOneSequenceShouldUsePreallocation = false;
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    protected void initializeStates() {
        this.states = new State[4];
        Iterator iterator = this.connectedSequences.iterator();
        while (iterator.hasNext()) {
            Sequence sequence = (Sequence)iterator.next();
            State state = this.getState(sequence.shouldUsePreallocation(), sequence.shouldUseTransaction());
            if (state != null) continue;
            this.createState(sequence.shouldUsePreallocation(), sequence.shouldUseTransaction());
        }
    }

    protected void clearStates() {
        this.states = null;
    }

    protected int getStateId(boolean bl, boolean bl2) {
        if (!bl) {
            return 0;
        }
        if (!bl2) {
            return 1;
        }
        if (this.getConnectionHandler() == null) {
            return 2;
        }
        return 3;
    }

    protected State getState(boolean bl, boolean bl2) {
        return this.states[this.getStateId(bl, bl2)];
    }

    protected void createState(boolean bl, boolean bl2) {
        if (!bl) {
            this.states[0] = new NoPreallocation_State();
        } else if (!bl2) {
            this.states[1] = new Preallocation_NoTransaction_State();
        } else if (this.getConnectionHandler() == null) {
            this.states[2] = new Preallocation_Transaction_NoAccessor_State();
        } else {
            this.states[3] = new Preallocation_Transaction_Accessor_State();
        }
    }

    protected void createSequencingCallback() {
        Vector<SequencingCallback> vector = new Vector<SequencingCallback>();
        for (int i = 0; i < 4; ++i) {
            SequencingCallback sequencingCallback;
            if (this.states[i] == null || (sequencingCallback = this.states[i].getSequencingCallback()) == null) continue;
            vector.addElement(sequencingCallback);
        }
        if (vector.isEmpty()) {
            this.setSequencingCallback(null);
        } else if (vector.size() == 1) {
            this.setSequencingCallback((SequencingCallback)vector.firstElement());
        } else {
            this.setSequencingCallback(new SequencingCallbackContainer(vector));
        }
    }

    public Object getNextValue(Session session, Class clazz) {
        Sequence sequence = this.getSequence(clazz);
        State state = this.getState(sequence.shouldUsePreallocation(), sequence.shouldUseTransaction());
        return state.getNextValue(sequence, session);
    }

    protected void logDebugSequencingConnected() {
        Vector[] vectorArray = new Vector[4];
        Iterator iterator = this.connectedSequences.iterator();
        while (iterator.hasNext()) {
            Sequence sequence = (Sequence)iterator.next();
            int n = this.getStateId(sequence.shouldUsePreallocation(), sequence.shouldUseTransaction());
            Vector<Sequence> vector = vectorArray[n];
            if (vector == null) {
                vectorArray[n] = vector = new Vector<Sequence>();
            }
            vector.addElement(sequence);
        }
        for (int i = 0; i < 4; ++i) {
            Vector vector = vectorArray[i];
            if (vector == null) continue;
            this.getOwnerSession().log(1, "sequencing", "sequencing_connected", this.states[i]);
            for (int j = 1; j < vector.size(); ++j) {
                Sequence sequence = (Sequence)vector.elementAt(j);
                Object[] objectArray = new Object[]{sequence.getName(), Integer.toString(sequence.getPreallocationSize())};
                this.getOwnerSession().log(1, "sequencing", "sequence_without_state", objectArray);
            }
        }
    }

    public int getPreallocationSize() {
        return this.getDefaultSequence().getPreallocationSize();
    }

    public void setPreallocationSize(int n) {
        this.getDefaultSequence().setPreallocationSize(n);
    }

    public boolean shouldAcquireValueAfterInsert(Class clazz) {
        return this.getSequence(clazz).shouldAcquireValueAfterInsert();
    }

    public boolean shouldOverrideExistingValue(Class clazz, Object object) {
        return this.getSequence(clazz).shouldOverrideExistingValue(object);
    }

    public int whenShouldAcquireValueForAll() {
        return this.whenShouldAcquireValueForAll;
    }

    protected Sequence getDefaultSequence() {
        return this.getOwnerSession().getDatasourcePlatform().getDefaultSequence();
    }

    protected Sequence getSequence(String string) {
        return this.getOwnerSession().getDatasourcePlatform().getSequence(string);
    }

    static class SequencingCallbackContainer
    implements SequencingCallback {
        SequencingCallback[] callbackArray;

        SequencingCallbackContainer(Vector vector) {
            this.callbackArray = new SequencingCallback[vector.size()];
            vector.copyInto(this.callbackArray);
        }

        public void afterTransaction(Accessor accessor, boolean bl) {
            for (int i = 0; i < this.callbackArray.length; ++i) {
                this.callbackArray[i].afterTransaction(accessor, bl);
            }
        }
    }

    class NoPreallocation_State
    extends State {
        NoPreallocation_State() {
        }

        public Object getNextValue(Sequence sequence, Session session) {
            return sequence.getGeneratedValue(null, session);
        }
    }

    class Preallocation_NoTransaction_State
    extends State {
        Preallocation_NoTransaction_State() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getNextValue(Sequence sequence, Session session) {
            Object e;
            String string = sequence.getName();
            SequencingManager.this.acquireLock(string);
            try {
                Vector vector = SequencingManager.this.getPreallocationHandler().getPreallocated(string);
                if (vector.isEmpty()) {
                    Vector vector2 = sequence.getGeneratedVector(null, session);
                    SequencingManager.this.getPreallocationHandler().setPreallocated(string, vector2);
                    SequencingManager.this.logDebugPreallocation(string, vector2);
                }
                e = vector.firstElement();
                vector.removeElementAt(0);
            }
            finally {
                SequencingManager.this.releaseLock(string);
            }
            return e;
        }
    }

    class Preallocation_Transaction_Accessor_State
    extends State {
        Preallocation_Transaction_Accessor_State() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getNextValue(Sequence sequence, Session session) {
            Object var3_3 = null;
            String string = sequence.getName();
            SequencingManager.this.acquireLock(string);
            try {
                Vector vector = SequencingManager.this.getPreallocationHandler().getPreallocated(string);
                if (vector.isEmpty()) {
                    Accessor accessor = null;
                    try {
                        accessor = SequencingManager.this.getConnectionHandler().acquireAccessor();
                        accessor.beginTransaction(session);
                        Vector vector2 = sequence.getGeneratedVector(accessor, session);
                        SequencingManager.this.getPreallocationHandler().setPreallocated(string, vector2);
                        accessor.commitTransaction(session);
                        SequencingManager.this.logDebugPreallocation(string, vector2);
                    }
                    catch (RuntimeException runtimeException) {
                        vector.clear();
                        try {
                            accessor.rollbackTransaction(session);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw runtimeException;
                    }
                    finally {
                        SequencingManager.this.getConnectionHandler().releaseAccessor(accessor);
                    }
                }
                var3_3 = vector.firstElement();
                vector.removeElementAt(0);
            }
            finally {
                SequencingManager.this.releaseLock(string);
            }
            return var3_3;
        }
    }

    class Preallocation_Transaction_NoAccessor_State
    extends State
    implements SequencingCallback {
        protected Hashtable accessorToPreallocated = new Hashtable(20);

        Preallocation_Transaction_NoAccessor_State() {
        }

        SequencingCallback getSequencingCallback() {
            return this;
        }

        public void afterTransaction(Accessor accessor, boolean bl) {
            Hashtable hashtable = (Hashtable)this.accessorToPreallocated.get(accessor);
            if (hashtable != null) {
                if (bl) {
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        Vector vector = (Vector)hashtable.get(string);
                        if (vector.isEmpty()) continue;
                        SequencingManager.this.acquireLock(string);
                        SequencingManager.this.getPreallocationHandler().setPreallocated(string, vector);
                        vector.clear();
                        SequencingManager.this.releaseLock(string);
                    }
                }
                this.accessorToPreallocated.remove(accessor);
                if (bl) {
                    SequencingManager.this.getOwnerSession().log(1, "sequencing", "sequencing_afterTransactionCommitted", null, accessor);
                } else {
                    SequencingManager.this.getOwnerSession().log(1, "sequencing", "sequencing_afterTransactionRolledBack", null, accessor);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getNextValue(Sequence sequence, Session session) {
            Vector vector;
            Hashtable<String, Vector<Object>> hashtable;
            Accessor accessor;
            String string = sequence.getName();
            SequencingManager.this.acquireLock(string);
            boolean bl = false;
            Vector vector2 = SequencingManager.this.getPreallocationHandler().getPreallocated(string);
            try {
                if (!vector2.isEmpty()) {
                    Object e = vector2.firstElement();
                    vector2.removeElementAt(0);
                    Object e2 = e;
                    return e2;
                }
                if (!SequencingManager.this.getOwnerSession().getDatasourceLogin().shouldUseExternalTransactionController() && sequence.getPreallocationSize() > 1 && !session.isInTransaction()) {
                    session.beginTransaction();
                    bl = true;
                }
            }
            finally {
                if (!bl) {
                    SequencingManager.this.releaseLock(string);
                }
            }
            if (!bl) {
                session.beginTransaction();
            }
            try {
                accessor = session.getAccessor();
                hashtable = (Hashtable<String, Vector>)this.accessorToPreallocated.get(accessor);
                if (hashtable == null) {
                    hashtable = new Hashtable<String, Vector>(20);
                    this.accessorToPreallocated.put(accessor, hashtable);
                }
                if ((vector = (Vector)hashtable.get(string)) == null || vector.isEmpty()) {
                    vector = sequence.getGeneratedVector(null, session);
                    hashtable.put(string, vector);
                    SequencingManager.this.logDebugLocalPreallocation(session, string, vector, accessor);
                }
            }
            catch (RuntimeException runtimeException) {
                if (bl) {
                    SequencingManager.this.releaseLock(string);
                }
                try {
                    session.rollbackTransaction();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw runtimeException;
            }
            if (!bl) {
                SequencingManager.this.acquireLock(string);
            }
            try {
                Object e;
                try {
                    session.commitTransaction();
                }
                catch (DatabaseException databaseException) {
                    try {
                        session.rollbackTransaction();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw databaseException;
                }
                if (!vector.isEmpty()) {
                    Object e3 = vector.firstElement();
                    vector.removeElementAt(0);
                    hashtable = e3;
                    return hashtable;
                }
                try {
                    e = vector2.firstElement();
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw ConcurrencyException.sequencingMultithreadThruConnection(String.valueOf(System.identityHashCode(accessor)));
                }
                vector2.removeElementAt(0);
                hashtable = e;
                return hashtable;
            }
            finally {
                SequencingManager.this.releaseLock(string);
            }
        }
    }

    static abstract class State {
        State() {
        }

        abstract Object getNextValue(Sequence var1, Session var2);

        SequencingCallback getSequencingCallback() {
            return null;
        }

        public String toString() {
            String string = this.getClass().getName();
            return string.substring(string.lastIndexOf(36) + 1);
        }
    }
}

