/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.remote;

import java.rmi.server.ObjID;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.queryframework.CursoredStream;
import oracle.toplink.remote.RemoteSession;

public class RemoteCursoredStream
extends CursoredStream {
    protected ObjID id = new ObjID();
    protected boolean isClosed;
    protected int pageSize;

    public RemoteCursoredStream(CursoredStream cursoredStream) {
        this.position = cursoredStream.getPosition();
        this.pageSize = cursoredStream.getPageSize();
        this.isClosed = cursoredStream.getResultSet() == null;
    }

    public void close() throws DatabaseException {
        if (this.isClosed()) {
            return;
        }
        ((RemoteSession)this.getSession()).getRemoteConnection().cursoredStreamClose(this.getID());
    }

    protected int getCursorSize() {
        return ((RemoteSession)this.getSession()).getRemoteConnection().cursoredStreamSize(this.getID());
    }

    public ObjID getID() {
        return this.id;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    protected Object retrieveNextPage() throws DatabaseException {
        if (this.isClosed()) {
            return null;
        }
        Vector vector = ((RemoteSession)this.getSession()).getRemoteConnection().cursoredStreamNextPage(this, this.getPolicy().getQuery(), (RemoteSession)this.getSession(), this.getPageSize());
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        Helper.addAllToVector(this.getObjectCollection(), vector);
        return this.getObjectCollection().lastElement();
    }
}

