/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.queryframework;

import java.util.Collection;
import java.util.Vector;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.queryframework.InterfaceContainerPolicy;
import oracle.toplink.publicinterface.Session;

public class CollectionContainerPolicy
extends InterfaceContainerPolicy {
    public CollectionContainerPolicy() {
    }

    public CollectionContainerPolicy(Class clazz) {
        super(clazz);
    }

    public CollectionContainerPolicy(String string) {
        super(string);
    }

    public boolean addInto(Object object, Object object2, Object object3) {
        try {
            return ((Collection)object3).add(object2);
        }
        catch (ClassCastException classCastException) {
            throw QueryException.cannotAddElement(object2, object3, classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw QueryException.cannotAddElement(object2, object3, illegalArgumentException);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw QueryException.cannotAddElement(object2, object3, unsupportedOperationException);
        }
    }

    public Object buildContainerFromVector(Vector vector, Session session) {
        if (this.getContainerClass() == vector.getClass() && !this.hasElementDescriptor()) {
            return vector;
        }
        return super.buildContainerFromVector(vector, session);
    }

    public void clear(Object object) {
        try {
            ((Collection)object).clear();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw QueryException.methodNotValid(object, "clear()");
        }
    }

    protected boolean contains(Object object, Object object2) {
        return ((Collection)object2).contains(object);
    }

    public Class getInterfaceType() {
        return ClassConstants.Collection_Class;
    }

    public boolean hasOrder() {
        return Helper.classImplementsInterface(this.getContainerClass(), ClassConstants.SortedSet_Class);
    }

    public boolean isValidContainer(Object object) {
        return object instanceof Collection;
    }

    public boolean isCollectionPolicy() {
        return true;
    }

    public Object iteratorFor(Object object) {
        return ((Collection)object).iterator();
    }

    protected boolean removeFrom(Object object, Object object2, Object object3) {
        try {
            return ((Collection)object3).remove(object2);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw QueryException.methodNotValid(object2, "remove(Object element)");
        }
    }

    public int sizeFor(Object object) {
        return ((Collection)object).size();
    }
}

