/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.parsing;

import java.util.Iterator;
import java.util.Vector;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.internal.parsing.EqualsAssignmentNode;
import oracle.toplink.internal.parsing.GenerationContext;
import oracle.toplink.internal.parsing.MajorNode;
import oracle.toplink.internal.parsing.Node;
import oracle.toplink.internal.parsing.ParseTree;
import oracle.toplink.queryframework.UpdateAllQuery;

public class SetNode
extends MajorNode {
    private Vector assignmentNodes = new Vector();

    public void addUpdatesToQuery(UpdateAllQuery updateAllQuery, GenerationContext generationContext) {
        Iterator iterator = this.assignmentNodes.iterator();
        while (iterator.hasNext()) {
            EqualsAssignmentNode equalsAssignmentNode = (EqualsAssignmentNode)iterator.next();
            Expression expression = this.getExpressionForNode(equalsAssignmentNode.getLeft(), updateAllQuery.getReferenceClass(), generationContext);
            Expression expression2 = this.getExpressionForNode(equalsAssignmentNode.getRight(), updateAllQuery.getReferenceClass(), generationContext);
            updateAllQuery.addUpdate(expression, expression2);
        }
    }

    protected Expression getExpressionForNode(Node node, Class clazz, GenerationContext generationContext) {
        Expression expression = null;
        if (node.isLocalVariableNode()) {
            String string = generationContext.getParseTreeContext().getVariableNameForClass(clazz, generationContext);
            expression = generationContext.expressionFor(string);
            if (expression == null) {
                expression = new ExpressionBuilder();
                generationContext.addExpression(expression, string);
            }
            expression = node.addToExpression(expression, generationContext);
        } else {
            expression = node.generateExpression(generationContext);
        }
        return expression;
    }

    public void placeNode(Node node) {
        this.assignmentNodes.add(node);
    }

    public void placeNodeOnTree(ParseTree parseTree) {
        parseTree.setSetNode(this);
    }
}

