/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.parsing;

import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.expressions.ExpressionMath;
import oracle.toplink.internal.parsing.ArithmeticFunctionNode;
import oracle.toplink.internal.parsing.GenerationContext;
import oracle.toplink.internal.parsing.IntegerLiteralNode;
import oracle.toplink.internal.parsing.Node;

public class ModNode
extends ArithmeticFunctionNode {
    private Object denominator = null;

    public boolean isComplete() {
        return this.getLeft() != null && this.getDenominator() != null;
    }

    public Expression generateExpression(GenerationContext generationContext) {
        Expression expression;
        Integer n = new Integer(((IntegerLiteralNode)this.getDenominator()).getLiteral().toString());
        if (this.getLeft().isLiteralNode()) {
            ExpressionBuilder expressionBuilder = new ExpressionBuilder();
            Integer n2 = new Integer(((IntegerLiteralNode)this.getLeft()).getLiteral().toString());
            expression = ExpressionMath.mod(expressionBuilder.value(n2), expressionBuilder.value(n));
        } else {
            expression = ExpressionMath.mod(this.getLeft().generateExpression(generationContext), n);
        }
        return expression;
    }

    public void placeNode(Node node) {
        if (this.getLeft() == null) {
            this.setLeft(node);
        } else if (this.getDenominator() == null) {
            this.setDenominator(node);
        } else {
            node.placeNode(this);
        }
    }

    public Object getDenominator() {
        return this.denominator;
    }

    public void setDenominator(Object object) {
        this.denominator = object;
    }
}

