/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ox.record;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import oracle.toplink.exceptions.XMLMarshalException;
import oracle.toplink.internal.ox.XMLObjectBuilder;
import oracle.toplink.internal.ox.XPathFragment;
import oracle.toplink.internal.ox.record.PlatformUnmarshaller;
import oracle.toplink.ox.XMLContext;
import oracle.toplink.ox.XMLDescriptor;
import oracle.toplink.ox.XMLUnmarshaller;
import oracle.toplink.ox.record.DOMRecord;
import oracle.toplink.platform.xml.XMLParser;
import oracle.toplink.platform.xml.XMLPlatformException;
import oracle.toplink.platform.xml.XMLPlatformFactory;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.sessions.DatabaseSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class DOMUnmarshaller
implements PlatformUnmarshaller {
    private XMLParser parser = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLParser();
    private XMLContext xmlContext;

    public DOMUnmarshaller(XMLContext xMLContext) {
        this.parser.setNamespaceAware(true);
        this.parser.setValidationMode(0);
        this.xmlContext = xMLContext;
    }

    public EntityResolver getEntityResolver() {
        return this.parser.getEntityResolver();
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.parser.setEntityResolver(entityResolver);
    }

    public ErrorHandler getErrorHandler() {
        return this.parser.getErrorHandler();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.parser.setErrorHandler(errorHandler);
    }

    public int getValidationMode() {
        return this.parser.getValidationMode();
    }

    public void setValidationMode(int n) {
        this.parser.setValidationMode(n);
    }

    public void setWhitespacePreserving(boolean bl) {
        this.parser.setWhitespacePreserving(bl);
    }

    public void setSchemas(Object[] objectArray) {
        try {
            this.parser.setXMLSchemas(objectArray);
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.errorSettingSchemas(xMLPlatformException, objectArray);
        }
    }

    public Object unmarshal(File file, XMLUnmarshaller xMLUnmarshaller) {
        try {
            Document document = null;
            document = this.parser.parse(file);
            return this.xmlToObject(new DOMRecord(document), xMLUnmarshaller);
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.unmarshalException(xMLPlatformException);
        }
    }

    public Object unmarshal(File file, Class clazz, XMLUnmarshaller xMLUnmarshaller) {
        try {
            Document document = null;
            document = this.parser.parse(file);
            return this.xmlToObject(new DOMRecord(document), clazz, xMLUnmarshaller);
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.unmarshalException(xMLPlatformException);
        }
    }

    public Object unmarshal(InputStream inputStream, XMLUnmarshaller xMLUnmarshaller) {
        try {
            Document document = null;
            document = this.parser.parse(inputStream);
            return this.xmlToObject(new DOMRecord(document), xMLUnmarshaller);
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.unmarshalException(xMLPlatformException);
        }
    }

    public Object unmarshal(InputStream inputStream, Class clazz, XMLUnmarshaller xMLUnmarshaller) {
        try {
            Document document = null;
            document = this.parser.parse(inputStream);
            return this.xmlToObject(new DOMRecord(document), clazz, xMLUnmarshaller);
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.unmarshalException(xMLPlatformException);
        }
    }

    public Object unmarshal(InputSource inputSource, XMLUnmarshaller xMLUnmarshaller) {
        try {
            Document document = null;
            document = this.parser.parse(inputSource);
            return this.xmlToObject(new DOMRecord(document), xMLUnmarshaller);
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.unmarshalException(xMLPlatformException);
        }
    }

    public Object unmarshal(InputSource inputSource, Class clazz, XMLUnmarshaller xMLUnmarshaller) {
        try {
            Document document = null;
            document = this.parser.parse(inputSource);
            return this.xmlToObject(new DOMRecord(document), clazz, xMLUnmarshaller);
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.unmarshalException(xMLPlatformException);
        }
    }

    public Object unmarshal(Node node, XMLUnmarshaller xMLUnmarshaller) {
        Element element = null;
        switch (node.getNodeType()) {
            case 9: {
                element = ((Document)node).getDocumentElement();
                break;
            }
            case 1: {
                element = (Element)node;
                break;
            }
            default: {
                throw XMLMarshalException.unmarshalException();
            }
        }
        return this.xmlToObject(new DOMRecord(element), xMLUnmarshaller);
    }

    public Object unmarshal(Node node, Class clazz, XMLUnmarshaller xMLUnmarshaller) {
        Element element = null;
        switch (node.getNodeType()) {
            case 9: {
                element = ((Document)node).getDocumentElement();
                break;
            }
            case 1: {
                element = (Element)node;
                break;
            }
            default: {
                throw XMLMarshalException.unmarshalException();
            }
        }
        return this.xmlToObject(new DOMRecord(element), clazz, xMLUnmarshaller);
    }

    public Object unmarshal(Reader reader, XMLUnmarshaller xMLUnmarshaller) {
        try {
            Document document = null;
            document = this.parser.parse(reader);
            return this.xmlToObject(new DOMRecord(document), xMLUnmarshaller);
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.unmarshalException(xMLPlatformException);
        }
    }

    public Object unmarshal(Reader reader, Class clazz, XMLUnmarshaller xMLUnmarshaller) {
        try {
            Document document = null;
            document = this.parser.parse(reader);
            return this.xmlToObject(new DOMRecord(document), clazz, xMLUnmarshaller);
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.unmarshalException(xMLPlatformException);
        }
    }

    public Object unmarshal(Source source, XMLUnmarshaller xMLUnmarshaller) {
        try {
            Document document = null;
            document = this.parser.parse(source);
            return this.xmlToObject(new DOMRecord(document), xMLUnmarshaller);
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.unmarshalException(xMLPlatformException);
        }
    }

    public Object unmarshal(Source source, Class clazz, XMLUnmarshaller xMLUnmarshaller) {
        try {
            Document document = null;
            document = this.parser.parse(source);
            return this.xmlToObject(new DOMRecord(document), clazz, xMLUnmarshaller);
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.unmarshalException(xMLPlatformException);
        }
    }

    public Object unmarshal(URL uRL, XMLUnmarshaller xMLUnmarshaller) {
        try {
            Document document = null;
            document = this.parser.parse(uRL);
            return this.xmlToObject(new DOMRecord(document), xMLUnmarshaller);
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.unmarshalException(xMLPlatformException);
        }
    }

    public Object unmarshal(URL uRL, Class clazz, XMLUnmarshaller xMLUnmarshaller) {
        try {
            Document document = null;
            document = this.parser.parse(uRL);
            return this.xmlToObject(new DOMRecord(document), clazz, xMLUnmarshaller);
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.unmarshalException(xMLPlatformException);
        }
    }

    protected XMLDescriptor getDescriptor(DOMRecord dOMRecord) throws XMLMarshalException {
        QName qName = new QName(dOMRecord.getNamespaceURI(), dOMRecord.getLocalName());
        XMLDescriptor xMLDescriptor = this.xmlContext.getDescriptor(qName);
        if (null == xMLDescriptor) {
            String string = dOMRecord.getDOM().getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (null != string) {
                XPathFragment xPathFragment = new XPathFragment(string);
                String string2 = dOMRecord.resolveNamespacePrefix(xPathFragment.getPrefix());
                xPathFragment.setNamespaceURI(string2);
                xMLDescriptor = this.xmlContext.getDescriptorByGlobalType(xPathFragment);
            }
            if (null == xMLDescriptor) {
                throw XMLMarshalException.noDescriptorWithMatchingRootElement(qName.toString());
            }
        }
        return xMLDescriptor;
    }

    public Object xmlToObject(DOMRecord dOMRecord, XMLUnmarshaller xMLUnmarshaller) throws XMLMarshalException {
        XMLDescriptor xMLDescriptor = this.getDescriptor(dOMRecord);
        return this.xmlToObject(dOMRecord, xMLDescriptor.getJavaClass(), xMLUnmarshaller);
    }

    public Object xmlToObject(DOMRecord dOMRecord, Class clazz, XMLUnmarshaller xMLUnmarshaller) throws XMLMarshalException {
        DatabaseSession databaseSession = this.xmlContext.getSession(clazz);
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setReferenceClass(clazz);
        readObjectQuery.setSession((Session)((Object)databaseSession));
        XMLDescriptor xMLDescriptor = (XMLDescriptor)databaseSession.getDescriptor(clazz);
        if (xMLDescriptor == null) {
            throw XMLMarshalException.descriptorNotFoundInProject(clazz.getName());
        }
        dOMRecord.setUnmarshaller(xMLUnmarshaller);
        XMLObjectBuilder xMLObjectBuilder = (XMLObjectBuilder)xMLDescriptor.getObjectBuilder();
        Object object = xMLObjectBuilder.buildObject(readObjectQuery, dOMRecord);
        return object;
    }
}

