/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ox;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.eis.EISDescriptor;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.internal.descriptors.ObjectBuilder;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.identitymaps.CacheKey;
import oracle.toplink.internal.ox.WeakObjectWrapper;
import oracle.toplink.internal.ox.XPathEngine;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.ox.NamespaceResolver;
import oracle.toplink.ox.XMLDescriptor;
import oracle.toplink.ox.XMLField;
import oracle.toplink.ox.XMLMarshaller;
import oracle.toplink.ox.XMLUnmarshaller;
import oracle.toplink.ox.record.DOMRecord;
import oracle.toplink.ox.record.XMLRecord;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLObjectBuilder
extends ObjectBuilder {
    public XMLObjectBuilder(Descriptor descriptor) {
        super(descriptor);
    }

    public DatabaseRow buildRow(Object object, Session session, DatabaseField databaseField, XMLRecord xMLRecord) {
        Cloneable cloneable;
        Vector vector;
        if (this.getDescriptor() instanceof XMLDescriptor && ((XMLDescriptor)this.getDescriptor()).shouldPreserveDocument()) {
            vector = this.extractPrimaryKeyFromObject(object, session);
            if (vector == null || vector.size() == 0) {
                vector = new Vector();
                vector.addElement(new WeakObjectWrapper(object));
            }
            if ((cloneable = session.getIdentityMapAccessorInstance().getCacheKeyForObject(vector, this.getDescriptor().getJavaClass(), this.getDescriptor())) != null && ((CacheKey)cloneable).getRecord() != null) {
                XMLRecord xMLRecord2 = (XMLRecord)((CacheKey)cloneable).getRecord();
                xMLRecord2.setMarshaller(xMLRecord.getMarshaller());
                return this.buildIntoNestedRow((DatabaseRow)((CacheKey)cloneable).getRecord(), object, session);
            }
        }
        vector = XPathEngine.getInstance().createUnownedElement(xMLRecord.getDOM(), (XMLField)databaseField);
        cloneable = new DOMRecord((Element)((Object)vector));
        ((XMLRecord)cloneable).setMarshaller(xMLRecord.getMarshaller());
        return this.buildIntoNestedRow((DatabaseRow)cloneable, object, session);
    }

    public DatabaseRow createRecord() {
        return this.createRecord(this.getDescriptor().getTableName());
    }

    public DatabaseRow createRecord(String string) {
        NamespaceResolver namespaceResolver = this.getNamespaceResolver();
        return new DOMRecord(string, namespaceResolver);
    }

    public DatabaseRow createRecord(String string, Node node) {
        NamespaceResolver namespaceResolver = this.getNamespaceResolver();
        return new DOMRecord(string, namespaceResolver, node);
    }

    public DatabaseRow createRecord(int n) {
        return this.createRecord(this.getDescriptor().getTableName());
    }

    public Object buildObject(ObjectLevelReadQuery objectLevelReadQuery, DatabaseRow databaseRow) throws DatabaseException, QueryException {
        Serializable serializable;
        boolean bl = this.getDescriptor() instanceof XMLDescriptor;
        XMLRecord xMLRecord = (XMLRecord)databaseRow;
        XMLUnmarshaller xMLUnmarshaller = xMLRecord.getUnmarshaller();
        Vector<WeakObjectWrapper> vector = this.extractPrimaryKeyFromRow(databaseRow, objectLevelReadQuery.getSession());
        if (!(bl || this.getDescriptor().isAggregateDescriptor() || this.getDescriptor().isAggregateCollectionDescriptor())) {
            return super.buildObject(objectLevelReadQuery, databaseRow);
        }
        objectLevelReadQuery.getSession().startOperationProfile("object building");
        Descriptor descriptor = this.getDescriptor();
        Object object = null;
        if (descriptor.hasInheritance() && descriptor.getInheritancePolicy().shouldReadSubclasses()) {
            serializable = descriptor.getInheritancePolicy().classFromRow(databaseRow, objectLevelReadQuery.getSession());
            descriptor = (XMLDescriptor)objectLevelReadQuery.getSession().getDescriptor((Class)serializable);
            if (descriptor == null && objectLevelReadQuery.hasPartialAttributeExpressions()) {
                descriptor = (XMLDescriptor)this.getDescriptor();
            }
            if (descriptor == null) {
                throw QueryException.noDescriptorForClassFromInheritancePolicy(objectLevelReadQuery, (Class)serializable);
            }
        }
        object = descriptor.getObjectBuilder().buildNewInstance();
        xMLRecord.setCurrentObject(object);
        descriptor.getObjectBuilder().buildAttributesIntoObject(object, databaseRow, objectLevelReadQuery, false);
        if (bl && ((XMLDescriptor)descriptor).shouldPreserveDocument()) {
            if (vector == null || vector.size() == 0) {
                vector = new Vector<WeakObjectWrapper>();
                vector.addElement(new WeakObjectWrapper(object));
            }
            serializable = objectLevelReadQuery.getSession().getIdentityMapAccessorInstance().acquireDeferredLock(vector, descriptor.getJavaClass(), descriptor);
            ((CacheKey)serializable).setRecord(databaseRow);
            ((CacheKey)serializable).setObject(object);
            ((CacheKey)serializable).releaseDeferredLock();
        }
        objectLevelReadQuery.getSession().endOperationProfile("object building");
        return object;
    }

    public DatabaseRow buildRow(DatabaseRow databaseRow, Object object, Session session) {
        Vector vector;
        XMLRecord xMLRecord = (XMLRecord)databaseRow;
        if (this.getDescriptor() instanceof XMLDescriptor && ((XMLDescriptor)this.getDescriptor()).shouldPreserveDocument()) {
            CacheKey cacheKey;
            vector = this.extractPrimaryKeyFromObject(object, session);
            if (vector == null || vector.size() == 0) {
                vector = new Vector();
                vector.addElement(new WeakObjectWrapper(object));
            }
            if ((cacheKey = session.getIdentityMapAccessorInstance().getCacheKeyForObject(vector, object.getClass(), this.getDescriptor())) != null && cacheKey.getRecord() != null) {
                xMLRecord = (XMLRecord)cacheKey.getRecord();
                xMLRecord.setMarshaller(((XMLRecord)databaseRow).getMarshaller());
            }
        }
        vector = this.getDescriptor().getMappings();
        for (int i = 0; i < vector.size(); ++i) {
            DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
            databaseMapping.writeFromObjectIntoRow(object, xMLRecord, session);
        }
        if (this.getDescriptor().hasInheritance()) {
            this.getDescriptor().getInheritancePolicy().addClassIndicatorFieldToRow(xMLRecord);
        }
        if (!this.getDescriptor().isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(xMLRecord);
        }
        this.addNamespaceDeclarations(xMLRecord.getDocument());
        return xMLRecord;
    }

    public void addNamespaceDeclarations(Document document) {
        NamespaceResolver namespaceResolver = this.getNamespaceResolver();
        if (namespaceResolver == null) {
            return;
        }
        Element element = document.getDocumentElement();
        Enumeration enumeration = namespaceResolver.getPrefixes();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = namespaceResolver.resolveNamespacePrefix(string);
            if (string.equals("")) {
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", string2);
                continue;
            }
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string, string2);
        }
    }

    public Vector extractPrimaryKeyFromObject(Object object, Session session) {
        if (this.getDescriptor().hasInheritance() && object.getClass() != this.getDescriptor().getJavaClass() && !object.getClass().getSuperclass().equals(this.getDescriptor().getJavaClass())) {
            return session.getDescriptor(object).getObjectBuilder().extractPrimaryKeyFromObject(object, session);
        }
        if (this.getDescriptor().getPrimaryKeyFields().size() == 0) {
            return null;
        }
        return super.extractPrimaryKeyFromObject(object, session);
    }

    public DatabaseRow buildIntoNestedRow(DatabaseRow databaseRow, Object object, Session session) {
        XMLRecord xMLRecord = (XMLRecord)databaseRow;
        XMLMarshaller xMLMarshaller = xMLRecord.getMarshaller();
        Vector vector = this.getDescriptor().getMappings();
        for (int i = 0; i < vector.size(); ++i) {
            DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
            databaseMapping.writeFromObjectIntoRow(object, databaseRow, session);
        }
        if (this.getDescriptor().hasInheritance()) {
            this.getDescriptor().getInheritancePolicy().addClassIndicatorFieldToRow(databaseRow);
        }
        if (!this.getDescriptor().isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(databaseRow);
        }
        return databaseRow;
    }

    public NamespaceResolver getNamespaceResolver() {
        NamespaceResolver namespaceResolver = null;
        if (this.getDescriptor() instanceof XMLDescriptor) {
            namespaceResolver = ((XMLDescriptor)this.getDescriptor()).getNamespaceResolver();
        } else if (this.getDescriptor() instanceof EISDescriptor) {
            namespaceResolver = ((EISDescriptor)this.getDescriptor()).getNamespaceResolver();
        }
        return namespaceResolver;
    }
}

