/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.indirection;

import java.lang.reflect.Constructor;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.indirection.IndirectContainer;
import oracle.toplink.indirection.ValueHolder;
import oracle.toplink.indirection.ValueHolderInterface;
import oracle.toplink.internal.descriptors.DescriptorIterator;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.indirection.BasicIndirectionPolicy;
import oracle.toplink.internal.indirection.DatabaseValueHolder;
import oracle.toplink.internal.indirection.UnitOfWorkValueHolder;
import oracle.toplink.internal.remote.RemoteSessionController;
import oracle.toplink.internal.remote.RemoteUnitOfWork;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadQuery;

public class ContainerIndirectionPolicy
extends BasicIndirectionPolicy {
    private Class containerClass;
    private String containerClassName;
    private Constructor containerConstructor;

    public Object backupCloneAttribute(Object object, Object object2, Object object3, UnitOfWork unitOfWork) {
        IndirectContainer indirectContainer = (IndirectContainer)object;
        ValueHolderInterface valueHolderInterface = indirectContainer.getValueHolder();
        ValueHolderInterface valueHolderInterface2 = (ValueHolderInterface)super.backupCloneAttribute(valueHolderInterface, object2, object3, unitOfWork);
        return this.buildContainer(valueHolderInterface2);
    }

    protected IndirectContainer buildContainer(ValueHolderInterface valueHolderInterface) {
        try {
            IndirectContainer indirectContainer = null;
            if (this.getContainerConstructor().getParameterTypes().length == 0) {
                indirectContainer = (IndirectContainer)PrivilegedAccessController.invokeConstructor(this.getContainerConstructor(), new Object[0]);
                indirectContainer.setValueHolder(valueHolderInterface);
            } else {
                indirectContainer = (IndirectContainer)PrivilegedAccessController.invokeConstructor(this.getContainerConstructor(), new Object[]{valueHolderInterface});
            }
            return indirectContainer;
        }
        catch (Exception exception) {
            throw DescriptorException.invalidIndirectionPolicyOperation(this, "buildContainer constructor (" + this.getContainerConstructor() + ") Failed: " + exception);
        }
    }

    public Object cloneAttribute(Object object, Object object2, Object object3, UnitOfWork unitOfWork, boolean bl) {
        IndirectContainer indirectContainer = (IndirectContainer)object;
        ValueHolderInterface valueHolderInterface = indirectContainer.getValueHolder();
        ValueHolderInterface valueHolderInterface2 = (ValueHolderInterface)super.cloneAttribute(valueHolderInterface, object2, object3, unitOfWork, bl);
        return this.buildContainer(valueHolderInterface2);
    }

    public DatabaseRow extractReferenceRow(Object object) {
        if (this.objectIsInstantiated(object)) {
            return null;
        }
        return ((DatabaseValueHolder)((IndirectContainer)object).getValueHolder()).getRow();
    }

    public Class getContainerClass() {
        return this.containerClass;
    }

    public String getContainerClassName() {
        if (this.containerClassName == null && this.containerClass != null) {
            this.containerClassName = this.containerClass.getName();
        }
        return this.containerClassName;
    }

    protected Constructor getContainerConstructor() {
        return this.containerConstructor;
    }

    public Object getOriginalIndirectionObject(Object object, Session session) {
        IndirectContainer indirectContainer = (IndirectContainer)object;
        if (indirectContainer.getValueHolder() instanceof UnitOfWorkValueHolder) {
            ValueHolderInterface valueHolderInterface = ((UnitOfWorkValueHolder)indirectContainer.getValueHolder()).getWrappedValueHolder();
            if (valueHolderInterface == null && session.isRemoteUnitOfWork()) {
                RemoteSessionController remoteSessionController = ((RemoteUnitOfWork)session).getParentSessionController();
                valueHolderInterface = (ValueHolderInterface)remoteSessionController.getRemoteValueHolders().get(((UnitOfWorkValueHolder)indirectContainer.getValueHolder()).getWrappedValueHolderRemoteID());
            }
            return this.buildContainer(valueHolderInterface);
        }
        return indirectContainer;
    }

    public Object getRealAttributeValueFromObject(Object object) {
        return ((IndirectContainer)object).getValueHolder().getValue();
    }

    public void initialize() {
        if (!ClassConstants.IndirectContainer_Class.isAssignableFrom(this.containerClass)) {
            throw DescriptorException.invalidIndirectionContainerClass(this, this.containerClass);
        }
        try {
            this.containerConstructor = PrivilegedAccessController.getConstructorFor(this.getContainerClass(), new Class[]{ClassConstants.ValueHolderInterface_Class}, false);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                this.containerConstructor = PrivilegedAccessController.getConstructorFor(this.getContainerClass(), new Class[0], false);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw DescriptorException.noConstructorIndirectionContainerClass(this, this.containerClass);
            }
        }
    }

    public void iterateOnAttributeValue(DescriptorIterator descriptorIterator, Object object) {
        super.iterateOnAttributeValue(descriptorIterator, ((IndirectContainer)object).getValueHolder());
    }

    public Object nullValueFromRow() {
        return this.buildContainer(new ValueHolder());
    }

    public boolean objectIsInstantiated(Object object) {
        return ((IndirectContainer)object).getValueHolder().isInstantiated();
    }

    public void setContainerClass(Class clazz) {
        this.containerClass = clazz;
    }

    public void setContainterClassName(String string) {
        this.containerClassName = string;
    }

    public void setRealAttributeValueInObject(Object object, Object object2) {
        IndirectContainer indirectContainer = (IndirectContainer)this.getMapping().getAttributeValueFromObject(object);
        indirectContainer.getValueHolder().setValue(object2);
        this.getMapping().setAttributeValueInObject(object, indirectContainer);
    }

    protected boolean typeIsValid(Class clazz) {
        return ClassConstants.IndirectContainer_Class.isAssignableFrom(clazz) || clazz.isAssignableFrom(this.getContainerClass());
    }

    public Object validateAttributeOfInstantiatedObject(Object object) {
        if (!this.getContainerClass().isInstance(object)) {
            throw DescriptorException.valueHolderInstantiationMismatch(object, this.getMapping());
        }
        return object;
    }

    public Object valueFromBatchQuery(ReadQuery readQuery, DatabaseRow databaseRow, ObjectLevelReadQuery objectLevelReadQuery) {
        ValueHolderInterface valueHolderInterface = (ValueHolderInterface)super.valueFromBatchQuery(readQuery, databaseRow, objectLevelReadQuery);
        return this.buildContainer(valueHolderInterface);
    }

    public Object valueFromMethod(Object object, DatabaseRow databaseRow, Session session) {
        ValueHolderInterface valueHolderInterface = (ValueHolderInterface)super.valueFromMethod(object, databaseRow, session);
        return this.buildContainer(valueHolderInterface);
    }

    public Object valueFromQuery(ReadQuery readQuery, DatabaseRow databaseRow, Session session) {
        ValueHolderInterface valueHolderInterface = (ValueHolderInterface)super.valueFromQuery(readQuery, databaseRow, session);
        return this.buildContainer(valueHolderInterface);
    }

    public Object valueFromRow(Object object) {
        return this.buildContainer(new ValueHolder(object));
    }
}

