/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.identitymaps;

import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.internal.identitymaps.CacheKey;
import oracle.toplink.internal.identitymaps.FullIdentityMap;
import oracle.toplink.internal.identitymaps.WeakCacheKey;

public class WeakIdentityMap
extends FullIdentityMap {
    protected int cleanupCount = 0;
    protected int cleanupSize;

    public WeakIdentityMap(int n) {
        super(n);
        this.cleanupSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupDeadCacheKeys() {
        Enumeration enumeration = this.getCacheKeys().elements();
        while (enumeration.hasMoreElements()) {
            CacheKey cacheKey = (CacheKey)enumeration.nextElement();
            if (cacheKey.getObject() != null || !cacheKey.acquireNoWait()) continue;
            try {
                if (cacheKey.getObject() != null) continue;
                this.getCacheKeys().remove(cacheKey);
            }
            finally {
                cacheKey.release();
            }
        }
    }

    public CacheKey createCacheKey(Vector vector, Object object, Object object2, long l) {
        return new WeakCacheKey(vector, object, object2, l);
    }

    protected int getCleanupCount() {
        return this.cleanupCount;
    }

    protected void setCleanupCount(int n) {
        this.cleanupCount = n;
    }

    protected int getCleanupSize() {
        return this.cleanupSize;
    }

    protected void setCleanupSize(int n) {
        this.cleanupSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void put(CacheKey cacheKey) {
        WeakIdentityMap weakIdentityMap = this;
        synchronized (weakIdentityMap) {
            if (this.getCleanupCount() > this.getCleanupSize()) {
                this.cleanupDeadCacheKeys();
                this.setCleanupCount(0);
                if (this.getSize() > this.getCleanupSize()) {
                    this.setCleanupSize(this.getSize());
                }
            }
            this.setCleanupCount(this.getCleanupCount() + 1);
        }
        super.put(cacheKey);
    }
}

