/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.helper;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class NonSynchronizedVector
extends Vector {
    public static NonSynchronizedVector newInstance(int n, int n2) {
        return new NonSynchronizedVector(n, n2);
    }

    public static NonSynchronizedVector newInstance(int n) {
        return new NonSynchronizedVector(n);
    }

    public static NonSynchronizedVector newInstance() {
        return new NonSynchronizedVector();
    }

    public static NonSynchronizedVector newInstance(Collection collection) {
        return new NonSynchronizedVector(collection);
    }

    public NonSynchronizedVector(int n, int n2) {
        super(n, n2);
    }

    public NonSynchronizedVector(int n) {
        super(n);
    }

    public NonSynchronizedVector() {
    }

    public NonSynchronizedVector(Collection collection) {
        super(collection);
    }

    public void copyInto(Object[] objectArray) {
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
    }

    public void trimToSize() {
        ++this.modCount;
        int n = this.elementData.length;
        if (this.elementCount < n) {
            Object[] objectArray = this.elementData;
            this.elementData = new Object[this.elementCount];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public void ensureCapacity(int n) {
        ++this.modCount;
        this.ensureCapacityHelper(n);
    }

    private void ensureCapacityHelper(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            int n3;
            Object[] objectArray = this.elementData;
            int n4 = n3 = this.capacityIncrement > 0 ? n2 + this.capacityIncrement : n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = new Object[n3];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public void setSize(int n) {
        ++this.modCount;
        if (n > this.elementCount) {
            this.ensureCapacityHelper(n);
        } else {
            for (int i = n; i < this.elementCount; ++i) {
                this.elementData[i] = null;
            }
        }
        this.elementCount = n;
    }

    public int capacity() {
        return this.elementData.length;
    }

    public int size() {
        return this.elementCount;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Enumeration elements() {
        return new Enumeration(){
            int count = 0;

            public boolean hasMoreElements() {
                return this.count < NonSynchronizedVector.this.elementCount;
            }

            public Object nextElement() {
                if (this.count < NonSynchronizedVector.this.elementCount) {
                    return NonSynchronizedVector.this.elementData[this.count++];
                }
                throw new NoSuchElementException("Vector Enumeration");
            }
        };
    }

    public int indexOf(Object object, int n) {
        if (object == null) {
            for (int i = n; i < this.elementCount; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n; i < this.elementCount; ++i) {
                if (!object.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.elementCount - 1);
    }

    public int lastIndexOf(Object object, int n) {
        if (n >= this.elementCount) {
            throw new IndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        if (object == null) {
            for (int i = n; i >= 0; --i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n; i >= 0; --i) {
                if (!object.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        return this.elementData[n];
    }

    public Object firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public Object lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public void setElementAt(Object object, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        this.elementData[n] = object;
    }

    public void removeElementAt(int n) {
        ++this.modCount;
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public void insertElementAt(Object object, int n) {
        ++this.modCount;
        if (n > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this.elementCount);
        }
        this.ensureCapacityHelper(this.elementCount + 1);
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        this.elementData[n] = object;
        ++this.elementCount;
    }

    public void addElement(Object object) {
        ++this.modCount;
        this.ensureCapacityHelper(this.elementCount + 1);
        this.elementData[this.elementCount++] = object;
    }

    public boolean removeElement(Object object) {
        ++this.modCount;
        int n = this.indexOf(object);
        if (n >= 0) {
            this.removeElementAt(n);
            return true;
        }
        return false;
    }

    public void removeAllElements() {
        ++this.modCount;
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.elementCount];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.elementCount) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.elementCount);
        }
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        if (objectArray.length > this.elementCount) {
            objectArray[this.elementCount] = null;
        }
        return objectArray;
    }

    public Object get(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.elementData[n];
    }

    public Object set(int n, Object object) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        Object object2 = this.elementData[n];
        this.elementData[n] = object;
        return object2;
    }

    public boolean add(Object object) {
        ++this.modCount;
        this.ensureCapacityHelper(this.elementCount + 1);
        this.elementData[this.elementCount++] = object;
        return true;
    }

    public Object remove(int n) {
        ++this.modCount;
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        Object object = this.elementData[n];
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.elementCount] = null;
        return object;
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection collection) {
        ++this.modCount;
        Object[] objectArray = collection.toArray();
        int n = objectArray.length;
        this.ensureCapacityHelper(this.elementCount + n);
        System.arraycopy(objectArray, 0, this.elementData, this.elementCount, n);
        this.elementCount += n;
        return n != 0;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public boolean addAll(int n, Collection collection) {
        ++this.modCount;
        if (n < 0 || n > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        this.ensureCapacityHelper(this.elementCount + n2);
        int n3 = this.elementCount - n;
        if (n3 > 0) {
            System.arraycopy(this.elementData, n, this.elementData, n + n2, n3);
        }
        System.arraycopy(objectArray, 0, this.elementData, n, n2);
        this.elementCount += n2;
        return n2 != 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        ListIterator listIterator = this.listIterator();
        ListIterator listIterator2 = ((List)object).listIterator();
        while (listIterator.hasNext() && listIterator2.hasNext()) {
            Object e = listIterator.next();
            Object e2 = listIterator2.next();
            if (e != null ? e.equals(e2) : e2 == null) continue;
            return false;
        }
        return !listIterator.hasNext() && !listIterator2.hasNext();
    }

    public int hashCode() {
        int n = 1;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            n = 31 * n + (e == null ? 0 : e.hashCode());
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.iterator();
        stringBuffer.append("[");
        int n = this.size() - 1;
        for (int i = 0; i <= n; ++i) {
            stringBuffer.append(String.valueOf(iterator.next()));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected void removeRange(int n, int n2) {
        ++this.modCount;
        int n3 = this.elementCount - n2;
        System.arraycopy(this.elementData, n2, this.elementData, n, n3);
        int n4 = this.elementCount - (n2 - n);
        while (this.elementCount != n4) {
            this.elementData[--this.elementCount] = null;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }
}

