/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.expressions;

import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.expressions.ExpressionOperator;
import oracle.toplink.internal.expressions.CompoundExpression;
import oracle.toplink.internal.expressions.ConstantExpression;
import oracle.toplink.internal.expressions.ExpressionJavaPrinter;
import oracle.toplink.internal.expressions.ExpressionNormalizer;
import oracle.toplink.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.internal.expressions.FieldExpression;
import oracle.toplink.internal.expressions.ObjectExpression;
import oracle.toplink.internal.expressions.ParameterExpression;
import oracle.toplink.internal.expressions.QueryKeyExpression;
import oracle.toplink.internal.expressions.TableAliasLookup;
import oracle.toplink.internal.expressions.TableExpression;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.identitymaps.CacheKey;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.InMemoryQueryIndirectionPolicy;

public class RelationExpression
extends CompoundExpression {
    protected boolean allChildrenAreFields() {
        return this.getFirstChild().getFields().size() == 1 && this.getSecondChild().getFields().size() == 1;
    }

    protected void convertNodeToUseOuterJoin() {
        if (this.getOperator().getSelector() == 4 && this.allChildrenAreFields()) {
            this.setOperator(this.getOperator(6));
        }
    }

    public String descriptionOfNodeType() {
        return "Relation";
    }

    public boolean doesConform(Object object, Session session, DatabaseRow databaseRow, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy, boolean bl) {
        Object object2 = this.getSecondChild().valueFromObject(object, session, databaseRow, inMemoryQueryIndirectionPolicy, bl);
        Object object3 = this.getFirstChild().valueFromObject(object, session, databaseRow, inMemoryQueryIndirectionPolicy, bl);
        if (object2 instanceof Vector) {
            if (this.getOperator().getSelector() == 13 || this.getOperator().getSelector() == 14) {
                if (this.isObjectComparison()) {
                    throw QueryException.cannotConformExpression();
                }
                if (object3 instanceof Vector) {
                    return this.doesAnyOfLeftValuesConform((Vector)object3, object2, session);
                }
                return this.getOperator().doesRelationConform(object3, object2);
            }
            Enumeration enumeration = ((Vector)object2).elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (object3 instanceof Vector && this.doesAnyOfLeftValuesConform((Vector)object3, e, session)) {
                    return true;
                }
                if (!this.doValuesConform(object3, e, session)) continue;
                return true;
            }
            return false;
        }
        if (object3 instanceof Vector) {
            return this.doesAnyOfLeftValuesConform((Vector)object3, object2, session);
        }
        return this.doValuesConform(object3, object2, session);
    }

    protected boolean doesAnyOfLeftValuesConform(Vector vector, Object object, Session session) {
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.get(i);
            if (!this.doValuesConform(e, object, session)) continue;
            return true;
        }
        return false;
    }

    protected boolean doValuesConform(Object object, Object object2, Session session) {
        if (this.isObjectComparison()) {
            return this.doesObjectConform(object, object2, session);
        }
        return this.getOperator().doesRelationConform(object, object2);
    }

    public boolean doesObjectConform(Object object, Object object2, Session session) {
        if (object == null && object2 == null) {
            return this.performSelector(true);
        }
        if (object == null || object2 == null) {
            return this.performSelector(false);
        }
        Class<?> clazz = object.getClass();
        if (clazz != object2.getClass()) {
            return this.performSelector(false);
        }
        Descriptor descriptor = session.getDescriptor(clazz);
        if (descriptor.isAggregateDescriptor()) {
            throw QueryException.cannotConformExpression();
        }
        Vector vector = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, session);
        Vector vector2 = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object2, session);
        CacheKey cacheKey = new CacheKey(vector2);
        CacheKey cacheKey2 = new CacheKey(vector);
        return this.performSelector(cacheKey.equals(cacheKey2));
    }

    public boolean extractPrimaryKeyValues(boolean bl, Descriptor descriptor, DatabaseRow databaseRow, DatabaseRow databaseRow2) {
        if (bl && this.getOperator().getSelector() != 4) {
            return false;
        }
        if (!bl && this.getOperator().getSelector() == 13) {
            return false;
        }
        DatabaseField databaseField = null;
        Object object = null;
        if (this.getSecondChild().isConstantExpression()) {
            object = ((ConstantExpression)this.getSecondChild()).getValue();
        } else if (this.getSecondChild().isParameterExpression()) {
            object = databaseRow2.get(((ParameterExpression)this.getSecondChild()).getField());
        } else if (this.getFirstChild().isConstantExpression()) {
            object = ((ConstantExpression)this.getFirstChild()).getValue();
        } else if (this.getFirstChild().isParameterExpression()) {
            object = databaseRow2.get(((ParameterExpression)this.getFirstChild()).getField());
        }
        if (object == null) {
            return false;
        }
        if (this.getFirstChild().isFieldExpression()) {
            if (this.getFirstChild().getBuilder() != ((FieldExpression)this.getFirstChild()).getBaseExpression()) {
                return false;
            }
            databaseField = ((FieldExpression)this.getFirstChild()).getField();
        } else if (this.getFirstChild().isQueryKeyExpression()) {
            DatabaseMapping databaseMapping = descriptor.getMappingForAttributeName(((QueryKeyExpression)this.getFirstChild()).getName());
            if (this.getFirstChild().getBuilder() != ((QueryKeyExpression)this.getFirstChild()).getBaseExpression()) {
                return false;
            }
            if (databaseMapping != null && !databaseMapping.isPrimaryKeyMapping()) {
                return false;
            }
            if (databaseMapping != null && (databaseMapping.isObjectReferenceMapping() || databaseMapping.isAggregateObjectMapping())) {
                databaseMapping.writeFromAttributeIntoRow(object, databaseRow, this.getSession());
                return true;
            }
            if (databaseMapping != null && !databaseMapping.isDirectToFieldMapping()) {
                return false;
            }
            databaseField = descriptor.getObjectBuilder().getFieldForQueryKeyName(this.getFirstChild().getName());
        } else if (this.getSecondChild().isFieldExpression()) {
            if (this.getFirstChild().getBuilder() != ((FieldExpression)this.getSecondChild()).getBaseExpression()) {
                return false;
            }
            databaseField = ((FieldExpression)this.getSecondChild()).getField();
        } else if (this.getSecondChild().isQueryKeyExpression()) {
            DatabaseMapping databaseMapping = descriptor.getMappingForAttributeName(((QueryKeyExpression)this.getSecondChild()).getName());
            if (this.getSecondChild().getBuilder() != ((QueryKeyExpression)this.getSecondChild()).getBaseExpression()) {
                return false;
            }
            if (databaseMapping != null && !databaseMapping.isPrimaryKeyMapping()) {
                return false;
            }
            if (databaseMapping != null && (databaseMapping.isObjectReferenceMapping() || databaseMapping.isAggregateObjectMapping())) {
                databaseMapping.writeFromAttributeIntoRow(object, databaseRow, this.getSession());
                return true;
            }
            if (databaseMapping != null && !databaseMapping.isDirectToFieldMapping()) {
                return false;
            }
            databaseField = descriptor.getObjectBuilder().getFieldForQueryKeyName(this.getSecondChild().getName());
        } else {
            return false;
        }
        if (databaseField == null || !descriptor.getPrimaryKeyFields().contains(databaseField)) {
            return false;
        }
        databaseRow.put(databaseField, object);
        return true;
    }

    public boolean isEqualNull(ExpressionSQLPrinter expressionSQLPrinter) {
        if (this.isObjectComparison()) {
            return false;
        }
        if (this.getOperator().getSelector() != 4) {
            return false;
        }
        if (this.getSecondChild().isConstantExpression() && ((ConstantExpression)this.getSecondChild()).getValue() == null) {
            return true;
        }
        return this.getSecondChild().isParameterExpression() && expressionSQLPrinter.getTranslationRow() != null && ((ParameterExpression)this.getSecondChild()).getValue(expressionSQLPrinter.getTranslationRow(), expressionSQLPrinter.getSession()) == null;
    }

    public boolean isNotEqualNull(ExpressionSQLPrinter expressionSQLPrinter) {
        if (this.isObjectComparison()) {
            return false;
        }
        if (this.getOperator().getSelector() != 5) {
            return false;
        }
        if (this.getSecondChild().isConstantExpression() && ((ConstantExpression)this.getSecondChild()).getValue() == null) {
            return true;
        }
        return this.getSecondChild().isParameterExpression() && expressionSQLPrinter.getTranslationRow() != null && ((ParameterExpression)this.getSecondChild()).getValue(expressionSQLPrinter.getTranslationRow(), expressionSQLPrinter.getSession()) == null;
    }

    protected boolean isObjectComparison() {
        if (!this.getFirstChild().isObjectExpression() || ((ObjectExpression)this.getFirstChild()).isAttribute()) {
            return false;
        }
        DatabaseMapping databaseMapping = ((ObjectExpression)this.getFirstChild()).getMapping();
        if (databaseMapping != null && databaseMapping.isDirectCollectionMapping()) {
            return false;
        }
        return this.getSecondChild().isObjectExpression() || this.getSecondChild().isValueExpression();
    }

    public boolean isRelationExpression() {
        return true;
    }

    public Expression normalize(ExpressionNormalizer expressionNormalizer) {
        Object object;
        if (!this.isObjectComparison()) {
            return super.normalize(expressionNormalizer);
        }
        this.validateNode();
        if (this.getOperator().getSelector() != 4 && this.getOperator().getSelector() != 5) {
            throw QueryException.invalidOperatorForObjectComparison(this);
        }
        Expression expression = null;
        ObjectExpression objectExpression = (ObjectExpression)this.getFirstChild();
        if (objectExpression.isExpressionBuilder() && this.getSecondChild().isQueryKeyExpression() && !((QueryKeyExpression)this.getSecondChild()).hasDerivedExpressions()) {
            objectExpression = (ExpressionBuilder)objectExpression.normalize(expressionNormalizer);
            object = new Vector(1);
            QueryKeyExpression queryKeyExpression = (QueryKeyExpression)this.getSecondChild();
            if (queryKeyExpression.hasBeenNormalized()) {
                queryKeyExpression.setHasBeenNormalized(false);
            }
            queryKeyExpression = (QueryKeyExpression)queryKeyExpression.normalize(expressionNormalizer, (Vector)object);
            if (!((Vector)object).isEmpty()) {
                expression = (Expression)((Vector)object).firstElement();
                if (objectExpression.getTableAliases() == null) {
                    TableAliasLookup tableAliasLookup = new TableAliasLookup();
                    objectExpression.setTableAliases(tableAliasLookup);
                    queryKeyExpression.setTableAliases(tableAliasLookup);
                } else {
                    queryKeyExpression.setTableAliases(objectExpression.getTableAliases());
                }
            }
        } else if (!objectExpression.isExpressionBuilder() && !((QueryKeyExpression)objectExpression).shouldQueryToManyRelationship() && ((QueryKeyExpression)objectExpression).getMapping() != null) {
            if (objectExpression.getBaseExpression() != null) {
                objectExpression.setBaseExpression(objectExpression.getBaseExpression().normalize(expressionNormalizer));
            }
            if (this.getSecondChild().isConstantExpression()) {
                object = ((ConstantExpression)this.getSecondChild()).getValue();
                expression = objectExpression.getMapping().buildObjectJoinExpression((Expression)objectExpression, object, this.getSession());
            } else if (this.getSecondChild().isObjectExpression() || this.getSecondChild().isParameterExpression()) {
                expression = objectExpression.getMapping().buildObjectJoinExpression((Expression)objectExpression, this.getSecondChild(), this.getSession());
            } else {
                throw QueryException.invalidUseOfToManyQueryKeyInExpression(this);
            }
        }
        if (expression == null) {
            objectExpression = (ObjectExpression)objectExpression.normalize(expressionNormalizer);
            if (this.getSecondChild().isConstantExpression()) {
                object = objectExpression.getDescriptor().getObjectBuilder().buildPrimaryKeyExpressionFromObject(((ConstantExpression)this.getSecondChild()).getValue(), this.getSession());
                expression = objectExpression.twist((Expression)object, objectExpression);
            } else if (this.getSecondChild().isObjectExpression() || this.getSecondChild().isParameterExpression()) {
                expression = objectExpression.twist(objectExpression.getDescriptor().getObjectBuilder().getPrimaryKeyExpression(), this.getSecondChild());
            } else {
                throw QueryException.invalidUseOfToManyQueryKeyInExpression(this);
            }
        }
        if (this.getOperator().getSelector() == 5) {
            expression = expression.not();
        }
        return expression.normalize(expressionNormalizer);
    }

    public boolean performSelector(boolean bl) {
        int n = this.getOperator().getSelector();
        this.getOperator();
        if (n == 4) {
            return bl;
        }
        int n2 = this.getOperator().getSelector();
        this.getOperator();
        if (n2 == 5) {
            return !bl;
        }
        throw QueryException.cannotConformExpression();
    }

    public void printSQL(ExpressionSQLPrinter expressionSQLPrinter) {
        if (this.isEqualNull(expressionSQLPrinter)) {
            this.getFirstChild().isNull().printSQL(expressionSQLPrinter);
        } else if (this.isNotEqualNull(expressionSQLPrinter)) {
            this.getFirstChild().notNull().printSQL(expressionSQLPrinter);
        } else {
            super.printSQL(expressionSQLPrinter);
        }
    }

    public void printJava(ExpressionJavaPrinter expressionJavaPrinter) {
        ExpressionOperator expressionOperator = this.getPlatformOperator(expressionJavaPrinter.getPlatform());
        Expression expression = this.getFirstChild();
        Expression expression2 = this.getSecondChild();
        expressionOperator.printJavaDuo(expression, expression2, expressionJavaPrinter);
    }

    public void printSQLNoParens(ExpressionSQLPrinter expressionSQLPrinter) {
        ExpressionOperator expressionOperator = this.getPlatformOperator(expressionSQLPrinter.getPlatform());
        expressionOperator.printDuo(this.getFirstChild(), this.getSecondChild(), expressionSQLPrinter);
    }

    public void validateNode() {
        if (this.getFirstChild().isTableExpression()) {
            throw QueryException.cannotCompareTablesInExpression(((TableExpression)this.getFirstChild()).getTable());
        }
        if (this.getSecondChild().isTableExpression()) {
            throw QueryException.cannotCompareTablesInExpression(((TableExpression)this.getSecondChild()).getTable());
        }
    }
}

