/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Vector;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.expressions.ExpressionOperator;
import oracle.toplink.history.AsOfClause;
import oracle.toplink.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.internal.expressions.ExpressionIterator;
import oracle.toplink.internal.expressions.ExpressionJavaPrinter;
import oracle.toplink.internal.expressions.ExpressionNormalizer;
import oracle.toplink.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.internal.helper.DatabaseTable;
import oracle.toplink.internal.helper.NonSynchronizedVector;

public abstract class CompoundExpression
extends Expression {
    protected ExpressionOperator operator;
    protected transient ExpressionOperator platformOperator;
    protected Expression firstChild;
    protected Expression secondChild;

    public DatabaseTable aliasForTable(DatabaseTable databaseTable) {
        DatabaseTable databaseTable2 = null;
        if (this.getFirstChild() != null) {
            databaseTable2 = this.getFirstChild().aliasForTable(databaseTable);
        }
        if (databaseTable2 == null && this.getSecondChild() != null) {
            databaseTable2 = this.getSecondChild().aliasForTable(databaseTable);
        }
        return databaseTable2;
    }

    public Expression asOf(AsOfClause asOfClause) {
        final AsOfClause asOfClause2 = asOfClause;
        ExpressionIterator expressionIterator = new ExpressionIterator(){

            public void iterate(Expression expression) {
                if (expression.isDataExpression()) {
                    expression.asOf(asOfClause2);
                }
            }

            public boolean shouldIterateOverSubSelects() {
                return true;
            }
        };
        expressionIterator.iterateOn(this);
        return this;
    }

    public Expression create(Expression expression, Object object, ExpressionOperator expressionOperator) {
        this.setFirstChild(expression);
        Expression expression2 = Expression.from(object, expression);
        this.setSecondChild(expression2);
        this.setOperator(expressionOperator);
        return this;
    }

    public Expression create(Expression expression, Vector vector, ExpressionOperator expressionOperator) {
        this.setFirstChild(expression);
        if (!vector.isEmpty()) {
            this.setSecondChild((Expression)vector.firstElement());
        }
        this.setOperator(expressionOperator);
        return this;
    }

    public String descriptionOfNodeType() {
        return "Compound Expression";
    }

    public ExpressionBuilder getBuilder() {
        ExpressionBuilder expressionBuilder = this.getFirstChild().getBuilder();
        if (expressionBuilder == null) {
            return this.getSecondChild().getBuilder();
        }
        return expressionBuilder;
    }

    public Expression getFirstChild() {
        return this.firstChild;
    }

    public ExpressionOperator getOperator() {
        return this.operator;
    }

    public ExpressionOperator getPlatformOperator(DatabasePlatform databasePlatform) {
        if (this.platformOperator == null) {
            this.initializePlatformOperator(databasePlatform);
        }
        return this.platformOperator;
    }

    public Expression getSecondChild() {
        return this.secondChild;
    }

    public void initializePlatformOperator(DatabasePlatform databasePlatform) {
        if (this.getOperator().isComplete()) {
            this.platformOperator = this.getOperator();
            return;
        }
        this.platformOperator = databasePlatform.getOperator(this.getOperator().getSelector());
        if (this.platformOperator == null) {
            throw QueryException.invalidOperator(this.getOperator().toString());
        }
    }

    public boolean isCompoundExpression() {
        return true;
    }

    public void iterateOn(ExpressionIterator expressionIterator) {
        super.iterateOn(expressionIterator);
        if (this.getFirstChild() != null) {
            this.getFirstChild().iterateOn(expressionIterator);
        }
        if (this.getSecondChild() != null) {
            this.getSecondChild().iterateOn(expressionIterator);
        }
    }

    public Expression normalize(ExpressionNormalizer expressionNormalizer) {
        this.validateNode();
        if (this.getFirstChild() != null) {
            this.setFirstChild(this.getFirstChild().normalize(expressionNormalizer));
        }
        if (this.getSecondChild() != null) {
            this.setSecondChild(this.getSecondChild().normalize(expressionNormalizer));
        }
        if (this.getFirstChild() == null) {
            return this.getSecondChild();
        }
        if (this.getSecondChild() == null) {
            return this.getFirstChild();
        }
        return this;
    }

    public void validateNode() {
        if (this.getFirstChild() != null && (this.getFirstChild().isDataExpression() || this.getFirstChild().isConstantExpression())) {
            throw QueryException.invalidExpression(this);
        }
        if (this.getSecondChild() != null && (this.getSecondChild().isDataExpression() || this.getSecondChild().isConstantExpression())) {
            throw QueryException.invalidExpression(this);
        }
    }

    protected void postCopyIn(Dictionary dictionary) {
        super.postCopyIn(dictionary);
        if (this.getFirstChild() != null) {
            this.setFirstChild(this.getFirstChild().copiedVersionFrom(dictionary));
        }
        if (this.getSecondChild() != null) {
            this.setSecondChild(this.getSecondChild().copiedVersionFrom(dictionary));
        }
    }

    public void printSQL(ExpressionSQLPrinter expressionSQLPrinter) {
        ExpressionOperator expressionOperator = this.getPlatformOperator(expressionSQLPrinter.getPlatform());
        expressionSQLPrinter.printString("(");
        expressionOperator.printDuo(this.getFirstChild(), this.getSecondChild(), expressionSQLPrinter);
        expressionSQLPrinter.printString(")");
    }

    public void printJava(ExpressionJavaPrinter expressionJavaPrinter) {
        ExpressionOperator expressionOperator = this.getPlatformOperator(expressionJavaPrinter.getPlatform());
        expressionOperator.printJavaDuo(this.getFirstChild(), this.getSecondChild(), expressionJavaPrinter);
    }

    public Expression rebuildOn(Expression expression) {
        NonSynchronizedVector nonSynchronizedVector;
        Expression expression2 = this.getFirstChild().rebuildOn(expression);
        if (this.getSecondChild() == null) {
            nonSynchronizedVector = NonSynchronizedVector.newInstance(0);
        } else {
            nonSynchronizedVector = NonSynchronizedVector.newInstance(1);
            ((Vector)nonSynchronizedVector).addElement(this.getSecondChild().rebuildOn(expression));
        }
        return expression2.performOperator(this.getOperator(), nonSynchronizedVector);
    }

    protected void setFirstChild(Expression expression) {
        this.firstChild = expression;
    }

    public void setOperator(ExpressionOperator expressionOperator) {
        this.operator = expressionOperator;
    }

    protected void setSecondChild(Expression expression) {
        this.secondChild = expression;
    }

    public Expression twistedForBaseAndContext(Expression expression, Expression expression2) {
        NonSynchronizedVector nonSynchronizedVector;
        if (this.getSecondChild() == null) {
            nonSynchronizedVector = NonSynchronizedVector.newInstance(0);
        } else {
            nonSynchronizedVector = NonSynchronizedVector.newInstance(1);
            ((Vector)nonSynchronizedVector).addElement(this.getSecondChild().twistedForBaseAndContext(expression, expression2));
        }
        Expression expression3 = this.getFirstChild().twistedForBaseAndContext(expression, expression2);
        return expression3.performOperator(this.getOperator(), nonSynchronizedVector);
    }

    public void writeDescriptionOn(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(this.operator.toString());
    }

    public void writeSubexpressionsTo(BufferedWriter bufferedWriter, int n) throws IOException {
        if (this.getFirstChild() != null) {
            this.getFirstChild().toString(bufferedWriter, n);
        }
        if (this.getSecondChild() != null) {
            this.getSecondChild().toString(bufferedWriter, n);
        }
    }
}

