/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp.wls11;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import oracle.toplink.internal.ejb.cmp.wls.WlsCMPCodeGenerator;
import oracle.toplink.internal.ejb.cmp.wls11.FinderGenerator;
import oracle.toplink.internal.ejb.cmp.wls11.Wls11CmpDom;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.tools.ejb11.CMPBeanDefinition;
import oracle.toplink.tools.ejb11.FinderDefinition;
import weblogic.ejb20.ejbc.EJBCException;
import weblogic.ejb20.utils.ClassUtils;
import weblogic.utils.Getopt2;

public class CMPCodeGenerator
extends WlsCMPCodeGenerator {
    protected Wls11CmpDom cmpDom;
    protected static final String TAB = "   ";
    protected static final String ORIGINAL_INDICATOR_ATTRIBUTE_NAME = "isOriginalTopLink";
    protected static final String WORKING_CLONE_INDICATOR_ATTRIBUTE_NAME = "isWorkingCopyCloneTopLink";
    protected static final String PERSISTENCE_MGR_ATTRIBUTE_NAME = "persistenceManagerTopLink";
    protected static final String ENTITY_CONTEXT_ATTRIBUTE_NAME = "entityContextTopLink";
    protected static final String PRIMARY_KEY_ATTRIBUTE_NAME = "pkTopLink";
    protected static final String CAN_BE_REUSED_ATTRIBUTE_NAME = "canBeReusedTopLink";
    protected static final String TRANSACTION_ATTRIBUTE_NAME = "associatedTransactionTopLink";
    protected static final String IS_DELETED_ATTRIBUTE_NAME = "isDeleted";
    public static final String CHANGETRACKER_ATTRIBUTE = "__toplinkChangeListener";

    public CMPCodeGenerator() {
    }

    public CMPCodeGenerator(Getopt2 getopt2) {
        super(getopt2);
    }

    protected String classFooter() {
        return "}";
    }

    protected Wls11CmpDom getCmpDom() {
        return this.cmpDom;
    }

    public void setCmpDom(Wls11CmpDom wls11CmpDom) {
        this.cmpDom = wls11CmpDom;
    }

    protected String classHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("public class ");
        stringBuffer.append(this.cmpBeanClassName());
        stringBuffer.append(" extends ");
        stringBuffer.append(this.getPersistenceManager().getEntityDescriptor().getBeanClass().getName());
        stringBuffer.append(" implements WLEnterpriseBean,");
        stringBuffer.append(" Cloneable,");
        stringBuffer.append(" TopLinkCmpEntity {");
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    public String codeGenSubclass() throws EJBCException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.packageStatement());
        stringBuffer.append(EOL);
        stringBuffer.append(EOL);
        stringBuffer.append(this.importStatement());
        stringBuffer.append(EOL);
        stringBuffer.append(EOL);
        stringBuffer.append(this.classHeader());
        stringBuffer.append(EOL);
        stringBuffer.append(this.defineInstanceVariables());
        stringBuffer.append(EOL);
        stringBuffer.append(this.implementCloneMethod());
        stringBuffer.append(EOL);
        stringBuffer.append(this.implementFinalizeMethod());
        stringBuffer.append(EOL);
        stringBuffer.append(this.implementFinderMethods());
        stringBuffer.append(EOL);
        stringBuffer.append(this.implementBeanManagerMethods());
        stringBuffer.append(EOL);
        stringBuffer.append(this.implementIsOriginalMethods());
        stringBuffer.append(EOL);
        stringBuffer.append(this.implementIsDeletedMethods());
        stringBuffer.append(EOL);
        stringBuffer.append(this.implementIsWorkingCopyMethods());
        stringBuffer.append(EOL);
        stringBuffer.append(this.implementPrimaryKeyMethods());
        stringBuffer.append(EOL);
        stringBuffer.append(this.implementEntityContextMethods());
        stringBuffer.append(EOL);
        stringBuffer.append(this.implementReturnGeneratedCollectionByNameMethod());
        stringBuffer.append(EOL);
        stringBuffer.append(this.implementCanBeReusedMethods());
        stringBuffer.append(EOL);
        stringBuffer.append(this.implementInitFieldsForCreateMethod());
        stringBuffer.append(EOL);
        stringBuffer.append(this.implementClearFieldsForPoolingMethod());
        stringBuffer.append(EOL);
        stringBuffer.append(this.implementReleaseMethod());
        stringBuffer.append(EOL);
        stringBuffer.append(this.implementAssociatedTxMethods());
        stringBuffer.append(EOL);
        stringBuffer.append(this.implementChangeTrackerInterface());
        stringBuffer.append(EOL);
        stringBuffer.append(this.addBasicCloneMethod());
        stringBuffer.append(EOL);
        stringBuffer.append(this.implementWLEnterpriseInterface());
        stringBuffer.append(this.classFooter());
        return stringBuffer.toString();
    }

    protected String defineInstanceVariables() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TAB);
        stringBuffer.append("PersistenceManagerBase persistenceManagerTopLink;");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("boolean isOriginalTopLink = false;");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("boolean isWorkingCopyCloneTopLink = false;");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("Object pkTopLink;");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("EntityContext entityContextTopLink;");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("boolean canBeReusedTopLink;");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("Transaction associatedTransactionTopLink;");
        stringBuffer.append(EOL);
        stringBuffer.append("java.beans.PropertyChangeListener __toplinkChangeListener = null;");
        stringBuffer.append(EOL);
        stringBuffer.append("boolean isDeleted = false;");
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    protected FinderDefinition finderDefinitionFor(Method method) throws Exception {
        String string;
        CMPBeanDefinition cMPBeanDefinition = this.getCmpDom().getBeanDefinition();
        FinderDefinition finderDefinition = cMPBeanDefinition.getFinder(string = this.fullyQualifiedMethodSignatureFor(method));
        if (finderDefinition == null) {
            string = this.unQualifiedMethodSignatureFor(method);
            finderDefinition = cMPBeanDefinition.getFinder(string);
        }
        return finderDefinition;
    }

    protected String fullyQualifiedMethodSignatureFor(Method method) throws Exception {
        return this.methodSignatureFor(method, true);
    }

    public List getFinderMethodsList() {
        Class clazz = this.getPersistenceManager().getEntityDescriptor().getHomeInterfaceClass();
        List list = ClassUtils.getFinderMethodList((Class)clazz);
        return list;
    }

    protected String implementCloneMethod() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("public Object __buildWorkingCloneTopLink() {");
        stringBuffer.append(EOL);
        stringBuffer.append("    TopLinkCmpEntity clone = null;");
        stringBuffer.append(EOL);
        stringBuffer.append("    try {");
        stringBuffer.append(EOL);
        stringBuffer.append(EOL);
        stringBuffer.append("\t    clone = (TopLinkCmpEntity)super.clone();");
        stringBuffer.append(EOL);
        stringBuffer.append("    } catch (CloneNotSupportedException e) {");
        stringBuffer.append(EOL);
        stringBuffer.append("    \t// This should never happen since this object implements Cloneable");
        stringBuffer.append(EOL);
        stringBuffer.append("    \tthrow new InternalError();");
        stringBuffer.append(EOL);
        stringBuffer.append("    }");
        stringBuffer.append(EOL);
        stringBuffer.append("    clone.setIsOriginalTopLink(false);");
        stringBuffer.append(EOL);
        stringBuffer.append("    clone.setIsWorkingCopyCloneTopLink(true);");
        stringBuffer.append(EOL);
        stringBuffer.append("    return clone;");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    protected String implementFinalizeMethod() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("public void finalize() throws Throwable {");
        stringBuffer.append(EOL);
        stringBuffer.append("    if (isOriginalTopLink()) {");
        stringBuffer.append(EOL);
        stringBuffer.append("        this.unsetEntityContext();");
        stringBuffer.append(EOL);
        stringBuffer.append("\t   }");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    protected String implementIsOriginalMethods() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("public boolean isOriginalTopLink() {");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("return this.isOriginalTopLink;");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        stringBuffer.append("public void setIsOriginalTopLink(boolean originalFlag) {");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("this.isOriginalTopLink = originalFlag;");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    protected String implementIsDeletedMethods() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("public boolean isDeleted() {");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("return this.isDeleted;");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        stringBuffer.append(EOL);
        stringBuffer.append("public void setIsDeleted(boolean deleted) {");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("this.isDeleted = deleted;");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    protected String implementIsWorkingCopyMethods() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("public boolean isWorkingCopyCloneTopLink() {");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("return this.isWorkingCopyCloneTopLink;");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        stringBuffer.append("public void setIsWorkingCopyCloneTopLink(boolean originalFlag) {");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("this.isWorkingCopyCloneTopLink = originalFlag;");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    protected String implementBeanManagerMethods() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("public PersistenceManagerBase getPersistenceManagerTopLink() {");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("return this.persistenceManagerTopLink;");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        stringBuffer.append("public void setPersistenceManagerTopLink(PersistenceManagerBase pm) {");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("this.persistenceManagerTopLink = pm;");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    protected String implementPrimaryKeyMethods() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("public Object getPrimaryKeyTopLink() {");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("return this.pkTopLink;");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        stringBuffer.append("public void setPrimaryKeyTopLink(Object obj) {");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("this.pkTopLink = obj;");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    protected String implementEntityContextMethods() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("public EntityContext getEntityContextTopLink() {");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("return this.entityContextTopLink;");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        stringBuffer.append("public void setEntityContextTopLink(EntityContext ctx) {");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("this.entityContextTopLink = ctx;");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    protected String implementReturnGeneratedCollectionByNameMethod() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("public java.util.Collection returnGeneratedCollectionByName(String collectionName, int initialSize) {");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("return new java.util.ArrayList(initialSize);");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    protected String implementCanBeReusedMethods() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("public boolean getCanBeReusedTopLink() {");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("return this.canBeReusedTopLink;");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        stringBuffer.append("public void setCanBeReusedTopLink(boolean reuse) {");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("this.canBeReusedTopLink = reuse;");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    protected String implementAssociatedTxMethods() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("public Transaction getAssociatedTransactionTopLink() {");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("return this.associatedTransactionTopLink;");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        stringBuffer.append("public void setAssociatedTransactionTopLink(Transaction tx) {");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("this.associatedTransactionTopLink = tx;");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    protected String implementInitFieldsForCreateMethod() {
        return "public void initFieldsForCreateTopLink() {}";
    }

    protected String implementClearFieldsForPoolingMethod() {
        return "public void clearFieldsForPoolingTopLink() {}";
    }

    protected String implementReleaseMethod() {
        return "public void releaseTopLink() {}";
    }

    public String implementFinder(Method method) throws Exception {
        FinderGenerator finderGenerator = null;
        CMPBeanDefinition cMPBeanDefinition = null;
        if (method == null) {
            return null;
        }
        cMPBeanDefinition = this.getCmpDom().getBeanDefinition();
        if (method.getName().equalsIgnoreCase("findByPrimaryKey")) {
            finderGenerator = new FinderGenerator(method, cMPBeanDefinition);
            finderGenerator.setIsFindByPrimaryKey(true);
        } else {
            FinderDefinition finderDefinition = this.finderDefinitionFor(method);
            finderGenerator = new FinderGenerator(method, finderDefinition, cMPBeanDefinition);
            if (!finderGenerator.hasFinderDefinition()) {
                System.out.println("****Warning No XML definition for: " + finderGenerator.getMethod());
            }
        }
        return finderGenerator.implementation();
    }

    protected String implementFinderMethods() throws EJBCException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        try {
            Iterator iterator = this.getFinderMethodsList().iterator();
            while (iterator.hasNext()) {
                string = this.implementFinder((Method)iterator.next());
                if (string == null) continue;
                stringBuffer.append(string);
                stringBuffer.append(EOL);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        return stringBuffer.toString();
    }

    protected String implementWLEnterpriseInterface() throws EJBCException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("public Transaction __WL_getBeanManagedTransaction() {");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("throw new AssertionError(\"Entity beans can't have bean-managed transactions\");");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        stringBuffer.append(EOL);
        stringBuffer.append(EOL);
        stringBuffer.append("public EJBContext __WL_getEJBContext() {");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("return __WL_EJBContext;");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        stringBuffer.append(EOL);
        stringBuffer.append(EOL);
        stringBuffer.append("public int __WL_getMethodState() {");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("return 0xFFFFFFFF;");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        stringBuffer.append(EOL);
        stringBuffer.append(EOL);
        stringBuffer.append("public void __WL_setMethodState(int state) {");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        stringBuffer.append(EOL);
        stringBuffer.append(EOL);
        stringBuffer.append("public boolean __WL_isBusy() { return false; }");
        stringBuffer.append(EOL);
        stringBuffer.append(EOL);
        stringBuffer.append("public void __WL_setBeanManagedTransaction(Transaction transaction) {");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("throw new AssertionError(\"Entity beans can't have bean-managed transactions\");");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        stringBuffer.append(EOL);
        stringBuffer.append(EOL);
        stringBuffer.append("public void __WL_setBusy(boolean flag) {}");
        stringBuffer.append(EOL);
        stringBuffer.append(EOL);
        stringBuffer.append("public void __WL_setEJBContext(EJBContext ejbcontext) {");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("__WL_EJBContext = ejbcontext;");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        stringBuffer.append(EOL);
        stringBuffer.append(EOL);
        stringBuffer.append("public boolean __WL_needsRemove() { return false; }");
        stringBuffer.append(EOL);
        stringBuffer.append(EOL);
        stringBuffer.append("public void __WL_setNeedsRemove(boolean flag) {}");
        stringBuffer.append(EOL);
        stringBuffer.append(EOL);
        stringBuffer.append("public boolean __WL_getIsLocal() { return false; }");
        stringBuffer.append(EOL);
        stringBuffer.append(EOL);
        stringBuffer.append("public void __WL_setIsLocal(boolean flag) {}");
        stringBuffer.append(EOL);
        stringBuffer.append(EOL);
        stringBuffer.append("public Object __WL_getLoadUser() { return null; }");
        stringBuffer.append(EOL);
        stringBuffer.append(EOL);
        stringBuffer.append("public void __WL_setLoadUser(Object obj) {}");
        stringBuffer.append(EOL);
        stringBuffer.append(EOL);
        stringBuffer.append("public boolean __WL_isCreatorOfTx() { return false; }");
        stringBuffer.append(EOL);
        stringBuffer.append(EOL);
        stringBuffer.append("public void __WL_setCreatorOfTx(boolean flag) {}");
        stringBuffer.append(EOL);
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("private EJBContext __WL_EJBContext;");
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    protected String importStatement() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("import oracle.toplink.queryframework.*;");
        stringBuffer.append(EOL);
        stringBuffer.append("import oracle.toplink.publicinterface.*;");
        stringBuffer.append(EOL);
        stringBuffer.append("import oracle.toplink.expressions.*;");
        stringBuffer.append(EOL);
        stringBuffer.append("import oracle.toplink.ejb.cmp.wls11.*;");
        stringBuffer.append(EOL);
        stringBuffer.append("import oracle.toplink.internal.ejb.cmp.wls11.*;");
        stringBuffer.append(EOL);
        stringBuffer.append("import oracle.toplink.internal.ejb.cmp.*;");
        stringBuffer.append(EOL);
        stringBuffer.append("import java.util.*;");
        stringBuffer.append(EOL);
        stringBuffer.append("import javax.ejb.*;");
        stringBuffer.append(EOL);
        stringBuffer.append("import javax.transaction.Transaction;");
        stringBuffer.append(EOL);
        stringBuffer.append("import weblogic.utils.AssertionError;");
        stringBuffer.append(EOL);
        stringBuffer.append("import weblogic.ejb20.interfaces.WLEnterpriseBean;");
        stringBuffer.append(EOL);
        stringBuffer.append("import oracle.toplink.descriptors.changetracking.ChangeTracker;");
        stringBuffer.append(EOL);
        stringBuffer.append("import oracle.toplink.indirection.*;");
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    protected String implementChangeTrackerInterface() throws EJBCException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("public java.beans.PropertyChangeListener getTopLinkPropertyChangeListener(){");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("return this.__toplinkChangeListener;");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        stringBuffer.append(EOL);
        stringBuffer.append("public void setTopLinkPropertyChangeListener(java.beans.PropertyChangeListener listener){");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("this.__toplinkChangeListener = listener;");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    protected String addBasicCloneMethod() throws EJBCException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("public Object clone(){");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("oracle.toplink.internal.ejb.cmp.TopLinkCmpEntity clone = null;");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("try {");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append(TAB);
        stringBuffer.append("clone = (oracle.toplink.internal.ejb.cmp.TopLinkCmpEntity)super.clone();");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("} catch (Exception cloneNotSupported) {}");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("clone.setIsOriginalTopLink(true);");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("clone.setIsWorkingCopyCloneTopLink(false);");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("clone.setEntityContextTopLink(null);");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("clone.setAssociatedTransactionTopLink(null);");
        stringBuffer.append(EOL);
        stringBuffer.append(TAB);
        stringBuffer.append("return clone;");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    protected String methodSignatureFor(Method method, boolean bl) throws Exception {
        if (method == null) {
            return null;
        }
        String string = method.getName();
        Class[] classArray = PrivilegedAccessController.getMethodParameterTypes(method);
        for (int i = 0; i < classArray.length; ++i) {
            String string2 = classArray[i].getName();
            if (!bl) {
                string2 = this.stripPackageFrom(string2);
            }
            string = string + string2;
        }
        return string;
    }

    protected String stripPackageFrom(String string) throws Exception {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    protected String unQualifiedMethodSignatureFor(Method method) throws Exception {
        return this.methodSignatureFor(method, false);
    }
}

