/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp.wls;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.toplink.internal.ejb.cmp.EJBExceptionFactory;
import oracle.toplink.internal.ejb.cmp.api.EntityDescriptor;
import oracle.toplink.internal.ejb.cmp.api.FinderDescriptor;
import oracle.toplink.internal.ejb.cmp.api.RelationshipDescriptor;
import oracle.toplink.internal.ejb.cmp.api.impl.DescriptorBuilder;
import oracle.toplink.internal.ejb.cmp.api.impl.EntityDescriptorImpl;
import oracle.toplink.internal.ejb.cmp.api.impl.FinderDescriptorImpl;
import oracle.toplink.internal.helper.ConversionManager;
import oracle.toplink.internal.security.PrivilegedAccessController;
import weblogic.ejb20.interfaces.EntityBeanQuery;
import weblogic.ejb20.persistence.spi.CMPBeanDescriptor;
import weblogic.ejb20.persistence.spi.EjbRelation;
import weblogic.ejb20.persistence.spi.EjbRelationshipRole;
import weblogic.ejb20.persistence.spi.Relationships;
import weblogic.ejb20.persistence.spi.RoleSource;

public class WlsDescriptorBuilder
extends DescriptorBuilder {
    private static final String RESULT_TYPE_MAPPING = "Local";
    private static final String REL_MULTIPLICITY = "Many";
    private Relationships oldRelationships;
    private Map tlRelationshipDescriptors;

    public WlsDescriptorBuilder() {
        this.oldDescriptors = new HashMap();
    }

    public void addOldDescriptors(Relationships relationships, Map map) {
        this.oldDescriptors.putAll(map);
        this.oldRelationships = relationships;
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            this.buildDescriptor(iterator.next());
        }
    }

    protected String getBeanName(Object object) {
        return ((CMPBeanDescriptor)object).getEJBName();
    }

    protected EntityDescriptor buildShallowDescriptor(String string) {
        CMPBeanDescriptor cMPBeanDescriptor = (CMPBeanDescriptor)this.getOldDescriptors().get(string);
        EntityDescriptorImpl entityDescriptorImpl = new EntityDescriptorImpl();
        entityDescriptorImpl.beanName = cMPBeanDescriptor.getEJBName();
        entityDescriptorImpl.isEjb20 = Modifier.isAbstract(cMPBeanDescriptor.getBeanClass().getModifiers());
        entityDescriptorImpl.abstractSchemaName = cMPBeanDescriptor.getAbstractSchemaName();
        entityDescriptorImpl.beanClass = cMPBeanDescriptor.getBeanClass();
        entityDescriptorImpl.concreteBeanClassName = cMPBeanDescriptor.getGeneratedBeanClassName();
        entityDescriptorImpl.remoteInterfaceClass = cMPBeanDescriptor.getRemoteInterfaceClass();
        entityDescriptorImpl.remoteHomeInterfaceClass = cMPBeanDescriptor.getHomeInterfaceClass();
        entityDescriptorImpl.localInterfaceClass = cMPBeanDescriptor.getLocalInterfaceClass();
        entityDescriptorImpl.localHomeInterfaceClass = cMPBeanDescriptor.getLocalHomeInterfaceClass();
        entityDescriptorImpl.pkClass = cMPBeanDescriptor.getPrimaryKeyClass();
        entityDescriptorImpl.cmrFields = new HashMap();
        return entityDescriptorImpl;
    }

    protected void buildDescriptorPostCodeGen(Object object) {
        CMPBeanDescriptor cMPBeanDescriptor = (CMPBeanDescriptor)object;
        EntityDescriptorImpl entityDescriptorImpl = (EntityDescriptorImpl)this.privateGetEntityDescriptor(this.getBeanName(object));
        try {
            entityDescriptorImpl.concreteBeanClass = PrivilegedAccessController.getClassForName(entityDescriptorImpl.getConcreteBeanClassName(), false, cMPBeanDescriptor.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw EJBExceptionFactory.internalErrorFindingGeneratedSubclass(entityDescriptorImpl.getConcreteBeanClassName(), classNotFoundException);
        }
        if (cMPBeanDescriptor.getHomeInterfaceName() != null) {
            entityDescriptorImpl.remoteImplClass = cMPBeanDescriptor.getRemoteClass();
            entityDescriptorImpl.remoteHomeImplClass = cMPBeanDescriptor.getHomeClass();
        }
        if (cMPBeanDescriptor.getLocalHomeInterfaceName() != null) {
            entityDescriptorImpl.localImplClass = cMPBeanDescriptor.getLocalClass();
            entityDescriptorImpl.localHomeImplClass = cMPBeanDescriptor.getLocalHomeClass();
        }
    }

    protected String getPrimaryKeyFieldName(Object object) {
        CMPBeanDescriptor cMPBeanDescriptor = (CMPBeanDescriptor)object;
        if (cMPBeanDescriptor.hasComplexPrimaryKey()) {
            return null;
        }
        return (String)cMPBeanDescriptor.getPrimaryKeyFieldNames().iterator().next();
    }

    protected Collection getCmpFieldNames(Object object) {
        return ((CMPBeanDescriptor)object).getCMFieldNames();
    }

    protected Collection getOldFinders(Object object) {
        return ((CMPBeanDescriptor)object).getAllQueries();
    }

    protected FinderDescriptor buildFinderDescriptor(Object object, EntityDescriptor entityDescriptor) {
        EntityBeanQuery entityBeanQuery = (EntityBeanQuery)object;
        FinderDescriptorImpl finderDescriptorImpl = new FinderDescriptorImpl();
        finderDescriptorImpl.methodName = entityBeanQuery.getMethodName();
        String[] stringArray = entityBeanQuery.getMethodParams();
        ArrayList<Class> arrayList = new ArrayList<Class>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(ConversionManager.loadClass(stringArray[i]));
        }
        finderDescriptorImpl.params = arrayList;
        finderDescriptorImpl.returnType = this.getFinderReturnType(entityDescriptor, finderDescriptorImpl);
        finderDescriptorImpl.isRemote = !RESULT_TYPE_MAPPING.equalsIgnoreCase(entityBeanQuery.getResultTypeMapping());
        finderDescriptorImpl.ejbql = entityBeanQuery.getQueryText();
        return finderDescriptorImpl;
    }

    protected Collection buildRelationships(Object object) {
        Collection collection;
        if (this.getOldRelationships() == null) {
            return new ArrayList(0);
        }
        if (this.tlRelationshipDescriptors == null) {
            this.buildRelationshipDescriptors();
        }
        if ((collection = (Collection)this.tlRelationshipDescriptors.get(this.getBeanName(object))) == null) {
            return new ArrayList(0);
        }
        return collection;
    }

    private void buildRelationshipDescriptors() {
        this.tlRelationshipDescriptors = new HashMap();
        Iterator iterator = this.getOldRelationships().getAllEjbRelations().values().iterator();
        while (iterator.hasNext()) {
            this.buildRelationship((EjbRelation)iterator.next());
        }
    }

    private void buildRelationship(EjbRelation ejbRelation) {
        Iterator iterator = ejbRelation.getAllEjbRelationshipRoles().iterator();
        EjbRelationshipRole ejbRelationshipRole = (EjbRelationshipRole)iterator.next();
        EjbRelationshipRole ejbRelationshipRole2 = (EjbRelationshipRole)iterator.next();
        String string = null;
        if (ejbRelationshipRole.getCmrField() != null) {
            string = ejbRelationshipRole.getCmrField().getName();
        }
        String string2 = null;
        if (ejbRelationshipRole2.getCmrField() != null) {
            string2 = ejbRelationshipRole2.getCmrField().getName();
        }
        this.addRelationshipDescriptor(this.buildRelationshipDescriptor(this.getEjbNameForRoleSource(ejbRelationshipRole.getRoleSource()), string, REL_MULTIPLICITY.equalsIgnoreCase(ejbRelationshipRole.getMultiplicity()), ejbRelationshipRole.getCascadeDelete(), this.getEjbNameForRoleSource(ejbRelationshipRole2.getRoleSource()), string2, REL_MULTIPLICITY.equalsIgnoreCase(ejbRelationshipRole2.getMultiplicity()), ejbRelationshipRole2.getCascadeDelete()));
        this.addRelationshipDescriptor(this.buildRelationshipDescriptor(this.getEjbNameForRoleSource(ejbRelationshipRole2.getRoleSource()), string2, REL_MULTIPLICITY.equalsIgnoreCase(ejbRelationshipRole2.getMultiplicity()), ejbRelationshipRole2.getCascadeDelete(), this.getEjbNameForRoleSource(ejbRelationshipRole.getRoleSource()), string, REL_MULTIPLICITY.equalsIgnoreCase(ejbRelationshipRole.getMultiplicity()), ejbRelationshipRole.getCascadeDelete()));
    }

    private void addRelationshipDescriptor(RelationshipDescriptor relationshipDescriptor) {
        String string = relationshipDescriptor.getSourceRole().getCmrField().getEntityDescriptor().getBeanName();
        ArrayList<RelationshipDescriptor> arrayList = (ArrayList<RelationshipDescriptor>)this.tlRelationshipDescriptors.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<RelationshipDescriptor>();
            this.tlRelationshipDescriptors.put(string, arrayList);
        }
        arrayList.add(relationshipDescriptor);
    }

    protected String getEjbNameForRoleSource(RoleSource roleSource) {
        return roleSource.getName();
    }

    private Relationships getOldRelationships() {
        return this.oldRelationships;
    }
}

