/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.eis.adapters.jms;

import javax.jms.JMSException;
import javax.resource.cci.LocalTransaction;
import oracle.toplink.eis.EISException;
import oracle.toplink.internal.eis.adapters.jms.CciJMSConnection;

public class CciJMSTransaction
implements LocalTransaction {
    protected boolean isInTransaction;
    protected CciJMSConnection connection;

    public CciJMSTransaction(CciJMSConnection cciJMSConnection) {
        this.connection = cciJMSConnection;
        this.isInTransaction = false;
    }

    public void begin() throws EISException {
        try {
            if (!this.connection.getSession().getTransacted()) {
                throw EISException.invalidMethodInvocation();
            }
        }
        catch (JMSException jMSException) {
            throw EISException.transactedSessionTestError();
        }
        this.isInTransaction = true;
    }

    public boolean isInTransaction() {
        return this.isInTransaction;
    }

    public void commit() throws EISException {
        try {
            this.connection.getSession().commit();
        }
        catch (Exception exception) {
            throw EISException.createException(exception);
        }
        this.isInTransaction = false;
    }

    public void rollback() throws EISException {
        try {
            this.connection.getSession().rollback();
        }
        catch (Exception exception) {
            throw EISException.createException(exception);
        }
        this.isInTransaction = false;
    }
}

