/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.annotations;

import java.lang.reflect.AnnotatedElement;
import java.util.Hashtable;
import javax.persistence.GeneratedIdTable;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.annotations.EJBAnnotationsProcessor;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.sequencing.NativeSequence;
import oracle.toplink.sequencing.Sequence;
import oracle.toplink.sequencing.TableSequence;
import oracle.toplink.sessions.DatasourceLogin;

public class SequencingProcessor {
    public static final String DEFAULT_AUTO_GENERATOR = "SEQ_GEN";
    public static final String DEFAULT_TABLE_GENERATOR = "SEQ_GEN_TABLE";
    public static final String DEFAULT_SEQUENCE_GENERATOR = "SEQ_GEN_SEQUENCE";
    private Hashtable<String, GeneratedIdTable> m_generatorTables = new Hashtable();
    private Hashtable<String, SequenceGenerator> m_sequenceGenerators;
    private Hashtable<String, TableGenerator> m_tableGenerators = new Hashtable();
    private Hashtable<Descriptor, Id> m_ids;
    private Hashtable<Object, AnnotatedElement> m_annotatedElements;

    public SequencingProcessor() {
        this.m_sequenceGenerators = new Hashtable();
        this.m_ids = new Hashtable();
        this.m_annotatedElements = new Hashtable();
    }

    public void preProcessGeneratorTable(AnnotatedElement annotatedElement) {
        GeneratedIdTable generatedIdTable = (GeneratedIdTable)EJBAnnotationsProcessor.getAnnotation(annotatedElement, GeneratedIdTable.class);
        if (generatedIdTable == null) {
            return;
        }
        this.m_annotatedElements.put(generatedIdTable, annotatedElement);
        String string = generatedIdTable.name();
        GeneratedIdTable generatedIdTable2 = this.m_generatorTables.get(string);
        if (generatedIdTable2 != null && generatedIdTable2.equals(generatedIdTable)) {
            return;
        }
        for (GeneratedIdTable generatedIdTable3 : this.m_generatorTables.values()) {
            this.checkForConflict(generatedIdTable3, generatedIdTable);
        }
        this.m_generatorTables.put(string, generatedIdTable);
    }

    public void preProcessTableGenerator(AnnotatedElement annotatedElement) {
        TableGenerator tableGenerator = (TableGenerator)EJBAnnotationsProcessor.getAnnotation(annotatedElement, TableGenerator.class);
        if (tableGenerator == null) {
            return;
        }
        this.m_annotatedElements.put(tableGenerator, annotatedElement);
        String string = tableGenerator.name();
        if (string.equals(DEFAULT_SEQUENCE_GENERATOR)) {
            throw ValidationException.reservedName(SequencingProcessor.getFullName(annotatedElement, tableGenerator), DEFAULT_SEQUENCE_GENERATOR, SequenceGenerator.class.getName());
        }
        TableGenerator tableGenerator2 = this.m_tableGenerators.get(string);
        if (tableGenerator2 != null && tableGenerator2.equals(tableGenerator)) {
            return;
        }
        for (TableGenerator tableGenerator3 : this.m_tableGenerators.values()) {
            this.checkForConflict(tableGenerator3, tableGenerator);
        }
        for (SequenceGenerator sequenceGenerator : this.m_sequenceGenerators.values()) {
            this.checkForConflict(sequenceGenerator, tableGenerator);
        }
        this.m_tableGenerators.put(string, tableGenerator);
    }

    public void preProcessSequenceGenerator(AnnotatedElement annotatedElement) {
        SequenceGenerator sequenceGenerator = (SequenceGenerator)EJBAnnotationsProcessor.getAnnotation(annotatedElement, SequenceGenerator.class);
        if (sequenceGenerator == null) {
            return;
        }
        this.m_annotatedElements.put(sequenceGenerator, annotatedElement);
        String string = sequenceGenerator.name();
        if (sequenceGenerator.equals(DEFAULT_TABLE_GENERATOR)) {
            throw ValidationException.reservedName(SequencingProcessor.getFullName(annotatedElement, sequenceGenerator), DEFAULT_TABLE_GENERATOR, TableGenerator.class.getName());
        }
        SequenceGenerator sequenceGenerator2 = this.m_sequenceGenerators.get(string);
        if (sequenceGenerator2 != null && sequenceGenerator2.equals(sequenceGenerator)) {
            return;
        }
        for (SequenceGenerator sequenceGenerator3 : this.m_sequenceGenerators.values()) {
            this.checkForConflict(sequenceGenerator3, sequenceGenerator);
        }
        for (TableGenerator tableGenerator : this.m_tableGenerators.values()) {
            this.checkForConflict(tableGenerator, sequenceGenerator);
        }
        this.m_sequenceGenerators.put(string, sequenceGenerator);
    }

    public void preProcessId(AnnotatedElement annotatedElement, Id id, String string, Descriptor descriptor) {
        if (id == null) {
            return;
        }
        this.m_annotatedElements.put(id, annotatedElement);
        GeneratorType generatorType = id.generate();
        String string2 = id.generator();
        if (generatorType == GeneratorType.NONE) {
            if (string2.equals("")) {
                return;
            }
            throw ValidationException.idAnnotationCannotSpecifyGenerator(SequencingProcessor.getFullName(annotatedElement, id), generatorType.toString());
        }
        Id id2 = this.m_ids.get(descriptor);
        if (id2 != null) {
            this.throwConflictException(id, id2);
        }
        if (generatorType == GeneratorType.AUTO && !string2.equals("")) {
            throw ValidationException.idAnnotationCannotSpecifyGenerator(SequencingProcessor.getFullName(annotatedElement, id), generatorType.toString());
        }
        descriptor.setSequenceNumberFieldName(string);
        for (Id id3 : this.m_ids.values()) {
            this.checkForConflict(id3, id);
        }
        this.m_ids.put(descriptor, id);
    }

    /*
     * WARNING - void declaration
     */
    public void process(DatasourceLogin datasourceLogin) {
        Sequence sequence;
        Object object;
        String string;
        Object object2;
        Object object3;
        Object object4;
        if (this.m_ids.isEmpty()) {
            return;
        }
        for (Id object52 : this.m_ids.values()) {
            object4 = object52.generate();
            object3 = object52.generator();
            if (object4.equals((Object)GeneratorType.TABLE)) {
                object2 = this.m_sequenceGenerators.get(object3);
                if (object2 == null) continue;
                this.throwConflictException(object52, object2);
                continue;
            }
            if (!object4.equals((Object)GeneratorType.SEQUENCE) && !object4.equals((Object)GeneratorType.IDENTITY) || (object2 = this.m_tableGenerators.get(object3)) == null) continue;
            this.throwConflictException(object52, object2);
        }
        Object object6 = null;
        NativeSequence nativeSequence = new NativeSequence(DEFAULT_SEQUENCE_GENERATOR);
        object4 = new TableSequence(DEFAULT_TABLE_GENERATOR);
        object3 = new Hashtable();
        for (SequenceGenerator sequenceGenerator : this.m_sequenceGenerators.values()) {
            string = sequenceGenerator.name();
            object2 = sequenceGenerator.sequenceName().equals("") ? string : sequenceGenerator.sequenceName();
            object = new NativeSequence((String)object2, sequenceGenerator.allocationSize());
            ((Hashtable)object3).put(string, object);
            if (string.equals(DEFAULT_AUTO_GENERATOR)) {
                object6 = object;
                continue;
            }
            if (!string.equals(DEFAULT_SEQUENCE_GENERATOR)) continue;
            Object object5 = object;
        }
        for (TableGenerator tableGenerator : this.m_tableGenerators.values()) {
            string = tableGenerator.name();
            object2 = tableGenerator.pkColumnValue().equals("") ? string : tableGenerator.pkColumnValue();
            object = new TableSequence((String)object2, tableGenerator.allocationSize());
            ((Hashtable)object3).put(string, object);
            sequence = this.m_generatorTables.get(tableGenerator.tableName());
            if (sequence != null) {
                Table table = sequence.table();
                if (table.specified()) {
                    if (!table.name().equals("")) {
                        ((TableSequence)object).setTableName(EJBAnnotationsProcessor.getFullyQualifiedTableName(table.name(), table.catalog(), table.schema()));
                    }
                } else {
                    ((TableSequence)object).setTableName(tableGenerator.tableName());
                }
                if (!sequence.pkColumnName().equals("")) {
                    ((TableSequence)object).setNameFieldName(sequence.pkColumnName());
                }
                if (!sequence.valueColumnName().equals("")) {
                    ((TableSequence)object).setCounterFieldName(sequence.valueColumnName());
                }
            }
            if (string.equals(DEFAULT_AUTO_GENERATOR)) {
                object6 = object;
                continue;
            }
            if (!string.equals(DEFAULT_TABLE_GENERATOR)) continue;
            object4 = object;
        }
        for (Descriptor descriptor : this.m_ids.keySet()) {
            string = this.m_ids.get(descriptor);
            object = string.generator();
            sequence = null;
            if (!((String)object).equals("")) {
                sequence = (Sequence)((Hashtable)object3).get(object);
            }
            if (sequence == null) {
                if (string.generate() == GeneratorType.TABLE) {
                    if (((String)object).equals("")) {
                        sequence = object4;
                    } else {
                        sequence = (Sequence)((Sequence)object4).clone();
                        sequence.setName((String)object);
                    }
                } else if (string.generate() == GeneratorType.SEQUENCE || string.generate() == GeneratorType.IDENTITY) {
                    void var3_5;
                    if (((String)object).equals("")) {
                        sequence = var3_5;
                    } else {
                        sequence = (Sequence)var3_5.clone();
                        sequence.setName((String)object);
                    }
                }
            }
            if (sequence != null) {
                descriptor.setSequenceNumberName(sequence.getName());
                datasourceLogin.addSequence(sequence);
                continue;
            }
            if (string.generate() == GeneratorType.AUTO) {
                if (object6 != null) {
                    descriptor.setSequenceNumberName(((Sequence)object6).getName());
                    datasourceLogin.setDefaultSequence((Sequence)object6);
                    continue;
                }
                descriptor.setSequenceNumberName(DEFAULT_AUTO_GENERATOR);
                continue;
            }
            assert (false);
        }
    }

    void checkForConflict(GeneratedIdTable generatedIdTable, GeneratedIdTable generatedIdTable2) {
        boolean bl;
        boolean bl2 = generatedIdTable.name().equals(generatedIdTable2.name());
        boolean bl3 = bl = generatedIdTable.table().equals(generatedIdTable2.table()) && (!generatedIdTable.pkColumnName().equals(generatedIdTable2.pkColumnName()) || !generatedIdTable.valueColumnName().equals(generatedIdTable2.valueColumnName()));
        if (bl2 || bl) {
            this.throwConflictException(generatedIdTable, generatedIdTable2);
        }
    }

    void checkForConflict(TableGenerator tableGenerator, TableGenerator tableGenerator2) {
        boolean bl;
        boolean bl2 = tableGenerator.name().equals(tableGenerator2.name());
        boolean bl3 = bl = tableGenerator.pkColumnValue().equals(tableGenerator2.pkColumnValue()) && (!tableGenerator.tableName().equals(tableGenerator2.tableName()) || tableGenerator.allocationSize() != tableGenerator2.allocationSize());
        if (bl2 || bl) {
            this.throwConflictException(tableGenerator, tableGenerator2);
        }
    }

    void checkForConflict(SequenceGenerator sequenceGenerator, SequenceGenerator sequenceGenerator2) {
        boolean bl;
        boolean bl2 = sequenceGenerator.name().equals(sequenceGenerator2.name());
        boolean bl3 = bl = sequenceGenerator.sequenceName().equals(sequenceGenerator2.sequenceName()) && sequenceGenerator.allocationSize() != sequenceGenerator2.allocationSize();
        if (bl2 || bl) {
            this.throwConflictException(sequenceGenerator, sequenceGenerator2);
        }
    }

    void checkForConflict(SequenceGenerator sequenceGenerator, TableGenerator tableGenerator) {
        this.checkForConflict(tableGenerator, sequenceGenerator);
    }

    void checkForConflict(TableGenerator tableGenerator, SequenceGenerator sequenceGenerator) {
        boolean bl = tableGenerator.name().equals(sequenceGenerator.name());
        boolean bl2 = tableGenerator.pkColumnValue().equals(sequenceGenerator.sequenceName());
        if (bl || bl2) {
            this.throwConflictException(tableGenerator, sequenceGenerator);
        }
    }

    void checkForConflict(Id id, Id id2) {
        GeneratorType generatorType;
        if (!id.generator().equals(id2.generator())) {
            return;
        }
        if (id.generator().equals("")) {
            return;
        }
        GeneratorType generatorType2 = id.generate();
        if (generatorType2.equals((Object)(generatorType = id2.generate()))) {
            return;
        }
        if (generatorType2.equals((Object)GeneratorType.IDENTITY) && generatorType.equals((Object)GeneratorType.SEQUENCE) || generatorType.equals((Object)GeneratorType.IDENTITY) && generatorType2.equals((Object)GeneratorType.SEQUENCE)) {
            return;
        }
        this.throwConflictException(id, id2);
    }

    void throwConflictException(Object object, Object object2) {
        throw ValidationException.annotationsConflict(this.getFullName(object), this.getFullName(object2));
    }

    String getFullName(Object object) {
        return SequencingProcessor.getFullName(this.m_annotatedElements.get(object), object);
    }

    static String getFullName(AnnotatedElement annotatedElement, Object object) {
        return annotatedElement.toString() + object.toString();
    }
}

