/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.annotations;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.toplink.descriptors.VersionLockingPolicy;
import oracle.toplink.internal.annotations.Accessor;
import oracle.toplink.internal.annotations.CBListener;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.DatabaseTable;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.publicinterface.Descriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptorMetadata {
    private Class m_pkClass;
    private Descriptor m_descriptor;
    private String m_idAttributeName;
    private String m_primaryTableName;
    private Class m_inheritanceParent;
    private boolean m_accessUsingMethods;
    private boolean m_ignoreIDAnnotations;
    private boolean m_ignoreTableAnnotations;
    private boolean m_ignoreInheritanceAnnotations;
    private String m_embeddedIdAttributeName;
    private Hashtable<String, Class> m_pkClassIDs;
    private Hashtable<String, String> m_namedQueries;
    private Hashtable<String, String> m_setMethodNames;
    private HashSet<Accessor> m_relationshipAccessors;

    public DescriptorMetadata(Class clazz) {
        this.init();
        this.m_descriptor = new Descriptor();
        this.m_descriptor.setJavaClass(clazz);
    }

    public DescriptorMetadata(Descriptor descriptor) {
        this.init();
        this.m_descriptor = descriptor;
    }

    private void init() {
        this.m_accessUsingMethods = true;
        this.m_ignoreIDAnnotations = false;
        this.m_ignoreTableAnnotations = false;
        this.m_ignoreInheritanceAnnotations = false;
        this.m_pkClassIDs = new Hashtable();
        this.m_namedQueries = new Hashtable();
        this.m_setMethodNames = new Hashtable();
        this.m_relationshipAccessors = new HashSet();
    }

    public boolean accessUsingMethods() {
        return this.m_accessUsingMethods;
    }

    public void addClassIndicator(Class clazz, String string) {
        this.m_descriptor.getInheritancePolicy().addClassIndicator(clazz, string);
    }

    public void addListener(CBListener cBListener) {
        this.m_descriptor.getEventManager().addListener(cBListener);
    }

    public void addMapping(DatabaseMapping databaseMapping) {
        this.m_descriptor.addMapping(databaseMapping);
    }

    public void addMultipleTableForeignKeyFieldName(String string, String string2) {
        this.m_descriptor.addMultipleTableForeignKeyFieldName(string, string2);
    }

    public void addMultipleTablePrimaryKeyFieldName(String string, String string2) {
        this.m_descriptor.addMultipleTablePrimaryKeyFieldName(string, string2);
    }

    public void addNamedQuery(String string, String string2) {
        this.m_namedQueries.put(string, string2);
    }

    public void addPKClassId(String string, Class clazz) {
        this.m_pkClassIDs.put(string, clazz);
    }

    public void addPrimaryKeyFieldName(String string) {
        this.m_descriptor.addPrimaryKeyFieldName(string);
    }

    public void addTableName(String string) {
        this.m_descriptor.addTableName(string);
    }

    public void addRelationshipAccessor(Accessor accessor) {
        this.m_relationshipAccessors.add(accessor);
    }

    public void addSetMethodName(String string, String string2) {
        this.m_setMethodNames.put(string, string2);
    }

    public String getAlias() {
        return this.m_descriptor.getAlias();
    }

    public Descriptor getDescriptor() {
        return this.m_descriptor;
    }

    public String getIdAttributeName() {
        return this.m_idAttributeName;
    }

    public Class getInheritanceParent() {
        return this.m_inheritanceParent;
    }

    public Class getJavaClass() {
        return this.m_descriptor.getJavaClass();
    }

    public Vector getMappings() {
        return this.m_descriptor.getMappings();
    }

    public DatabaseMapping getMappingForAttributeName(String string) {
        return this.m_descriptor.getMappingForAttributeName(string);
    }

    public Hashtable<String, String> getNamedQueries() {
        return this.m_namedQueries;
    }

    public Class getPKClass() {
        return this.m_pkClass;
    }

    public Vector<String> getPrimaryKeyFieldNames() {
        return this.m_descriptor.getPrimaryKeyFieldNames();
    }

    public List<DatabaseField> getPrimaryKeyFields() {
        return this.m_descriptor.getPrimaryKeyFields();
    }

    public String getPrimaryTableName() {
        Vector vector = this.m_descriptor.getTables();
        if (this.m_primaryTableName == null && !vector.isEmpty()) {
            this.m_primaryTableName = ((DatabaseTable)vector.firstElement()).getQualifiedName();
        }
        return this.m_primaryTableName;
    }

    public HashSet<Accessor> getRelationshipAccessors() {
        return this.m_relationshipAccessors;
    }

    public String getSetMethodName(String string) {
        return this.m_setMethodNames.get(string);
    }

    public boolean isDescriptorEmbbedable() {
        return this.m_descriptor.isAggregateDescriptor();
    }

    public boolean isPKAttribute(String string, Class clazz) {
        Class clazz2;
        if (this.m_pkClassIDs.containsKey(string) && (clazz2 = this.m_pkClassIDs.get(string)) == clazz) {
            this.m_pkClassIDs.remove(string);
            return true;
        }
        return false;
    }

    public String getEmbeddedIdAttributeName() {
        return this.m_embeddedIdAttributeName;
    }

    public boolean hasEmbeddedIdAttribute() {
        return this.m_embeddedIdAttributeName != null;
    }

    public boolean hasIdAttribute() {
        return this.m_idAttributeName != null;
    }

    public boolean hasMappingForAttributeName(String string) {
        return this.m_descriptor.getMappingForAttributeName(string) != null;
    }

    public boolean hasPKClass() {
        return this.m_pkClass != null;
    }

    public boolean hasPrimaryKeyFieldNames() {
        return this.m_descriptor.getPrimaryKeyFieldNames().size() > 0;
    }

    public boolean hasTableNames() {
        return this.m_descriptor.getTableNames().size() > 0;
    }

    public void setAccessUsingMethods(boolean bl) {
        this.m_accessUsingMethods = bl;
    }

    public void setAlias(String string) {
        this.m_descriptor.setAlias(string);
    }

    public void setClassIndicatorFieldName(String string) {
        this.m_descriptor.getInheritancePolicy().setClassIndicatorFieldName(string);
    }

    public void setDescriptor(Descriptor descriptor) {
        this.m_descriptor = descriptor;
    }

    public void setDescriptorIsEmbeddable() {
        this.m_descriptor.descriptorIsAggregate();
    }

    public void setEmbeddedIdAttributeName(String string) {
        this.m_embeddedIdAttributeName = string;
    }

    public void setIdAttributeName(String string) {
        this.m_idAttributeName = string;
    }

    public void setOptimisticLockingPolicy(String string) {
        VersionLockingPolicy versionLockingPolicy = new VersionLockingPolicy();
        versionLockingPolicy.setWriteLockFieldName(string);
        versionLockingPolicy.storeInObject();
        this.m_descriptor.setOptimisticLockingPolicy(versionLockingPolicy);
    }

    public void setParentClass(Class clazz) {
        this.m_descriptor.getInheritancePolicy().setParentClass(clazz);
    }

    public void setPKClass(Class clazz) {
        this.m_pkClass = clazz;
    }

    public void setPrimaryKeyFieldNames(Vector vector) {
        this.m_descriptor.setPrimaryKeyFieldNames(vector);
    }

    public void setPrimaryTableName(String string) {
        this.addTableName(string);
        this.m_primaryTableName = string;
    }

    public void setIgnoreFlags() {
        this.m_ignoreIDAnnotations = this.hasPrimaryKeyFieldNames();
        this.m_ignoreTableAnnotations = this.hasTableNames();
        this.m_ignoreInheritanceAnnotations = this.m_descriptor.hasInheritance();
    }

    public void setInheritanceParent(Class clazz) {
        this.m_inheritanceParent = clazz;
    }

    public boolean ignoreIDAnnotations() {
        return this.m_ignoreIDAnnotations;
    }

    public boolean ignoreInheritanceAnnotations() {
        return this.m_ignoreInheritanceAnnotations;
    }

    public boolean ignoreTableAnnotations() {
        return this.m_ignoreTableAnnotations;
    }

    public boolean usesOptimisticLocking() {
        return this.m_descriptor.usesOptimisticLocking();
    }

    public boolean validatedPKClass() {
        return this.m_pkClassIDs.size() == 0;
    }
}

