/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.expressions;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.expressions.ExpressionJavaPrinter;
import oracle.toplink.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.internal.expressions.ObjectExpression;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.DatabaseTable;
import oracle.toplink.internal.helper.JavaPlatform;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.security.PrivilegedAccessController;

public class ExpressionOperator
implements Serializable {
    static final long serialVersionUID = -7066100204792043980L;
    protected int selector;
    protected String[] databaseStrings;
    protected boolean isPrefix = false;
    protected boolean isRepeating = false;
    protected Class nodeClass;
    protected int type = 5;
    protected int[] argumentIndices = null;
    protected static Hashtable allOperators;
    protected static Hashtable platformOperatorNames;
    protected String[] javaStrings;
    public static final int LogicalOperator = 1;
    public static final int ComparisonOperator = 2;
    public static final int AggregateOperator = 3;
    public static final int OrderOperator = 4;
    public static final int FunctionOperator = 5;
    public static final int And = 1;
    public static final int Or = 2;
    public static final int Not = 3;
    public static final int Equal = 4;
    public static final int NotEqual = 5;
    public static final int EqualOuterJoin = 6;
    public static final int LessThan = 7;
    public static final int LessThanEqual = 8;
    public static final int GreaterThan = 9;
    public static final int GreaterThanEqual = 10;
    public static final int Like = 11;
    public static final int NotLike = 12;
    public static final int In = 13;
    public static final int NotIn = 14;
    public static final int Between = 15;
    public static final int NotBetween = 16;
    public static final int IsNull = 17;
    public static final int NotNull = 18;
    public static final int Exists = 86;
    public static final int NotExists = 88;
    public static final int LikeEscape = 89;
    public static final int Decode = 105;
    public static final int Case = 117;
    public static final int Count = 19;
    public static final int Sum = 20;
    public static final int Average = 21;
    public static final int Maximum = 22;
    public static final int Minimum = 23;
    public static final int StandardDeviation = 24;
    public static final int Variance = 25;
    public static final int Distinct = 87;
    public static final int Ascending = 26;
    public static final int Descending = 27;
    public static final int ToUpperCase = 28;
    public static final int ToLowerCase = 29;
    public static final int Chr = 30;
    public static final int Concat = 31;
    public static final int HexToRaw = 32;
    public static final int Initcap = 33;
    public static final int Instring = 34;
    public static final int Soundex = 35;
    public static final int LeftPad = 36;
    public static final int LeftTrim = 37;
    public static final int Replace = 38;
    public static final int RightPad = 39;
    public static final int RightTrim = 40;
    public static final int Substring = 41;
    public static final int ToNumber = 42;
    public static final int Translate = 43;
    public static final int Trim = 44;
    public static final int Ascii = 45;
    public static final int Length = 46;
    public static final int CharIndex = 96;
    public static final int CharLength = 97;
    public static final int Difference = 98;
    public static final int Reverse = 99;
    public static final int Replicate = 100;
    public static final int Right = 101;
    public static final int Locate = 112;
    public static final int Locate2 = 113;
    public static final int ToChar = 114;
    public static final int ToCharWithFormat = 115;
    public static final int RightTrim2 = 116;
    public static final int AddMonths = 47;
    public static final int DateToString = 48;
    public static final int LastDay = 49;
    public static final int MonthsBetween = 50;
    public static final int NextDay = 51;
    public static final int RoundDate = 52;
    public static final int ToDate = 53;
    public static final int Today = 54;
    public static final int AddDate = 90;
    public static final int DateName = 92;
    public static final int DatePart = 93;
    public static final int DateDifference = 94;
    public static final int TruncateDate = 102;
    public static final int NewTime = 103;
    public static final int Nvl = 104;
    public static final int Ceil = 55;
    public static final int Cos = 56;
    public static final int Cosh = 57;
    public static final int Abs = 58;
    public static final int Acos = 59;
    public static final int Asin = 60;
    public static final int Atan = 61;
    public static final int Exp = 62;
    public static final int Sqrt = 63;
    public static final int Floor = 64;
    public static final int Ln = 65;
    public static final int Log = 66;
    public static final int Mod = 67;
    public static final int Power = 68;
    public static final int Round = 69;
    public static final int Sign = 70;
    public static final int Sin = 71;
    public static final int Sinh = 72;
    public static final int Tan = 73;
    public static final int Tanh = 74;
    public static final int Trunc = 75;
    public static final int Greatest = 76;
    public static final int Least = 77;
    public static final int Add = 78;
    public static final int Subtract = 79;
    public static final int Divide = 80;
    public static final int Multiply = 81;
    public static final int Atan2 = 91;
    public static final int Cot = 95;
    public static final int Deref = 82;
    public static final int Ref = 83;
    public static final int RefToHex = 84;
    public static final int Value = 85;
    public static final int Extract = 106;
    public static final int ExtractValue = 107;
    public static final int ExistsNode = 108;
    public static final int GetStringVal = 109;
    public static final int GetNumberVal = 110;
    public static final int IsFragment = 111;
    static /* synthetic */ Class class$oracle$toplink$internal$expressions$FunctionExpression;

    public ExpressionOperator() {
        this.setNodeClass(ClassConstants.FunctionExpression_Class);
    }

    public ExpressionOperator(int n, Vector vector) {
        this.setNodeClass(ClassConstants.FunctionExpression_Class);
        this.selector = n;
        this.printsAs(vector);
    }

    public static ExpressionOperator abs() {
        return ExpressionOperator.simpleFunction(58, "ABS");
    }

    public static ExpressionOperator acos() {
        return ExpressionOperator.simpleFunction(59, "ACOS");
    }

    public static ExpressionOperator addDate() {
        ExpressionOperator expressionOperator = ExpressionOperator.simpleThreeArgumentFunction(90, "DATEADD");
        int[] nArray = new int[]{1, 2, 0};
        expressionOperator.setArgumentIndices(nArray);
        return expressionOperator;
    }

    public static ExpressionOperator addMonths() {
        return ExpressionOperator.simpleTwoArgumentFunction(47, "ADD_MONTHS");
    }

    public static void addOperator(ExpressionOperator expressionOperator) {
        allOperators.put(new Integer(expressionOperator.getSelector()), expressionOperator);
    }

    public static ExpressionOperator and() {
        return ExpressionOperator.simpleLogical(1, "AND", "and");
    }

    public Object applyFunction(Object object, Vector vector) {
        if (object instanceof String) {
            if (this.getSelector() == 28) {
                return ((String)object).toUpperCase();
            }
            if (this.getSelector() == 29) {
                return ((String)object).toLowerCase();
            }
            if (this.getSelector() == 31 && vector.size() == 1 && vector.elementAt(0) instanceof String) {
                return ((String)object).concat((String)vector.elementAt(0));
            }
            if (this.getSelector() == 41 && vector.size() == 2 && vector.elementAt(0) instanceof Number && vector.elementAt(1) instanceof Number) {
                return ((String)object).substring(((Number)vector.elementAt(0)).intValue(), ((Number)vector.elementAt(1)).intValue());
            }
            if (this.getSelector() == 42) {
                return new BigDecimal((String)object);
            }
            if (this.getSelector() == 44) {
                return ((String)object).trim();
            }
            if (this.getSelector() == 46) {
                return new Integer(((String)object).length());
            }
        } else if (object instanceof Number) {
            if (this.getSelector() == 55) {
                return new Double(Math.ceil(((Number)object).doubleValue()));
            }
            if (this.getSelector() == 56) {
                return new Double(Math.cos(((Number)object).doubleValue()));
            }
            if (this.getSelector() == 58) {
                return new Double(Math.abs(((Number)object).doubleValue()));
            }
            if (this.getSelector() == 59) {
                return new Double(Math.acos(((Number)object).doubleValue()));
            }
            if (this.getSelector() == 60) {
                return new Double(Math.asin(((Number)object).doubleValue()));
            }
            if (this.getSelector() == 61) {
                return new Double(Math.atan(((Number)object).doubleValue()));
            }
            if (this.getSelector() == 62) {
                return new Double(Math.exp(((Number)object).doubleValue()));
            }
            if (this.getSelector() == 63) {
                return new Double(Math.sqrt(((Number)object).doubleValue()));
            }
            if (this.getSelector() == 64) {
                return new Double(Math.floor(((Number)object).doubleValue()));
            }
            if (this.getSelector() == 66) {
                return new Double(Math.log(((Number)object).doubleValue()));
            }
            if (this.getSelector() == 68 && vector.size() == 1 && vector.elementAt(0) instanceof Number) {
                return new Double(Math.pow(((Number)object).doubleValue(), ((Number)vector.elementAt(0)).doubleValue()));
            }
            if (this.getSelector() == 69) {
                return new Double(Math.round(((Number)object).doubleValue()));
            }
            if (this.getSelector() == 71) {
                return new Double(Math.sin(((Number)object).doubleValue()));
            }
            if (this.getSelector() == 73) {
                return new Double(Math.tan(((Number)object).doubleValue()));
            }
            if (this.getSelector() == 76 && vector.size() == 1 && vector.elementAt(0) instanceof Number) {
                return new Double(Math.max(((Number)object).doubleValue(), ((Number)vector.elementAt(0)).doubleValue()));
            }
            if (this.getSelector() == 77 && vector.size() == 1 && vector.elementAt(0) instanceof Number) {
                return new Double(Math.min(((Number)object).doubleValue(), ((Number)vector.elementAt(0)).doubleValue()));
            }
            if (this.getSelector() == 78 && vector.size() == 1 && vector.elementAt(0) instanceof Number) {
                return new Double(((Number)object).doubleValue() + ((Number)vector.elementAt(0)).doubleValue());
            }
            if (this.getSelector() == 79 && vector.size() == 1 && vector.elementAt(0) instanceof Number) {
                return new Double(((Number)object).doubleValue() - ((Number)vector.elementAt(0)).doubleValue());
            }
            if (this.getSelector() == 80 && vector.size() == 1 && vector.elementAt(0) instanceof Number) {
                return new Double(((Number)object).doubleValue() / ((Number)vector.elementAt(0)).doubleValue());
            }
            if (this.getSelector() == 81 && vector.size() == 1 && vector.elementAt(0) instanceof Number) {
                return new Double(((Number)object).doubleValue() * ((Number)vector.elementAt(0)).doubleValue());
            }
        }
        throw QueryException.cannotConformExpression();
    }

    public static ExpressionOperator ascending() {
        return ExpressionOperator.simpleOrdering(26, "ASC", "ascending");
    }

    public static ExpressionOperator ascii() {
        return ExpressionOperator.simpleFunction(45, "ASCII");
    }

    public static ExpressionOperator asin() {
        return ExpressionOperator.simpleFunction(60, "ASIN");
    }

    public static ExpressionOperator atan() {
        return ExpressionOperator.simpleFunction(61, "ATAN");
    }

    public static ExpressionOperator average() {
        return ExpressionOperator.simpleAggregate(21, "AVG", "average");
    }

    public void bePostfix() {
        this.isPrefix = false;
    }

    public void bePrefix() {
        this.isPrefix = true;
    }

    public void beRepeating() {
        this.isRepeating = true;
    }

    public static ExpressionOperator between() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setSelector(15);
        expressionOperator.setType(2);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        ((Vector)nonSynchronizedVector).addElement("(");
        ((Vector)nonSynchronizedVector).addElement(" BETWEEN ");
        ((Vector)nonSynchronizedVector).addElement(" AND ");
        ((Vector)nonSynchronizedVector).addElement(")");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator caseStatement() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(117);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(class$oracle$toplink$internal$expressions$FunctionExpression == null ? (class$oracle$toplink$internal$expressions$FunctionExpression = ExpressionOperator.class$("oracle.toplink.internal.expressions.FunctionExpression")) : class$oracle$toplink$internal$expressions$FunctionExpression);
        return expressionOperator;
    }

    public static ExpressionOperator ceil() {
        return ExpressionOperator.simpleFunction(55, "CEIL");
    }

    public static ExpressionOperator charIndex() {
        return ExpressionOperator.simpleTwoArgumentFunction(96, "CHARINDEX");
    }

    public static ExpressionOperator charLength() {
        return ExpressionOperator.simpleFunction(97, "CHAR_LENGTH");
    }

    public static ExpressionOperator chr() {
        return ExpressionOperator.simpleFunction(30, "CHR");
    }

    public static ExpressionOperator concat() {
        return ExpressionOperator.simpleMath(31, "+");
    }

    public boolean conformBetween(Object object, Object object2) {
        Object e = ((Vector)object2).elementAt(0);
        Object e2 = ((Vector)object2).elementAt(1);
        if (object == null || e == null || e2 == null) {
            return false;
        }
        if (object instanceof Number && e instanceof Number && e2 instanceof Number) {
            return ((Number)object).doubleValue() >= ((Number)e).doubleValue() && ((Number)object).doubleValue() <= ((Number)e2).doubleValue();
        }
        if (object instanceof String && e instanceof String && e2 instanceof String) {
            return !(((String)object).compareTo((String)e) <= 0 && ((String)object).compareTo((String)e) != 0 || ((String)object).compareTo((String)e2) >= 0 && ((String)object).compareTo((String)e2) != 0);
        }
        if (object instanceof Date && e instanceof Date && e2 instanceof Date) {
            return !(!((Date)object).after((Date)e) && !((Date)object).equals((Date)e) || !((Date)object).before((Date)e2) && !((Date)object).equals((Date)e2));
        }
        throw QueryException.cannotConformExpression();
    }

    public boolean conformLike(Object object, Object object2) {
        if (object2 == null && object == null) {
            return true;
        }
        if (!(object2 instanceof String) || !(object instanceof String)) {
            throw QueryException.cannotConformExpression();
        }
        String string = (String)object2;
        if (string.indexOf("_") != -1) {
            throw QueryException.cannotConformExpression();
        }
        String string2 = (String)object;
        if (string.indexOf("%") == -1) {
            return object.equals(object2);
        }
        boolean bl = !string.startsWith("%");
        boolean bl2 = !string.endsWith("%");
        StringTokenizer stringTokenizer = new StringTokenizer(string, "%");
        int n = 0;
        String string3 = null;
        if (bl && !string2.startsWith(string3 = stringTokenizer.nextToken())) {
            return false;
        }
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            n = string2.indexOf(string3, n);
            if (n >= 0) continue;
            return false;
        }
        if (bl2) {
            return string2.endsWith(string3);
        }
        return true;
    }

    public static ExpressionOperator cos() {
        return ExpressionOperator.simpleFunction(56, "COS");
    }

    public static ExpressionOperator cosh() {
        return ExpressionOperator.simpleFunction(57, "COSH");
    }

    public static ExpressionOperator cot() {
        return ExpressionOperator.simpleFunction(95, "COT");
    }

    public static ExpressionOperator count() {
        return ExpressionOperator.simpleAggregate(19, "COUNT", "count");
    }

    public static ExpressionOperator dateDifference() {
        return ExpressionOperator.simpleThreeArgumentFunction(94, "DATEDIFF");
    }

    public static ExpressionOperator dateName() {
        return ExpressionOperator.simpleTwoArgumentFunction(92, "DATENAME");
    }

    public static ExpressionOperator oracleDateName() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(92);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(3);
        ((Vector)nonSynchronizedVector).addElement("TO_CHAR(");
        ((Vector)nonSynchronizedVector).addElement(", '");
        ((Vector)nonSynchronizedVector).addElement("')");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        int[] nArray = new int[]{1, 0};
        expressionOperator.setArgumentIndices(nArray);
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator datePart() {
        return ExpressionOperator.simpleTwoArgumentFunction(93, "DATEPART");
    }

    public static ExpressionOperator dateToString() {
        return ExpressionOperator.simpleFunction(48, "TO_CHAR");
    }

    public static ExpressionOperator toChar() {
        return ExpressionOperator.simpleFunction(114, "TO_CHAR");
    }

    public static ExpressionOperator toCharWithFormat() {
        return ExpressionOperator.simpleTwoArgumentFunction(115, "TO_CHAR");
    }

    public static ExpressionOperator decode() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setSelector(105);
        expressionOperator.setNodeClass(class$oracle$toplink$internal$expressions$FunctionExpression == null ? (class$oracle$toplink$internal$expressions$FunctionExpression = ExpressionOperator.class$("oracle.toplink.internal.expressions.FunctionExpression")) : class$oracle$toplink$internal$expressions$FunctionExpression);
        expressionOperator.setType(5);
        expressionOperator.bePrefix();
        return expressionOperator;
    }

    public static ExpressionOperator deref() {
        return ExpressionOperator.simpleFunction(82, "DEREF");
    }

    public static ExpressionOperator descending() {
        return ExpressionOperator.simpleOrdering(27, "DESC", "descending");
    }

    public static ExpressionOperator difference() {
        return ExpressionOperator.simpleTwoArgumentFunction(98, "DIFFERENCE");
    }

    public static ExpressionOperator distinct() {
        return ExpressionOperator.simpleFunction(87, "DISTINCT", "distinct");
    }

    public boolean doesRelationConform(Object object, Object object2) {
        if (this.getSelector() == 4) {
            if (object == null && object2 == null) {
                return true;
            }
            if (object == null || object2 == null) {
                return false;
            }
            if (object instanceof Number && object2 instanceof Number && object.getClass() != object2.getClass()) {
                return ((Number)object).doubleValue() == ((Number)object2).doubleValue();
            }
            return object.equals(object2);
        }
        if (this.getSelector() == 5) {
            if (object == null && object2 == null) {
                return false;
            }
            if (object == null || object2 == null) {
                return true;
            }
            return !object.equals(object2);
        }
        if (this.getSelector() == 17) {
            return object == null;
        }
        if (this.getSelector() == 18) {
            return object != null;
        }
        if (this.getSelector() == 7) {
            if (object == null || object2 == null) {
                return false;
            }
            if (object instanceof Number && object2 instanceof Number) {
                return ((Number)object).doubleValue() < ((Number)object2).doubleValue();
            }
            if (object instanceof String && object2 instanceof String) {
                return ((String)object).compareTo((String)object2) < 0;
            }
            if (object instanceof Date && object2 instanceof Date) {
                return ((Date)object).before((Date)object2);
            }
        } else if (this.getSelector() == 8) {
            if (object == null && object2 == null) {
                return true;
            }
            if (object == null || object2 == null) {
                return false;
            }
            if (object instanceof Number && object2 instanceof Number) {
                return ((Number)object).doubleValue() <= ((Number)object2).doubleValue();
            }
            if (object instanceof String && object2 instanceof String) {
                int n = ((String)object).compareTo((String)object2);
                return n < 0 || n == 0;
            }
            if (object instanceof Date && object2 instanceof Date) {
                return ((Date)object).equals((Date)object2) || ((Date)object).before((Date)object2);
            }
        } else if (this.getSelector() == 9) {
            if (object == null || object2 == null) {
                return false;
            }
            if (object instanceof Number && object2 instanceof Number) {
                return ((Number)object).doubleValue() > ((Number)object2).doubleValue();
            }
            if (object instanceof String && object2 instanceof String) {
                int n = ((String)object).compareTo((String)object2);
                return n > 0;
            }
            if (object instanceof Date && object2 instanceof Date) {
                return ((Date)object).after((Date)object2);
            }
        } else if (this.getSelector() == 10) {
            if (object == null && object2 == null) {
                return true;
            }
            if (object == null || object2 == null) {
                return false;
            }
            if (object instanceof Number && object2 instanceof Number) {
                return ((Number)object).doubleValue() >= ((Number)object2).doubleValue();
            }
            if (object instanceof String && object2 instanceof String) {
                int n = ((String)object).compareTo((String)object2);
                return n > 0 || n == 0;
            }
            if (object instanceof Date && object2 instanceof Date) {
                return ((Date)object).equals((Date)object2) || ((Date)object).after((Date)object2);
            }
        } else {
            if (this.getSelector() == 15 && object2 instanceof Vector && ((Vector)object2).size() == 2) {
                return this.conformBetween(object, object2);
            }
            if (this.getSelector() == 16 && object2 instanceof Vector && ((Vector)object2).size() == 2) {
                return !this.conformBetween(object, object2);
            }
            if (this.getSelector() == 13 && object2 instanceof Vector) {
                return ((Vector)object2).contains(object);
            }
            if (this.getSelector() == 14 && object2 instanceof Vector) {
                return !((Vector)object2).contains(object);
            }
            if (this.getSelector() == 11 || this.getSelector() == 12) {
                int n = JavaPlatform.conformLike(object, object2);
                if (n == 1) {
                    return this.getSelector() == 11;
                }
                if (n == 0) {
                    return this.getSelector() != 11;
                }
            }
        }
        throw QueryException.cannotConformExpression();
    }

    public static ExpressionOperator equalOuterJoin() {
        return ExpressionOperator.simpleRelation(6, "=*");
    }

    public boolean equals(Object object) {
        if (!(object instanceof ExpressionOperator)) {
            return false;
        }
        return this.getSelector() == ((ExpressionOperator)object).getSelector();
    }

    public int hashCode() {
        return this.getSelector();
    }

    public static ExpressionOperator exists() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(86);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement("EXISTS ");
        ((Vector)nonSynchronizedVector).addElement(" ");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator exp() {
        return ExpressionOperator.simpleFunction(62, "EXP");
    }

    public Expression expressionFor(Expression expression) {
        return this.expressionForArguments(expression, NonSynchronizedVector.newInstance(0));
    }

    public Expression expressionFor(Expression expression, Object object) {
        return this.newExpressionForArgument(expression, object);
    }

    public Expression expressionForArguments(Expression expression, Vector vector) {
        return this.newExpressionForArguments(expression, vector);
    }

    public static ExpressionOperator extract() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        ((Vector)nonSynchronizedVector).addElement("extract(");
        ((Vector)nonSynchronizedVector).addElement(",");
        ((Vector)nonSynchronizedVector).addElement(")");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setSelector(106);
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator extractValue() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        ((Vector)nonSynchronizedVector).addElement("extractValue(");
        ((Vector)nonSynchronizedVector).addElement(",");
        ((Vector)nonSynchronizedVector).addElement(")");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setSelector(107);
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator existsNode() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        ((Vector)nonSynchronizedVector).addElement("existsNode(");
        ((Vector)nonSynchronizedVector).addElement(",");
        ((Vector)nonSynchronizedVector).addElement(")");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setSelector(108);
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator getStringVal() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        ((Vector)nonSynchronizedVector).addElement(".getStringVal()");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePostfix();
        expressionOperator.setSelector(109);
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator getNumberVal() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        ((Vector)nonSynchronizedVector).addElement(".getNumberVal()");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePostfix();
        expressionOperator.setSelector(110);
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator isFragment() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        ((Vector)nonSynchronizedVector).addElement(".isFragment()");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePostfix();
        expressionOperator.setSelector(111);
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator floor() {
        return ExpressionOperator.simpleFunction(64, "FLOOR");
    }

    public static synchronized Hashtable getAllOperators() {
        if (allOperators == null) {
            ExpressionOperator.initializeOperators();
        }
        return allOperators;
    }

    public String[] getDatabaseStrings() {
        return this.databaseStrings;
    }

    public String[] getJavaStrings() {
        return this.javaStrings;
    }

    public Class getNodeClass() {
        return this.nodeClass;
    }

    public static ExpressionOperator getOperator(Integer n) {
        return (ExpressionOperator)ExpressionOperator.getAllOperators().get(n);
    }

    public int getSelector() {
        return this.selector;
    }

    public int getType() {
        return this.type;
    }

    public static ExpressionOperator greatest() {
        return ExpressionOperator.simpleTwoArgumentFunction(76, "GREATEST");
    }

    public static ExpressionOperator hexToRaw() {
        return ExpressionOperator.simpleFunction(32, "HEXTORAW");
    }

    public static ExpressionOperator ifNull() {
        return ExpressionOperator.simpleTwoArgumentFunction(104, "NVL");
    }

    public static ExpressionOperator in() {
        return ExpressionOperator.simpleRelation(13, "IN");
    }

    public static ExpressionOperator initcap() {
        return ExpressionOperator.simpleFunction(33, "INITCAP");
    }

    protected static void initializeAggregateFunctionOperators() {
        ExpressionOperator.addOperator(ExpressionOperator.count());
        ExpressionOperator.addOperator(ExpressionOperator.sum());
        ExpressionOperator.addOperator(ExpressionOperator.average());
        ExpressionOperator.addOperator(ExpressionOperator.minimum());
        ExpressionOperator.addOperator(ExpressionOperator.maximum());
        ExpressionOperator.addOperator(ExpressionOperator.variance());
        ExpressionOperator.addOperator(ExpressionOperator.standardDeviation());
        ExpressionOperator.addOperator(ExpressionOperator.distinct());
    }

    protected static void initializeFunctionOperators() {
        ExpressionOperator.addOperator(ExpressionOperator.notOperator());
        ExpressionOperator.addOperator(ExpressionOperator.ascending());
        ExpressionOperator.addOperator(ExpressionOperator.descending());
    }

    protected static void initializeLogicalOperators() {
        ExpressionOperator.addOperator(ExpressionOperator.and());
        ExpressionOperator.addOperator(ExpressionOperator.or());
        ExpressionOperator.addOperator(ExpressionOperator.isNull());
        ExpressionOperator.addOperator(ExpressionOperator.notNull());
    }

    public static Hashtable initializeOperators() {
        ExpressionOperator.resetOperators();
        ExpressionOperator.initializeFunctionOperators();
        ExpressionOperator.initializeRelationOperators();
        ExpressionOperator.initializeLogicalOperators();
        ExpressionOperator.initializeAggregateFunctionOperators();
        return allOperators;
    }

    public static String getPlatformOperatorName(int n) {
        String string = (String)ExpressionOperator.getPlatformOperatorNames().get(new Integer(n));
        if (string == null) {
            string = String.valueOf(n);
        }
        return string;
    }

    public static synchronized Hashtable getPlatformOperatorNames() {
        if (platformOperatorNames == null) {
            platformOperatorNames = new Hashtable();
            platformOperatorNames.put(new Integer(28), "ToUpperCase");
            platformOperatorNames.put(new Integer(29), "ToLowerCase");
            platformOperatorNames.put(new Integer(30), "Chr");
            platformOperatorNames.put(new Integer(31), "Concat");
            platformOperatorNames.put(new Integer(32), "HexToRaw");
            platformOperatorNames.put(new Integer(33), "Initcap");
            platformOperatorNames.put(new Integer(34), "Instring");
            platformOperatorNames.put(new Integer(35), "Soundex");
            platformOperatorNames.put(new Integer(36), "LeftPad");
            platformOperatorNames.put(new Integer(37), "LeftTrim");
            platformOperatorNames.put(new Integer(39), "RightPad");
            platformOperatorNames.put(new Integer(40), "RightTrim");
            platformOperatorNames.put(new Integer(41), "Substring");
            platformOperatorNames.put(new Integer(43), "Translate");
            platformOperatorNames.put(new Integer(45), "Ascii");
            platformOperatorNames.put(new Integer(46), "Length");
            platformOperatorNames.put(new Integer(96), "CharIndex");
            platformOperatorNames.put(new Integer(97), "CharLength");
            platformOperatorNames.put(new Integer(98), "Difference");
            platformOperatorNames.put(new Integer(99), "Reverse");
            platformOperatorNames.put(new Integer(100), "Replicate");
            platformOperatorNames.put(new Integer(101), "Right");
            platformOperatorNames.put(new Integer(112), "Locate");
            platformOperatorNames.put(new Integer(113), "Locate");
            platformOperatorNames.put(new Integer(42), "ToNumber");
            platformOperatorNames.put(new Integer(114), "ToChar");
            platformOperatorNames.put(new Integer(115), "ToChar");
            platformOperatorNames.put(new Integer(47), "AddMonths");
            platformOperatorNames.put(new Integer(48), "DateToString");
            platformOperatorNames.put(new Integer(50), "MonthsBetween");
            platformOperatorNames.put(new Integer(51), "NextDay");
            platformOperatorNames.put(new Integer(52), "RoundDate");
            platformOperatorNames.put(new Integer(90), "AddDate");
            platformOperatorNames.put(new Integer(92), "DateName");
            platformOperatorNames.put(new Integer(93), "DatePart");
            platformOperatorNames.put(new Integer(94), "DateDifference");
            platformOperatorNames.put(new Integer(102), "TruncateDate");
            platformOperatorNames.put(new Integer(103), "NewTime");
            platformOperatorNames.put(new Integer(104), "Nvl");
            platformOperatorNames.put(new Integer(103), "NewTime");
            platformOperatorNames.put(new Integer(55), "Ceil");
            platformOperatorNames.put(new Integer(56), "Cos");
            platformOperatorNames.put(new Integer(57), "Cosh");
            platformOperatorNames.put(new Integer(58), "Abs");
            platformOperatorNames.put(new Integer(59), "Acos");
            platformOperatorNames.put(new Integer(60), "Asin");
            platformOperatorNames.put(new Integer(61), "Atan");
            platformOperatorNames.put(new Integer(62), "Exp");
            platformOperatorNames.put(new Integer(63), "Sqrt");
            platformOperatorNames.put(new Integer(64), "Floor");
            platformOperatorNames.put(new Integer(65), "Ln");
            platformOperatorNames.put(new Integer(66), "Log");
            platformOperatorNames.put(new Integer(67), "Mod");
            platformOperatorNames.put(new Integer(68), "Power");
            platformOperatorNames.put(new Integer(69), "Round");
            platformOperatorNames.put(new Integer(70), "Sign");
            platformOperatorNames.put(new Integer(71), "Sin");
            platformOperatorNames.put(new Integer(72), "Sinh");
            platformOperatorNames.put(new Integer(73), "Tan");
            platformOperatorNames.put(new Integer(74), "Tanh");
            platformOperatorNames.put(new Integer(75), "Trunc");
            platformOperatorNames.put(new Integer(76), "Greatest");
            platformOperatorNames.put(new Integer(77), "Least");
            platformOperatorNames.put(new Integer(78), "Add");
            platformOperatorNames.put(new Integer(79), "Subtract");
            platformOperatorNames.put(new Integer(80), "Divide");
            platformOperatorNames.put(new Integer(81), "Multiply");
            platformOperatorNames.put(new Integer(91), "Atan2");
            platformOperatorNames.put(new Integer(95), "Cot");
            platformOperatorNames.put(new Integer(82), "Deref");
            platformOperatorNames.put(new Integer(83), "Ref");
            platformOperatorNames.put(new Integer(84), "RefToHex");
            platformOperatorNames.put(new Integer(85), "Value");
            platformOperatorNames.put(new Integer(106), "Extract");
            platformOperatorNames.put(new Integer(107), "ExtractValue");
            platformOperatorNames.put(new Integer(108), "ExistsNode");
            platformOperatorNames.put(new Integer(109), "GetStringVal");
            platformOperatorNames.put(new Integer(110), "GetNumberVal");
            platformOperatorNames.put(new Integer(111), "IsFragment");
        }
        return platformOperatorNames;
    }

    protected static void initializeRelationOperators() {
        ExpressionOperator.addOperator(ExpressionOperator.simpleRelation(4, "=", "equal"));
        ExpressionOperator.addOperator(ExpressionOperator.simpleRelation(5, "<>", "notEqual"));
        ExpressionOperator.addOperator(ExpressionOperator.simpleRelation(7, "<", "lessThan"));
        ExpressionOperator.addOperator(ExpressionOperator.simpleRelation(8, "<=", "lessThanEqual"));
        ExpressionOperator.addOperator(ExpressionOperator.simpleRelation(9, ">", "greaterThan"));
        ExpressionOperator.addOperator(ExpressionOperator.simpleRelation(10, ">=", "greaterThanEqual"));
        ExpressionOperator.addOperator(ExpressionOperator.in());
        ExpressionOperator.addOperator(ExpressionOperator.notIn());
        ExpressionOperator.addOperator(ExpressionOperator.like());
        ExpressionOperator.addOperator(ExpressionOperator.likeEscape());
        ExpressionOperator.addOperator(ExpressionOperator.notLike());
        ExpressionOperator.addOperator(ExpressionOperator.between());
        ExpressionOperator.addOperator(ExpressionOperator.exists());
        ExpressionOperator.addOperator(ExpressionOperator.notExists());
    }

    public static ExpressionOperator instring() {
        return ExpressionOperator.simpleTwoArgumentFunction(34, "INSTR");
    }

    public boolean isAggregateOperator() {
        return this.getType() == 3;
    }

    public boolean isComparisonOperator() {
        return this.getType() == 2;
    }

    public boolean isComplete() {
        return this.databaseStrings != null && this.databaseStrings.length != 0;
    }

    public boolean isFunctionOperator() {
        return this.getType() == 5;
    }

    public boolean isLogicalOperator() {
        return this.getType() == 1;
    }

    public static ExpressionOperator isNull() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(2);
        expressionOperator.setSelector(17);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        ((Vector)nonSynchronizedVector).addElement("(");
        ((Vector)nonSynchronizedVector).addElement(" IS NULL)");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.printsJavaAs(".isNull()");
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public boolean isOrderOperator() {
        return this.getType() == 4;
    }

    public boolean isPrefix() {
        return this.isPrefix;
    }

    public static ExpressionOperator lastDay() {
        return ExpressionOperator.simpleFunction(49, "LAST_DAY");
    }

    public static ExpressionOperator least() {
        return ExpressionOperator.simpleTwoArgumentFunction(77, "LEAST");
    }

    public static ExpressionOperator leftPad() {
        return ExpressionOperator.simpleThreeArgumentFunction(36, "LPAD");
    }

    public static ExpressionOperator leftTrim() {
        return ExpressionOperator.simpleFunction(37, "LTRIM");
    }

    public static ExpressionOperator length() {
        return ExpressionOperator.simpleFunction(46, "LENGTH");
    }

    public static ExpressionOperator like() {
        return ExpressionOperator.simpleRelation(11, "LIKE", "like");
    }

    public static ExpressionOperator likeEscape() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setSelector(89);
        expressionOperator.setType(2);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        ((Vector)nonSynchronizedVector).addElement("(");
        ((Vector)nonSynchronizedVector).addElement(" LIKE ");
        ((Vector)nonSynchronizedVector).addElement(" ESCAPE ");
        ((Vector)nonSynchronizedVector).addElement(")");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator ln() {
        return ExpressionOperator.simpleFunction(65, "LN");
    }

    public static ExpressionOperator locate() {
        ExpressionOperator expressionOperator = ExpressionOperator.simpleTwoArgumentFunction(112, "LOCATE");
        int[] nArray = new int[]{1, 0};
        expressionOperator.setArgumentIndices(nArray);
        return expressionOperator;
    }

    public static ExpressionOperator locate2() {
        ExpressionOperator expressionOperator = ExpressionOperator.simpleThreeArgumentFunction(113, "LOCATE");
        int[] nArray = new int[]{1, 0, 2};
        expressionOperator.setArgumentIndices(nArray);
        return expressionOperator;
    }

    public static ExpressionOperator log() {
        return ExpressionOperator.simpleFunction(66, "LOG");
    }

    public static ExpressionOperator maximum() {
        return ExpressionOperator.simpleAggregate(22, "MAX", "maximum");
    }

    public static ExpressionOperator minimum() {
        return ExpressionOperator.simpleAggregate(23, "MIN", "minimum");
    }

    public static ExpressionOperator mod() {
        return ExpressionOperator.simpleTwoArgumentFunction(67, "MOD");
    }

    public static ExpressionOperator monthsBetween() {
        return ExpressionOperator.simpleTwoArgumentFunction(50, "MONTHS_BETWEEN");
    }

    public Expression newExpressionForArgument(Expression expression, Object object) {
        if (this.representsEqualToNull(object)) {
            return expression.isNull();
        }
        if (this.representsNotEqualToNull(object)) {
            return expression.notNull();
        }
        try {
            Expression expression2 = (Expression)PrivilegedAccessController.newInstanceFromClass(this.getNodeClass());
            expression2.create(expression, object, this);
            return expression2;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public Expression newExpressionForArguments(Expression expression, Vector vector) {
        if (this.representsEqualToNull(vector)) {
            return expression.isNull();
        }
        if (this.representsNotEqualToNull(vector)) {
            return expression.notNull();
        }
        try {
            Expression expression2 = (Expression)PrivilegedAccessController.newInstanceFromClass(this.getNodeClass());
            expression2.create(expression, vector, this);
            return expression2;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public static ExpressionOperator newTime() {
        return ExpressionOperator.simpleThreeArgumentFunction(103, "NEW_TIME");
    }

    public static ExpressionOperator nextDay() {
        return ExpressionOperator.simpleTwoArgumentFunction(51, "NEXT_DAY");
    }

    public static ExpressionOperator notExists() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(88);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement("NOT EXISTS ");
        ((Vector)nonSynchronizedVector).addElement(" ");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator notIn() {
        return ExpressionOperator.simpleRelation(14, "NOT IN");
    }

    public static ExpressionOperator notLike() {
        return ExpressionOperator.simpleRelation(12, "NOT LIKE", "notLike");
    }

    public static ExpressionOperator notNull() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(2);
        expressionOperator.setSelector(18);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        ((Vector)nonSynchronizedVector).addElement("(");
        ((Vector)nonSynchronizedVector).addElement(" IS NOT NULL)");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.printsJavaAs(".notNull()");
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator notOperator() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setSelector(3);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        ((Vector)nonSynchronizedVector).addElement("NOT (");
        ((Vector)nonSynchronizedVector).addElement(")");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.printsJavaAs(".not()");
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator or() {
        return ExpressionOperator.simpleLogical(2, "OR", "or");
    }

    public static ExpressionOperator power() {
        return ExpressionOperator.simpleTwoArgumentFunction(68, "POWER");
    }

    public void printCollection(Vector vector, ExpressionSQLPrinter expressionSQLPrinter) {
        int n = 0;
        try {
            if (this.isPrefix()) {
                expressionSQLPrinter.getWriter().write(this.getDatabaseStrings()[0]);
                n = 1;
            } else {
                n = 0;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        for (int i = 0; i < vector.size(); ++i) {
            int n2 = 0;
            n2 = this.argumentIndices == null ? i : this.argumentIndices[i];
            Expression expression = (Expression)vector.elementAt(n2);
            if (this.getSelector() == 83 || this.getSelector() == 82 && expression.isObjectExpression()) {
                DatabaseTable databaseTable = ((ObjectExpression)expression).aliasForTable((DatabaseTable)((ObjectExpression)expression).getDescriptor().getTables().firstElement());
                expressionSQLPrinter.printString(databaseTable.getName());
            } else if (this.getSelector() == 19 && expression.isExpressionBuilder()) {
                expressionSQLPrinter.printString("*");
            } else if (this.getType() == 5) {
                expression.printSQLWithoutConversion(expressionSQLPrinter);
            } else {
                expression.printSQL(expressionSQLPrinter);
            }
            if (n >= this.getDatabaseStrings().length) continue;
            expressionSQLPrinter.printString(this.getDatabaseStrings()[n++]);
        }
    }

    public void printJavaCollection(Vector vector, ExpressionJavaPrinter expressionJavaPrinter) {
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            Expression expression = (Expression)vector.elementAt(i);
            expression.printJava(expressionJavaPrinter);
            if (n >= this.getJavaStrings().length) continue;
            expressionJavaPrinter.printString(this.getJavaStrings()[n++]);
        }
    }

    public void printDuo(Expression expression, Expression expression2, ExpressionSQLPrinter expressionSQLPrinter) {
        int n;
        if (this.isPrefix()) {
            expressionSQLPrinter.printString(this.getDatabaseStrings()[0]);
            n = 1;
        } else {
            n = 0;
        }
        expression.printSQL(expressionSQLPrinter);
        if (n < this.getDatabaseStrings().length) {
            expressionSQLPrinter.printString(this.getDatabaseStrings()[n++]);
        }
        if (expression2 != null) {
            expression2.printSQL(expressionSQLPrinter);
            if (n < this.getDatabaseStrings().length) {
                expressionSQLPrinter.printString(this.getDatabaseStrings()[n++]);
            }
        }
    }

    public void printJavaDuo(Expression expression, Expression expression2, ExpressionJavaPrinter expressionJavaPrinter) {
        int n = 0;
        expression.printJava(expressionJavaPrinter);
        if (n < this.getJavaStrings().length) {
            expressionJavaPrinter.printString(this.getJavaStrings()[n++]);
        }
        if (expression2 != null) {
            expression2.printJava(expressionJavaPrinter);
            if (n < this.getJavaStrings().length) {
                expressionJavaPrinter.printString(this.getJavaStrings()[n]);
            }
        }
    }

    public void printsAs(String string) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(1);
        ((Vector)nonSynchronizedVector).addElement(string);
        this.printsAs(nonSynchronizedVector);
    }

    public void printsAs(Vector vector) {
        this.databaseStrings = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            this.getDatabaseStrings()[i] = (String)vector.elementAt(i);
        }
    }

    public void printsJavaAs(String string) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(1);
        ((Vector)nonSynchronizedVector).addElement(string);
        this.printsJavaAs(nonSynchronizedVector);
    }

    public void printsJavaAs(Vector vector) {
        this.javaStrings = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            this.getJavaStrings()[i] = (String)vector.elementAt(i);
        }
    }

    public static ExpressionOperator ref() {
        return ExpressionOperator.simpleFunction(83, "REF");
    }

    public static ExpressionOperator refToHex() {
        return ExpressionOperator.simpleFunction(84, "REFTOHEX");
    }

    public static ExpressionOperator replace() {
        return ExpressionOperator.simpleThreeArgumentFunction(38, "REPLACE");
    }

    public static ExpressionOperator replicate() {
        return ExpressionOperator.simpleTwoArgumentFunction(100, "REPLICATE");
    }

    public boolean representsEqualToNull(Object object) {
        if (object instanceof Vector) {
            return this.representsEqualToNull((Vector)object);
        }
        return this.getSelector() == 4 && object == null;
    }

    public boolean representsEqualToNull(Vector vector) {
        return this.getSelector() == 4 && vector.size() == 1 && vector.elementAt(0) == null;
    }

    public boolean representsNotEqualToNull(Object object) {
        if (object instanceof Vector) {
            return this.representsNotEqualToNull((Vector)object);
        }
        return this.getSelector() == 5 && object == null;
    }

    public boolean representsNotEqualToNull(Vector vector) {
        return this.getSelector() == 5 && vector.size() == 1 && vector.elementAt(0) == null;
    }

    public static void resetOperators() {
        allOperators = new Hashtable();
    }

    public static ExpressionOperator reverse() {
        return ExpressionOperator.simpleFunction(99, "REVERSE");
    }

    public static ExpressionOperator right() {
        return ExpressionOperator.simpleTwoArgumentFunction(101, "RIGHT");
    }

    public static ExpressionOperator rightPad() {
        return ExpressionOperator.simpleThreeArgumentFunction(39, "RPAD");
    }

    public static ExpressionOperator rightTrim() {
        return ExpressionOperator.simpleFunction(40, "RTRIM");
    }

    public static ExpressionOperator rightTrim2() {
        return ExpressionOperator.simpleTwoArgumentFunction(116, "RTRIM");
    }

    public static ExpressionOperator round() {
        return ExpressionOperator.simpleTwoArgumentFunction(69, "ROUND");
    }

    public static ExpressionOperator roundDate() {
        return ExpressionOperator.simpleTwoArgumentFunction(52, "ROUND");
    }

    public void setArgumentIndices(int[] nArray) {
        this.argumentIndices = nArray;
    }

    public void setNodeClass(Class clazz) {
        this.nodeClass = clazz;
    }

    public void setSelector(int n) {
        this.selector = n;
    }

    public void setType(int n) {
        this.type = n;
    }

    public static ExpressionOperator sign() {
        return ExpressionOperator.simpleFunction(70, "SIGN");
    }

    public static ExpressionOperator simpleAggregate(int n, String string, String string2) {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(3);
        expressionOperator.setSelector(n);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement(string + "(");
        ((Vector)nonSynchronizedVector).addElement(")");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.printsJavaAs("." + string2 + "()");
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator simpleFunction(int n, String string) {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(n);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement(string + "(");
        ((Vector)nonSynchronizedVector).addElement(")");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator simpleFunction(int n, String string, String string2) {
        ExpressionOperator expressionOperator = ExpressionOperator.simpleFunction(n, string);
        expressionOperator.printsJavaAs("." + string2 + "()");
        return expressionOperator;
    }

    public static ExpressionOperator simpleLogical(int n, String string, String string2) {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(1);
        expressionOperator.setSelector(n);
        expressionOperator.printsAs(" " + string + " ");
        expressionOperator.bePostfix();
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement("." + string2 + "(");
        ((Vector)nonSynchronizedVector).addElement(")");
        expressionOperator.printsJavaAs(nonSynchronizedVector);
        expressionOperator.setNodeClass(ClassConstants.LogicalExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator simpleMath(int n, String string) {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(n);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(3);
        ((Vector)nonSynchronizedVector).addElement("(");
        ((Vector)nonSynchronizedVector).addElement(" " + string + " ");
        ((Vector)nonSynchronizedVector).addElement(")");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator simpleOrdering(int n, String string, String string2) {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(4);
        expressionOperator.setSelector(n);
        expressionOperator.printsAs(" " + string);
        expressionOperator.bePostfix();
        expressionOperator.printsJavaAs("." + string2 + "()");
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator simpleRelation(int n, String string) {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(2);
        expressionOperator.setSelector(n);
        expressionOperator.printsAs(" " + string + " ");
        expressionOperator.bePostfix();
        expressionOperator.setNodeClass(ClassConstants.RelationExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator simpleRelation(int n, String string, String string2) {
        ExpressionOperator expressionOperator = ExpressionOperator.simpleRelation(n, string);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement("." + string2 + "(");
        ((Vector)nonSynchronizedVector).addElement(")");
        expressionOperator.printsJavaAs(nonSynchronizedVector);
        return expressionOperator;
    }

    public static ExpressionOperator simpleThreeArgumentFunction(int n, String string) {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(n);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(4);
        ((Vector)nonSynchronizedVector).addElement(string + "(");
        ((Vector)nonSynchronizedVector).addElement(", ");
        ((Vector)nonSynchronizedVector).addElement(", ");
        ((Vector)nonSynchronizedVector).addElement(")");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator simpleTwoArgumentFunction(int n, String string) {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(n);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(5);
        ((Vector)nonSynchronizedVector).addElement(string + "(");
        ((Vector)nonSynchronizedVector).addElement(", ");
        ((Vector)nonSynchronizedVector).addElement(")");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator simpleLogicalNoParens(int n, String string) {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(n);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(5);
        ((Vector)nonSynchronizedVector).addElement("");
        ((Vector)nonSynchronizedVector).addElement(" " + string + " ");
        ((Vector)nonSynchronizedVector).addElement("");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator sin() {
        return ExpressionOperator.simpleFunction(71, "SIN");
    }

    public static ExpressionOperator sinh() {
        return ExpressionOperator.simpleFunction(72, "SINH");
    }

    public static ExpressionOperator soundex() {
        return ExpressionOperator.simpleFunction(35, "SOUNDEX");
    }

    public static ExpressionOperator sqrt() {
        return ExpressionOperator.simpleFunction(63, "SQRT");
    }

    public static ExpressionOperator standardDeviation() {
        return ExpressionOperator.simpleAggregate(24, "STDDEV", "standardDeviation");
    }

    public static ExpressionOperator substring() {
        return ExpressionOperator.simpleThreeArgumentFunction(41, "SUBSTR");
    }

    public static ExpressionOperator sum() {
        return ExpressionOperator.simpleAggregate(20, "SUM", "sum");
    }

    public static ExpressionOperator sybaseAddMonthsOperator() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(47);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(3);
        ((Vector)nonSynchronizedVector).addElement("DATEADD(month, ");
        ((Vector)nonSynchronizedVector).addElement(", ");
        ((Vector)nonSynchronizedVector).addElement(")");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        int[] nArray = new int[]{1, 0};
        expressionOperator.setArgumentIndices(nArray);
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator sybaseAtan2Operator() {
        return ExpressionOperator.simpleTwoArgumentFunction(91, "ATN2");
    }

    public static ExpressionOperator sybaseInStringOperator() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(34);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(3);
        ((Vector)nonSynchronizedVector).addElement("CHARINDEX(");
        ((Vector)nonSynchronizedVector).addElement(", ");
        ((Vector)nonSynchronizedVector).addElement(")");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        int[] nArray = new int[]{1, 0};
        expressionOperator.setArgumentIndices(nArray);
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator sybaseToNumberOperator() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(42);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement("CONVERT(NUMERIC, ");
        ((Vector)nonSynchronizedVector).addElement(")");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator sybaseToDateToStringOperator() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(48);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement("CONVERT(CHAR, ");
        ((Vector)nonSynchronizedVector).addElement(")");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator sybaseToDateOperator() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(53);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement("CONVERT(DATETIME, ");
        ((Vector)nonSynchronizedVector).addElement(")");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator sybaseToCharOperator() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(114);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement("CONVERT(CHAR, ");
        ((Vector)nonSynchronizedVector).addElement(")");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator sybaseToCharWithFormatOperator() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(115);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(3);
        ((Vector)nonSynchronizedVector).addElement("CONVERT(CHAR, ");
        ((Vector)nonSynchronizedVector).addElement(",");
        ((Vector)nonSynchronizedVector).addElement(")");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator tan() {
        return ExpressionOperator.simpleFunction(73, "TAN");
    }

    public static ExpressionOperator tanh() {
        return ExpressionOperator.simpleFunction(74, "TANH");
    }

    public static ExpressionOperator toDate() {
        return ExpressionOperator.simpleFunction(53, "TO_DATE");
    }

    public static ExpressionOperator today() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(54);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(1);
        ((Vector)nonSynchronizedVector).addElement("SYSDATE");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public static ExpressionOperator toLowerCase() {
        return ExpressionOperator.simpleFunction(29, "LOWER", "toLowerCase");
    }

    public static ExpressionOperator toNumber() {
        return ExpressionOperator.simpleFunction(42, "TO_NUMBER");
    }

    public String toString() {
        if (this.getDatabaseStrings() == null || this.getDatabaseStrings().length == 0) {
            return "platform operator - " + ExpressionOperator.getPlatformOperatorName(this.getSelector());
        }
        return "operator " + this.getDatabaseStrings()[0];
    }

    public static ExpressionOperator toUpperCase() {
        return ExpressionOperator.simpleFunction(28, "UPPER", "toUpperCase");
    }

    public static ExpressionOperator translate() {
        return ExpressionOperator.simpleThreeArgumentFunction(43, "TRANSLATE");
    }

    public static ExpressionOperator trim() {
        return ExpressionOperator.simpleFunction(44, "TRIM");
    }

    public static ExpressionOperator trunc() {
        return ExpressionOperator.simpleTwoArgumentFunction(75, "TRUNC");
    }

    public static ExpressionOperator truncateDate() {
        return ExpressionOperator.simpleTwoArgumentFunction(102, "TRUNC");
    }

    public static ExpressionOperator value() {
        return ExpressionOperator.simpleFunction(85, "VALUE");
    }

    public static ExpressionOperator variance() {
        return ExpressionOperator.simpleAggregate(25, "VARIANCE", "variance");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

