/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.exceptions;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.IntegrityChecker;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.exceptions.i18n.ExceptionMessageGenerator;
import oracle.toplink.internal.helper.Helper;

public class IntegrityException
extends ValidationException {
    protected IntegrityChecker integrityChecker;

    public IntegrityException() {
    }

    public IntegrityException(IntegrityChecker integrityChecker) {
        this.integrityChecker = integrityChecker;
    }

    public IntegrityChecker getIntegrityChecker() {
        return this.integrityChecker;
    }

    public String getMessage() {
        Exception exception;
        String string = Helper.cr();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(string + ExceptionMessageGenerator.getHeader("DescriptorExceptionsHeader"));
        printWriter.println("---------------------------------------------------------");
        Enumeration enumeration = this.getIntegrityChecker().getCaughtExceptions().elements();
        while (enumeration.hasMoreElements()) {
            exception = (Exception)enumeration.nextElement();
            if (!(exception instanceof DescriptorException)) continue;
            printWriter.println(string + exception);
        }
        if (this.getIntegrityChecker().hasRuntimeExceptions()) {
            printWriter.println(string + ExceptionMessageGenerator.getHeader("RuntimeExceptionsHeader"));
            printWriter.println("---------------------------------------------------------");
            enumeration = this.getIntegrityChecker().getCaughtExceptions().elements();
            while (enumeration.hasMoreElements()) {
                exception = (Exception)enumeration.nextElement();
                if (exception instanceof DescriptorException) continue;
                printWriter.println(string + exception);
            }
        }
        printWriter.flush();
        stringWriter.flush();
        return stringWriter.toString();
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        this.printStackTrace(new PrintWriter(printStream));
    }

    public void printStackTrace(PrintWriter printWriter) {
        Exception exception;
        super.printStackTrace(printWriter);
        String string = Helper.cr();
        printWriter.println(string + ExceptionMessageGenerator.getHeader("DescriptorExceptionsHeader"));
        printWriter.println("---------------------------------------------------------");
        Enumeration enumeration = this.getIntegrityChecker().getCaughtExceptions().elements();
        while (enumeration.hasMoreElements()) {
            exception = (Exception)enumeration.nextElement();
            if (!(exception instanceof DescriptorException)) continue;
            printWriter.println(string);
            exception.printStackTrace(printWriter);
        }
        if (this.getIntegrityChecker().hasRuntimeExceptions()) {
            printWriter.println(string + ExceptionMessageGenerator.getHeader("RuntimeExceptionsHeader"));
            printWriter.println("---------------------------------------------------------");
            enumeration = this.getIntegrityChecker().getCaughtExceptions().elements();
            while (enumeration.hasMoreElements()) {
                exception = (Exception)enumeration.nextElement();
                if (exception instanceof DescriptorException) continue;
                printWriter.println(string);
                exception.printStackTrace(printWriter);
            }
        }
        printWriter.flush();
    }
}

