/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.ejb.cmp;

import javax.ejb.EntityContext;
import oracle.toplink.internal.ejb.cmp.CmpHelper;
import oracle.toplink.internal.ejb.cmp.EJBExceptionFactory;
import oracle.toplink.internal.ejb.cmp.PersistenceManagerBase;
import oracle.toplink.internal.ejb.cmp.SessionAccessorHelper;
import oracle.toplink.internal.ejb.cmp.UOWManager;
import oracle.toplink.internal.queryframework.ContainerPolicy;
import oracle.toplink.mappings.CollectionMapping;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.ForeignReferenceMapping;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;

public class SessionAccessor {
    private static SessionAccessorHelper accessorHelper = null;

    public static UnitOfWork getCurrentUnitOfWorkFor(EntityContext entityContext) {
        return SessionAccessor.getCurrentUnitOfWorkFor(SessionAccessor.getPersistenceManager(entityContext));
    }

    public static Session getSessionFor(EntityContext entityContext) {
        return SessionAccessor.getPersistenceManager(entityContext).getSession();
    }

    public static Session getSessionFor(String string) {
        return UOWManager.getManagerForName(string).getSession();
    }

    public static Object registerOrMergeObject(Object object, EntityContext entityContext) {
        if (object == null) {
            return null;
        }
        UnitOfWork unitOfWork = SessionAccessor.getCurrentUnitOfWorkFor(entityContext);
        if (unitOfWork == null) {
            return object;
        }
        return SessionAccessor.currentMergedClone(object, unitOfWork);
    }

    public static Object registerOrMergeAttribute(Object object, String string, EntityContext entityContext) {
        if (object == null) {
            return null;
        }
        PersistenceManagerBase persistenceManagerBase = SessionAccessor.getPersistenceManager(entityContext);
        if (persistenceManagerBase == null) {
            throw EJBExceptionFactory.internalErrorInitializingContext(entityContext);
        }
        DatabaseMapping databaseMapping = persistenceManagerBase.getDescriptor().getMappingForAttributeName(string);
        if (databaseMapping == null) {
            throw EJBExceptionFactory.internalErrorInvalidMapping(string, persistenceManagerBase.getEntityDescriptor().getBeanName());
        }
        if (!databaseMapping.isForeignReferenceMapping()) {
            return object;
        }
        ForeignReferenceMapping foreignReferenceMapping = (ForeignReferenceMapping)databaseMapping;
        if (CmpHelper.isEntity(foreignReferenceMapping.getReferenceClass())) {
            return object;
        }
        UnitOfWork unitOfWork = SessionAccessor.getCurrentUnitOfWorkFor(persistenceManagerBase);
        if (unitOfWork == null) {
            return object;
        }
        if (foreignReferenceMapping.isCollectionMapping()) {
            return SessionAccessor.objectIntoCollection(object, (CollectionMapping)foreignReferenceMapping, unitOfWork);
        }
        return SessionAccessor.currentMergedClone(object, unitOfWork);
    }

    protected static Object objectIntoCollection(Object object, CollectionMapping collectionMapping, UnitOfWork unitOfWork) {
        ContainerPolicy containerPolicy = collectionMapping.getContainerPolicy();
        if (!containerPolicy.isValidContainer(object)) {
            return object;
        }
        return SessionAccessor.collectionIntoCollection(object, collectionMapping, unitOfWork);
    }

    protected static Object collectionIntoCollection(Object object, CollectionMapping collectionMapping, UnitOfWork unitOfWork) {
        ContainerPolicy containerPolicy = collectionMapping.getContainerPolicy();
        if (containerPolicy.sizeFor(object) == 0) {
            return object;
        }
        Object object2 = containerPolicy.iteratorFor(object);
        Object object3 = containerPolicy.containerInstance(containerPolicy.sizeFor(object) + 1);
        Object object4 = null;
        Object object5 = null;
        while (containerPolicy.hasNext(object2)) {
            object4 = containerPolicy.next(object2, unitOfWork);
            if (object4 != null) {
                object5 = SessionAccessor.currentMergedClone(object4, unitOfWork);
            }
            containerPolicy.addInto(object5, object3, unitOfWork);
        }
        return object3;
    }

    protected static Object currentMergedClone(Object object, UnitOfWork unitOfWork) {
        if (unitOfWork.checkExistence(object) == null) {
            return object;
        }
        return unitOfWork.mergeCloneWithReferences(object);
    }

    protected static PersistenceManagerBase getPersistenceManager(EntityContext entityContext) {
        return SessionAccessor.getAccessorHelper().getPersistenceManager(entityContext);
    }

    protected static UnitOfWork getCurrentUnitOfWorkFor(PersistenceManagerBase persistenceManagerBase) {
        return persistenceManagerBase.getUOWManager().getOrCreateActiveUnitOfWork();
    }

    protected static SessionAccessorHelper getAccessorHelper() {
        return accessorHelper;
    }

    public static void setAccessorHelper(SessionAccessorHelper sessionAccessorHelper) {
        accessorHelper = sessionAccessorHelper;
    }
}

