/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.eis.interactions;

import java.io.StringWriter;
import java.util.Vector;
import javax.resource.cci.Record;
import oracle.toplink.eis.EISAccessor;
import oracle.toplink.eis.EISDOMRecord;
import oracle.toplink.eis.EISDescriptor;
import oracle.toplink.eis.interactions.MappedInteraction;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.ox.XMLObjectBuilder;
import oracle.toplink.ox.XMLField;
import oracle.toplink.ox.record.DOMRecord;
import oracle.toplink.ox.record.XMLRecord;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import org.w3c.dom.Element;

public class XMLInteraction
extends MappedInteraction {
    protected String inputRootElementName = "";
    protected String outputRootElementName = "";

    public String getInputRootElementName() {
        return this.inputRootElementName;
    }

    public void setInputRootElementName(String string) {
        this.inputRootElementName = string;
    }

    public String getOutputRootElementName() {
        return this.outputRootElementName;
    }

    public void setOutputRootElementName(String string) {
        this.outputRootElementName = string;
    }

    public void prepare(Session session) {
        EISDescriptor eISDescriptor;
        if (this.getInputRootElementName().length() == 0) {
            if (this.getQuery() != null && this.getQuery().getDescriptor() instanceof EISDescriptor) {
                eISDescriptor = (EISDescriptor)this.getQuery().getDescriptor();
                this.setInputRootElementName(eISDescriptor.getDataTypeName());
            } else {
                this.setInputRootElementName("input");
            }
        }
        if (this.getOutputRootElementName().length() == 0) {
            if (this.getQuery() != null && this.getQuery().getDescriptor() instanceof EISDescriptor) {
                eISDescriptor = (EISDescriptor)this.getQuery().getDescriptor();
                this.setOutputRootElementName(eISDescriptor.getDataTypeName());
            } else {
                this.setInputRootElementName("output");
            }
        }
        super.prepare(session);
    }

    public Record createInputRecord(EISAccessor eISAccessor) {
        Record record = eISAccessor.getEISPlatform().createDOMRecord(this.getInputRecordName(), eISAccessor);
        Element element = this.createInputDOM(eISAccessor);
        eISAccessor.getEISPlatform().setDOMInRecord(element, record, this, eISAccessor);
        return record;
    }

    public Element createInputDOM(EISAccessor eISAccessor) {
        Element element = null;
        if (this.getInputRow() != null && !this.hasArguments()) {
            if (this.getInputResultPath().length() == 0) {
                if (this.getInputRow() instanceof XMLRecord) {
                    element = ((XMLRecord)this.getInputRow()).getDOM();
                    if (!element.getTagName().equals(this.getInputRootElementName())) {
                        XMLRecord xMLRecord = this.createXMLRecord(this.getInputRootElementName());
                        xMLRecord.put("/" + this.getInputRootElementName(), (Object)this.getInputRow());
                        element = xMLRecord.getDOM();
                    }
                } else {
                    XMLRecord xMLRecord = this.createXMLRecord(this.getInputRootElementName());
                    for (int i = 0; i < this.getInputRow().size(); ++i) {
                        xMLRecord.put(this.getInputRow().getFields().elementAt(i), this.getInputRow().getValues().elementAt(i));
                    }
                    element = xMLRecord.getDOM();
                }
            } else {
                XMLRecord xMLRecord = this.createXMLRecord(this.getInputRootElementName());
                xMLRecord.put(this.getInputResultPath(), (Object)this.getInputRow());
                element = xMLRecord.getDOM();
            }
        } else {
            XMLRecord xMLRecord = this.createXMLRecord(this.getInputRootElementName());
            for (int i = 0; i < this.getArgumentNames().size(); ++i) {
                String string = (String)this.getArgumentNames().get(i);
                Object object = this.getParameters().get(i);
                if (object == null && this.getInputRow() != null) {
                    object = this.getInputRow().get(string);
                }
                xMLRecord.put(string, object);
            }
            element = xMLRecord.getDOM();
        }
        return element;
    }

    public DatabaseRow buildRow(Record record, EISAccessor eISAccessor) {
        if (record == null) {
            return null;
        }
        DatabaseRow databaseRow = eISAccessor.getEISPlatform().createDatabaseRowFromDOMRecord(record, this, eISAccessor);
        if (databaseRow == null) {
            return null;
        }
        if (this.getOutputResultPath().length() > 0) {
            databaseRow = (DatabaseRow)databaseRow.get(this.getOutputResultPath());
        } else if (this.hasOutputArguments()) {
            databaseRow = this.createXMLRecord(this.getOutputRootElementName());
            for (int i = 0; i < this.getOutputArgumentNames().size(); ++i) {
                DatabaseField databaseField = (DatabaseField)this.getOutputArguments().get(i);
                databaseRow.put(databaseField, databaseRow.get(this.getOutputArgumentNames().get(i)));
            }
        }
        return databaseRow;
    }

    public Vector buildRows(Record record, EISAccessor eISAccessor) {
        Vector<DatabaseRow> vector = null;
        if (record == null) {
            return new Vector(0);
        }
        DatabaseRow databaseRow = eISAccessor.getEISPlatform().createDatabaseRowFromDOMRecord(record, this, eISAccessor);
        if (this.getOutputResultPath().length() > 0) {
            Vector<DatabaseRow> vector2 = (Vector<DatabaseRow>)databaseRow.getValues(this.getOutputResultPath());
            if (vector2 == null) {
                vector2 = new Vector<DatabaseRow>(0);
            }
            vector = vector2;
        } else {
            vector = new Vector<DatabaseRow>(1);
            vector.add(databaseRow);
        }
        return vector;
    }

    public String getLogString(Accessor accessor) {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("Executing ");
        stringWriter.write(this.toString());
        stringWriter.write(Helper.cr());
        stringWriter.write("\tspec => ");
        stringWriter.write(String.valueOf(this.getInteractionSpec()));
        stringWriter.write(Helper.cr());
        stringWriter.write("\tproperties => ");
        stringWriter.write(String.valueOf(this.getProperties()));
        stringWriter.write(Helper.cr());
        stringWriter.write("\txml => ");
        Element element = this.createInputDOM((EISAccessor)accessor);
        EISDOMRecord eISDOMRecord = new EISDOMRecord(element);
        eISDOMRecord.transformToWriter(stringWriter);
        return stringWriter.toString();
    }

    protected DatabaseField createField(String string) {
        if (this.getQuery().getDescriptor() != null) {
            return this.getQuery().getDescriptor().buildField(string);
        }
        return new XMLField(string);
    }

    protected XMLRecord createXMLRecord(String string) {
        if (this.getQuery().getDescriptor() instanceof EISDescriptor && this.getQuery().getDescriptor() != null) {
            return (XMLRecord)((XMLObjectBuilder)this.getQuery().getDescriptor().getObjectBuilder()).createRecord(this.getInputRootElementName());
        }
        return new DOMRecord(this.getInputRootElementName());
    }
}

