/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.eis.adapters.jms;

import javax.jms.TextMessage;
import javax.resource.ResourceException;
import javax.resource.cci.IndexedRecord;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import oracle.toplink.eis.EISAccessor;
import oracle.toplink.eis.EISDOMRecord;
import oracle.toplink.eis.EISException;
import oracle.toplink.eis.EISPlatform;
import oracle.toplink.eis.interactions.EISInteraction;
import oracle.toplink.internal.eis.adapters.jms.CciJMSInteractionSpec;
import oracle.toplink.internal.eis.adapters.jms.CciJMSReceiveInteractionSpec;
import oracle.toplink.internal.eis.adapters.jms.CciJMSSendInteractionSpec;
import oracle.toplink.internal.eis.adapters.jms.CciJMSSendReceiveInteractionSpec;
import oracle.toplink.ox.record.DOMRecord;
import oracle.toplink.publicinterface.DatabaseRow;
import org.w3c.dom.Element;

public class JMSPlatform
extends EISPlatform {
    public static String MODE = "mode";
    public static String SEND = "send";
    public static String RECEIVE = "receive";
    public static String SEND_RECEIVE = "sendAndReceive";
    public static String SELECTOR = "selector";
    public static String TIMEOUT = "timeout";
    public static String DESTINATION = "destination";
    public static String DESTINATION_URL = "destinationURL";
    public static String REPLY_TO_DESTINATION = "replyToDestination";
    public static String REPLY_TO_DESTINATION_URL = "replyToDestinationURL";

    public JMSPlatform() {
        this.setShouldConvertDataToStrings(true);
        this.setIsMappedRecordSupported(false);
        this.setIsIndexedRecordSupported(true);
        this.setIsDOMRecordSupported(true);
        this.setSupportsLocalTransactions(true);
        this.setRequiresAutoCommit(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionSpec buildInteractionSpec(EISInteraction eISInteraction) {
        CciJMSInteractionSpec cciJMSInteractionSpec;
        InteractionSpec interactionSpec = eISInteraction.getInteractionSpec();
        if (interactionSpec != null) return interactionSpec;
        if (eISInteraction.getProperty(MODE) == null) {
            throw EISException.propertyNotSet(MODE);
        }
        if (eISInteraction.getProperty(MODE).equals(SEND)) {
            cciJMSInteractionSpec = new CciJMSSendInteractionSpec();
        } else if (eISInteraction.getProperty(MODE).equals(RECEIVE)) {
            cciJMSInteractionSpec = new CciJMSReceiveInteractionSpec();
        } else {
            if (!eISInteraction.getProperty(MODE).equals(SEND_RECEIVE)) throw EISException.invalidProperty(MODE);
            cciJMSInteractionSpec = new CciJMSSendReceiveInteractionSpec();
        }
        String string = (String)eISInteraction.getProperty(SELECTOR);
        if (string != null) {
            cciJMSInteractionSpec.setMessageSelector(string);
        }
        if (cciJMSInteractionSpec instanceof CciJMSSendInteractionSpec) {
            string = (String)eISInteraction.getProperty(DESTINATION_URL);
            if (string != null) {
                cciJMSInteractionSpec.setDestinationURL(string);
            } else {
                string = (String)eISInteraction.getProperty(DESTINATION);
                if (string == null) throw EISException.propertiesNotSet(DESTINATION_URL, DESTINATION);
                cciJMSInteractionSpec.setDestination(string);
            }
            string = (String)eISInteraction.getProperty(REPLY_TO_DESTINATION_URL);
            if (string != null) {
                ((CciJMSSendInteractionSpec)cciJMSInteractionSpec).setReplyToDestinationURL(string);
                return cciJMSInteractionSpec;
            } else {
                string = (String)eISInteraction.getProperty(REPLY_TO_DESTINATION);
                if (string == null) throw EISException.propertiesNotSet(REPLY_TO_DESTINATION_URL, REPLY_TO_DESTINATION);
                ((CciJMSSendInteractionSpec)cciJMSInteractionSpec).setReplyToDestination(string);
            }
            return cciJMSInteractionSpec;
        } else if (cciJMSInteractionSpec instanceof CciJMSReceiveInteractionSpec) {
            string = (String)eISInteraction.getProperty(DESTINATION_URL);
            if (string != null) {
                cciJMSInteractionSpec.setDestinationURL(string);
            } else {
                string = (String)eISInteraction.getProperty(DESTINATION);
                if (string == null) throw EISException.propertiesNotSet(DESTINATION_URL, DESTINATION);
                cciJMSInteractionSpec.setDestination(string);
            }
            string = (String)eISInteraction.getProperty(TIMEOUT);
            if (string == null) return cciJMSInteractionSpec;
            ((CciJMSReceiveInteractionSpec)cciJMSInteractionSpec).setTimeout(string);
            return cciJMSInteractionSpec;
        } else {
            string = (String)eISInteraction.getProperty(DESTINATION_URL);
            if (string != null) {
                ((CciJMSSendReceiveInteractionSpec)cciJMSInteractionSpec).setDestinationURL(string);
            } else {
                string = (String)eISInteraction.getProperty(DESTINATION);
                if (string == null) throw EISException.propertiesNotSet(DESTINATION_URL, DESTINATION);
                ((CciJMSSendReceiveInteractionSpec)cciJMSInteractionSpec).setDestination(string);
            }
            string = (String)eISInteraction.getProperty(REPLY_TO_DESTINATION_URL);
            if (string != null) {
                ((CciJMSSendReceiveInteractionSpec)cciJMSInteractionSpec).setReplyToDestinationURL(string);
            } else {
                string = (String)eISInteraction.getProperty(REPLY_TO_DESTINATION);
                if (string == null) throw EISException.propertiesNotSet(REPLY_TO_DESTINATION_URL, REPLY_TO_DESTINATION);
                ((CciJMSSendReceiveInteractionSpec)cciJMSInteractionSpec).setReplyToDestination(string);
            }
            string = (String)eISInteraction.getProperty(TIMEOUT);
            if (string == null) return cciJMSInteractionSpec;
            ((CciJMSSendReceiveInteractionSpec)cciJMSInteractionSpec).setTimeout(string);
        }
        return cciJMSInteractionSpec;
    }

    public Record createDOMRecord(String string, EISAccessor eISAccessor) {
        try {
            return eISAccessor.getRecordFactory().createIndexedRecord(string);
        }
        catch (ResourceException resourceException) {
            throw EISException.createException((Exception)((Object)resourceException));
        }
    }

    public void setDOMInRecord(Element element, Record record, EISInteraction eISInteraction, EISAccessor eISAccessor) {
        IndexedRecord indexedRecord = (IndexedRecord)record;
        indexedRecord.add((Object)new DOMRecord(element).transformToXML());
    }

    public DatabaseRow createDatabaseRowFromDOMRecord(Record record, EISInteraction eISInteraction, EISAccessor eISAccessor) {
        IndexedRecord indexedRecord = (IndexedRecord)record;
        if (indexedRecord.size() == 0) {
            return null;
        }
        EISDOMRecord eISDOMRecord = new EISDOMRecord();
        Object object = indexedRecord.get(0);
        if (object instanceof TextMessage) {
            try {
                eISDOMRecord.transformFromXML(((TextMessage)object).getText());
            }
            catch (Exception exception) {
                return null;
            }
        } else if (object instanceof String) {
            eISDOMRecord.transformFromXML((String)object);
        } else {
            throw EISException.unsupportedMessageInOutputRecord();
        }
        return eISDOMRecord;
    }
}

