/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.descriptors.invalidation;

import oracle.toplink.descriptors.invalidation.CacheInvalidationPolicy;
import oracle.toplink.internal.identitymaps.CacheKey;

public class TimeToLiveCacheInvalidationPolicy
extends CacheInvalidationPolicy {
    protected long timeToLive = 0L;

    public TimeToLiveCacheInvalidationPolicy() {
    }

    public TimeToLiveCacheInvalidationPolicy(long l) {
        this.timeToLive = l;
    }

    public long getExpiryTimeInMillis(CacheKey cacheKey) {
        return cacheKey.getReadTime() + this.timeToLive;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public boolean isInvalidated(CacheKey cacheKey, long l) {
        if (cacheKey.getInvalidationState() == -1) {
            return true;
        }
        return this.getExpiryTimeInMillis(cacheKey) <= l;
    }

    public void setTimeToLive(long l) {
        this.timeToLive = l;
    }
}

