/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.descriptors.changetracking;

import java.io.Serializable;
import java.util.Vector;
import oracle.toplink.descriptors.DescriptorEvent;
import oracle.toplink.descriptors.changetracking.ObjectChangePolicy;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.descriptors.ObjectBuilder;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.sessions.MergeManager;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelModifyQuery;
import oracle.toplink.queryframework.WriteObjectQuery;

public class DeferredChangeDetectionPolicy
implements ObjectChangePolicy,
Serializable {
    public ObjectChangeSet calculateChanges(Object object, Object object2, UnitOfWorkChangeSet unitOfWorkChangeSet, Session session, Descriptor descriptor) {
        Serializable serializable;
        boolean bl;
        boolean bl2 = bl = object2 == null || ((UnitOfWork)session).isObjectNew(object) && !descriptor.isAggregateDescriptor();
        if (!session.usesOldCommit()) {
            if (descriptor.hasCMPPolicy()) {
                descriptor.getCMPPolicy().invokeEJBStore(object, session);
            }
            if (descriptor.getEventManager().hasAnyEventListeners()) {
                serializable = new WriteObjectQuery(object.getClass());
                ((ObjectLevelModifyQuery)serializable).setObject(object);
                ((ObjectLevelModifyQuery)serializable).setBackupClone(object2);
                ((DatabaseQuery)serializable).setSession(session);
                ((DatabaseQuery)serializable).setDescriptor(descriptor);
                descriptor.getEventManager().executeEvent(new DescriptorEvent(0, (ObjectLevelModifyQuery)serializable));
                if (bl) {
                    descriptor.getEventManager().executeEvent(new DescriptorEvent(4, (ObjectLevelModifyQuery)serializable));
                } else {
                    descriptor.getEventManager().executeEvent(new DescriptorEvent(6, (ObjectLevelModifyQuery)serializable));
                }
            }
        }
        if (!(((ObjectChangeSet)(serializable = this.createObjectChangeSet(object, object2, unitOfWorkChangeSet, bl, session, descriptor))).getPrimaryKeys() != null || bl || ((ObjectChangeSet)serializable).isAggregate() || ((UnitOfWork)session).isNestedUnitOfWork() && (!((UnitOfWork)session).isNestedUnitOfWork() || ((UnitOfWork)((UnitOfWork)session).getParent()).isObjectNew(object2)))) {
            throw ValidationException.nullPrimaryKeyInUnitOfWorkClone();
        }
        if (descriptor.getCMPPolicy() != null && descriptor.getCMPPolicy().getForceUpdate()) {
            ((ObjectChangeSet)serializable).setHasCmpPolicyForcedUpdate(true);
        }
        if (!((ObjectChangeSet)serializable).hasForcedChangesFromCascadeLocking()) {
            ((ObjectChangeSet)serializable).setShouldModifyVersionField((Boolean)((UnitOfWork)session).getOptimisticReadLockObjects().get(object));
        }
        if (((ObjectChangeSet)serializable).hasChanges() || ((ObjectChangeSet)serializable).hasForcedChanges()) {
            return serializable;
        }
        return null;
    }

    public void clearChanges(Object object, UnitOfWork unitOfWork, Descriptor descriptor) {
    }

    public ObjectChangeSet createObjectChangeSet(Object object, Object object2, UnitOfWorkChangeSet unitOfWorkChangeSet, boolean bl, Session session, Descriptor descriptor) {
        return this.createObjectChangeSetThroughComparison(object, object2, unitOfWorkChangeSet, bl, session, descriptor);
    }

    public ObjectChangeSet createObjectChangeSetThroughComparison(Object object, Object object2, UnitOfWorkChangeSet unitOfWorkChangeSet, boolean bl, Session session, Descriptor descriptor) {
        ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
        ObjectChangeSet objectChangeSet = objectBuilder.createObjectChangeSet(object, unitOfWorkChangeSet, bl, session);
        if (descriptor.usesOptimisticLocking() && objectChangeSet.getPrimaryKeys() != null) {
            objectChangeSet.setInitialWriteLockValue(descriptor.getOptimisticLockingPolicy().getWriteLockValue(object, objectChangeSet.getPrimaryKeys(), session));
        }
        Vector vector = descriptor.getMappings();
        for (int i = 0; i < vector.size(); ++i) {
            DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
            objectChangeSet.addChange(databaseMapping.compareForChange(object, object2, objectChangeSet, session));
        }
        return objectChangeSet;
    }

    public void dissableEventProcessing(Object object) {
    }

    public void enableEventProcessing(Object object) {
    }

    public boolean shouldCompareForChange(Object object, UnitOfWork unitOfWork, Descriptor descriptor) {
        return true;
    }

    public Object buildBackupClone(Object object, ObjectBuilder objectBuilder, UnitOfWork unitOfWork) {
        return objectBuilder.buildBackupClone(object, unitOfWork);
    }

    public void setAggregateChangeListener(Object object, Object object2, UnitOfWork unitOfWork, Descriptor descriptor, String string) {
    }

    public void setChangeListener(Object object, UnitOfWork unitOfWork, Descriptor descriptor) {
    }

    public void setChangeSetOnListener(ObjectChangeSet objectChangeSet, Object object) {
    }

    public void updateWithChanges(Object object, ObjectChangeSet objectChangeSet, UnitOfWork unitOfWork, Descriptor descriptor) {
        if (objectChangeSet == null) {
            return;
        }
        Object object2 = unitOfWork.getCloneMapping().get(object);
        if (object2 != null) {
            MergeManager mergeManager = new MergeManager(unitOfWork);
            mergeManager.setCascadePolicy(1);
            descriptor.getObjectBuilder().mergeChangesIntoObject(object2, objectChangeSet, object, mergeManager);
        }
        this.clearChanges(object, unitOfWork, descriptor);
    }

    public void raiseInternalPropertyChangeEvent(Object object, String string, Object object2, Object object3) {
    }

    public void revertChanges(Object object, Descriptor descriptor, UnitOfWork unitOfWork, IdentityHashtable identityHashtable) {
        identityHashtable.put(object, this.buildBackupClone(object, descriptor.getObjectBuilder(), unitOfWork));
        this.clearChanges(object, unitOfWork, descriptor);
    }

    public void initialize(Session session, Descriptor descriptor) {
    }

    public boolean isDeferredChangeDetectionPolicy() {
        return true;
    }

    public boolean isObjectChangeTrackingPolicy() {
        return false;
    }

    public boolean isAttributeChangeTrackingPolicy() {
        return false;
    }
}

