/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.descriptors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.expressions.ExpressionMath;
import oracle.toplink.internal.descriptors.OptimisticLockingPolicy;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.DatabaseTable;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DeleteObjectQuery;
import oracle.toplink.queryframework.ModifyQuery;
import oracle.toplink.queryframework.ObjectLevelModifyQuery;
import oracle.toplink.queryframework.WriteObjectQuery;

public class VersionLockingPolicy
implements OptimisticLockingPolicy,
Serializable {
    protected DatabaseField writeLockField;
    protected boolean isCascaded;
    protected int lockValueStored;
    protected Descriptor descriptor;
    protected transient Expression cachedExpression;
    public static final int IN_CACHE = 1;
    public static final int IN_OBJECT = 2;

    public VersionLockingPolicy() {
        this.storeInCache();
    }

    public VersionLockingPolicy(String string) {
        this(new DatabaseField(string));
    }

    public VersionLockingPolicy(DatabaseField databaseField) {
        this();
        this.setWriteLockField(databaseField);
    }

    public void addLockFieldsToUpdateRow(DatabaseRow databaseRow, Session session) {
        if (this.isStoredInCache()) {
            databaseRow.put(this.getWriteLockField(), (Object)null);
        }
    }

    public void addLockValuesToTranslationRow(ObjectLevelModifyQuery objectLevelModifyQuery) {
        Object object = this.isStoredInCache() ? objectLevelModifyQuery.getSession().getIdentityMapAccessorInstance().getWriteLockValue(objectLevelModifyQuery.getPrimaryKey(), objectLevelModifyQuery.getObject().getClass(), this.getDescriptor()) : this.lockValueFromObject(objectLevelModifyQuery.getObject());
        if (object == null) {
            if (objectLevelModifyQuery.isDeleteObjectQuery()) {
                throw OptimisticLockException.noVersionNumberWhenDeleting(objectLevelModifyQuery.getObject(), objectLevelModifyQuery);
            }
            throw OptimisticLockException.noVersionNumberWhenUpdating(objectLevelModifyQuery.getObject(), objectLevelModifyQuery);
        }
        objectLevelModifyQuery.getTranslationRow().put(this.getWriteLockField(), object);
    }

    public Expression buildDeleteExpression(DatabaseTable databaseTable, Expression expression, DatabaseRow databaseRow) {
        return this.buildUpdateExpression(databaseTable, expression, databaseRow, null);
    }

    protected Expression buildExpression() {
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        return expressionBuilder.getField(this.getWriteLockField()).equal(expressionBuilder.getParameter(this.getWriteLockField()));
    }

    public Expression buildUpdateExpression(DatabaseTable databaseTable, Expression expression, DatabaseRow databaseRow, DatabaseRow databaseRow2) {
        if (this.cachedExpression == null) {
            this.cachedExpression = this.buildExpression();
        }
        if (this.getWriteLockField().getTableName().equals(databaseTable.getName())) {
            return expression.and(this.cachedExpression);
        }
        return expression;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected Class getDefaultLockingFieldType() {
        return ClassConstants.BIGDECIMAL;
    }

    public Object getBaseValue() {
        return new BigDecimal(0.0);
    }

    protected Descriptor getDescriptor() {
        return this.descriptor;
    }

    protected Object getInitialWriteValue(Session session) {
        return new BigDecimal(1.0);
    }

    protected Object getNewLockValue(ModifyQuery modifyQuery) {
        Class clazz = modifyQuery.getDescriptor().getJavaClass();
        Number number = null;
        Number number2 = this.isStoredInCache() ? (Number)((Number)modifyQuery.getSession().getIdentityMapAccessorInstance().getWriteLockValue(((WriteObjectQuery)modifyQuery).getPrimaryKey(), clazz, this.getDescriptor())) : (Number)((Number)this.lockValueFromObject(((ObjectLevelModifyQuery)modifyQuery).getObject()));
        if (number2 == null) {
            throw OptimisticLockException.noVersionNumberWhenUpdating(((ObjectLevelModifyQuery)modifyQuery).getObject(), (ObjectLevelModifyQuery)modifyQuery);
        }
        number = this.incrementWriteLockValue(number2);
        return number;
    }

    protected Vector getUnmappedFields() {
        Vector<DatabaseField> vector = new Vector<DatabaseField>(1);
        if (this.isStoredInCache()) {
            vector.addElement(this.getWriteLockField());
        }
        return vector;
    }

    public Object getValueToPutInCache(DatabaseRow databaseRow, Session session) {
        if (this.isStoredInCache()) {
            return databaseRow.get(this.getWriteLockField());
        }
        return null;
    }

    public int getVersionDifference(Object object, Object object2, Vector vector, Session session) {
        Number number = (Number)object;
        if (number == null) {
            return 0;
        }
        Number number2 = this.isStoredInCache() ? (Number)((Number)session.getIdentityMapAccessorInstance().getWriteLockValue(vector, object2.getClass(), this.getDescriptor())) : (Number)((Number)this.lockValueFromObject(object2));
        if (number2 == null) {
            number2 = new BigDecimal(0.0);
        }
        if (!(number2 instanceof BigDecimal)) {
            number2 = new BigDecimal((double)number2.longValue());
        }
        if (!(number instanceof BigDecimal)) {
            number = new BigDecimal((double)number.longValue());
        }
        return ((BigDecimal)number).subtract((BigDecimal)number2).intValue();
    }

    public DatabaseField getWriteLockField() {
        return this.writeLockField;
    }

    public String getWriteLockFieldName() {
        return this.getWriteLockField().getQualifiedName();
    }

    public Expression getWriteLockUpdateExpression(ExpressionBuilder expressionBuilder) {
        return ExpressionMath.add(expressionBuilder.getField(this.writeLockField.getName()), 1);
    }

    public Object getWriteLockValue(Object object, Vector vector, Session session) {
        Number number = this.isStoredInCache() ? (Number)((Number)session.getIdentityMapAccessorInstance().getWriteLockValue(vector, object.getClass(), this.getDescriptor())) : (Number)((Number)this.lockValueFromObject(object));
        return number;
    }

    protected Number incrementWriteLockValue(Number number) {
        BigDecimal bigDecimal = number instanceof BigDecimal ? (BigDecimal)number : new BigDecimal(number.doubleValue());
        return bigDecimal.add(new BigDecimal(1.0));
    }

    public void initialize(Session session) {
        DatabaseMapping databaseMapping = this.mappingFromLockField();
        if (databaseMapping == null) {
            if (this.isStoredInObject()) {
                throw OptimisticLockException.mustHaveMappingWhenStoredInObject(this.descriptor.getJavaClass());
            }
            return;
        }
        if (databaseMapping.isReadOnly()) {
            throw DescriptorException.mappingCanNotBeReadOnly(databaseMapping);
        }
        if (this.isStoredInCache()) {
            session.getIntegrityChecker().handleError(DescriptorException.mustBeReadOnlyMappingWhenStoredInCache(databaseMapping));
        }
    }

    public void initializeProperties() {
        DatabaseField databaseField = this.getWriteLockField();
        this.descriptor.buildField(databaseField);
        if (databaseField.getType() == null) {
            databaseField.setType(this.getDefaultLockingFieldType());
        }
        Enumeration enumeration = this.getUnmappedFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField2 = (DatabaseField)enumeration.nextElement();
            this.descriptor.getFields().addElement(databaseField2);
        }
    }

    public boolean isCascaded() {
        return this.isCascaded;
    }

    public boolean isChildWriteLockValueGreater(Session session, Vector vector, Class clazz, ObjectChangeSet objectChangeSet) {
        if (this.isStoredInCache()) {
            Number number = (Number)objectChangeSet.getWriteLockValue();
            Number number2 = (Number)session.getIdentityMapAccessorInstance().getWriteLockValue(vector, clazz, this.getDescriptor());
            if (number2 != null && !(number2 instanceof BigDecimal)) {
                number2 = new BigDecimal((double)number2.longValue());
            }
            if (number != null && !(number instanceof BigDecimal)) {
                number = new BigDecimal((double)number.longValue());
            }
            if (number != null && (number2 == null || ((BigDecimal)number2).compareTo((BigDecimal)number) == -1)) {
                return true;
            }
        }
        return false;
    }

    public boolean isChildWriteLockValueGreater(UnitOfWork unitOfWork, Vector vector, Class clazz) {
        if (this.isStoredInCache()) {
            Number number = (Number)unitOfWork.getIdentityMapAccessorInstance().getWriteLockValue(vector, clazz, this.getDescriptor());
            Number number2 = (Number)unitOfWork.getParent().getIdentityMapAccessorInstance().getWriteLockValue(vector, clazz, this.getDescriptor());
            if (number2 != null && !(number2 instanceof BigDecimal)) {
                number2 = new BigDecimal((double)number2.longValue());
            }
            if (number != null && !(number instanceof BigDecimal)) {
                number = new BigDecimal((double)number.longValue());
            }
            if (number != null && (number2 == null || ((BigDecimal)number2).compareTo((BigDecimal)number) == -1)) {
                return true;
            }
        }
        return false;
    }

    public boolean isNewerVersion(Object object, Object object2, Vector vector, Session session) {
        Number number = (Number)object;
        if (number == null) {
            return true;
        }
        Number number2 = this.isStoredInCache() ? (Number)((Number)session.getIdentityMapAccessorInstance().getWriteLockValue(vector, object2.getClass(), this.getDescriptor())) : (Number)((Number)this.lockValueFromObject(object2));
        if (!(number2 instanceof BigDecimal)) {
            number2 = new BigDecimal((double)number2.longValue());
        }
        if (!(number instanceof BigDecimal)) {
            number = new BigDecimal((double)number.longValue());
        }
        return number2 == null || ((BigDecimal)number).compareTo((BigDecimal)number2) == 1;
    }

    public boolean isNewerVersion(DatabaseRow databaseRow, Object object, Vector vector, Session session) {
        Number number = (Number)databaseRow.get(this.getWriteLockField());
        Number number2 = this.isStoredInCache() ? (Number)((Number)session.getIdentityMapAccessorInstance().getWriteLockValue(vector, object.getClass(), this.getDescriptor())) : (Number)((Number)this.lockValueFromObject(object));
        if (!(number2 instanceof BigDecimal)) {
            number2 = new BigDecimal((double)number2.longValue());
        }
        if (!(number instanceof BigDecimal)) {
            number = new BigDecimal((double)number.longValue());
        }
        return number2 == null || ((BigDecimal)number).compareTo((BigDecimal)number2) == 1;
    }

    public boolean isStoredInCache() {
        return this.lockValueStored == 1;
    }

    public boolean isStoredInObject() {
        return this.lockValueStored == 2;
    }

    protected Object lockValueFromObject(Object object) {
        return this.getDescriptor().getObjectBuilder().getBaseValueForField(this.getWriteLockField(), object);
    }

    protected DatabaseMapping mappingFromLockField() {
        return this.descriptor.getObjectBuilder().getMappingForField(this.getWriteLockField());
    }

    public void mergeIntoParentCache(UnitOfWork unitOfWork, Vector vector, Object object) {
        if (this.isStoredInCache()) {
            Object object2 = unitOfWork.getParent().getIdentityMapAccessorInstance().getWriteLockValue(vector, object.getClass(), this.getDescriptor());
            unitOfWork.getIdentityMapAccessor().updateWriteLockValue(vector, object.getClass(), object2);
        }
    }

    public void setDescriptor(Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setIsStoredInCache(boolean bl) {
        if (bl) {
            this.storeInCache();
        } else {
            this.storeInObject();
        }
    }

    public void setIsCascaded(boolean bl) {
        this.isCascaded = bl;
    }

    public void setupWriteFieldsForInsert(ObjectLevelModifyQuery objectLevelModifyQuery) {
        Object object = this.getInitialWriteValue(objectLevelModifyQuery.getSession());
        this.updateWriteLockValueForWrite(objectLevelModifyQuery, object);
    }

    protected void updateWriteLockValueForWrite(ObjectLevelModifyQuery objectLevelModifyQuery, Object object) {
        objectLevelModifyQuery.getModifyRow().put(this.getWriteLockField(), object);
        ObjectChangeSet objectChangeSet = objectLevelModifyQuery.getObjectChangeSet();
        if (objectChangeSet != null) {
            objectChangeSet.setWriteLockValue(object);
        }
        DatabaseRow databaseRow = this.getDescriptor().getObjectBuilder().createRecord(1);
        databaseRow.put(this.getWriteLockField(), object);
        this.getDescriptor().getObjectBuilder().assignReturnRow(objectLevelModifyQuery.getObject(), objectLevelModifyQuery.getSession(), databaseRow);
        if (objectLevelModifyQuery.getSession().isUnitOfWork() && ((UnitOfWork)objectLevelModifyQuery.getSession()).getUnitOfWorkChangeSet() != null) {
            if (objectChangeSet == null) {
                objectChangeSet = (ObjectChangeSet)((UnitOfWork)objectLevelModifyQuery.getSession()).getUnitOfWorkChangeSet().getObjectChangeSetForClone(objectLevelModifyQuery.getObject());
            }
            objectLevelModifyQuery.getQueryMechanism().updateChangeSet(this.getDescriptor(), objectChangeSet, databaseRow, objectLevelModifyQuery.getObject());
        }
    }

    public void setWriteLockField(DatabaseField databaseField) {
        this.writeLockField = databaseField;
    }

    public void setWriteLockFieldName(String string) {
        this.setWriteLockField(new DatabaseField(string));
    }

    public void storeInCache() {
        this.lockValueStored = 1;
    }

    public void storeInObject() {
        this.lockValueStored = 2;
    }

    public void updateRowAndObjectForUpdate(ObjectLevelModifyQuery objectLevelModifyQuery, Object object) {
        Object object2 = this.getNewLockValue(objectLevelModifyQuery);
        if (this.isStoredInCache()) {
            objectLevelModifyQuery.getSession().getIdentityMapAccessor().updateWriteLockValue(objectLevelModifyQuery.getPrimaryKey(), object.getClass(), object2);
        }
        this.updateWriteLockValueForWrite(objectLevelModifyQuery, object2);
    }

    public void writeLockValueIntoRow(ObjectLevelModifyQuery objectLevelModifyQuery, Object object) {
        Object object2 = this.getWriteLockValue(object, objectLevelModifyQuery.getPrimaryKey(), objectLevelModifyQuery.getSession());
        objectLevelModifyQuery.getModifyRow().put(this.getWriteLockField(), object2);
        if (this.isStoredInCache()) {
            objectLevelModifyQuery.getSession().getIdentityMapAccessor().updateWriteLockValue(objectLevelModifyQuery.getPrimaryKey(), object.getClass(), object2);
        }
    }

    public void validateDelete(int n, Object object, DeleteObjectQuery deleteObjectQuery) {
        if (n <= 0) {
            throw OptimisticLockException.objectChangedSinceLastReadWhenDeleting(object, deleteObjectQuery);
        }
    }

    public void validateUpdate(int n, Object object, WriteObjectQuery writeObjectQuery) {
        if (n <= 0) {
            throw OptimisticLockException.objectChangedSinceLastReadWhenUpdating(object, writeObjectQuery);
        }
    }
}

