/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.descriptors;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.descriptors.FieldsLockingPolicy;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.DatabaseTable;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.ObjectLevelModifyQuery;

public class SelectedFieldsLockingPolicy
extends FieldsLockingPolicy {
    protected Map lockFieldsByTable = new HashMap(5);
    protected Vector lockFields = NonSynchronizedVector.newInstance();

    public void addLockFieldName(String string) {
        this.getLockFields().addElement(new DatabaseField(string));
    }

    public void addLockValuesToTranslationRow(ObjectLevelModifyQuery objectLevelModifyQuery) {
        this.verifyUsage(objectLevelModifyQuery.getSession());
        Object object = objectLevelModifyQuery.isDeleteObjectQuery() ? objectLevelModifyQuery.getObject() : objectLevelModifyQuery.getBackupClone();
        Iterator iterator = this.getLockFieldsByTable().values().iterator();
        while (iterator.hasNext()) {
            Enumeration enumeration = ((Vector)iterator.next()).elements();
            while (enumeration.hasMoreElements()) {
                DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
                DatabaseMapping databaseMapping = this.descriptor.getObjectBuilder().getMappingForField(databaseField);
                databaseMapping.writeFromObjectIntoRow(object, objectLevelModifyQuery.getTranslationRow(), objectLevelModifyQuery.getSession());
            }
        }
    }

    protected Vector getFieldsToCompare(DatabaseTable databaseTable, DatabaseRow databaseRow, DatabaseRow databaseRow2) {
        return this.getLockFields(databaseTable);
    }

    public Vector getLockFields() {
        return this.lockFields;
    }

    protected Vector getLockFields(DatabaseTable databaseTable) {
        Vector vector = (Vector)this.lockFieldsByTable.get(databaseTable);
        if (vector == null) {
            return new Vector();
        }
        return vector;
    }

    protected Map getLockFieldsByTable() {
        return this.lockFieldsByTable;
    }

    public void initialize(Session session) {
        super.initialize(session);
        Enumeration enumeration = this.lockFields.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            this.descriptor.buildField(databaseField);
            Vector vector = (Vector)this.getLockFieldsByTable().get(databaseField.getTable());
            if (vector == null) {
                vector = NonSynchronizedVector.newInstance();
                this.getLockFieldsByTable().put(databaseField.getTable(), vector);
            }
            vector.addElement(databaseField);
        }
    }

    public void setLockFieldNames(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addLockFieldName((String)enumeration.nextElement());
        }
    }

    public void setLockFields(Map map) {
        this.lockFieldsByTable = map;
    }

    protected void setLockFields(Vector vector) {
        this.lockFields = vector;
    }

    protected void setLockFieldsByTable(Hashtable hashtable) {
        this.lockFieldsByTable = hashtable;
    }
}

