/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.descriptors;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.internal.descriptors.OptimisticLockingPolicy;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.DatabaseTable;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DeleteObjectQuery;
import oracle.toplink.queryframework.ObjectLevelModifyQuery;
import oracle.toplink.queryframework.WriteObjectQuery;

public abstract class FieldsLockingPolicy
implements OptimisticLockingPolicy {
    protected Descriptor descriptor;
    protected Vector allNonPrimaryKeyFields;

    public void addLockFieldsToUpdateRow(DatabaseRow databaseRow, Session session) {
    }

    public abstract void addLockValuesToTranslationRow(ObjectLevelModifyQuery var1);

    protected Vector buildAllNonPrimaryKeyFields() {
        Vector<DatabaseField> vector = new Vector<DatabaseField>();
        Enumeration enumeration = this.descriptor.getFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            if (this.isPrimaryKey(databaseField)) continue;
            if (this.descriptor.hasInheritance()) {
                DatabaseField databaseField2 = this.descriptor.getInheritancePolicy().getClassIndicatorField();
                if (databaseField2 == null || databaseField.equals(databaseField2)) continue;
                vector.addElement(databaseField);
                continue;
            }
            vector.addElement(databaseField);
        }
        return vector;
    }

    public Expression buildDeleteExpression(DatabaseTable databaseTable, Expression expression, DatabaseRow databaseRow) {
        return expression.and(this.buildExpression(databaseTable, databaseRow, null));
    }

    protected Expression buildExpression(DatabaseTable databaseTable, DatabaseRow databaseRow, DatabaseRow databaseRow2) {
        Object object;
        DatabaseField databaseField;
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        Enumeration enumeration = this.getFieldsToCompare(databaseTable, databaseRow, databaseRow2).elements();
        if (enumeration.hasMoreElements()) {
            databaseField = (DatabaseField)enumeration.nextElement();
            object = databaseRow.get(databaseField);
            expression = expressionBuilder.getField(databaseField).equal(object);
        }
        while (enumeration.hasMoreElements()) {
            databaseField = (DatabaseField)enumeration.nextElement();
            object = databaseRow.get(databaseField);
            expression = expression.and(expressionBuilder.getField(databaseField).equal(object));
        }
        return expression;
    }

    public Expression buildUpdateExpression(DatabaseTable databaseTable, Expression expression, DatabaseRow databaseRow, DatabaseRow databaseRow2) {
        return expression.and(this.buildExpression(databaseTable, databaseRow, databaseRow2));
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected Vector getAllNonPrimaryKeyFields() {
        if (this.allNonPrimaryKeyFields == null) {
            this.allNonPrimaryKeyFields = this.buildAllNonPrimaryKeyFields();
        }
        return this.allNonPrimaryKeyFields;
    }

    protected Vector getAllNonPrimaryKeyFields(DatabaseTable databaseTable) {
        Vector<DatabaseField> vector = new Vector<DatabaseField>();
        Enumeration enumeration = this.getAllNonPrimaryKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            if (!databaseField.getTableName().equals(databaseTable.getName())) continue;
            vector.addElement(databaseField);
        }
        return vector;
    }

    public Object getBaseValue() {
        return null;
    }

    protected abstract Vector getFieldsToCompare(DatabaseTable var1, DatabaseRow var2, DatabaseRow var3);

    public DatabaseField getWriteLockField() {
        return null;
    }

    public Expression getWriteLockUpdateExpression(ExpressionBuilder expressionBuilder) {
        return null;
    }

    public Object getValueToPutInCache(DatabaseRow databaseRow, Session session) {
        return null;
    }

    public int getVersionDifference(Object object, Object object2, Vector vector, Session session) {
        return -1;
    }

    public Object getWriteLockValue(Object object, Vector vector, Session session) {
        return null;
    }

    public void initialize(Session session) {
    }

    public void initializeProperties() {
    }

    public boolean isCascaded() {
        return false;
    }

    public boolean isChildWriteLockValueGreater(Session session, Vector vector, Class clazz, ObjectChangeSet objectChangeSet) {
        return false;
    }

    public boolean isChildWriteLockValueGreater(UnitOfWork unitOfWork, Vector vector, Class clazz) {
        return false;
    }

    public boolean isNewerVersion(Object object, Object object2, Vector vector, Session session) {
        return true;
    }

    public boolean isNewerVersion(DatabaseRow databaseRow, Object object, Vector vector, Session session) {
        return true;
    }

    protected boolean isPrimaryKey(DatabaseField databaseField) {
        if (this.descriptor.getPrimaryKeyFields().contains(databaseField)) {
            return true;
        }
        if (this.descriptor.isMultipleTableDescriptor()) {
            Iterator iterator = this.descriptor.getAdditionalTablePrimaryKeyFields().values().iterator();
            while (iterator.hasNext()) {
                if (!((Map)iterator.next()).containsKey(databaseField)) continue;
                return true;
            }
        }
        return false;
    }

    public void mergeIntoParentCache(UnitOfWork unitOfWork, Vector vector, Object object) {
    }

    protected void setAllNonPrimaryKeyFields(Vector vector) {
        this.allNonPrimaryKeyFields = vector;
    }

    public void setDescriptor(Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setupWriteFieldsForInsert(ObjectLevelModifyQuery objectLevelModifyQuery) {
    }

    public void updateRowAndObjectForUpdate(ObjectLevelModifyQuery objectLevelModifyQuery, Object object) {
    }

    public void validateDelete(int n, Object object, DeleteObjectQuery deleteObjectQuery) {
        if (n <= 0) {
            throw OptimisticLockException.objectChangedSinceLastReadWhenDeleting(object, deleteObjectQuery);
        }
    }

    public void validateUpdate(int n, Object object, WriteObjectQuery writeObjectQuery) {
        if (n <= 0) {
            throw OptimisticLockException.objectChangedSinceLastReadWhenUpdating(object, writeObjectQuery);
        }
    }

    protected void verifyUsage(Session session) {
        if (!session.isUnitOfWork()) {
            throw ValidationException.fieldLevelLockingNotSupportedWithoutUnitOfWork();
        }
    }
}

