/*
#	Le livre de Java 1er langage
#	A. Tasso
#	Chapitre 12 : Créer une interface graphique
#	Section  : Gestion de bulletins de notes
#	Fichier  : BulletinNotes.java
#	Class    : BulletinNotes
*/

// Le fichier BulletinNotes.java se trouve dans le répertoire 
// Sources/Exemples/Chapitre12/NetBeansProjects/GestionClasseExemple/src/Introduction
package Introduction;
// Pour traiter l'affichage d'une photo
import javax.swing.ImageIcon;

 // La classe BulletinNotes hérite des propriétés et méthodes de la la classe JFRame
public class BulletinNotes extends javax.swing.JFrame {
  // Propriété de la classe BulletinNotes
  private  Etudiant etudiant;
    
  public BulletinNotes(Etudiant tmp) {
   // Rendre le panneau visible
   setVisible(true);
   // Mettre en place les composants créés dans la fenêtre Design
   initComponents();
   // Définir la position et la taille du panneau, à l’écran
   this.setBounds(100, 100,522, 669);
   // Initialiser la propriété etudiant, a l’étudiant passé en paramètre
   etudiant = tmp;
   // Afficher les noms et prénoms de l’étudiant
   nomEtudiant.setText(etudiant.getNom());
   prenomEtudiant.setText(etudiant.getPrenom());
   // Afficher le semestre de validation
   semestre.setText(etudiant.getSemestre());
   // Récupérer la liste des matières 
   String [] listeMatieres = etudiant.getMatieres() ;
   // Afficher chaque matière dans le composant qui lui correspond
   matiereLue1.setText(listeMatieres[0]);
   matiereLue2.setText(listeMatieres[1]);
   matiereLue3.setText(listeMatieres[2]);
   matiereLue4.setText(listeMatieres[3]);
   matiereLue5.setText(listeMatieres[4]);
   // Récupérer la moyenne de l’étudiant pour chaque matière. 
   // La première fois le moyenne est forcément nulle
   double [] listeMoyenne = etudiant.getMoyenne() ;
   // Afficher chaque moyenne dans le composant qui lui correspond
   moyenne1.setText(Double.toString(listeMoyenne[0]));
   moyenne2.setText(Double.toString(listeMoyenne[1]));
   moyenne3.setText(Double.toString(listeMoyenne[2]));
   moyenne4.setText(Double.toString(listeMoyenne[3]));
   moyenne5.setText(Double.toString(listeMoyenne[4]));
   //  Afficher la photo de l’étudiant
   ImageIcon iconPhoto = new ImageIcon(etudiant.getPhoto());
   photoEtudiant.setIcon(iconPhoto); 
}   

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        BoiteInfos = new javax.swing.JPanel();
        labelNom = new javax.swing.JLabel();
        labelPrenom = new javax.swing.JLabel();
        labelPeriode = new javax.swing.JLabel();
        nomEtudiant = new javax.swing.JLabel();
        prenomEtudiant = new javax.swing.JLabel();
        semestre = new javax.swing.JLabel();
        photoEtudiant = new javax.swing.JLabel();
        BoiteNotes = new javax.swing.JPanel();
        matiereLue1 = new javax.swing.JLabel();
        matiereLue2 = new javax.swing.JLabel();
        matiereLue3 = new javax.swing.JLabel();
        matiereLue4 = new javax.swing.JLabel();
        matiereLue5 = new javax.swing.JLabel();
        moyenne1 = new javax.swing.JTextField();
        moyenne2 = new javax.swing.JTextField();
        moyenne3 = new javax.swing.JTextField();
        moyenne4 = new javax.swing.JTextField();
        moyenne5 = new javax.swing.JTextField();
        unTrait = new javax.swing.JSeparator();
        labelMoyenne = new javax.swing.JLabel();
        moyenneGenerale = new javax.swing.JLabel();
        BoiteBoutons = new javax.swing.JPanel();
        calculerBtn = new javax.swing.JButton();
        enregistrerBtn = new javax.swing.JButton();
        fermerBtn = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Bulletin de notes");
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));

        labelNom.setText("Nom :");

        labelPrenom.setText("Prenom :");

        labelPeriode.setText("Période :");

        nomEtudiant.setText("nom de l'étudiant");

        prenomEtudiant.setText("prénom de l'étudiant");

        semestre.setText("semestre");

        photoEtudiant.setBackground(new java.awt.Color(100, 100, 100));
        photoEtudiant.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        photoEtudiant.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        photoEtudiant.setVerticalTextPosition(javax.swing.SwingConstants.TOP);

        javax.swing.GroupLayout BoiteInfosLayout = new javax.swing.GroupLayout(BoiteInfos);
        BoiteInfos.setLayout(BoiteInfosLayout);
        BoiteInfosLayout.setHorizontalGroup(
            BoiteInfosLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(BoiteInfosLayout.createSequentialGroup()
                .addGap(42, 42, 42)
                .addComponent(photoEtudiant, javax.swing.GroupLayout.PREFERRED_SIZE, 100, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(60, 60, 60)
                .addGroup(BoiteInfosLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(labelPrenom)
                    .addComponent(labelNom)
                    .addComponent(labelPeriode))
                .addGap(37, 37, 37)
                .addGroup(BoiteInfosLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(prenomEtudiant)
                    .addComponent(nomEtudiant)
                    .addComponent(semestre))
                .addContainerGap(58, Short.MAX_VALUE))
        );
        BoiteInfosLayout.setVerticalGroup(
            BoiteInfosLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(BoiteInfosLayout.createSequentialGroup()
                .addGap(64, 64, 64)
                .addGroup(BoiteInfosLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(photoEtudiant, javax.swing.GroupLayout.PREFERRED_SIZE, 100, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(BoiteInfosLayout.createSequentialGroup()
                        .addComponent(labelNom)
                        .addGap(8, 8, 8)
                        .addComponent(labelPrenom)
                        .addGap(8, 8, 8)
                        .addComponent(labelPeriode))
                    .addGroup(BoiteInfosLayout.createSequentialGroup()
                        .addComponent(nomEtudiant)
                        .addGap(8, 8, 8)
                        .addComponent(prenomEtudiant)
                        .addGap(8, 8, 8)
                        .addComponent(semestre)))
                .addContainerGap(53, Short.MAX_VALUE))
        );

        matiereLue1.setText("Matière du cursus ");

        matiereLue2.setText("Matière du cursus ");

        matiereLue3.setText("Matière du cursus ");

        matiereLue4.setText("Matière  du cursus ");

        matiereLue5.setText("Matière du cursus ");

        moyenne1.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        moyenne1.setText("0.0");

        moyenne2.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        moyenne2.setText("0.0");

        moyenne3.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        moyenne3.setText("0.0");

        moyenne4.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        moyenne4.setText("0.0");

        moyenne5.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        moyenne5.setText("0.0");

        labelMoyenne.setText("Moyenne générale");

        moyenneGenerale.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        moyenneGenerale.setText("Total");

        javax.swing.GroupLayout BoiteNotesLayout = new javax.swing.GroupLayout(BoiteNotes);
        BoiteNotes.setLayout(BoiteNotesLayout);
        BoiteNotesLayout.setHorizontalGroup(
            BoiteNotesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(BoiteNotesLayout.createSequentialGroup()
                .addGap(38, 38, 38)
                .addGroup(BoiteNotesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(labelMoyenne)
                    .addComponent(matiereLue5)
                    .addComponent(matiereLue3)
                    .addComponent(matiereLue1)
                    .addComponent(matiereLue2)
                    .addComponent(matiereLue4))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 126, Short.MAX_VALUE)
                .addGroup(BoiteNotesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(moyenneGenerale, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 57, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(moyenne1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 61, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(moyenne2, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 59, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(moyenne3, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 61, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(moyenne4, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(moyenne5, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 54, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(146, 146, 146))
            .addComponent(unTrait, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 502, Short.MAX_VALUE)
        );

        BoiteNotesLayout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {moyenne1, moyenne2, moyenne3, moyenne4, moyenne5, moyenneGenerale});

        BoiteNotesLayout.setVerticalGroup(
            BoiteNotesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(BoiteNotesLayout.createSequentialGroup()
                .addGap(30, 30, 30)
                .addGroup(BoiteNotesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(matiereLue1)
                    .addComponent(moyenne1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(BoiteNotesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(matiereLue2)
                    .addComponent(moyenne2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(BoiteNotesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(matiereLue3)
                    .addComponent(moyenne3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(14, 14, 14)
                .addGroup(BoiteNotesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(matiereLue4)
                    .addComponent(moyenne4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(BoiteNotesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(matiereLue5)
                    .addComponent(moyenne5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(unTrait, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(BoiteNotesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(labelMoyenne)
                    .addComponent(moyenneGenerale))
                .addContainerGap(33, Short.MAX_VALUE))
        );

        BoiteNotesLayout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {moyenne1, moyenne2, moyenne3, moyenne4, moyenne5});

        calculerBtn.setText("Moyenne ?");
        calculerBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                calculerBtnActionPerformed(evt);
            }
        });

        enregistrerBtn.setText("Enregistrer");
        enregistrerBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                enregistrerBtnActionPerformed(evt);
            }
        });

        fermerBtn.setText("Fermer");
        fermerBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fermerBtnActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout BoiteBoutonsLayout = new javax.swing.GroupLayout(BoiteBoutons);
        BoiteBoutons.setLayout(BoiteBoutonsLayout);
        BoiteBoutonsLayout.setHorizontalGroup(
            BoiteBoutonsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(BoiteBoutonsLayout.createSequentialGroup()
                .addGap(70, 70, 70)
                .addComponent(calculerBtn)
                .addGap(18, 18, 18)
                .addComponent(enregistrerBtn)
                .addGap(18, 18, 18)
                .addComponent(fermerBtn)
                .addContainerGap(100, Short.MAX_VALUE))
        );
        BoiteBoutonsLayout.setVerticalGroup(
            BoiteBoutonsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, BoiteBoutonsLayout.createSequentialGroup()
                .addContainerGap(18, Short.MAX_VALUE)
                .addGroup(BoiteBoutonsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(enregistrerBtn)
                    .addComponent(fermerBtn)
                    .addComponent(calculerBtn))
                .addGap(25, 25, 25))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(BoiteBoutons, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(BoiteNotes, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(BoiteInfos, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap())))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(57, 57, 57)
                .addComponent(BoiteInfos, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(BoiteNotes, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(BoiteBoutons, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

   
private void calculerBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_calculerBtnActionPerformed
  // Récupérer la première  moyenne
  String moyenneTxt = moyenne1.getText();
  // Transformer la chaîne de caractère en valeur numérique 
  float m1 = Float.parseFloat(moyenneTxt);
  // Mémoriser la nouvelle moyenne de l’etudiant en cours de traitement
  etudiant.setMoyenne(m1, 0);
  // Récupérer la seconde  moyenne
  moyenneTxt = moyenne2.getText();
  // Transformer la chaîne de caractère en valeur numérique 
  float m2 = Float.parseFloat(moyenneTxt); 
  // Mémoriser la nouvelle moyenne de l’etudiant en cours de traitement
  etudiant.setMoyenne(m2,1);
  // Récupérer la troisième moyenne
  moyenneTxt = moyenne3.getText();
  // Transformer la chaîne de caractère en valeur numérique 
  float m3 = Float.parseFloat(moyenneTxt); 
  // Mémoriser la nouvelle moyenne de l’etudiant en cours de traitement
  etudiant.setMoyenne(m3, 2);
  // Récupérer la quatrième  moyenne
  moyenneTxt = moyenne4.getText();
  // Transformer la chaîne de caractère en valeur numérique 
  float m4 = Float.parseFloat(moyenneTxt); 
  // Mémoriser la nouvelle moyenne de l’etudiant en cours de traitement
  etudiant.setMoyenne(m4, 3);
  // Récupérer la cinquième  moyenne
  moyenneTxt = moyenne5.getText();
  // Transformer la chaîne de caractère en valeur numérique 
  float m5 = Float.parseFloat(moyenne5.getText());
  // Mémoriser la nouvelle moyenne de l’etudiant en cours de traitement
  etudiant.setMoyenne(m5, 4);
  // calculer la moyenne générale
  float resultat = (m1 + m2 + m3 + m4 + m5)/5;
  // Afficher le résultat dans le composant moyenneGenerale
  moyenneGenerale.setText(Float.toString(resultat)); 
}//GEN-LAST:event_calculerBtnActionPerformed

private void enregistrerBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_enregistrerBtnActionPerformed
  // Créer un cursus
  Cursus promo= new Cursus();
  // Créer un fichier d’étudiants
  FichierEtudiant F = new FichierEtudiant();
  // Si le fichier s’ouvre en lecture
  if (F.ouvrir("L")) {
      // Lire les données et les mémoriser dans l’objet
      promo = F.lire(); 
      // Fermer le fichier
      F.fermer();
  }
  // Ajouter l’étudiant en cours de traitement à la promo
  promo.ajouteUnEtudiant(etudiant.getNom(), etudiant.getPrenom(), etudiant.getPhoto(), etudiant.getMatieres(), etudiant.getSemestre(), etudiant.moyenne);
  // Ouvrir le fichier en écriture
  F.ouvrir("W"); 
  // Enregistrer la promo avec l’étudiant supplémentaire
  F.ecrire(promo);
  // fermer le fichier
  F.fermer();
}//GEN-LAST:event_enregistrerBtnActionPerformed

private void fermerBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fermerBtnActionPerformed
    // Fermer la fenêtre sans quitter l'application
    this.dispose();
}//GEN-LAST:event_fermerBtnActionPerformed

   
  

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel BoiteBoutons;
    private javax.swing.JPanel BoiteInfos;
    private javax.swing.JPanel BoiteNotes;
    private javax.swing.JButton calculerBtn;
    private javax.swing.JButton enregistrerBtn;
    private javax.swing.JButton fermerBtn;
    private javax.swing.JLabel labelMoyenne;
    private javax.swing.JLabel labelNom;
    private javax.swing.JLabel labelPeriode;
    private javax.swing.JLabel labelPrenom;
    private javax.swing.JLabel matiereLue1;
    private javax.swing.JLabel matiereLue2;
    private javax.swing.JLabel matiereLue3;
    private javax.swing.JLabel matiereLue4;
    private javax.swing.JLabel matiereLue5;
    private javax.swing.JTextField moyenne1;
    private javax.swing.JTextField moyenne2;
    private javax.swing.JTextField moyenne3;
    private javax.swing.JTextField moyenne4;
    private javax.swing.JTextField moyenne5;
    private javax.swing.JLabel moyenneGenerale;
    private javax.swing.JLabel nomEtudiant;
    private javax.swing.JLabel photoEtudiant;
    private javax.swing.JLabel prenomEtudiant;
    private javax.swing.JLabel semestre;
    private javax.swing.JSeparator unTrait;
    // End of variables declaration//GEN-END:variables
  
}
